--
-- BUILD SCRIPT
--                      RDBMS: MYSQL 5.0
--

CREATE TABLE AUDITENTRIES
(
  TIMESTAMP  VARCHAR(50) NOT NULL,
  CONTEXT    VARCHAR(64) NOT NULL,
  ACTIVITY   VARCHAR(64) NOT NULL,
  RESOURCES  VARCHAR(4000) NOT NULL,
  PRINCIPAL  VARCHAR(255) NOT NULL,
  HOSTNAME   VARCHAR(64) NOT NULL,
  VMID       VARCHAR(64) NOT NULL
);

CREATE TABLE AUTHPERMTYPES
(
  PERMTYPEUID       NUMERIC(10) NOT NULL PRIMARY KEY,
  DISPLAYNAME       VARCHAR(250) NOT NULL,
  FACTORYCLASSNAME  VARCHAR(80) NOT NULL
);

CREATE TABLE AUTHPOLICIES
(
  POLICYUID    NUMERIC(10) NOT NULL PRIMARY KEY,
  DESCRIPTION  VARCHAR(250),
  POLICYNAME   VARCHAR(250) NOT NULL
);

CREATE TABLE AUTHPRINCIPALS
(
  PRINCIPALTYPE  NUMERIC(10) NOT NULL,
  PRINCIPALNAME  VARCHAR(255) NOT NULL,
  POLICYUID      NUMERIC(10) NOT NULL REFERENCES AUTHPOLICIES (POLICYUID) ,
  GRANTOR        VARCHAR(255) NOT NULL,
  CONSTRAINT PK_AUTHPOLICYPRINCIPALS UNIQUE (PRINCIPALNAME, POLICYUID)
);

CREATE TABLE AUTHREALMS
(
  REALMUID     NUMERIC(10) NOT NULL PRIMARY KEY,
  REALMNAME    VARCHAR(250) NOT NULL UNIQUE,
  DESCRIPTION  VARCHAR(550)
);

CREATE TABLE CFG_STARTUP_STATE
(STATE INTEGER DEFAULT 0 ,
LASTCHANGED VARCHAR(50) );




CREATE TABLE IDTABLE
(
  IDCONTEXT  VARCHAR(20) NOT NULL PRIMARY KEY,
  NEXTID     NUMERIC
);

CREATE TABLE LOGMESSAGETYPES
(
  MESSAGELEVEL  NUMERIC(10) NOT NULL PRIMARY KEY,
  NAME          VARCHAR(64) NOT NULL,
  DISPLAYNAME   VARCHAR(64)
);

CREATE TABLE PRINCIPALTYPES
(
  PRINCIPALTYPEUID  NUMERIC(10) NOT NULL PRIMARY KEY,
  PRINCIPALTYPE     VARCHAR(60) NOT NULL,
  DISPLAYNAME       VARCHAR(80) NOT NULL,
  LASTCHANGEDBY     VARCHAR(255) NOT NULL,
  LASTCHANGED       VARCHAR(50)
);


CREATE TABLE RT_MDLS
(
  MDL_UID           NUMERIC(10) NOT NULL PRIMARY KEY,
  MDL_UUID          VARCHAR(64) NOT NULL,
  MDL_NM            VARCHAR(255) NOT NULL,
  MDL_VERSION       VARCHAR(50),
  DESCRIPTION       VARCHAR(255),
  MDL_URI           VARCHAR(255),
  MDL_TYPE          NUMERIC(3),
  IS_PHYSICAL       CHAR(1) NOT NULL,
  MULTI_SOURCED     CHAR(1) DEFAULT '0',  
  VISIBILITY      NUMERIC(10)
  );

CREATE TABLE RT_MDL_PRP_NMS
(
  PRP_UID  NUMERIC(10) NOT NULL PRIMARY KEY,
  MDL_UID  NUMERIC(10) NOT NULL ,
  PRP_NM   VARCHAR(255) NOT NULL
);

CREATE TABLE RT_MDL_PRP_VLS
(
  PRP_UID  NUMERIC(10) NOT NULL ,
  PART_ID  NUMERIC(10) NOT NULL,
  PRP_VL   VARCHAR(255) NOT NULL,
  CONSTRAINT PK_MDL_PRP_VLS UNIQUE (PRP_UID, PART_ID)
);


CREATE TABLE RT_VIRTUAL_DBS
(
  VDB_UID        NUMERIC(10) NOT NULL PRIMARY KEY,
  VDB_VERSION    VARCHAR(50) NOT NULL,
  VDB_NM         VARCHAR(255) NOT NULL,
  DESCRIPTION    VARCHAR(255),
  PROJECT_GUID   VARCHAR(64),
  VDB_STATUS     NUMERIC NOT NULL,
  WSDL_DEFINED   CHAR(1) DEFAULT '0',     
  VERSION_BY     VARCHAR(100),
  VERSION_DATE   VARCHAR(50) NOT NULL,
  CREATED_BY     VARCHAR(100),
  CREATION_DATE  VARCHAR(50),
  UPDATED_BY     VARCHAR(100),
  UPDATED_DATE   VARCHAR(50),
  VDB_FILE_NM VARCHAR(2048)
);

CREATE INDEX RTMDLS_NM_IX ON RT_MDLS (MDL_NM);

CREATE INDEX RTVIRTUALDBS_NM_IX ON RT_VIRTUAL_DBS (VDB_NM);

CREATE INDEX RTVIRTUALDBS_VRSN_IX ON RT_VIRTUAL_DBS (VDB_VERSION);

CREATE UNIQUE INDEX MDL_PRP_NMS_UIX ON RT_MDL_PRP_NMS (MDL_UID, PRP_NM);

CREATE UNIQUE INDEX PRNCIPALTYP_UIX ON PRINCIPALTYPES (PRINCIPALTYPE);

CREATE UNIQUE INDEX AUTHPOLICIES_NAM_UIX ON AUTHPOLICIES (POLICYNAME);

CREATE TABLE AUTHPERMISSIONS
(
  PERMISSIONUID    NUMERIC(10) NOT NULL PRIMARY KEY,
  RESOURCENAME     VARCHAR(250) NOT NULL,
  ACTIONS          NUMERIC(10) NOT NULL,
  CONTENTMODIFIER  VARCHAR(250),
  PERMTYPEUID      NUMERIC(10) NOT NULL REFERENCES AUTHPERMTYPES (PERMTYPEUID) ,
  REALMUID         NUMERIC(10) NOT NULL REFERENCES AUTHREALMS (REALMUID) ,
  POLICYUID        NUMERIC(10) NOT NULL REFERENCES AUTHPOLICIES (POLICYUID)
);


CREATE TABLE LOGENTRIES
(
  TIMESTAMP   VARCHAR(50) NOT NULL,
  CONTEXT     VARCHAR(64) NOT NULL,
  MSGLEVEL    NUMERIC(10) NOT NULL REFERENCES LOGMESSAGETYPES (MESSAGELEVEL) ,
  EXCEPTION   VARCHAR(4000),
  MESSAGE     VARCHAR(2000) NOT NULL,
  HOSTNAME    VARCHAR(64) NOT NULL,
  VMID        VARCHAR(64) NOT NULL,
  THREADNAME  VARCHAR(64) NOT NULL,
  VMSEQNUM NUMERIC(7) NOT NULL
);

CREATE TABLE RT_VDB_MDLS
(
  VDB_UID         NUMERIC(10) NOT NULL ,
  MDL_UID         NUMERIC(10) NOT NULL ,
  CNCTR_BNDNG_NM  VARCHAR(255)
);

CREATE INDEX AWA_SYS_MSGLEVEL_1E6F845E ON LOGENTRIES (MSGLEVEL);

CREATE UNIQUE INDEX AUTHPERM_UIX ON AUTHPERMISSIONS ( POLICYUID, RESOURCENAME);

CREATE TABLE CS_EXT_FILES  (
   FILE_UID             INTEGER                          NOT NULL,
   CHKSUM               NUMERIC(20),
   FILE_NAME            VARCHAR(255)		NOT NULL,
   FILE_CONTENTS        LONGBLOB,
   CONFIG_CONTENTS	LONGTEXT,
   SEARCH_POS           INTEGER,
   IS_ENABLED           CHAR(1),
   FILE_DESC            VARCHAR(4000),
   CREATED_BY           VARCHAR(100),
   CREATION_DATE        VARCHAR(50),
   UPDATED_BY           VARCHAR(100),
   UPDATE_DATE          VARCHAR(50),
   FILE_TYPE            VARCHAR(30),
   CONSTRAINT PK_CS_EXT_FILES PRIMARY KEY (FILE_UID)
)
;

ALTER TABLE CS_EXT_FILES ADD CONSTRAINT CSEXFILS_FIL_NA_UK UNIQUE (FILE_NAME);


CREATE TABLE CS_SYSTEM_PROPS (
	PROPERTY_NAME VARCHAR(255),
	PROPERTY_VALUE VARCHAR(255)
);

CREATE UNIQUE INDEX SYSPROPS_KEY ON CS_SYSTEM_PROPS (PROPERTY_NAME);

CREATE TABLE TX_MMXCMDLOG
(
	REQUESTID  VARCHAR(255)  NOT NULL,
	TXNUID  VARCHAR(50)  NULL,
	CMDPOINT  NUMERIC(10)  NOT NULL,
	SESSIONUID  VARCHAR(255)  NOT NULL,
	APP_NAME  VARCHAR(255)  NULL,
	PRINCIPAL_NA  VARCHAR(255)  NOT NULL,
	VDBNAME  VARCHAR(255)  NOT NULL,
	VDBVERSION  VARCHAR(50)  NOT NULL,
	CREATED_TS  VARCHAR(50)  NULL,
	ENDED_TS  VARCHAR(50)  NULL,
	CMD_STATUS  NUMERIC(10)  NOT NULL,
	SQL_ID  NUMERIC(10),
	FINL_ROWCNT  NUMERIC(10)
)
;

CREATE TABLE TX_SRCCMDLOG
(
	REQUESTID  VARCHAR(255)  NOT NULL,
	NODEID  NUMERIC(10)  NOT NULL,
	SUBTXNUID  VARCHAR(50)  NULL,
	CMD_STATUS  NUMERIC(10)  NOT NULL,
	MDL_NM  VARCHAR(255)  NOT NULL,
	CNCTRNAME  VARCHAR(255)  NOT NULL,
	CMDPOINT  NUMERIC(10)  NOT NULL,
	SESSIONUID  VARCHAR(255)  NOT NULL,
	PRINCIPAL_NA  VARCHAR(255)  NOT NULL,
	CREATED_TS  VARCHAR(50)  NULL,
	ENDED_TS  VARCHAR(50)  NULL,
	SQL_ID  NUMERIC(10)  NULL,
	FINL_ROWCNT  NUMERIC(10)  NULL
)
;


CREATE TABLE TX_SQL ( SQL_ID  NUMERIC(10)    NOT NULL,
    SQL_VL  TEXT )
;
ALTER TABLE TX_SQL 
    ADD CONSTRAINT TX_SQL_PK
PRIMARY KEY (SQL_ID)
;


CREATE INDEX LOGENTRIES_TMSTMP_IX ON LOGENTRIES (TIMESTAMP);

CREATE TABLE MMSCHEMAINFO_CA
(
    SCRIPTNAME        VARCHAR(50),
    SCRIPTEXECUTEDBY  VARCHAR(50),
    SCRIPTREV         VARCHAR(50),
    RELEASEDATE VARCHAR(50),
    DATECREATED       DATE,
    DATEUPDATED       DATE,
    UPDATEID          VARCHAR(50),
    METAMATRIXSERVERURL  VARCHAR(100)
)
;


INSERT INTO MMSCHEMAINFO_CA (SCRIPTNAME,SCRIPTEXECUTEDBY,SCRIPTREV,
RELEASEDATE, DATECREATED,DATEUPDATED, UPDATEID,METAMATRIXSERVERURL)
SELECT 'MM_CREATE.SQL',USER(),'##BUILD_NUMBER##', '##BUILD_DATE##',SYSDATE(),SYSDATE(),'','';


