/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.server;

import com.metamatrix.admin.server.FakeConfiguration;
import com.metamatrix.common.actions.ActionDefinition;
import com.metamatrix.common.actions.CreateObject;
import com.metamatrix.common.actions.ModificationException;
import com.metamatrix.common.comm.ClientServiceRegistry;
import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.common.config.api.ComponentDefnID;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.DeployedComponentID;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ProductServiceConfigID;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.config.api.SharedResource;
import com.metamatrix.common.config.api.SharedResourceID;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.api.exceptions.ConfigurationLockException;
import com.metamatrix.common.config.api.exceptions.InvalidArgumentException;
import com.metamatrix.common.config.api.exceptions.InvalidConfigurationException;
import com.metamatrix.common.config.model.BasicConfigurationObjectEditor;
import com.metamatrix.common.config.model.BasicConnectorBindingType;
import com.metamatrix.common.config.model.BasicHost;
import com.metamatrix.common.config.model.BasicSharedResource;
import com.metamatrix.common.config.model.ConfigurationModelContainerImpl;
import com.metamatrix.common.config.model.ConfigurationObjectEditorHelper;
import com.metamatrix.common.config.xml.XMLConfigurationImportExportUtility;
import com.metamatrix.common.queue.WorkerPoolStats;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.config.api.service.ConfigurationServiceInterface;
import com.metamatrix.platform.service.api.ServiceID;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class FakeConfigurationService
implements ConfigurationServiceInterface {
    private String CONFIG_FILE_PATH = UnitTestUtil.getTestDataPath() + "/config/" + "config.xml";
    private ConfigurationModelContainerImpl config;

    public FakeConfigurationService() {
        File configFile = new File(this.CONFIG_FILE_PATH);
        this.config = (ConfigurationModelContainerImpl)this.importConfigurationModel(configFile, Configuration.NEXT_STARTUP_ID);
    }

    private ConfigurationModelContainer importConfigurationModel(File fileToImport, ConfigurationID configID) {
        Collection configObjects = null;
        BasicConfigurationObjectEditor editor = new BasicConfigurationObjectEditor(false);
        ConfigurationModelContainerImpl configModel = null;
        try {
            XMLConfigurationImportExportUtility io = new XMLConfigurationImportExportUtility();
            FileInputStream inputStream = new FileInputStream(fileToImport);
            configObjects = io.importConfigurationObjects((InputStream)inputStream, (ConfigurationObjectEditor)editor, configID.getFullName());
            configModel = new ConfigurationModelContainerImpl();
            configModel.setConfigurationObjects(configObjects);
        }
        catch (Exception ioe) {
            configModel = null;
        }
        return configModel;
    }

    private ProductServiceConfig getPSCByName(Configuration config, String pscName) throws InvalidArgumentException {
        ProductServiceConfig result = null;
        if (config != null) {
            ProductServiceConfigID pscID = new ProductServiceConfigID((ConfigurationID)config.getID(), pscName);
            result = config.getPSC((ComponentDefnID)pscID);
        }
        return result;
    }

    public Host addHost(String hostName, String principalName, Properties properties) throws ConfigurationException {
        Host host = null;
        ConfigurationObjectEditor editor = null;
        try {
            editor = this.createEditor();
            ConfigurationModelContainer config = this.getConfigurationModel("Next Startup");
            Properties defaultProps = config.getDefaultPropertyValues(Host.HOST_COMPONENT_TYPE_ID);
            Properties allProps = PropertiesUtils.clone((Properties)defaultProps, (boolean)false);
            allProps.putAll((Map<?, ?>)properties);
            host = editor.createHost(hostName);
            host = (Host)editor.modifyProperties((ComponentObject)host, allProps, 0);
        }
        catch (Exception theException) {
            if (editor != null) {
                editor.getDestination().popActions();
            }
            Object[] params = new Object[]{hostName};
            String msg = PlatformPlugin.Util.getString("ConfigurationServiceImpl.Error_creating_New_Host", params);
            throw new ConfigurationException((Throwable)theException, msg);
        }
        return host;
    }

    public ConfigurationObjectEditor createEditor() throws ConfigurationException {
        return new BasicConfigurationObjectEditor(true);
    }

    public ConfigurationID getCurrentConfigurationID() throws ConfigurationException {
        return null;
    }

    public ConfigurationID getNextStartupConfigurationID() throws ConfigurationException {
        return null;
    }

    public ConfigurationID getStartupConfigurationID() throws ConfigurationException {
        return null;
    }

    public void baselineCurrentConfiguration(String principalName) throws ConfigurationException {
    }

    public Configuration getCurrentConfiguration() throws ConfigurationException {
        return new FakeConfiguration();
    }

    public Configuration getNextStartupConfiguration() throws ConfigurationException {
        return new FakeConfiguration();
    }

    public Configuration getStartupConfiguration() throws ConfigurationException {
        return new FakeConfiguration();
    }

    public Configuration getConfiguration(String configName) throws InvalidConfigurationException, ConfigurationException {
        return new FakeConfiguration();
    }

    public ConfigurationModelContainer getConfigurationModel(String configName) throws InvalidConfigurationException, ConfigurationException {
        return this.config;
    }

    public Collection getConfigurationAndDependents(ConfigurationID configID) throws ConfigurationException {
        return null;
    }

    public Collection getAllGlobalConfigObjects() throws ConfigurationException {
        return null;
    }

    public Map getComponentTypeDefinitions(Collection componentIDs) throws ConfigurationException {
        return null;
    }

    public Collection getComponentTypeDefinitions(ComponentTypeID componentTypeID) throws ConfigurationException {
        return null;
    }

    public Collection getAllComponentTypeDefinitions(ComponentTypeID componentTypeID) throws ConfigurationException {
        return null;
    }

    public Map getDependentComponentTypeDefinitions(Collection componentIDs) throws ConfigurationException {
        return null;
    }

    public Collection getDependentComponentTypeDefinitions(ComponentTypeID componentTypeID) throws ConfigurationException {
        return null;
    }

    public Collection getMonitoredComponentTypes(boolean includeDeprecated) throws ConfigurationException {
        return null;
    }

    public ComponentType getComponentType(ComponentTypeID id) throws ConfigurationException {
        return null;
    }

    public Collection getAllComponentTypes(boolean includeDeprecated) throws ConfigurationException {
        ArrayList<BasicConnectorBindingType> results = new ArrayList<BasicConnectorBindingType>();
        ComponentTypeID typeID1 = new ComponentTypeID("connectorType1");
        BasicConnectorBindingType type1 = new BasicConnectorBindingType(typeID1, typeID1, typeID1, true, false, true);
        type1.setComponentTypeCode(2);
        results.add(type1);
        ComponentTypeID typeID2 = new ComponentTypeID("connectorType2");
        BasicConnectorBindingType type2 = new BasicConnectorBindingType(typeID2, typeID2, typeID2, true, false, true);
        type2.setComponentTypeCode(2);
        results.add(type2);
        return results;
    }

    public Host getHost(HostID hostID) throws ConfigurationException {
        return null;
    }

    public Collection getHosts() throws ConfigurationException {
        ArrayList<BasicHost> hosts = new ArrayList<BasicHost>();
        HostID hostID1 = new HostID("1.1.1.1");
        BasicHost host1 = new BasicHost(Configuration.NEXT_STARTUP_ID, hostID1, new ComponentTypeID("Host"));
        hosts.add(host1);
        HostID hostID2 = new HostID("2.2.2.2");
        BasicHost host2 = new BasicHost(Configuration.NEXT_STARTUP_ID, hostID2, new ComponentTypeID("Host"));
        hosts.add(host2);
        return hosts;
    }

    public ComponentDefn getComponentDefn(ConfigurationID configurationID, ComponentDefnID componentDefnID) throws ConfigurationException {
        return null;
    }

    public Collection getComponentDefns(Collection componentDefnIDs, ConfigurationID configurationID) throws ConfigurationException {
        return null;
    }

    public Collection getResourcePools(ConfigurationID configurationID) throws ConfigurationException {
        return null;
    }

    public Collection getResourcePoolTypes(ConfigurationID configurationID) throws ConfigurationException {
        return null;
    }

    public Collection getPoolableResourcePoolTypes(ConfigurationID configurationID) throws ConfigurationException {
        return null;
    }

    public Collection getResourcePools(ConfigurationID configurationID, ComponentTypeID componentTypeID) throws ConfigurationException {
        return null;
    }

    public Collection getResources() throws ConfigurationException {
        ArrayList<BasicSharedResource> results = new ArrayList<BasicSharedResource>();
        SharedResourceID resourceID1 = new SharedResourceID("resource1");
        BasicSharedResource resource1 = new BasicSharedResource(resourceID1, SharedResource.JDBC_COMPONENT_TYPE_ID);
        ConfigurationObjectEditorHelper.addProperty((ComponentObject)resource1, (String)"prop1", (String)"value1");
        ConfigurationObjectEditorHelper.addProperty((ComponentObject)resource1, (String)"metamatrix.common.pooling.resource.name", (String)"pool");
        results.add(resource1);
        SharedResourceID resourceID2 = new SharedResourceID("resource2");
        BasicSharedResource resource2 = new BasicSharedResource(resourceID2, SharedResource.JDBC_COMPONENT_TYPE_ID);
        results.add(resource2);
        return results;
    }

    public Collection getResources(ComponentTypeID componentTypeID) throws ConfigurationException {
        return null;
    }

    public void saveResources(Collection resourceDescriptors, String principalName) throws ConfigurationException {
    }

    public Collection getProductReleaseInfos() throws ConfigurationException {
        return null;
    }

    public Set executeTransaction(ActionDefinition action, String principalName) throws ModificationException, ConfigurationLockException, ConfigurationException {
        return null;
    }

    public Set executeTransaction(List actions, String principalName) throws ModificationException, ConfigurationLockException, ConfigurationException {
        if (actions != null) {
            for (Object o : actions) {
                if (!(o instanceof CreateObject)) continue;
                CreateObject co = (CreateObject)o;
                Object[] objs = co.getArguments();
                this.config.addObject(objs[0]);
            }
        }
        return null;
    }

    public Set executeInsertTransaction(ConfigurationID assignConfigurationID, List actions, String principalName) throws ModificationException, ConfigurationLockException, ConfigurationException {
        return null;
    }

    public Set undoActionsAsTransaction(int numberOfActions, String principalName) throws ConfigurationException {
        return null;
    }

    public List getHistory() throws ConfigurationException {
        return null;
    }

    public void clearHistory() throws ConfigurationException {
    }

    public int getHistorySize() throws ConfigurationException {
        return 0;
    }

    public int getHistoryLimit() throws ConfigurationException {
        return 0;
    }

    public void setHistoryLimit(int maximumHistoryCount) throws ConfigurationException {
    }

    public Date getServerStartupTime() throws ConfigurationException {
        return new Date(1234L);
    }

    public VMComponentDefn addProcess(String processName, String hostName, String principalName, Properties properties) throws ConfigurationException {
        return null;
    }

    public void setSystemPropertyValue(String propertyName, String propertyValue, String principalName) throws ConfigurationException {
    }

    public void updateSystemPropertyValues(Properties properties, String principalName) throws ConfigurationException {
    }

    public ConnectorBinding createConnectorBinding(String connectorBindingName, String connectorType, String pscName, String principalName, Properties properties) throws ConfigurationException {
        return null;
    }

    public Object modify(ComponentObject theObject, Properties theProperties, String principalName) throws ConfigurationException, ModificationException {
        return null;
    }

    public ConnectorBinding importConnectorBinding(InputStream inputStream, String name, String pscName, String principalName) throws ConfigurationException {
        ConnectorBinding newBinding = null;
        ConfigurationObjectEditor editor = this.createEditor();
        try {
            XMLConfigurationImportExportUtility util = new XMLConfigurationImportExportUtility();
            newBinding = util.importConnectorBinding(inputStream, editor, name);
            Configuration config = this.getNextStartupConfiguration();
            if (pscName != null && !pscName.equals("")) {
                ProductServiceConfig psc = this.getPSCByName(config, pscName);
                ServiceComponentDefnID bindingID = (ServiceComponentDefnID)newBinding.getID();
                editor.addServiceComponentDefn(psc, bindingID);
                editor.deployServiceDefn(config, (ServiceComponentDefn)newBinding, (ProductServiceConfigID)psc.getID());
            }
        }
        catch (Exception theException) {
            if (editor != null) {
                editor.getDestination().popActions();
            }
            Object[] params = new Object[]{name, theException.getMessage()};
            String msg = PlatformPlugin.Util.getString("ConfigurationServiceImpl.Error_importing_connector_binding", params);
            throw new ConfigurationException((Throwable)theException, msg);
        }
        return newBinding;
    }

    public ComponentType importConnectorType(InputStream inputStream, String name, String principalName) throws ConfigurationException {
        ComponentType newType = null;
        ConfigurationObjectEditor editor = this.createEditor();
        try {
            XMLConfigurationImportExportUtility util = new XMLConfigurationImportExportUtility();
            newType = util.importComponentType(inputStream, editor, name);
        }
        catch (Exception theException) {
            if (editor != null) {
                editor.getDestination().popActions();
            }
            Object[] params = new Object[]{name, theException.getMessage()};
            String msg = PlatformPlugin.Util.getString("ConfigurationServiceImpl.Error_importing_connector_type", params);
            throw new ConfigurationException((Throwable)theException, msg);
        }
        return newType;
    }

    public void delete(ComponentObject theObject, boolean theDeleteDependenciesFlag, String principalName) throws ConfigurationException, ModificationException {
    }

    public void delete(ComponentType componentType, String principalName) throws ConfigurationException, ModificationException {
    }

    public Collection deployPSC(Host theHost, VMComponentDefn theProcess, String pscName, String principalName) throws ConfigurationException, ModificationException {
        return null;
    }

    public List checkPropertiesDecryptable(List defns) throws ConfigurationException {
        return null;
    }

    public boolean checkPropertiesDecryptable(Properties props, String componentTypeIdentifier) throws ConfigurationException {
        return false;
    }

    public void die() {
    }

    public void dieNow() {
    }

    public void checkState() {
    }

    public Properties getProperties() {
        return null;
    }

    public Date getStartTime() {
        return null;
    }

    public String getHostname() {
        return null;
    }

    public String getProcessName() {
        return null;
    }

    public boolean isAlive() {
        return false;
    }

    public String getServiceType() {
        return null;
    }

    public int getCurrentState() {
        return 0;
    }

    public Date getStateChangeTime() {
        return null;
    }

    public ServiceID getID() {
        return null;
    }

    public Collection getQueueStatistics() {
        return null;
    }

    public WorkerPoolStats getQueueStatistics(String name) {
        return null;
    }

    public void init(ServiceID id, DeployedComponentID deployedComponentID, Properties props, ClientServiceRegistry listenerRegistry) {
    }

    public void setInitException(Throwable t) {
    }

    public void updateState(int state) {
    }

    public Throwable getInitException() {
        return null;
    }
}

