/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.server;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.server.InvalidRequestIDException;
import com.metamatrix.common.comm.ClientServiceRegistry;
import com.metamatrix.common.config.api.DeployedComponentID;
import com.metamatrix.common.queue.WorkerPoolStats;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.service.api.ServiceID;
import com.metamatrix.server.query.service.QueryServiceInterface;
import com.metamatrix.server.serverapi.RequestInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class FakeQueryService
implements QueryServiceInterface {
    protected static Set cancelledQueries = new HashSet();
    ServiceID id;

    protected static void clearState() {
        cancelledQueries.clear();
    }

    public FakeQueryService(ServiceID id) {
        this.id = id;
    }

    public void clearCache(SessionToken sessionToken) throws ComponentNotFoundException {
    }

    public Collection getAllQueries() {
        ArrayList<RequestInfo> results = new ArrayList<RequestInfo>();
        RequestInfo info1 = new RequestInfo(new RequestID("1", 1L), "sql1", new Date(), new Date());
        SessionToken token1 = new SessionToken(new MetaMatrixSessionID(1L), "user1");
        info1.setSessionToken(token1);
        results.add(info1);
        RequestInfo info2 = new RequestInfo(new RequestID("2", 2L), "sql2", new Date(), new Date());
        SessionToken token2 = new SessionToken(new MetaMatrixSessionID(2L), "user2");
        info2.setSessionToken(token2);
        results.add(info2);
        RequestInfo info1A = new RequestInfo(new RequestID("1", 1L), "sql1", new Date(), new Date());
        SessionToken token1A = new SessionToken(new MetaMatrixSessionID(1L), "user1");
        info1A.setSessionToken(token1A);
        info1A.setConnectorBindingUUID("connectorBinding1");
        info1A.setNodeID(1);
        results.add(info1A);
        RequestInfo info2A = new RequestInfo(new RequestID("2", 2L), "sql2", new Date(), new Date());
        SessionToken token2A = new SessionToken(new MetaMatrixSessionID(2L), "user2");
        info2A.setSessionToken(token2A);
        info2A.setConnectorBindingUUID("connectorBinding2");
        info2A.setNodeID(2);
        results.add(info2A);
        return results;
    }

    public Collection getQueriesForSession(SessionToken userToken) {
        return null;
    }

    public void cancelQueries(SessionToken sessionToken, boolean shouldRollback) throws InvalidRequestIDException, MetaMatrixComponentException {
    }

    public void cancelQuery(RequestID requestID, boolean shouldRollback) throws InvalidRequestIDException, MetaMatrixComponentException {
        cancelledQueries.add(FakeQueryService.buildIdentifierFromRequestId(requestID, null));
    }

    public void cancelQuery(RequestID requestID, int nodeID) throws InvalidRequestIDException, MetaMatrixComponentException {
        cancelledQueries.add(FakeQueryService.buildIdentifierFromRequestId(requestID, "" + nodeID));
    }

    public void die() {
    }

    public void dieNow() {
    }

    public void checkState() {
    }

    public Properties getProperties() {
        return null;
    }

    public Date getStartTime() {
        return null;
    }

    public String getHostname() {
        return null;
    }

    public String getProcessName() {
        return null;
    }

    public boolean isAlive() {
        return false;
    }

    public String getServiceType() {
        return null;
    }

    public int getCurrentState() {
        return 0;
    }

    public Date getStateChangeTime() {
        return null;
    }

    public ServiceID getID() {
        return null;
    }

    public Collection getQueueStatistics() {
        ArrayList<WorkerPoolStats> results = new ArrayList<WorkerPoolStats>();
        WorkerPoolStats stats = new WorkerPoolStats();
        stats.name = "pool";
        stats.queued = (int)this.id.getID();
        stats.totalSubmitted = (int)this.id.getID();
        results.add(stats);
        return results;
    }

    public WorkerPoolStats getQueueStatistics(String name) {
        return null;
    }

    public Map getCaches() throws MetaMatrixComponentException {
        return null;
    }

    public void clearCache(String name, Properties props) throws MetaMatrixComponentException {
    }

    private static String buildIdentifierFromRequestId(RequestID requestId, String nodeId) {
        String connectionId = requestId.getConnectionID();
        String executionId = Long.toString(requestId.getExecutionID());
        StringBuffer buff = new StringBuffer();
        buff.append(connectionId);
        buff.append('|');
        buff.append(executionId);
        if (nodeId != null) {
            buff.append('|');
            buff.append(nodeId);
        }
        return buff.toString();
    }

    public void init(ServiceID id, DeployedComponentID deployedComponentID, Properties props, ClientServiceRegistry listenerRegistry) {
    }

    public void setInitException(Throwable t) {
    }

    public void updateState(int state) {
    }

    public Throwable getInitException() {
        return null;
    }
}

