/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.server;

import com.metamatrix.metadata.runtime.api.ModelID;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseException;
import com.metamatrix.metadata.runtime.model.BasicModel;
import com.metamatrix.metadata.runtime.model.BasicModelID;
import com.metamatrix.metadata.runtime.model.BasicVirtualDatabase;
import com.metamatrix.metadata.runtime.model.BasicVirtualDatabaseID;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class FakeRuntimeMetadataCatalog {
    private static String VDB_NAME1 = "myVdb1";
    private static String VDB_NAME2 = "myVdb2";
    private static String VERSION1 = "1";
    private static String PHYSICAL_MODEL_NAME1 = "PhysicalModel1";
    private static String PHYSICAL_MODEL_NAME2 = "PhysicalModel2";
    private static Map vdbMap = new HashMap();
    private static Map modelsMap = new HashMap();

    public static VirtualDatabase helpGetVirtualDatabaseWithPhysicalModel() {
        BasicVirtualDatabaseID vdbid = new BasicVirtualDatabaseID(VDB_NAME1, VERSION1);
        BasicVirtualDatabase vdb = new BasicVirtualDatabase(vdbid);
        BasicModelID mid = new BasicModelID(PHYSICAL_MODEL_NAME1, VERSION1);
        BasicModel model = new BasicModel(mid, vdbid);
        vdb.addModelID((ModelID)mid);
        HashSet<BasicModel> models = new HashSet<BasicModel>();
        models.add(model);
        modelsMap.put(vdbid, models);
        return vdb;
    }

    public static VirtualDatabase helpGetVirtualDatabaseWithMultiEnabledPhysicalModel() {
        BasicVirtualDatabaseID vdbid = new BasicVirtualDatabaseID(VDB_NAME2, VERSION1);
        BasicVirtualDatabase vdb = new BasicVirtualDatabase(vdbid);
        BasicModelID mid = new BasicModelID(PHYSICAL_MODEL_NAME2, VERSION1);
        BasicModel model = new BasicModel(mid, vdbid);
        model.enableMutliSourceBindings(true);
        vdb.addModelID((ModelID)mid);
        HashSet<BasicModel> models = new HashSet<BasicModel>();
        models.add(model);
        modelsMap.put(vdbid, models);
        return vdb;
    }

    public static Collection getVirtualDatabases() {
        return vdbMap.values();
    }

    public static Collection getModels(VirtualDatabaseID vdbID) {
        return (Collection)modelsMap.get(vdbID);
    }

    public static void setConnectorBindingNames(VirtualDatabaseID vdbID, Map modelAndCBNames, String userName) throws VirtualDatabaseException {
        Collection models = FakeRuntimeMetadataCatalog.getModels(vdbID);
        for (String keyName : modelAndCBNames.keySet()) {
            for (BasicModel model : models) {
                if (!model.getName().equals(keyName)) continue;
                Collection cbNames = (Collection)modelAndCBNames.get(keyName);
                model.setConnectorBindingNames(cbNames);
            }
        }
    }

    public static void setVDBStatus(VirtualDatabaseID virtualDBID, short status, String userName) {
    }

    static {
        VirtualDatabase vdb1 = FakeRuntimeMetadataCatalog.helpGetVirtualDatabaseWithPhysicalModel();
        vdbMap.put(vdb1.getVirtualDatabaseID(), vdb1);
        VirtualDatabase vdb2 = FakeRuntimeMetadataCatalog.helpGetVirtualDatabaseWithMultiEnabledPhysicalModel();
        vdbMap.put(vdb2.getVirtualDatabaseID(), vdb2);
    }
}

