/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.server;

import com.metamatrix.admin.api.objects.AdminObject;
import com.metamatrix.admin.server.FakeConfiguration;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MultipleException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.api.exceptions.ConfigurationLockException;
import com.metamatrix.common.log.LogConfiguration;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.common.messaging.NoOpMessageBus;
import com.metamatrix.common.queue.WorkerPoolStats;
import com.metamatrix.platform.admin.api.runtime.HostData;
import com.metamatrix.platform.admin.api.runtime.ProcessData;
import com.metamatrix.platform.admin.api.runtime.SystemState;
import com.metamatrix.platform.admin.apiimpl.RuntimeStateAdminAPIHelper;
import com.metamatrix.platform.registry.ClusteredRegistryState;
import com.metamatrix.platform.registry.ResourceNotBoundException;
import com.metamatrix.platform.registry.ServiceRegistryBinding;
import com.metamatrix.platform.service.api.ServiceID;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.vm.controller.ProcessStatistics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class FakeRuntimeStateAdminAPIHelper
extends RuntimeStateAdminAPIHelper {
    private FakeConfiguration configuration = new FakeConfiguration();
    protected static Set stoppedServices = new HashSet();
    protected static Set restartedServices = new HashSet();
    protected static Set stoppedHosts = new HashSet();
    protected static Set startedHosts = new HashSet();
    protected static Set stoppedProcesses = new HashSet();
    protected static Set startedProcesses = new HashSet();
    protected static boolean shutdownSystem = false;
    protected static boolean synchronizeSystem = false;

    protected static void clearState() {
        stoppedServices.clear();
        restartedServices.clear();
        stoppedHosts.clear();
        startedHosts.clear();
        stoppedProcesses.clear();
        startedProcesses.clear();
        shutdownSystem = false;
        synchronizeSystem = false;
    }

    public FakeRuntimeStateAdminAPIHelper(ClusteredRegistryState registry) {
        super(registry, null);
    }

    public void bounceServer() throws MetaMatrixComponentException {
    }

    public List getHosts() throws MetaMatrixComponentException {
        return null;
    }

    public List getProcesses() throws MetaMatrixComponentException {
        return null;
    }

    public ServiceRegistryBinding getServiceBinding(ServiceID serviceID) throws ResourceNotBoundException {
        List deployedComponents = this.configuration.deployedComponents;
        if (serviceID.getID() == 2L) {
            DeployedComponent deployedComponent = (DeployedComponent)deployedComponents.get(1);
            ServiceRegistryBinding binding = new ServiceRegistryBinding(serviceID, null, "ConnectorService", "connectorBinding2", "Connector", "connectorBinding2", "2.2.2.2", deployedComponent, null, 2, new Date(), false, (MessageBus)new NoOpMessageBus());
            return binding;
        }
        if (serviceID.getID() == 3L) {
            DeployedComponent deployedComponent = (DeployedComponent)deployedComponents.get(2);
            ServiceRegistryBinding binding = new ServiceRegistryBinding(serviceID, null, "ConnectorService", "connectorBinding3", "Connector", "connectorBinding3", "3.3.3.3", deployedComponent, null, 2, new Date(), false, (MessageBus)new NoOpMessageBus());
            return binding;
        }
        if (serviceID.getID() == 5L) {
            DeployedComponent deployedComponent = (DeployedComponent)deployedComponents.get(4);
            ServiceRegistryBinding binding = new ServiceRegistryBinding(serviceID, null, "QueryService", "dqp2", "QueryService", "dqp2", "2.2.2.2", deployedComponent, null, 2, new Date(), false, (MessageBus)new NoOpMessageBus());
            return binding;
        }
        if (serviceID.getID() == 6L) {
            DeployedComponent deployedComponent = (DeployedComponent)deployedComponents.get(5);
            ServiceRegistryBinding binding = new ServiceRegistryBinding(serviceID, null, "QueryService", "dqp3", "QueryService", "dqp3", "3.3.3.3", deployedComponent, null, 2, new Date(), false, (MessageBus)new NoOpMessageBus());
            return binding;
        }
        return null;
    }

    public Collection getServiceQueueStatistics(ServiceID serviceID) throws MetaMatrixComponentException {
        long id = serviceID.getID();
        if (id == 2L || id == 3L || id == 5L || id == 6L) {
            ArrayList<WorkerPoolStats> results = new ArrayList<WorkerPoolStats>();
            WorkerPoolStats stats = new WorkerPoolStats();
            stats.name = "pool";
            stats.queued = (int)id;
            stats.totalSubmitted = (int)id;
            results.add(stats);
            return results;
        }
        return null;
    }

    public List getServices() throws MetaMatrixComponentException {
        ArrayList<ServiceID> results = new ArrayList<ServiceID>();
        ServiceID serviceID2 = new ServiceID(2L, "2.2.2.2", "process2");
        results.add(serviceID2);
        ServiceID serviceID3 = new ServiceID(3L, "3.3.3.3", "process3");
        results.add(serviceID3);
        ServiceID serviceID2A = new ServiceID(5L, "2.2.2.2", "process2");
        results.add(serviceID2A);
        ServiceID serviceID3A = new ServiceID(6L, "3.3.3.3", "process3");
        results.add(serviceID3A);
        return results;
    }

    public synchronized SystemState getSystemState() throws MetaMatrixComponentException {
        ArrayList<HostData> hosts = new ArrayList<HostData>();
        ArrayList<ProcessData> processes2 = new ArrayList<ProcessData>();
        ProcessData process2 = new ProcessData("2.2.2.2", "process2", "31000", null, new ArrayList(), true, true);
        processes2.add(process2);
        HostData host2 = new HostData("2.2.2.2", processes2, true, true, new Properties());
        hosts.add(host2);
        ArrayList<ProcessData> processes3 = new ArrayList<ProcessData>();
        ProcessData process3 = new ProcessData("3.3.3.3", "process3", "31001", null, new ArrayList(), true, true);
        processes3.add(process3);
        HostData host3 = new HostData("3.3.3.3", processes3, true, true, new Properties());
        hosts.add(host3);
        return new SystemState(hosts);
    }

    public ProcessStatistics getVMStatistics(String hostName, String processName) throws MetaMatrixComponentException {
        if (processName.equals("process2")) {
            ProcessStatistics statistics = new ProcessStatistics();
            statistics.freeMemory = 2L;
            statistics.threadCount = 2;
            statistics.socketListenerStats.sockets = 2;
            statistics.processPoolStats.name = "pool";
            statistics.processPoolStats.queued = 2;
            return statistics;
        }
        if (processName.equals("process3")) {
            ProcessStatistics statistics = new ProcessStatistics();
            statistics.freeMemory = 3L;
            statistics.threadCount = 3;
            statistics.socketListenerStats.sockets = 3;
            statistics.processPoolStats.name = "pool";
            statistics.processPoolStats.queued = 3;
            return statistics;
        }
        return null;
    }

    public boolean isSystemStarted() throws MetaMatrixComponentException {
        return true;
    }

    public void restartService(ServiceID serviceID) throws MetaMatrixComponentException {
        restartedServices.add(serviceID.toString());
    }

    public void setLogConfiguration(Configuration config, LogConfiguration logConfig, List actions, String principalName) throws ConfigurationLockException, ConfigurationException, ServiceException, MetaMatrixComponentException {
    }

    public synchronized void shutdownServer() throws MetaMatrixComponentException {
        shutdownSystem = true;
    }

    public void startHost(String host) throws MetaMatrixComponentException {
        startedHosts.add(host);
    }

    public void startProcess(String host, String process) throws MetaMatrixComponentException {
        startedProcesses.add(host + AdminObject.DELIMITER + process);
    }

    public void stopHost(String host, boolean stopNow) throws MetaMatrixComponentException, MultipleException {
        stoppedHosts.add(host);
    }

    public void stopProcess(String hostName, String processName, boolean stopNow) throws AuthorizationException, MetaMatrixComponentException {
        stoppedProcesses.add(hostName + "|" + processName);
    }

    public void stopService(ServiceID serviceID, boolean stopNow) throws MetaMatrixComponentException {
        stoppedServices.add(serviceID.toString());
    }

    public synchronized void synchronizeServer() throws MetaMatrixComponentException, MultipleException {
        synchronizeSystem = true;
    }
}

