/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.server;

import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.exception.AdminProcessingException;
import com.metamatrix.admin.server.FakeRuntimeMetadataCatalog;
import com.metamatrix.admin.server.FakeServerAdminImpl;
import com.metamatrix.admin.server.FakeServerConfigAdminImpl;
import com.metamatrix.admin.server.IdentifierConstants;
import com.metamatrix.admin.server.ServerAdminImpl;
import com.metamatrix.core.util.ObjectConverterUtil;
import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.metadata.runtime.api.Model;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.platform.registry.ClusteredRegistryState;
import com.metamatrix.platform.registry.FakeRegistryUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class TestServerConfigAdminImpl
extends TestCase
implements IdentifierConstants {
    private static final String BOGUS_HOST = "slwxp120";
    private static final String BOGUS_HOST_IP = "192.168.10.157";
    private static final String BOGUS_HOST_FULLY_QUALIFIED = "slwxp120quadrian.com";
    private static String VDB_NAME1 = "myVdb1";
    private static String VDB_NAME2 = "myVdb2";
    private static String VERSION1 = "1";
    private static String PHYSICAL_MODEL_NAME1 = "PhysicalModel1";
    private static String PHYSICAL_MODEL_NAME2 = "PhysicalModel2";
    private ServerAdminImpl parent;
    private FakeServerConfigAdminImpl admin;

    public void setUp() throws Exception {
        System.setProperty("metamatrix.config.none", "true");
        System.setProperty("metamatrix.message.bus.type", "noop.message.bus");
        ClusteredRegistryState registry = FakeRegistryUtil.getFakeRegistry();
        this.parent = new FakeServerAdminImpl(registry);
        this.admin = new FakeServerConfigAdminImpl(this.parent, registry);
    }

    private void helpCheckBindings(Model model, Collection expectedBindingNames) throws Exception {
        List modelBindings = model.getConnectorBindingNames();
        if (modelBindings.size() != expectedBindingNames.size()) {
            TestServerConfigAdminImpl.fail((String)("The number of actual bindings does not match the expected count \n  actual: " + modelBindings.size() + "\n  expected: " + expectedBindingNames.size()));
        }
        for (String expectedName : expectedBindingNames) {
            boolean found = false;
            for (String actualName : modelBindings) {
                if (!actualName.equals(expectedName)) continue;
                found = true;
                break;
            }
            if (found) continue;
            TestServerConfigAdminImpl.fail((String)("Binding [" + expectedName + "] was not found in the list of actual model bindings"));
        }
    }

    private Model helpGetModel(String vdbName, String vdbVersion, String modelName) throws Exception {
        Model resultModel = null;
        Collection vdbs = FakeRuntimeMetadataCatalog.getVirtualDatabases();
        block0: for (VirtualDatabase vdb : vdbs) {
            VirtualDatabaseID vdbID = vdb.getVirtualDatabaseID();
            if (!vdbID.getName().equals(vdbName)) continue;
            Collection models = FakeRuntimeMetadataCatalog.getModels(vdbID);
            for (Model model : models) {
                if (!model.getName().equals(modelName)) continue;
                resultModel = model;
                continue block0;
            }
        }
        return resultModel;
    }

    public void testExportConfiguration() throws AdminException {
        char[] results = this.admin.exportConfiguration();
        TestServerConfigAdminImpl.assertNotNull((Object)results);
    }

    public void testAddConnectorType() throws Exception {
        String name = "MS Access Connector New";
        String cdkFileName = "MS Access Connector.cdk";
        String datapath = UnitTestUtil.getTestDataPath();
        String fullpathName = datapath + File.separator + cdkFileName;
        File file = new File(fullpathName);
        char[] data = ObjectConverterUtil.convertFileToCharArray((File)file, null);
        this.admin.addConnectorType(name, data);
    }

    public void testAddHost() throws Exception {
        String hostIdentifier = BOGUS_HOST;
        Properties hostProperties = new Properties();
        hostProperties.setProperty("metamatrix.installationDir", "D:\\MetaMatrix\\s43401\\");
        hostProperties.setProperty("metamatrix.host.dir", "D:\\MetaMatrix\\s43401\\host");
        hostProperties.setProperty("metamatrix.log.dir", "D:\\MetaMatrix\\s43401\\log");
        hostProperties.setProperty("host.enabled", "true");
        this.admin.addHost(hostIdentifier, hostProperties);
    }

    public void testAddHostIP() throws Exception {
        String hostIdentifier = BOGUS_HOST_IP;
        Properties hostProperties = new Properties();
        hostProperties.setProperty("metamatrix.installationDir", "D:\\MetaMatrix\\s43401\\");
        hostProperties.setProperty("metamatrix.host.dir", "D:\\MetaMatrix\\s43401\\host");
        hostProperties.setProperty("metamatrix.log.dir", "D:\\MetaMatrix\\s43401\\log");
        hostProperties.setProperty("host.enabled", "true");
        this.admin.addHost(hostIdentifier, hostProperties);
    }

    public void testAddHostFullyQualifiedName() throws Exception {
        String hostIdentifier = BOGUS_HOST_FULLY_QUALIFIED;
        Properties hostProperties = new Properties();
        hostProperties.setProperty("metamatrix.installationDir", "D:\\MetaMatrix\\s43401\\");
        hostProperties.setProperty("metamatrix.host.dir", "D:\\MetaMatrix\\s43401\\host");
        hostProperties.setProperty("metamatrix.log.dir", "D:\\MetaMatrix\\s43401\\log");
        hostProperties.setProperty("host.enabled", "true");
        this.admin.addHost(hostIdentifier, hostProperties);
    }

    public void testAssignBindingToModel() throws Exception {
        this.admin.assignBindingToModel("connectorBinding2", VDB_NAME1, VERSION1, PHYSICAL_MODEL_NAME1);
        HashSet<String> expectedBindingNames = new HashSet<String>();
        expectedBindingNames.add("connectorBinding2uuid");
        Model model = this.helpGetModel(VDB_NAME1, VERSION1, PHYSICAL_MODEL_NAME1);
        this.helpCheckBindings(model, expectedBindingNames);
    }

    public void testAssignBindingsToNonMultiEnabledModel() throws Exception {
        String[] bindings = new String[]{"connectorBinding1", "connectorBinding2"};
        this.admin.assignBindingsToModel(bindings, VDB_NAME1, VERSION1, PHYSICAL_MODEL_NAME1);
        HashSet<String> expectedBindingNames = new HashSet<String>();
        expectedBindingNames.add("connectorBinding1uuid");
        Model model = this.helpGetModel(VDB_NAME1, VERSION1, PHYSICAL_MODEL_NAME1);
        this.helpCheckBindings(model, expectedBindingNames);
    }

    public void testAssignBindingsToMultiEnabledModel() throws Exception {
        String[] bindings = new String[]{"connectorBinding1", "connectorBinding2"};
        this.admin.assignBindingsToModel(bindings, VDB_NAME2, VERSION1, PHYSICAL_MODEL_NAME2);
        HashSet<String> expectedBindingNames = new HashSet<String>();
        expectedBindingNames.add("connectorBinding1uuid");
        expectedBindingNames.add("connectorBinding2uuid");
        Model model = this.helpGetModel(VDB_NAME2, VERSION1, PHYSICAL_MODEL_NAME2);
        this.helpCheckBindings(model, expectedBindingNames);
    }

    public void testDeassignBindingFromModel() throws Exception {
        this.admin.assignBindingToModel("connectorBinding2", VDB_NAME1, VERSION1, PHYSICAL_MODEL_NAME1);
        HashSet<String> expectedBindingNames = new HashSet<String>();
        expectedBindingNames.add("connectorBinding2uuid");
        Model model = this.helpGetModel(VDB_NAME1, VERSION1, PHYSICAL_MODEL_NAME1);
        this.helpCheckBindings(model, expectedBindingNames);
        this.admin.deassignBindingFromModel("connectorBinding2", VDB_NAME1, VERSION1, PHYSICAL_MODEL_NAME1);
        expectedBindingNames = new HashSet();
        this.helpCheckBindings(model, expectedBindingNames);
    }

    public void testDeassignMultiBindingsFromMultiModel() throws Exception {
        String[] bindings = new String[]{"connectorBinding1", "connectorBinding2", "connectorBinding3"};
        this.admin.assignBindingsToModel(bindings, VDB_NAME2, VERSION1, PHYSICAL_MODEL_NAME2);
        HashSet<String> expectedBindingNames = new HashSet<String>();
        expectedBindingNames.add("connectorBinding1uuid");
        expectedBindingNames.add("connectorBinding2uuid");
        expectedBindingNames.add("connectorBinding3uuid");
        Model model = this.helpGetModel(VDB_NAME2, VERSION1, PHYSICAL_MODEL_NAME2);
        this.helpCheckBindings(model, expectedBindingNames);
        String[] debindings = new String[]{"connectorBinding1", "connectorBinding3"};
        this.admin.deassignBindingsFromModel(debindings, VDB_NAME2, VERSION1, PHYSICAL_MODEL_NAME2);
        expectedBindingNames = new HashSet();
        expectedBindingNames.add("connectorBinding2uuid");
        this.helpCheckBindings(model, expectedBindingNames);
        this.admin.deassignBindingsFromModel(debindings, VDB_NAME2, VERSION1, PHYSICAL_MODEL_NAME2);
        this.helpCheckBindings(model, expectedBindingNames);
        debindings = new String[]{"connectorBinding2"};
        this.admin.deassignBindingsFromModel(debindings, VDB_NAME2, VERSION1, PHYSICAL_MODEL_NAME2);
        expectedBindingNames = new HashSet();
        this.helpCheckBindings(model, expectedBindingNames);
    }

    public void testDeassignNonexistantBinding() throws Exception {
        String[] bindings = new String[]{"connectorBinding1", "connectorBinding2", "connectorBinding3"};
        this.admin.assignBindingsToModel(bindings, VDB_NAME2, VERSION1, PHYSICAL_MODEL_NAME2);
        String[] debindings = new String[]{"connectorBindingx"};
        try {
            this.admin.deassignBindingsFromModel(debindings, VDB_NAME2, VERSION1, PHYSICAL_MODEL_NAME2);
        }
        catch (AdminProcessingException e) {
            TestServerConfigAdminImpl.assertEquals((String)"Connector Binding connectorBindingx not found in Configuration", (String)e.getMessage());
        }
    }

    public void testAddAuthenticationProvider() throws Exception {
        String name = "My Test Provider";
        String providertype = "File Membership Domain Provider";
        Properties props = new Properties();
        props.setProperty("usersFile", "usersFile.txt");
        props.setProperty("groupsFile", "groupsFile.txt");
        this.admin.addAuthorizationProvider(name, providertype, props);
        if (this.admin.getConfigurationModel().getConfiguration().getAuthenticationProvider(name) == null) {
            TestServerConfigAdminImpl.fail((String)("AuthenticationProvider [" + name + "] was not found to be added"));
        }
    }
}

