/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.server;

import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.objects.MMConnectorBinding;
import com.metamatrix.admin.objects.MMConnectorType;
import com.metamatrix.admin.objects.MMDQP;
import com.metamatrix.admin.objects.MMExtensionModule;
import com.metamatrix.admin.objects.MMHost;
import com.metamatrix.admin.objects.MMProcess;
import com.metamatrix.admin.objects.MMQueueWorkerPool;
import com.metamatrix.admin.objects.MMRequest;
import com.metamatrix.admin.objects.MMResource;
import com.metamatrix.admin.objects.MMSession;
import com.metamatrix.admin.objects.MMSourceRequest;
import com.metamatrix.admin.objects.MMSystem;
import com.metamatrix.admin.server.FakeServerAdminImpl;
import com.metamatrix.admin.server.IdentifierConstants;
import com.metamatrix.admin.server.ServerAdminImpl;
import com.metamatrix.admin.server.ServerMonitoringAdminImpl;
import com.metamatrix.platform.registry.ClusteredRegistryState;
import com.metamatrix.platform.registry.FakeRegistryUtil;
import com.metamatrix.platform.registry.ResourceNotBoundException;
import com.metamatrix.platform.registry.ServiceRegistryBinding;
import com.metamatrix.platform.service.api.ServiceID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import junit.framework.TestCase;

public class TestServerMonitoringAdminImpl
extends TestCase
implements IdentifierConstants {
    private ServerAdminImpl parent;
    private ServerMonitoringAdminImpl admin;

    public void setUp() throws Exception {
        System.setProperty("metamatrix.config.none", "true");
        System.setProperty("metamatrix.message.bus.type", "noop.message.bus");
        ClusteredRegistryState registry = FakeRegistryUtil.getFakeRegistry();
        this.parent = new FakeServerAdminImpl(registry);
        this.admin = new ServerMonitoringAdminImpl(this.parent, registry);
    }

    public void testTrimString() {
        String string = "  string ";
        TestServerMonitoringAdminImpl.assertEquals((String)"string", (String)ServerMonitoringAdminImpl.trimString((String)string));
        string = null;
        TestServerMonitoringAdminImpl.assertEquals((String)"", (String)ServerMonitoringAdminImpl.trimString((String)string));
    }

    public void testGetConnectorBindings() throws AdminException {
        try {
            ServiceRegistryBinding binding = this.admin.registry.getServiceBinding("3.3.3.3", "3", new ServiceID(3L, "3.3.3.3", "3"));
            binding.updateState(2);
        }
        catch (ResourceNotBoundException e1) {
            // empty catch block
        }
        Collection results = this.admin.getConnectorBindings("*");
        TestServerMonitoringAdminImpl.assertEquals((int)3, (int)results.size());
        for (MMConnectorBinding binding : results) {
            if (HOST_1_1_1_1_PROCESS1_CONNECTOR_BINDING1.equals(binding.getIdentifier())) {
                TestServerMonitoringAdminImpl.assertEquals((String)"Not Registered", (String)binding.getStateAsString());
                TestServerMonitoringAdminImpl.assertEquals((boolean)false, (boolean)binding.isRegistered());
                TestServerMonitoringAdminImpl.assertEquals((boolean)true, (boolean)binding.isDeployed());
                continue;
            }
            if (HOST_2_2_2_2_PROCESS2_CONNECTOR_BINDING2.equals(binding.getIdentifier())) {
                TestServerMonitoringAdminImpl.assertEquals((String)"connectorBinding2", (String)binding.getDescription());
                TestServerMonitoringAdminImpl.assertEquals((boolean)true, (boolean)binding.isRegistered());
                TestServerMonitoringAdminImpl.assertEquals((boolean)true, (boolean)binding.isDeployed());
                Properties properties = binding.getProperties();
                TestServerMonitoringAdminImpl.assertEquals((Object)"value1", (Object)properties.get("prop1"));
                TestServerMonitoringAdminImpl.assertEquals((Object)"value2", (Object)properties.get("prop2"));
                continue;
            }
            if (_3_3_3_3_PROCESS3_CONNECTOR_BINDING3.equals(binding.getIdentifier())) {
                TestServerMonitoringAdminImpl.assertEquals((boolean)true, (boolean)binding.isRegistered());
                TestServerMonitoringAdminImpl.assertEquals((boolean)true, (boolean)binding.isDeployed());
                continue;
            }
            TestServerMonitoringAdminImpl.fail((String)("Unexpected d: " + binding.getIdentifier()));
        }
        results = this.admin.getConnectorBindings(HOST_2_2_2_2_PROCESS2_CONNECTOR_BINDING2);
        TestServerMonitoringAdminImpl.assertEquals((int)1, (int)results.size());
        results = this.admin.getConnectorBindings(HOST_2_2_2_2_PROCESS2_WILDCARD);
        TestServerMonitoringAdminImpl.assertEquals((int)1, (int)results.size());
        results = this.admin.getConnectorBindings("2.2.2.2*");
        TestServerMonitoringAdminImpl.assertEquals((int)1, (int)results.size());
    }

    public void testGetConnectorTypes() throws AdminException {
        Collection results = this.admin.getConnectorTypes("*");
        ArrayList resultsList = new ArrayList(results);
        TestServerMonitoringAdminImpl.assertEquals((int)2, (int)results.size());
        MMConnectorType type = (MMConnectorType)resultsList.get(0);
        TestServerMonitoringAdminImpl.assertEquals((String)"connectorType1", (String)type.getIdentifier());
        results = this.admin.getConnectorTypes("connectorType1");
        TestServerMonitoringAdminImpl.assertEquals((int)1, (int)results.size());
    }

    public void testGetDQPs() throws AdminException {
        Collection results = this.admin.getDQPs("*");
        TestServerMonitoringAdminImpl.assertEquals((int)3, (int)results.size());
        for (MMDQP dqp : results) {
            if (HOST_1_1_1_1_PROCESS1_DQP1.equals(dqp.getIdentifier())) {
                TestServerMonitoringAdminImpl.assertEquals((String)"Not Registered", (String)dqp.getStateAsString());
                TestServerMonitoringAdminImpl.assertEquals((boolean)false, (boolean)dqp.isRegistered());
                TestServerMonitoringAdminImpl.assertEquals((boolean)true, (boolean)dqp.isDeployed());
                continue;
            }
            if (HOST_2_2_2_2_PROCESS2_DQP2.equals(dqp.getIdentifier())) {
                TestServerMonitoringAdminImpl.assertEquals((String)"dqp2", (String)dqp.getDescription());
                TestServerMonitoringAdminImpl.assertEquals((boolean)true, (boolean)dqp.isRegistered());
                TestServerMonitoringAdminImpl.assertEquals((boolean)true, (boolean)dqp.isDeployed());
                continue;
            }
            if (_3_3_3_3_PROCESS3_DQP3.equals(dqp.getIdentifier())) {
                TestServerMonitoringAdminImpl.assertEquals((boolean)true, (boolean)dqp.isRegistered());
                TestServerMonitoringAdminImpl.assertEquals((boolean)true, (boolean)dqp.isDeployed());
                continue;
            }
            TestServerMonitoringAdminImpl.fail((String)("Unexpected dqp: " + dqp.getIdentifier()));
        }
        results = this.admin.getDQPs(HOST_2_2_2_2_PROCESS2_DQP2);
        TestServerMonitoringAdminImpl.assertEquals((int)1, (int)results.size());
        results = this.admin.getDQPs(HOST_2_2_2_2_PROCESS2_WILDCARD);
        TestServerMonitoringAdminImpl.assertEquals((int)1, (int)results.size());
        results = this.admin.getDQPs("2.2.2.2*");
        TestServerMonitoringAdminImpl.assertEquals((int)1, (int)results.size());
    }

    public void testGetExtensionModules() throws AdminException {
        Collection results = this.admin.getExtensionModules("*");
        ArrayList resultsList = new ArrayList(results);
        TestServerMonitoringAdminImpl.assertEquals((int)2, (int)results.size());
        MMExtensionModule module = (MMExtensionModule)resultsList.get(0);
        TestServerMonitoringAdminImpl.assertEquals((String)"extensionModule1", (String)module.getIdentifier());
        TestServerMonitoringAdminImpl.assertEquals((String)"testUser1", (String)module.getCreatedBy());
        TestServerMonitoringAdminImpl.assertEquals((String)"description1", (String)module.getDescription());
        TestServerMonitoringAdminImpl.assertEquals((String)"bytes1", (String)new String(module.getFileContents()));
        results = this.admin.getExtensionModules("extensionModule1");
        TestServerMonitoringAdminImpl.assertEquals((int)1, (int)results.size());
    }

    public void testGetHosts() throws AdminException {
        Collection results = this.admin.getHosts("*");
        TestServerMonitoringAdminImpl.assertEquals((int)3, (int)results.size());
        for (MMHost host : results) {
            if ("1.1.1.1".equals(host.getIdentifier())) {
                TestServerMonitoringAdminImpl.assertFalse((boolean)host.isRunning());
                TestServerMonitoringAdminImpl.assertTrue((boolean)host.isDeployed());
                continue;
            }
            if ("2.2.2.2".equals(host.getIdentifier())) {
                TestServerMonitoringAdminImpl.assertTrue((boolean)host.isRunning());
                TestServerMonitoringAdminImpl.assertTrue((boolean)host.isDeployed());
                continue;
            }
            if ("3.3.3.3".equals(host.getIdentifier())) {
                TestServerMonitoringAdminImpl.assertTrue((boolean)host.isRunning());
                TestServerMonitoringAdminImpl.assertFalse((boolean)host.isDeployed());
                continue;
            }
            TestServerMonitoringAdminImpl.fail((String)("Unexpected host " + host.getIdentifier()));
        }
        results = this.admin.getHosts("1.1.1.1");
        TestServerMonitoringAdminImpl.assertEquals((int)1, (int)results.size());
    }

    public void testGetProcesses() throws AdminException {
        Collection results = this.admin.getProcesses("*");
        TestServerMonitoringAdminImpl.assertEquals((int)3, (int)results.size());
        for (MMProcess process : results) {
            if (HOST_1_1_1_1_PROCESS1.equals(process.getIdentifier())) {
                TestServerMonitoringAdminImpl.assertFalse((boolean)process.isRunning());
                TestServerMonitoringAdminImpl.assertTrue((boolean)process.isDeployed());
                continue;
            }
            if (HOST_2_2_2_2_PROCESS2.equals(process.getIdentifier())) {
                TestServerMonitoringAdminImpl.assertTrue((boolean)process.isRunning());
                TestServerMonitoringAdminImpl.assertTrue((boolean)process.isDeployed());
                TestServerMonitoringAdminImpl.assertEquals((long)2L, (long)process.getFreeMemory());
                TestServerMonitoringAdminImpl.assertEquals((int)2, (int)process.getThreadCount());
                TestServerMonitoringAdminImpl.assertEquals((int)2, (int)process.getSockets());
                TestServerMonitoringAdminImpl.assertEquals((String)HOST_2_2_2_2_PROCESS2_POOL, (String)process.getQueueWorkerPool().getIdentifier());
                TestServerMonitoringAdminImpl.assertEquals((int)2, (int)process.getQueueWorkerPool().getQueued());
                continue;
            }
            if (HOST_3_3_3_3_PROCESS3.equals(process.getIdentifier())) {
                TestServerMonitoringAdminImpl.assertTrue((boolean)process.isRunning());
                TestServerMonitoringAdminImpl.assertFalse((boolean)process.isDeployed());
                continue;
            }
            TestServerMonitoringAdminImpl.fail((String)("Unexpected process " + process.getIdentifier()));
        }
        results = this.admin.getProcesses("1.1.1.1*");
        TestServerMonitoringAdminImpl.assertEquals((int)1, (int)results.size());
        results = this.admin.getProcesses(HOST_1_1_1_1_PROCESS1);
        TestServerMonitoringAdminImpl.assertEquals((int)1, (int)results.size());
    }

    public void testGetQueueWorkerPools() throws AdminException {
        Collection results = this.admin.getQueueWorkerPools("*");
        TestServerMonitoringAdminImpl.assertEquals((int)4, (int)results.size());
        for (MMQueueWorkerPool pool : results) {
            if (HOST_2_2_2_2_PROCESS2_CONNECTOR_BINDING2_POOL.equals(pool.getIdentifier())) {
                TestServerMonitoringAdminImpl.assertEquals((int)2, (int)pool.getQueued());
                TestServerMonitoringAdminImpl.assertEquals((long)2L, (long)pool.getTotalEnqueues());
                continue;
            }
            if (HOST_3_3_3_3_PROCESS3_CONNECTOR_BINDING3_POOL.equals(pool.getIdentifier())) {
                TestServerMonitoringAdminImpl.assertEquals((int)3, (int)pool.getQueued());
                TestServerMonitoringAdminImpl.assertEquals((long)3L, (long)pool.getTotalEnqueues());
                continue;
            }
            if (HOST_2_2_2_2_PROCESS2_CONNECTOR_DQP2_POOL.equals(pool.getIdentifier())) {
                TestServerMonitoringAdminImpl.assertEquals((int)5, (int)pool.getQueued());
                TestServerMonitoringAdminImpl.assertEquals((long)5L, (long)pool.getTotalEnqueues());
                continue;
            }
            if (HOST_3_3_3_3_PROCESS3_CONNECTOR_DQP3_POOL.equals(pool.getIdentifier())) {
                TestServerMonitoringAdminImpl.assertEquals((int)6, (int)pool.getQueued());
                TestServerMonitoringAdminImpl.assertEquals((long)6L, (long)pool.getTotalEnqueues());
                continue;
            }
            TestServerMonitoringAdminImpl.fail((String)("unexpected pool " + pool.getIdentifier()));
        }
        results = this.admin.getQueueWorkerPools("2.2.2.2*");
        TestServerMonitoringAdminImpl.assertEquals((int)2, (int)results.size());
        results = this.admin.getQueueWorkerPools(HOST_2_2_2_2_PROCESS2_WILDCARD);
        TestServerMonitoringAdminImpl.assertEquals((int)2, (int)results.size());
        results = this.admin.getQueueWorkerPools(HOST_2_2_2_2_PROCESS2_CONNECTOR_BINDING2_WILDCARD);
        TestServerMonitoringAdminImpl.assertEquals((int)1, (int)results.size());
        results = this.admin.getQueueWorkerPools(HOST_2_2_2_2_PROCESS2_CONNECTOR_BINDING2_POOL);
        TestServerMonitoringAdminImpl.assertEquals((int)1, (int)results.size());
    }

    public void testGetRequests() throws AdminException {
        Collection results = this.admin.getRequests("*");
        TestServerMonitoringAdminImpl.assertEquals((int)2, (int)results.size());
        MMRequest request = (MMRequest)results.iterator().next();
        TestServerMonitoringAdminImpl.assertEquals((String)REQUEST_1_1, (String)request.getIdentifier());
        TestServerMonitoringAdminImpl.assertEquals((String)"1", (String)request.getSessionID());
        TestServerMonitoringAdminImpl.assertEquals((String)"1", (String)request.getRequestID());
        TestServerMonitoringAdminImpl.assertEquals((String)"user1", (String)request.getUserName());
        results = this.admin.getRequests("1*");
        TestServerMonitoringAdminImpl.assertEquals((int)1, (int)results.size());
        results = this.admin.getRequests(REQUEST_1_1);
        TestServerMonitoringAdminImpl.assertEquals((int)1, (int)results.size());
    }

    public void testGetResources() throws AdminException {
        Collection results = this.admin.getResources("*");
        TestServerMonitoringAdminImpl.assertEquals((int)2, (int)results.size());
        MMResource resource = (MMResource)results.iterator().next();
        TestServerMonitoringAdminImpl.assertEquals((String)"resource1", (String)resource.getIdentifier());
        TestServerMonitoringAdminImpl.assertEquals((String)"JDBC Resource Type", (String)resource.getResourceType());
        TestServerMonitoringAdminImpl.assertEquals((String)"pool", (String)resource.getConnectionPoolIdentifier());
        results = this.admin.getResources("resource1");
        TestServerMonitoringAdminImpl.assertEquals((int)1, (int)results.size());
    }

    public void testGetSourceRequests() throws AdminException {
        Collection results = this.admin.getSourceRequests("*");
        TestServerMonitoringAdminImpl.assertEquals((int)2, (int)results.size());
        MMSourceRequest request = (MMSourceRequest)results.iterator().next();
        TestServerMonitoringAdminImpl.assertEquals((String)REQUEST_1_1_1, (String)request.getIdentifier());
        TestServerMonitoringAdminImpl.assertEquals((String)"1", (String)request.getSessionID());
        TestServerMonitoringAdminImpl.assertEquals((String)REQUEST_1_1, (String)request.getRequestID());
        TestServerMonitoringAdminImpl.assertEquals((String)"connectorBinding1", (String)request.getConnectorBindingName());
        TestServerMonitoringAdminImpl.assertEquals((String)"user1", (String)request.getUserName());
        results = this.admin.getSourceRequests("1*");
        TestServerMonitoringAdminImpl.assertEquals((int)1, (int)results.size());
        results = this.admin.getSourceRequests(_1_1_WILDCARD);
        TestServerMonitoringAdminImpl.assertEquals((int)1, (int)results.size());
        results = this.admin.getSourceRequests(REQUEST_1_1_1);
        TestServerMonitoringAdminImpl.assertEquals((int)1, (int)results.size());
    }

    public void testGetSessions() throws AdminException {
        Collection results = this.admin.getSessions("*");
        TestServerMonitoringAdminImpl.assertEquals((int)2, (int)results.size());
        MMSession session = (MMSession)results.iterator().next();
        TestServerMonitoringAdminImpl.assertEquals((String)"00000000-0000-0001-0000-000000000001", (String)session.getIdentifier());
        TestServerMonitoringAdminImpl.assertEquals((String)"vdb1", (String)session.getVDBName());
        TestServerMonitoringAdminImpl.assertEquals((String)"1", (String)session.getVDBVersion());
        TestServerMonitoringAdminImpl.assertEquals((String)"app1", (String)session.getApplicationName());
        TestServerMonitoringAdminImpl.assertEquals((String)"product1", (String)session.getProductName());
        results = this.admin.getSessions("00000000-0000-0001-0000-000000000001");
        TestServerMonitoringAdminImpl.assertEquals((int)1, (int)results.size());
    }

    public void testGetSystem() throws AdminException {
        MMSystem system = (MMSystem)this.admin.getSystem();
        TestServerMonitoringAdminImpl.assertTrue((boolean)system.isStarted());
        TestServerMonitoringAdminImpl.assertEquals((Object)new Date(1234L), (Object)system.getStartTime());
        TestServerMonitoringAdminImpl.assertEquals((String)"value1", (String)system.getProperties().getProperty("key1"));
    }

    public void testGetVDBs() {
    }
}

