/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.server;

import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.exception.AdminProcessingException;
import com.metamatrix.admin.api.objects.AdminObject;
import com.metamatrix.admin.api.objects.Request;
import com.metamatrix.admin.server.FakeCacheAdmin;
import com.metamatrix.admin.server.FakeQueryService;
import com.metamatrix.admin.server.FakeRuntimeStateAdminAPIHelper;
import com.metamatrix.admin.server.FakeServerAdminImpl;
import com.metamatrix.admin.server.FakeServerSessionService;
import com.metamatrix.admin.server.IdentifierConstants;
import com.metamatrix.admin.server.ServerAdminImpl;
import com.metamatrix.admin.server.ServerRuntimeStateAdminImpl;
import com.metamatrix.common.id.dbid.DBIDGenerator;
import com.metamatrix.platform.registry.ClusteredRegistryState;
import com.metamatrix.platform.registry.FakeRegistryUtil;
import com.metamatrix.platform.registry.ResourceNotBoundException;
import com.metamatrix.platform.registry.ServiceRegistryBinding;
import com.metamatrix.platform.service.api.ServiceID;
import junit.framework.TestCase;

public class TestServerRuntimeStateAdminImpl
extends TestCase
implements IdentifierConstants {
    private ServerAdminImpl parent;
    private ServerRuntimeStateAdminImpl admin;

    public void setUp() throws Exception {
        System.setProperty("metamatrix.config.none", "true");
        System.setProperty("metamatrix.message.bus.type", "noop.message.bus");
        DBIDGenerator.getInstance().setUseMemoryIDGeneration(true);
        FakeQueryService.clearState();
        FakeCacheAdmin.clearState();
        FakeRuntimeStateAdminAPIHelper.clearState();
        ClusteredRegistryState registry = FakeRegistryUtil.getFakeRegistry();
        this.parent = new FakeServerAdminImpl(registry);
        this.admin = new ServerRuntimeStateAdminImpl(this.parent, registry);
    }

    public void testCancelRequest() throws AdminException {
        boolean failed = false;
        try {
            this.admin.cancelRequest("1*");
        }
        catch (AdminProcessingException e) {
            failed = true;
        }
        TestServerRuntimeStateAdminImpl.assertTrue((String)"Expected AdminProcessingException", (boolean)failed);
        TestServerRuntimeStateAdminImpl.assertTrue((boolean)FakeQueryService.cancelledQueries.isEmpty());
        this.admin.cancelRequest(REQUEST_1_1);
        TestServerRuntimeStateAdminImpl.assertTrue((boolean)FakeQueryService.cancelledQueries.contains(REQUEST_1_1));
        failed = false;
        try {
            this.admin.cancelRequest("abc" + Request.DELIMITER + "def");
        }
        catch (AdminProcessingException e) {
            failed = true;
        }
        TestServerRuntimeStateAdminImpl.assertTrue((String)"Expected AdminProcessingException", (boolean)failed);
    }

    public void testCancelSourceRequest() throws AdminException {
        TestServerRuntimeStateAdminImpl.assertTrue((boolean)FakeQueryService.cancelledQueries.isEmpty());
        this.admin.cancelSourceRequest(REQUEST_1_1_1);
        TestServerRuntimeStateAdminImpl.assertTrue((boolean)FakeQueryService.cancelledQueries.contains(REQUEST_1_1_1));
        boolean failed = false;
        try {
            this.admin.cancelSourceRequest("1" + Request.DELIMITER + "1" + "*");
        }
        catch (AdminProcessingException e) {
            failed = true;
        }
        TestServerRuntimeStateAdminImpl.assertTrue((String)"Expected AdminProcessingException", (boolean)failed);
        failed = false;
        try {
            this.admin.cancelSourceRequest("abc" + Request.DELIMITER + "def" + Request.DELIMITER + "ghi");
        }
        catch (AdminProcessingException e) {
            failed = true;
        }
        TestServerRuntimeStateAdminImpl.assertTrue((String)"Expected AdminProcessingException", (boolean)failed);
    }

    public void testChangeVDBStatus() {
    }

    public void testClearCache() throws AdminException {
        TestServerRuntimeStateAdminImpl.assertTrue((boolean)FakeCacheAdmin.clearedCaches.isEmpty());
        this.admin.clearCache("PreparedPlanCache");
        TestServerRuntimeStateAdminImpl.assertTrue((boolean)FakeCacheAdmin.clearedCaches.contains("cache1"));
        boolean failed = false;
        try {
            this.admin.cancelSourceRequest("*badcachename");
        }
        catch (AdminProcessingException e) {
            failed = true;
        }
        TestServerRuntimeStateAdminImpl.assertTrue((String)"Expected AdminProcessingException", (boolean)failed);
    }

    public void testStartConnectorBinding() throws AdminException {
        TestServerRuntimeStateAdminImpl.assertTrue((boolean)FakeRuntimeStateAdminAPIHelper.restartedServices.isEmpty());
        String host = "2.2.2.2";
        String process = "process2";
        try {
            ServiceRegistryBinding binding = this.admin.registry.getServiceBinding(host, process, new ServiceID(2L, host, process));
            binding.updateState(2);
        }
        catch (ResourceNotBoundException e1) {
            // empty catch block
        }
        this.admin.startConnectorBinding("*connectorBinding2");
        TestServerRuntimeStateAdminImpl.assertTrue((boolean)FakeRuntimeStateAdminAPIHelper.restartedServices.contains("Service<2|2.2.2.2|process2>"));
        boolean success = false;
        try {
            this.admin.startConnectorBinding("*badcbname");
            success = true;
        }
        catch (AdminProcessingException e) {
            success = false;
        }
        TestServerRuntimeStateAdminImpl.assertFalse((String)"Should not have been able to startConnectorBinding - *badcbname", (boolean)success);
        success = false;
        try {
            this.admin.startConnectorBinding("*");
            success = true;
        }
        catch (AdminProcessingException e) {
            success = false;
        }
        TestServerRuntimeStateAdminImpl.assertTrue((String)"Should have been able to startConnectorBinding - *", (boolean)success);
    }

    public void testStartHost() throws AdminException {
        TestServerRuntimeStateAdminImpl.assertTrue((boolean)FakeRuntimeStateAdminAPIHelper.startedHosts.isEmpty());
        this.admin.startHost("2.2.2.2", true);
        TestServerRuntimeStateAdminImpl.assertTrue((boolean)FakeRuntimeStateAdminAPIHelper.startedHosts.contains("2.2.2.2"));
    }

    public void testStartProcess() throws AdminException {
        TestServerRuntimeStateAdminImpl.assertTrue((boolean)FakeRuntimeStateAdminAPIHelper.startedProcesses.isEmpty());
        this.admin.startProcess(HOST_2_2_2_2_PROCESS2, true);
        TestServerRuntimeStateAdminImpl.assertTrue((boolean)FakeRuntimeStateAdminAPIHelper.startedProcesses.contains(HOST_2_2_2_2_PROCESS2));
        boolean failed = false;
        try {
            this.admin.startProcess("*process2", true);
        }
        catch (AdminProcessingException e) {
            failed = true;
        }
        TestServerRuntimeStateAdminImpl.assertTrue((String)"Expected AdminProcessingException", (boolean)failed);
    }

    public void testStopConnectorBinding() throws AdminException {
        TestServerRuntimeStateAdminImpl.assertTrue((boolean)FakeRuntimeStateAdminAPIHelper.stoppedServices.isEmpty());
        this.admin.stopConnectorBinding("*connectorBinding2", true);
        TestServerRuntimeStateAdminImpl.assertTrue((boolean)FakeRuntimeStateAdminAPIHelper.stoppedServices.contains("Service<2|2.2.2.2|process2>"));
        boolean success = false;
        try {
            this.admin.stopConnectorBinding("*badcbname", true);
            success = true;
        }
        catch (AdminProcessingException e) {
            success = false;
        }
        TestServerRuntimeStateAdminImpl.assertFalse((String)"Should not have been able to stopConnectorBinding - *badcbname", (boolean)success);
        success = false;
        try {
            this.admin.stopConnectorBinding("*", true);
            success = true;
        }
        catch (AdminProcessingException e) {
            success = false;
        }
        TestServerRuntimeStateAdminImpl.assertTrue((String)"Should have been able to stopConnectorBinding - *", (boolean)success);
    }

    public void testStopHost() throws AdminException {
        TestServerRuntimeStateAdminImpl.assertTrue((boolean)FakeRuntimeStateAdminAPIHelper.stoppedHosts.isEmpty());
        this.admin.stopHost("2.2.2.2", true, false);
        TestServerRuntimeStateAdminImpl.assertTrue((boolean)FakeRuntimeStateAdminAPIHelper.stoppedHosts.contains("2.2.2.2"));
    }

    public void testStopProcess() throws AdminException {
        TestServerRuntimeStateAdminImpl.assertTrue((boolean)FakeRuntimeStateAdminAPIHelper.stoppedProcesses.isEmpty());
        this.admin.stopProcess("*process2", true, false);
        TestServerRuntimeStateAdminImpl.assertTrue((boolean)FakeRuntimeStateAdminAPIHelper.stoppedProcesses.contains("2.2.2.2|process2"));
        boolean failed = false;
        try {
            this.admin.stopProcess("*badprocessname", true, false);
        }
        catch (AdminProcessingException e) {
            failed = true;
        }
        TestServerRuntimeStateAdminImpl.assertTrue((String)"Expected AdminProcessingException", (boolean)failed);
        failed = false;
        try {
            this.admin.stopProcess("*", true, false);
        }
        catch (AdminProcessingException e) {
            failed = true;
        }
        TestServerRuntimeStateAdminImpl.assertTrue((String)"Expected AdminProcessingException", (boolean)failed);
    }

    public void testStopSystem() throws AdminException {
        TestServerRuntimeStateAdminImpl.assertFalse((boolean)FakeRuntimeStateAdminAPIHelper.shutdownSystem);
        this.admin.stopSystem();
        TestServerRuntimeStateAdminImpl.assertTrue((boolean)FakeRuntimeStateAdminAPIHelper.shutdownSystem);
    }

    public void testSynchronizeSystem() throws AdminException {
        TestServerRuntimeStateAdminImpl.assertFalse((boolean)FakeRuntimeStateAdminAPIHelper.synchronizeSystem);
        this.admin.synchronizeSystem(false);
        TestServerRuntimeStateAdminImpl.assertTrue((boolean)FakeRuntimeStateAdminAPIHelper.synchronizeSystem);
    }

    public void testTerminateSession() throws AdminException {
        TestServerRuntimeStateAdminImpl.assertTrue((boolean)FakeServerSessionService.terminatedSessions.isEmpty());
        this.admin.terminateSession("00000000-0000-0001-0000-000000000001");
        TestServerRuntimeStateAdminImpl.assertTrue((boolean)FakeServerSessionService.terminatedSessions.contains("00000000-0000-0001-0000-000000000001"));
        boolean failed = false;
        try {
            this.admin.terminateSession("abc" + AdminObject.DELIMITER + "def");
        }
        catch (AdminProcessingException e) {
            failed = true;
        }
        TestServerRuntimeStateAdminImpl.assertTrue((String)"Expected AdminProcessingException", (boolean)failed);
    }
}

