/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.util;

import com.metamatrix.admin.AdminPlugin;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.util.AdminMethodRoleResolver;
import junit.framework.TestCase;

public class TestAdminMethodRoleResolver
extends TestCase {
    private AdminMethodRoleResolver methods;

    public TestAdminMethodRoleResolver(String name) {
        super(name);
    }

    private AdminMethodRoleResolver getAdminMethods() throws AdminException {
        if (this.methods == null) {
            AdminMethodRoleResolver theMethods = new AdminMethodRoleResolver();
            theMethods.init();
            this.methods = theMethods;
        }
        return this.methods;
    }

    private void helpTestExpectedRoles(String method, String expectedRoleName) throws Exception {
        AdminMethodRoleResolver methodHolder = this.getAdminMethods();
        String roleName = methodHolder.getRoleNameForMethod(method);
        TestAdminMethodRoleResolver.assertTrue((String)("Did not receive the roles expected. Expected: " + expectedRoleName + " Recieved: " + roleName), (boolean)roleName.equals(expectedRoleName));
        TestAdminMethodRoleResolver.assertTrue((String)("Did not receive the roles expected.  Expected: " + expectedRoleName + " Recieved: " + roleName), (boolean)expectedRoleName.equals(roleName));
    }

    public void testInitWithUnknownMethod_fail() throws Exception {
        String methodName = "addBogus";
        try {
            this.getAdminMethods().getRoleNameForMethod(methodName);
        }
        catch (AdminException err) {
            Object[] params = new Object[]{methodName};
            String msg = AdminPlugin.Util.getString("AdminMethodRoleResolver.Unknown_method", params);
            TestAdminMethodRoleResolver.assertEquals((String)msg, (String)err.getMessage());
        }
    }

    public void testAddUser_succeed() throws Exception {
        String methodName = "addUser";
        this.helpTestExpectedRoles(methodName, "Admin.SystemAdmin");
    }

    public void testEnableHost_succeed() throws Exception {
        String methodName = "enableHost";
        this.helpTestExpectedRoles(methodName, "Admin.SystemAdmin");
    }

    public void testGetVdbs() throws Exception {
        String methodName = "getVDBs";
        this.helpTestExpectedRoles(methodName, "Anonymous");
    }
}

