/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform;

import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.platform.admin.apiimpl.IAdminHelper;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.SessionToken;
import java.util.Iterator;
import java.util.Set;

public class FakeAdminHelper
implements IAdminHelper {
    private String userName;
    private Set userRoleNames;

    public FakeAdminHelper(String userName, Set userRoleNames) {
        this.userName = userName;
        this.userRoleNames = userRoleNames;
    }

    public void checkForRequiredRole(SessionToken adminToken, String roleName) throws AuthorizationException, ComponentNotFoundException {
        if (adminToken.getUsername().equals(this.userName)) {
            for (String userRole : this.userRoleNames) {
                if (!userRole.equals(roleName)) continue;
                return;
            }
            throw new AuthorizationException("User does not have required role [" + roleName + "].");
        }
        throw new AuthorizationException("User names are not equal. Incoming [" + adminToken.getUsername() + "] Expected [" + this.userName + "]");
    }

    public void checkForRequiredRole(SessionToken adminToken, Set roleNames) throws AuthorizationException, ComponentNotFoundException {
        Iterator roles = roleNames.iterator();
        while (roles.hasNext()) {
            this.checkForRequiredRole(adminToken, (String)roles.next());
        }
    }

    public SessionToken validateSession(MetaMatrixSessionID sessionID) throws InvalidSessionException, ComponentNotFoundException {
        return new SessionToken(sessionID, "fake");
    }
}

