/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.server;

import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.server.ServerAdmin;
import com.metamatrix.admin.util.AdminMethodRoleResolver;
import com.metamatrix.common.comm.platform.FakeAdminHelper;
import com.metamatrix.common.comm.platform.socket.server.AdminAuthorizationInterceptor;
import com.metamatrix.core.util.SimpleMock;
import com.metamatrix.platform.admin.apiimpl.IAdminHelper;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.SessionToken;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.teiid.dqp.internal.process.DQPWorkContext;

public class TestAdminAuthInterceptor
extends TestCase {
    public TestAdminAuthInterceptor(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        DQPWorkContext.getWorkContext().setSessionToken(new SessionToken(new MetaMatrixSessionID(1L), "gojo"));
    }

    protected void tearDown() throws Exception {
        DQPWorkContext.setWorkContext((DQPWorkContext)new DQPWorkContext());
    }

    public void testAddUserUDF_fail() throws AdminException {
        HashSet userRoles = new HashSet();
        ServerAdmin serverAdmin = this.getTestServerAdmin(userRoles);
        try {
            serverAdmin.addUDF(null, null);
        }
        catch (AdminException adminException) {
            // empty catch block
        }
    }

    private ServerAdmin getTestServerAdmin(Set userRoles) throws AdminException {
        FakeAdminHelper authHelper = new FakeAdminHelper("gojo", userRoles);
        AdminMethodRoleResolver roleResolver = new AdminMethodRoleResolver();
        roleResolver.init();
        AdminAuthorizationInterceptor authInterceptor = new AdminAuthorizationInterceptor((IAdminHelper)authHelper, roleResolver, (ServerAdmin)SimpleMock.createSimpleMock(ServerAdmin.class));
        ServerAdmin serverAdmin = (ServerAdmin)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{ServerAdmin.class}, (InvocationHandler)authInterceptor);
        return serverAdmin;
    }

    public void testAddUDF_succeed() throws Exception {
        HashSet<String> userRoles = new HashSet<String>();
        userRoles.add("Admin.SystemAdmin");
        ServerAdmin serverAdmin = this.getTestServerAdmin(userRoles);
        serverAdmin.addUDF(null, null);
    }

    public void testGetVDBs() throws Exception {
        HashSet userRoles = new HashSet();
        ServerAdmin serverAdmin = this.getTestServerAdmin(userRoles);
        serverAdmin.getVDBs("*");
    }

    public void testReadOnlyFails() throws Exception {
        HashSet userRoles = new HashSet();
        ServerAdmin serverAdmin = this.getTestServerAdmin(userRoles);
        try {
            serverAdmin.getSessions("*");
        }
        catch (AdminException adminException) {
            // empty catch block
        }
    }
}

