/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.server;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.LogonException;
import com.metamatrix.common.api.MMURL;
import com.metamatrix.common.comm.ClientServiceRegistry;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.exception.ConnectionException;
import com.metamatrix.common.comm.platform.socket.SocketUtil;
import com.metamatrix.common.comm.platform.socket.client.SocketServerConnection;
import com.metamatrix.common.comm.platform.socket.client.SocketServerConnectionFactory;
import com.metamatrix.common.comm.platform.socket.client.UrlServerDiscovery;
import com.metamatrix.common.comm.platform.socket.server.LogonImpl;
import com.metamatrix.common.comm.platform.socket.server.SocketListener;
import com.metamatrix.common.queue.WorkerPoolFactory;
import com.metamatrix.common.util.crypto.NullCryptor;
import com.metamatrix.platform.security.api.ILogon;
import com.metamatrix.platform.security.api.LogonResult;
import com.metamatrix.platform.security.api.service.SessionServiceInterface;
import com.metamatrix.platform.vm.controller.SocketListenerStats;
import java.net.InetSocketAddress;
import java.util.Properties;
import javax.net.ssl.SSLEngine;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCommSockets {
    SocketListener listener;
    private SocketServerConnectionFactory sscf;
    private InetSocketAddress addr;

    @Before
    public void setUp() {
        this.addr = new InetSocketAddress(0);
    }

    @After
    public void tearDown() throws Exception {
        if (this.listener != null) {
            this.listener.stop();
        }
    }

    @Test
    public void testFailedConnect() throws Exception {
        ClientServiceRegistry csr = new ClientServiceRegistry();
        SessionServiceInterface sessionService = (SessionServiceInterface)Mockito.mock(SessionServiceInterface.class);
        csr.registerClientService(ILogon.class, (Object)new LogonImpl(sessionService, "fakeCluster"), "foo");
        this.listener = new SocketListener(this.addr.getPort(), this.addr.getAddress().getHostAddress(), csr, 1024, 1024, WorkerPoolFactory.newWorkerPool((String)"testIO", (int)1, (long)120000L), null, true, sessionService);
        try {
            Properties p = new Properties();
            p.setProperty("serverURL", new MMURL(this.addr.getHostName(), this.listener.getPort() - 1, false).getAppServerURL());
            SocketServerConnectionFactory.getInstance().createConnection(p);
            Assert.fail((String)"exception expected");
        }
        catch (CommunicationException communicationException) {
            // empty catch block
        }
    }

    @Test
    public void testConnectWithoutPooling() throws Exception {
        Properties p = new Properties();
        p.setProperty("org.teiid.sockets.maxCachedInstances", String.valueOf(0));
        SocketServerConnection conn = this.helpEstablishConnection(false, null, true, p);
        SocketListenerStats stats = this.listener.getStats();
        Assert.assertEquals((long)2L, (long)stats.objectsRead);
        Assert.assertEquals((long)1L, (long)stats.sockets);
        conn.shutdown();
        stats = this.listener.getStats();
        Assert.assertEquals((long)1L, (long)stats.maxSockets);
        Assert.assertEquals((long)3L, (long)stats.objectsRead);
        if (stats.sockets > 0) {
            Thread.sleep(500L);
        }
        stats = this.listener.getStats();
        Assert.assertEquals((long)0L, (long)stats.sockets);
    }

    @Test
    public void testConnectWithPooling() throws Exception {
        SocketServerConnection conn = this.helpEstablishConnection(false, null);
        SocketListenerStats stats = this.listener.getStats();
        Assert.assertEquals((long)2L, (long)stats.objectsRead);
        Assert.assertEquals((long)1L, (long)stats.sockets);
        conn.shutdown();
        stats = this.listener.getStats();
        Assert.assertEquals((long)1L, (long)stats.maxSockets);
        Assert.assertEquals((long)3L, (long)stats.objectsRead);
        stats = this.listener.getStats();
        Assert.assertEquals((long)1L, (long)stats.sockets);
        conn = this.helpEstablishConnection(false, null);
        conn.shutdown();
        stats = this.listener.getStats();
        Assert.assertEquals((long)1L, (long)stats.sockets);
        Assert.assertEquals((long)1L, (long)stats.maxSockets);
    }

    @Test
    public void testConnectWithoutClientEncryption() throws Exception {
        SocketServerConnection conn = this.helpEstablishConnection(false, null, false, new Properties());
        Assert.assertTrue((boolean)(conn.selectServerInstance().getCryptor() instanceof NullCryptor));
        conn.shutdown();
    }

    private SocketServerConnection helpEstablishConnection(boolean secure, SSLEngine serverSSL) throws CommunicationException, ConnectionException {
        return this.helpEstablishConnection(secure, serverSSL, true, new Properties());
    }

    private SocketServerConnection helpEstablishConnection(boolean secure, SSLEngine serverSSL, boolean isClientEncryptionEnabled, Properties socketConfig) throws CommunicationException, ConnectionException {
        if (this.listener == null) {
            SessionServiceInterface sessionService = (SessionServiceInterface)Mockito.mock(SessionServiceInterface.class);
            ClientServiceRegistry csr = new ClientServiceRegistry();
            csr.registerClientService(ILogon.class, (Object)new LogonImpl(sessionService, "fakeCluster"){

                public LogonResult logon(Properties connProps) throws LogonException, ComponentNotFoundException {
                    return new LogonResult();
                }
            }, "foo");
            this.listener = new SocketListener(this.addr.getPort(), this.addr.getAddress().getHostAddress(), csr, 1024, 1024, WorkerPoolFactory.newWorkerPool((String)"testIO", (int)1, (long)120000L), serverSSL, isClientEncryptionEnabled, sessionService);
            SocketListenerStats stats = this.listener.getStats();
            Assert.assertEquals((long)0L, (long)stats.maxSockets);
            Assert.assertEquals((long)0L, (long)stats.objectsRead);
            Assert.assertEquals((long)0L, (long)stats.objectsWritten);
            Assert.assertEquals((long)0L, (long)stats.sockets);
        }
        Properties p = new Properties();
        p.setProperty("serverURL", new MMURL(this.addr.getHostName(), this.listener.getPort(), secure).getAppServerURL());
        p.setProperty("discoveryStategy", UrlServerDiscovery.class.getName());
        if (this.sscf == null) {
            this.sscf = new SocketServerConnectionFactory();
            this.sscf.init(socketConfig);
        }
        return this.sscf.createConnection(p);
    }

    @Test
    public void testSSLConnectWithNonSSLServer() throws Exception {
        try {
            this.helpEstablishConnection(true, null);
            Assert.fail((String)"exception expected");
        }
        catch (CommunicationException communicationException) {
            // empty catch block
        }
    }

    @Test
    public void testAnonSSLConnect() throws Exception {
        SSLEngine engine = SocketUtil.getAnonSSLContext().createSSLEngine();
        engine.setUseClientMode(false);
        engine.setEnabledCipherSuites(new String[]{"TLS_DH_anon_WITH_AES_128_CBC_SHA"});
        Properties p = new Properties();
        p.setProperty("org.teiid.ssl.trustStore", "none");
        SocketServerConnection conn = this.helpEstablishConnection(true, engine, true, p);
        conn.shutdown();
    }
}

