/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.server;

import com.metamatrix.api.exception.security.LogonException;
import com.metamatrix.common.comm.platform.socket.server.LogonImpl;
import com.metamatrix.platform.security.api.LogonResult;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.MetaMatrixSessionInfo;
import com.metamatrix.platform.security.api.service.SessionServiceInterface;
import java.util.Properties;
import junit.framework.TestCase;
import org.mockito.Mockito;

public class TestLogonImpl
extends TestCase {
    public void testLogonResult() throws Exception {
        SessionServiceInterface ssi = (SessionServiceInterface)Mockito.mock(SessionServiceInterface.class);
        String userName = "Fred";
        String applicationName = "test";
        String productName = "foo";
        Properties p = new Properties();
        p.setProperty("user", userName);
        p.setProperty("ApplicationName", applicationName);
        p.setProperty("productName", productName);
        MetaMatrixSessionInfo resultInfo = new MetaMatrixSessionInfo(new MetaMatrixSessionID(1L), userName, 0L, applicationName, 0, "bar", new Properties(), "product", null, null);
        Mockito.stub((Object)ssi.createSession(userName, null, null, applicationName, productName, p)).toReturn((Object)resultInfo);
        LogonImpl impl = new LogonImpl(ssi, "fakeCluster");
        LogonResult result = impl.logon(p);
        TestLogonImpl.assertEquals((String)userName, (String)result.getUserName());
        TestLogonImpl.assertEquals((Object)new MetaMatrixSessionID(1L), (Object)result.getSessionID());
    }

    public void testCredentials() throws Exception {
        SessionServiceInterface ssi = (SessionServiceInterface)Mockito.mock(SessionServiceInterface.class);
        LogonImpl impl = new LogonImpl(ssi, "fakeCluster");
        Properties p = new Properties();
        p.put("clientToken", new Object());
        p.setProperty("credentials", "(...)");
        try {
            impl.logon(p);
            TestLogonImpl.fail((String)"exception expected");
        }
        catch (LogonException e) {
            TestLogonImpl.assertEquals((String)"Conflicting use of both client session token and credentials. ", (String)e.getMessage());
        }
        p.remove("clientToken");
        try {
            impl.logon(p);
            TestLogonImpl.fail((String)"exception expected");
        }
        catch (LogonException e) {
            TestLogonImpl.assertEquals((String)"Credentials string must contain \"system\" property.", (String)e.getMessage());
        }
    }
}

