/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.server;

import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.api.exception.security.LogonException;
import com.metamatrix.common.api.HostInfo;
import com.metamatrix.common.api.MMURL;
import com.metamatrix.common.comm.ClientServiceRegistry;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.ResultsReceiver;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.exception.ConnectionException;
import com.metamatrix.common.comm.platform.socket.client.ServerDiscovery;
import com.metamatrix.common.comm.platform.socket.client.SocketServerConnection;
import com.metamatrix.common.comm.platform.socket.client.SocketServerInstance;
import com.metamatrix.common.comm.platform.socket.client.SocketServerInstanceFactory;
import com.metamatrix.common.comm.platform.socket.client.SocketServerInstanceImpl;
import com.metamatrix.common.comm.platform.socket.client.UrlServerDiscovery;
import com.metamatrix.common.comm.platform.socket.server.ClientInstance;
import com.metamatrix.common.comm.platform.socket.server.ServerWorkItem;
import com.metamatrix.common.util.crypto.Cryptor;
import com.metamatrix.common.util.crypto.NullCryptor;
import com.metamatrix.common.xa.XATransactionException;
import com.metamatrix.core.util.SimpleMock;
import com.metamatrix.dqp.client.ClientSideDQP;
import com.metamatrix.dqp.client.ResultsFuture;
import com.metamatrix.platform.security.api.ILogon;
import com.metamatrix.platform.security.api.LogonResult;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.service.SessionServiceInterface;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.teiid.dqp.internal.process.DQPWorkContext;

public class TestSocketRemoting
extends TestCase {
    public void testUnckedException() throws Exception {
        FakeClientServerInstance serverInstance = new FakeClientServerInstance(null);
        try {
            this.createFakeConnection(serverInstance);
            TestSocketRemoting.fail((String)"expected exception");
        }
        catch (CommunicationException e) {
            TestSocketRemoting.assertEquals((String)"Unable to find a component used in logging on to MetaMatrix", (String)e.getMessage());
        }
    }

    public void testMethodInvocation() throws Exception {
        ClientServiceRegistry csr = new ClientServiceRegistry();
        csr.registerClientService(ILogon.class, (Object)new ILogon(){

            public ResultsFuture<?> logoff() throws InvalidSessionException, MetaMatrixComponentException {
                ResultsFuture result = new ResultsFuture();
                result.getResultsReceiver().exceptionOccurred((Throwable)new MetaMatrixComponentException("some exception"));
                return result;
            }

            public LogonResult logon(Properties connectionProperties) throws LogonException, MetaMatrixComponentException {
                return new LogonResult();
            }

            public ResultsFuture<?> ping() throws InvalidSessionException, MetaMatrixComponentException {
                return null;
            }

            public void assertIdentity(MetaMatrixSessionID sessionId) throws InvalidSessionException, MetaMatrixComponentException {
            }
        }, "foo");
        csr.registerClientService(FakeService.class, (Object)new FakeServiceImpl(), "foo");
        FakeClientServerInstance serverInstance = new FakeClientServerInstance(csr);
        SocketServerConnection connection = this.createFakeConnection(serverInstance);
        ILogon logon = (ILogon)connection.getService(ILogon.class);
        ResultsFuture result = logon.ping();
        TestSocketRemoting.assertNull(result.get(0L, TimeUnit.MILLISECONDS));
        result = logon.logoff();
        try {
            result.get(0L, TimeUnit.MICROSECONDS);
            TestSocketRemoting.fail((String)"exception expected");
        }
        catch (ExecutionException e) {
            TestSocketRemoting.assertTrue((boolean)(e.getCause() instanceof MetaMatrixComponentException));
        }
        FakeService service = (FakeService)connection.getService(FakeService.class);
        ResultsFuture<Integer> asynchInteger = service.asynchResult();
        TestSocketRemoting.assertEquals((Object)new Integer(5), asynchInteger.get(0L, TimeUnit.MILLISECONDS));
        try {
            service.exceptionMethod();
            TestSocketRemoting.fail((String)"exception expected");
        }
        catch (MetaMatrixProcessingException e) {
            // empty catch block
        }
        ClientSideDQP dqp = (ClientSideDQP)connection.getService(ClientSideDQP.class);
        try {
            dqp.begin();
            TestSocketRemoting.fail((String)"exception expected");
        }
        catch (XATransactionException e) {
            e.printStackTrace();
            TestSocketRemoting.assertEquals((String)"Component not found: com.metamatrix.dqp.client.ClientSideDQP", (String)e.getMessage());
        }
    }

    private SocketServerConnection createFakeConnection(final FakeClientServerInstance serverInstance) throws CommunicationException, ConnectionException {
        SocketServerConnection connection = new SocketServerConnection(new SocketServerInstanceFactory(){

            public SocketServerInstance getServerInstance(HostInfo info, boolean ssl) throws CommunicationException, IOException {
                return serverInstance;
            }
        }, false, (ServerDiscovery)new UrlServerDiscovery(new MMURL("foo", 1, false)), new Properties(), null);
        return connection;
    }

    private static class FakeClientServerInstance
    extends SocketServerInstanceImpl
    implements ClientInstance {
        ClientServiceRegistry clientServiceRegistry;
        private ResultsReceiver<Object> listener;

        public FakeClientServerInstance(ClientServiceRegistry clientServiceRegistry) {
            this.clientServiceRegistry = clientServiceRegistry;
        }

        public HostInfo getHostInfo() {
            return new HostInfo("fake", 1);
        }

        public boolean isOpen() {
            return true;
        }

        public void send(Message message, ResultsReceiver<Object> listener, Serializable messageKey) throws CommunicationException, InterruptedException {
            ServerWorkItem workItem = new ServerWorkItem((ClientInstance)this, messageKey, message, this.clientServiceRegistry, (SessionServiceInterface)SimpleMock.createSimpleMock(SessionServiceInterface.class));
            this.listener = listener;
            workItem.run();
        }

        public void shutdown() {
        }

        public Cryptor getCryptor() {
            return new NullCryptor();
        }

        public DQPWorkContext getWorkContext() {
            return new DQPWorkContext();
        }

        public void send(Message message, Serializable messageKey) {
            this.listener.receiveResults((Object)message.getContents());
        }
    }

    private static class FakeServiceImpl
    implements FakeService {
        private FakeServiceImpl() {
        }

        @Override
        public ResultsFuture<Integer> asynchResult() {
            ResultsFuture result = new ResultsFuture();
            result.getResultsReceiver().receiveResults((Object)new Integer(5));
            return result;
        }

        @Override
        public String exceptionMethod() throws MetaMatrixProcessingException {
            throw new MetaMatrixProcessingException();
        }
    }

    public static interface FakeService {
        public ResultsFuture<Integer> asynchResult();

        public String exceptionMethod() throws MetaMatrixProcessingException;
    }
}

