/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.extensionmodule;

import com.metamatrix.common.extensionmodule.ExtensionModuleDescriptor;
import com.metamatrix.core.util.Assertion;

public class ExtensionModuleDescriptorUtils {
    private ExtensionModuleDescriptorUtils() {
    }

    public static boolean equals(ExtensionModuleDescriptor descriptor, Object obj) {
        if (descriptor == obj) {
            return true;
        }
        if (obj instanceof ExtensionModuleDescriptor) {
            ExtensionModuleDescriptor that = (ExtensionModuleDescriptor)obj;
            return descriptor.getPosition() == that.getPosition();
        }
        return false;
    }

    public static int compareTo(ExtensionModuleDescriptor descriptor, Object obj) {
        ExtensionModuleDescriptor that = (ExtensionModuleDescriptor)obj;
        Assertion.isNotNull((Object)obj, (String)"Attempt to compare null");
        if (obj == descriptor) {
            return 0;
        }
        return descriptor.getPosition() - that.getPosition();
    }

    public static boolean isEquivalent(ExtensionModuleDescriptor descriptor, Object obj) {
        if (!ExtensionModuleDescriptorUtils.equals(descriptor, obj)) {
            return false;
        }
        ExtensionModuleDescriptor that = (ExtensionModuleDescriptor)obj;
        if (!descriptor.getName().equals(that.getName())) {
            return false;
        }
        if (!descriptor.getType().equals(that.getType())) {
            return false;
        }
        if (!descriptor.getCreatedBy().equals(that.getCreatedBy())) {
            return false;
        }
        if (!descriptor.getLastUpdatedBy().equals(that.getLastUpdatedBy())) {
            return false;
        }
        if (!descriptor.getCreationDate().equals(that.getCreationDate())) {
            return false;
        }
        if (!descriptor.getLastUpdatedDate().equals(that.getLastUpdatedDate())) {
            return false;
        }
        if (descriptor.getChecksum() != that.getChecksum()) {
            return false;
        }
        if (descriptor.isEnabled() != that.isEnabled()) {
            return false;
        }
        if (descriptor.getDescription() == null) {
            return that.getDescription() == null;
        }
        if (that.getDescription() == null) {
            return false;
        }
        return descriptor.getDescription().equals(that.getDescription());
    }

    public static String toVerboseString(ExtensionModuleDescriptor descriptor) {
        StringBuffer s = new StringBuffer("ExtensionModuleDescriptor " + descriptor.getName() + "\n");
        s.append("  type       : " + descriptor.getType() + "\n");
        s.append("  description: " + descriptor.getDescription() + "\n");
        s.append("  position   : " + descriptor.getPosition() + "\n");
        s.append("  enabled    : " + descriptor.isEnabled() + "\n");
        s.append("  created by : " + descriptor.getCreatedBy() + "\n");
        s.append("  created    : " + descriptor.getCreationDate() + "\n");
        s.append("  updated by : " + descriptor.getLastUpdatedBy() + "\n");
        s.append("  updated    : " + descriptor.getLastUpdatedDate() + "\n");
        s.append("  checksum   : " + descriptor.getChecksum() + "\n");
        s.append("(Class: " + descriptor.getClass().getName() + ")");
        return s.toString();
    }
}

