/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.extensionmodule;

import com.metamatrix.common.extensionmodule.ExtensionModuleDescriptor;
import com.metamatrix.common.extensionmodule.ExtensionModuleDescriptorUtils;
import com.metamatrix.common.util.ByteArrayHelper;
import com.metamatrix.core.util.DateUtil;
import com.metamatrix.core.util.UnitTestUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public final class FakeData {
    public static final String PARENT_DIRECTORY = UnitTestUtil.getTestDataPath() + "/extensionmodule";
    public static final String SYSTEM_PRINCIPAL = "System";
    public static final List DATA_FILES;

    public static void init() throws IOException {
        TestJar1.data = FakeData.loadFileIntoMemory(PARENT_DIRECTORY, "fake1.jar");
        TestJar2.data = FakeData.loadFileIntoMemory(PARENT_DIRECTORY, "fake2.jar");
        TestJar7.data = FakeData.createBigByteArray(32000000);
        TestTextFile.data = FakeData.loadFileIntoMemory(PARENT_DIRECTORY, "fake.txt");
        TestTextFile2.data = FakeData.loadFileIntoMemory(PARENT_DIRECTORY, "Nuge.log");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadFileIntoMemory(String parentDirectory, String fileName) throws IOException {
        InputStream stream = null;
        byte[] data = null;
        try {
            File aFile = new File(parentDirectory, fileName);
            stream = new FileInputStream(aFile);
            int size = (int)aFile.length();
            data = ByteArrayHelper.toByteArray((InputStream)stream, (int)(size + 1));
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {}
        }
        return data;
    }

    public static byte[] createBigByteArray(int size) {
        byte[] bytes = new byte[size];
        Arrays.fill(bytes, (byte)1);
        return bytes;
    }

    static {
        ArrayList<ExtensionModuleDescriptor> aList = new ArrayList<ExtensionModuleDescriptor>();
        aList.add(TestJar1.DESCRIPTOR);
        aList.add(TestJar2.DESCRIPTOR);
        aList.add(TestJar7.DESCRIPTOR);
        aList.add(TestTextFile.DESCRIPTOR);
        aList.add(TestTextFile2.DESCRIPTOR);
        DATA_FILES = Collections.unmodifiableList(aList);
    }

    private static class DataFileImpl
    extends ExtensionModuleDescriptor
    implements Serializable {
        private String name;
        private String type;
        private int pos;
        private String desc;
        private String modifiedString;
        private long checksum;

        DataFileImpl(String name, String type, int pos, String desc, long checksum, long modified) {
            this.modifiedString = DateUtil.getDateAsString((Date)new Date(modified));
            this.name = name;
            this.type = type;
            this.desc = desc;
            this.checksum = checksum;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public int getPosition() {
            return this.pos;
        }

        public boolean isEnabled() {
            return true;
        }

        public String getDescription() {
            return this.desc;
        }

        public String getCreatedBy() {
            return FakeData.SYSTEM_PRINCIPAL;
        }

        public String getCreationDate() {
            return this.modifiedString;
        }

        public String getLastUpdatedBy() {
            return FakeData.SYSTEM_PRINCIPAL;
        }

        public String getLastUpdatedDate() {
            return this.modifiedString;
        }

        public long getChecksum() {
            return this.checksum;
        }

        public int compareTo(Object obj) {
            return ExtensionModuleDescriptorUtils.compareTo(this, obj);
        }

        public boolean equals(Object obj) {
            return ExtensionModuleDescriptorUtils.equals(this, obj);
        }
    }

    public static class TestTextFile2 {
        public static final String SOURCE_NAME = "Nuge.log";
        public static final String TYPE = "Function Definition";
        public static final String DESCRIPTION = "A test text file";
        private static final long CHECKSUM = 3438642310L;
        private static final long LAST_MODIFIED = new File(PARENT_DIRECTORY, "Nuge.log").lastModified();
        private static final int POSITION = 8;
        public static byte[] data;
        public static final ExtensionModuleDescriptor DESCRIPTOR;

        static {
            DESCRIPTOR = new DataFileImpl(SOURCE_NAME, TYPE, 8, DESCRIPTION, 3438642310L, LAST_MODIFIED);
        }
    }

    public static class TestTextFile {
        public static final String SOURCE_NAME = "fake.txt";
        public static final String TYPE = "Function Definition";
        public static final String DESCRIPTION = "A test text file";
        private static final long CHECKSUM = 3438642310L;
        private static final long LAST_MODIFIED = new File(PARENT_DIRECTORY, "fake.txt").lastModified();
        private static final int POSITION = 7;
        public static byte[] data;
        public static final ExtensionModuleDescriptor DESCRIPTOR;

        static {
            DESCRIPTOR = new DataFileImpl(SOURCE_NAME, TYPE, 7, DESCRIPTION, 3438642310L, LAST_MODIFIED);
        }
    }

    public static class TestJar7 {
        public static final String SOURCE_NAME = "big.jar";
        public static final String TYPE = "JAR File";
        public static final String DESCRIPTION = "A test JAR file of no interest";
        private static final long CHECKSUM = 1895850785L;
        private static final long LAST_MODIFIED = new File(PARENT_DIRECTORY, "big.jar").lastModified();
        private static final int POSITION = 6;
        public static byte[] data;
        public static final ExtensionModuleDescriptor DESCRIPTOR;

        static {
            DESCRIPTOR = new DataFileImpl(SOURCE_NAME, TYPE, 6, DESCRIPTION, 1895850785L, LAST_MODIFIED);
        }
    }

    public static class TestJar2 {
        public static final String SOURCE_NAME = "fake2.jar";
        public static final String TYPE = "JAR File";
        public static final String DESCRIPTION = "A test JAR file with two classes";
        private static final long CHECKSUM = 360275295L;
        private static final long LAST_MODIFIED = new File(PARENT_DIRECTORY, "fake2.jar").lastModified();
        private static final int POSITION = 1;
        public static byte[] data;
        public static final ExtensionModuleDescriptor DESCRIPTOR;

        static {
            DESCRIPTOR = new DataFileImpl(SOURCE_NAME, TYPE, 1, DESCRIPTION, 360275295L, LAST_MODIFIED);
        }

        public static class Class2 {
            public static final String CLASSNAME = "com.fake.MyClass2a";
            public static Class theClass;
        }

        public static class Class1 {
            public static final String CLASSNAME = "com.fake.MyClass2";
            public static Class theClass;
        }
    }

    public static class TestJar1 {
        public static final String SOURCE_NAME = "fake1.jar";
        public static final String TYPE = "JAR File";
        public static final String DESCRIPTION = "A test JAR file with one class";
        private static final long CHECKSUM = 4287822908L;
        private static final long LAST_MODIFIED = new File(PARENT_DIRECTORY, "fake1.jar").lastModified();
        private static final int POSITION = 0;
        public static byte[] data;
        public static final ExtensionModuleDescriptor DESCRIPTOR;

        static {
            DESCRIPTOR = new DataFileImpl(SOURCE_NAME, TYPE, 0, DESCRIPTION, 4287822908L, LAST_MODIFIED);
        }

        public static class Class1 {
            public static final String CLASSNAME = "com.fake.MyClass1";
            public static Class theClass;
        }
    }
}

