/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.extensionmodule;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.extensionmodule.ExtensionModuleDescriptor;
import com.metamatrix.common.extensionmodule.ExtensionModuleManager;
import com.metamatrix.common.extensionmodule.FakeData;
import com.metamatrix.common.extensionmodule.exception.DuplicateExtensionModuleException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleNotFoundException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleOrderingException;
import com.metamatrix.common.extensionmodule.exception.InvalidExtensionModuleTypeException;
import com.metamatrix.common.util.PropertiesUtils;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.CRC32;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestExtensionModuleManager
extends TestCase {
    private static final String PRINCIPAL = "TestPrincipal";
    private ExtensionModuleManager manager;

    public TestExtensionModuleManager(String name) {
        super(name);
    }

    public static void setUpOnce() throws Exception {
        ExtensionModuleManager.reInit();
        TestExtensionModuleManager.resetProperties();
        FakeData.init();
    }

    public static void resetProperties() {
        try {
            CurrentConfiguration.getInstance().reset();
        }
        catch (ConfigurationException e) {
            // empty catch block
        }
        System.setProperty("metamatrix.message.bus.type", "noop.message.bus");
        boolean deepClone = false;
        boolean makeUnmodifiable = false;
        Properties newSystemProps = PropertiesUtils.clone((Properties)System.getProperties(), (Properties)TestExtensionModuleManager.getExtensionModuleProperties(), (boolean)deepClone, (boolean)makeUnmodifiable);
        newSystemProps = PropertiesUtils.clone((Properties)newSystemProps, (boolean)makeUnmodifiable);
        System.setProperties(newSystemProps);
    }

    private static Properties getExtensionModuleProperties() {
        Properties BASE_PROPERTIES = new Properties();
        BASE_PROPERTIES.setProperty("metamatrix.log.captureSystemOut", "false");
        BASE_PROPERTIES.setProperty("metamatrix.log.captureSystemErr", "false");
        BASE_PROPERTIES.setProperty("metamatrix.log", "5");
        BASE_PROPERTIES.setProperty("metamatrix.log.console", "true");
        BASE_PROPERTIES.setProperty("metamatrix.log.consoleFormat", "com.metamatrix.common.log.format.ReadableLogMessageFormat");
        BASE_PROPERTIES.setProperty("metamatrix.extensionsource.connection.Factory", "com.metamatrix.common.extensionmodule.spi.InMemoryExtensionModuleTransactionFactory");
        return BASE_PROPERTIES;
    }

    public static void tearDownOnce() throws Exception {
        ExtensionModuleManager manager = ExtensionModuleManager.getInstance();
        Iterator i = manager.getSourceNames().iterator();
        while (i.hasNext()) {
            manager.removeSource(PRINCIPAL, i.next().toString());
        }
    }

    public void setUp() throws Exception {
        this.manager = ExtensionModuleManager.getInstance();
        try {
            this.manager.removeSource(PRINCIPAL, "fake1.jar");
        }
        catch (ExtensionModuleNotFoundException e) {
            // empty catch block
        }
        try {
            this.manager.removeSource(PRINCIPAL, "fake.txt");
        }
        catch (ExtensionModuleNotFoundException e) {
            // empty catch block
        }
        try {
            this.manager.removeSource(PRINCIPAL, "fake2.jar");
        }
        catch (ExtensionModuleNotFoundException e) {
            // empty catch block
        }
        try {
            this.manager.removeSource(PRINCIPAL, "big.jar");
        }
        catch (ExtensionModuleNotFoundException extensionModuleNotFoundException) {
            // empty catch block
        }
        this.manager.addSource(PRINCIPAL, "JAR File", "fake1.jar", FakeData.TestJar1.data, "A test JAR file with one class", true);
        this.manager.addSource(PRINCIPAL, "Function Definition", "fake.txt", FakeData.TestTextFile.data, "A test text file", true);
        this.manager.addSource(PRINCIPAL, "JAR File", "fake2.jar", FakeData.TestJar2.data, "A test JAR file with two classes", true);
        this.manager.addSource(PRINCIPAL, "JAR File", "big.jar", FakeData.TestJar7.data, "A test JAR file of no interest", true);
    }

    static void printDescriptor(ExtensionModuleDescriptor desc, PrintStream ps) {
        ps.println("<!><!><!><!>------------------------------------");
        ps.println("ExtensionModuleDescriptor:");
        ps.println("Name:       " + desc.getName());
        ps.println("Desc:       " + desc.getDescription());
        ps.println("Type:       " + desc.getType());
        ps.println("Search Pos: " + desc.getPosition());
        ps.println("Enabled:    " + desc.isEnabled());
        ps.println("Created by: " + desc.getCreatedBy());
        ps.println("Created:    " + desc.getCreationDate());
        ps.println("Updated by: " + desc.getLastUpdatedBy());
        ps.println("Updated:    " + desc.getLastUpdatedDate());
        ps.println("checksum:   " + desc.getChecksum());
        ps.println("toString(): " + desc.toString());
        ps.println("<!><!><!><!>------------------------------------");
    }

    static void printDescriptors(Collection descs, PrintStream ps) {
        ps.println("Printing " + descs.size() + " descriptor(s)...");
        Iterator i = descs.iterator();
        while (i.hasNext()) {
            TestExtensionModuleManager.printDescriptor((ExtensionModuleDescriptor)i.next(), ps);
        }
    }

    public void testAddSource() {
        this.manager = ExtensionModuleManager.getInstance();
        try {
            this.manager.removeSource(PRINCIPAL, "fake1.jar");
        }
        catch (ExtensionModuleNotFoundException e) {
        }
        catch (MetaMatrixComponentException e) {
            TestExtensionModuleManager.fail((String)e.getMessage());
        }
        ExtensionModuleDescriptor desc = null;
        try {
            desc = this.manager.addSource(PRINCIPAL, "JAR File", "fake1.jar", FakeData.TestJar1.data, "A test JAR file with one class", true);
        }
        catch (DuplicateExtensionModuleException e) {
            TestExtensionModuleManager.fail((String)("Source fake1.jar already exists: " + e.getMessage()));
        }
        catch (InvalidExtensionModuleTypeException e) {
            TestExtensionModuleManager.fail((String)("Type is invalid: " + e.getMessage()));
        }
        catch (MetaMatrixComponentException e) {
            TestExtensionModuleManager.fail((String)e.getMessage());
        }
        TestExtensionModuleManager.assertTrue((boolean)desc.getName().equals("fake1.jar"));
        TestExtensionModuleManager.assertTrue((boolean)desc.getType().equals("JAR File"));
        TestExtensionModuleManager.assertTrue((boolean)desc.getDescription().equals("A test JAR file with one class"));
        CRC32 algorithm = new CRC32();
        algorithm.update(FakeData.TestJar1.data, 0, FakeData.TestJar1.data.length);
        TestExtensionModuleManager.assertTrue((desc.getChecksum() == algorithm.getValue() ? 1 : 0) != 0);
    }

    public void testAddDuplicateSource() {
        DuplicateExtensionModuleException exception = null;
        try {
            this.manager.addSource(PRINCIPAL, "JAR File", "fake1.jar", FakeData.TestJar1.data, "A test JAR file with one class", true);
        }
        catch (DuplicateExtensionModuleException e) {
            exception = e;
        }
        catch (InvalidExtensionModuleTypeException e) {
            TestExtensionModuleManager.fail((String)e.getMessage());
        }
        catch (MetaMatrixComponentException e) {
            TestExtensionModuleManager.fail((String)e.getMessage());
        }
        TestExtensionModuleManager.assertNotNull((Object)((Object)exception));
    }

    public void testRemoveSource() {
        try {
            this.manager.removeSource(PRINCIPAL, "fake2.jar");
        }
        catch (ExtensionModuleNotFoundException e) {
            TestExtensionModuleManager.fail((String)("Source fake2.jar not found: " + (Object)((Object)e)));
        }
        catch (MetaMatrixComponentException e) {
            TestExtensionModuleManager.fail((String)e.getMessage());
        }
        ExtensionModuleNotFoundException exception = null;
        try {
            this.manager.getSource("fake2.jar");
        }
        catch (ExtensionModuleNotFoundException e) {
            exception = e;
        }
        catch (MetaMatrixComponentException e) {
            TestExtensionModuleManager.fail((String)e.getMessage());
        }
        TestExtensionModuleManager.assertNotNull((Object)((Object)exception));
    }

    public void testGetDescriptors() {
        List descriptors = null;
        try {
            descriptors = this.manager.getSourceDescriptors();
        }
        catch (MetaMatrixComponentException e) {
            TestExtensionModuleManager.fail((String)e.getMessage());
        }
        TestExtensionModuleManager.assertNotNull((Object)descriptors);
    }

    public void testGetTypesAndDescriptors() {
        Collection types = null;
        try {
            types = this.manager.getSourceTypes();
        }
        catch (MetaMatrixComponentException e) {
            TestExtensionModuleManager.fail((String)e.getMessage());
        }
        TestExtensionModuleManager.assertNotNull((Object)types);
        Iterator i = types.iterator();
        List descriptors = null;
        try {
            while (i.hasNext()) {
                descriptors = this.manager.getSourceDescriptors(i.next().toString());
                TestExtensionModuleManager.assertNotNull((Object)descriptors);
                descriptors = null;
            }
        }
        catch (InvalidExtensionModuleTypeException e) {
            TestExtensionModuleManager.fail((String)e.getMessage());
        }
        catch (MetaMatrixComponentException e) {
            TestExtensionModuleManager.fail((String)e.getMessage());
        }
    }

    public void testGetDescriptorsOfInvalidType() {
        InvalidExtensionModuleTypeException exception = null;
        try {
            this.manager.getSourceDescriptors("!!BOGUS TYPE!!");
        }
        catch (InvalidExtensionModuleTypeException e) {
            exception = e;
        }
        catch (MetaMatrixComponentException e) {
            TestExtensionModuleManager.fail((String)e.getMessage());
        }
        TestExtensionModuleManager.assertNotNull((Object)((Object)exception));
    }

    public void testGetDescriptor() {
        ExtensionModuleDescriptor result = null;
        try {
            result = this.manager.getSourceDescriptor("fake2.jar");
        }
        catch (ExtensionModuleNotFoundException e) {
            TestExtensionModuleManager.fail((String)("Source descriptor for fake2.jar not found: " + e.getMessage()));
        }
        catch (MetaMatrixComponentException e) {
            TestExtensionModuleManager.fail((String)e.getMessage());
        }
        TestExtensionModuleManager.assertNotNull((Object)result);
        TestExtensionModuleManager.assertTrue((boolean)result.getName().equals("fake2.jar"));
    }

    public void testShuffleSources() {
        List sourceNames = null;
        try {
            sourceNames = this.manager.getSourceNames();
        }
        catch (MetaMatrixComponentException e) {
            TestExtensionModuleManager.fail((String)e.getMessage());
        }
        Collections.shuffle(sourceNames);
        List test = null;
        try {
            this.manager.setSearchOrder(PRINCIPAL, sourceNames);
            test = this.manager.getSourceNames();
        }
        catch (ExtensionModuleOrderingException e) {
            TestExtensionModuleManager.fail((String)e.getMessage());
        }
        catch (MetaMatrixComponentException e) {
            TestExtensionModuleManager.fail((String)e.getMessage());
        }
        TestExtensionModuleManager.assertEquals((Object)sourceNames, test);
    }

    public void testInvalidOrdering() {
        List sourceNames = null;
        ArrayList oneMissing = null;
        ArrayList<String> oneTooMany = null;
        ArrayList<String> oneWrong = null;
        try {
            sourceNames = this.manager.getSourceNames();
        }
        catch (MetaMatrixComponentException e) {
            TestExtensionModuleManager.fail((String)e.getMessage());
        }
        oneWrong = new ArrayList<String>(sourceNames);
        oneMissing = new ArrayList(sourceNames);
        Collections.shuffle(oneMissing);
        oneTooMany = new ArrayList<String>(oneMissing);
        oneMissing.remove(0);
        oneTooMany.add("BOGUS##!!.txt");
        oneWrong.set(0, "BOGUS##!!.txt");
        List test = null;
        ExtensionModuleOrderingException exception = null;
        try {
            this.manager.setSearchOrder(PRINCIPAL, oneMissing);
            test = this.manager.getSourceNames();
        }
        catch (ExtensionModuleOrderingException e) {
            exception = e;
        }
        catch (MetaMatrixComponentException e) {
            TestExtensionModuleManager.fail((String)e.getMessage());
        }
        TestExtensionModuleManager.assertNotNull((Object)((Object)exception));
        test = null;
        exception = null;
        try {
            this.manager.setSearchOrder(PRINCIPAL, oneTooMany);
            test = this.manager.getSourceNames();
        }
        catch (ExtensionModuleOrderingException e) {
            exception = e;
        }
        catch (MetaMatrixComponentException e) {
            TestExtensionModuleManager.fail((String)e.getMessage());
        }
        TestExtensionModuleManager.assertNotNull((Object)((Object)exception));
        test = null;
        exception = null;
        try {
            this.manager.setSearchOrder(PRINCIPAL, oneWrong);
            test = this.manager.getSourceNames();
        }
        catch (ExtensionModuleOrderingException e) {
            exception = e;
        }
        catch (MetaMatrixComponentException e) {
            TestExtensionModuleManager.fail((String)e.getMessage());
        }
        TestExtensionModuleManager.assertNotNull((Object)((Object)exception));
        test = null;
        try {
            test = this.manager.getSourceNames();
        }
        catch (MetaMatrixComponentException e) {
            TestExtensionModuleManager.fail((String)e.getMessage());
        }
        TestExtensionModuleManager.assertEquals((Object)sourceNames, (Object)test);
    }

    public void testSetEnabled() throws Exception {
        ArrayList<String> sourceNames = new ArrayList<String>(2);
        sourceNames.add("fake1.jar");
        sourceNames.add("fake2.jar");
        List descriptors = this.manager.setEnabled(PRINCIPAL, sourceNames, false);
        ExtensionModuleDescriptor descriptor2 = null;
        for (ExtensionModuleDescriptor descriptor2 : descriptors) {
            TestExtensionModuleManager.assertTrue((!descriptor2.isEnabled() ? 1 : 0) != 0);
        }
        descriptors = this.manager.setEnabled(PRINCIPAL, sourceNames, true);
        for (ExtensionModuleDescriptor descriptor2 : descriptors) {
            TestExtensionModuleManager.assertTrue((boolean)descriptor2.isEnabled());
        }
    }

    public void testGetSource() {
        byte[] source = null;
        try {
            source = this.manager.getSource("fake1.jar");
        }
        catch (ExtensionModuleNotFoundException e) {
            TestExtensionModuleManager.fail((String)("Source fake1.jar not found: " + e.getMessage()));
        }
        catch (MetaMatrixComponentException e) {
            TestExtensionModuleManager.fail((String)e.getMessage());
        }
        if (!Arrays.equals(source, FakeData.TestJar1.data)) {
            TestExtensionModuleManager.fail((String)"Source returned for fake1.jar not equal to test data.");
        }
    }

    public void testSetSource() {
        ExtensionModuleDescriptor descriptor = null;
        try {
            descriptor = this.manager.setSource(PRINCIPAL, "fake.txt", FakeData.TestTextFile2.data);
        }
        catch (ExtensionModuleNotFoundException e) {
            TestExtensionModuleManager.fail((String)("Source fake.txt not found: " + e.getMessage()));
        }
        catch (MetaMatrixComponentException e) {
            TestExtensionModuleManager.fail((String)e.getMessage());
        }
        TestExtensionModuleManager.assertNotNull((Object)descriptor);
        byte[] source = null;
        try {
            source = this.manager.getSource("fake.txt");
        }
        catch (ExtensionModuleNotFoundException e) {
            TestExtensionModuleManager.fail((String)("Source fake1.jar not found: " + e.getMessage()));
        }
        catch (MetaMatrixComponentException e) {
            TestExtensionModuleManager.fail((String)e.getMessage());
        }
        if (!Arrays.equals(source, FakeData.TestTextFile2.data)) {
            TestExtensionModuleManager.fail((String)"Source returned for fake1.jar not equal to test data.");
        }
        source = null;
        try {
            descriptor = this.manager.setSource(PRINCIPAL, "fake.txt", FakeData.TestTextFile.data);
        }
        catch (ExtensionModuleNotFoundException e) {
            TestExtensionModuleManager.fail((String)("Source fake.txt not found: " + e.getMessage()));
        }
        catch (MetaMatrixComponentException e) {
            TestExtensionModuleManager.fail((String)e.getMessage());
        }
        TestExtensionModuleManager.assertNotNull((Object)descriptor);
        try {
            source = this.manager.getSource("fake.txt");
        }
        catch (ExtensionModuleNotFoundException e) {
            TestExtensionModuleManager.fail((String)("Source fake1.jar not found: " + e.getMessage()));
        }
        catch (MetaMatrixComponentException e) {
            TestExtensionModuleManager.fail((String)e.getMessage());
        }
        if (!Arrays.equals(source, FakeData.TestTextFile.data)) {
            TestExtensionModuleManager.fail((String)"Source returned for fake1.jar not equal to test data.");
        }
    }

    public void testSetSourceName() {
        ExtensionModuleDescriptor descriptor = null;
        String newName = "BOGUS NAME";
        try {
            descriptor = this.manager.setSourceName(PRINCIPAL, "fake2.jar", newName);
        }
        catch (ExtensionModuleNotFoundException e) {
            TestExtensionModuleManager.fail((String)("Source fake2.jar not found: " + e.getMessage()));
        }
        catch (MetaMatrixComponentException e) {
            TestExtensionModuleManager.fail((String)e.getMessage());
        }
        TestExtensionModuleManager.assertNotNull((Object)descriptor);
        TestExtensionModuleManager.assertEquals((String)descriptor.getName(), (String)newName);
        try {
            descriptor = this.manager.setSourceName(PRINCIPAL, newName, "fake2.jar");
        }
        catch (ExtensionModuleNotFoundException e) {
            TestExtensionModuleManager.fail((String)("Source " + newName + " not found: " + e.getMessage()));
        }
        catch (MetaMatrixComponentException e) {
            TestExtensionModuleManager.fail((String)e.getMessage());
        }
        TestExtensionModuleManager.assertNotNull((Object)descriptor);
        TestExtensionModuleManager.assertEquals((String)descriptor.getName(), (String)"fake2.jar");
    }

    public void testSetSourceDescription() {
        ExtensionModuleDescriptor descriptor = null;
        String newDesc = "BOGUS DESCRIPTION";
        try {
            descriptor = this.manager.setSourceDescription(PRINCIPAL, "fake2.jar", newDesc);
        }
        catch (ExtensionModuleNotFoundException e) {
            TestExtensionModuleManager.fail((String)("Source fake2.jar not found: " + e.getMessage()));
        }
        catch (MetaMatrixComponentException e) {
            TestExtensionModuleManager.fail((String)e.getMessage());
        }
        TestExtensionModuleManager.assertNotNull((Object)descriptor);
        TestExtensionModuleManager.assertEquals((String)descriptor.getDescription(), (String)newDesc);
    }

    public void testChecksum() {
        CRC32 algorithm = new CRC32();
        algorithm.update(FakeData.TestJar1.data, 0, FakeData.TestJar1.data.length);
        long thisChecksum = algorithm.getValue();
        ExtensionModuleDescriptor desc = null;
        try {
            desc = this.manager.getSourceDescriptor("fake1.jar");
            TestExtensionModuleManager.assertNotNull((Object)desc);
            long thatChecksum = desc.getChecksum();
            TestExtensionModuleManager.assertTrue((thisChecksum == thatChecksum ? 1 : 0) != 0);
        }
        catch (ExtensionModuleNotFoundException e) {
            TestExtensionModuleManager.fail((String)("Source descriptor for fake1.jar not found: " + e.getMessage()));
        }
        catch (MetaMatrixComponentException e) {
            TestExtensionModuleManager.fail((String)e.getMessage());
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(TestExtensionModuleManager.class);
        return new TestSetup((Test)suite){

            protected void setUp() throws Exception {
                TestExtensionModuleManager.setUpOnce();
            }

            protected void tearDown() throws Exception {
                TestExtensionModuleManager.tearDownOnce();
            }
        };
    }
}

