/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.extensionmodule.spi;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.connection.BaseTransaction;
import com.metamatrix.common.connection.ManagedConnection;
import com.metamatrix.common.connection.ManagedConnectionException;
import com.metamatrix.common.extensionmodule.ExtensionModuleDescriptor;
import com.metamatrix.common.extensionmodule.exception.DuplicateExtensionModuleException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleNotFoundException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleOrderingException;
import com.metamatrix.common.extensionmodule.spi.ExtensionModuleTransaction;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.DateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class InMemoryExtensionModuleTransaction
extends BaseTransaction
implements ExtensionModuleTransaction {
    private static final String LOG_CONTEXT = "IN_MEMORY_EXTENSION_SOURCE";
    private static Map sourceCache = new HashMap();
    private static Map descCache = new HashMap();
    private static List sourceNames = new ArrayList();

    InMemoryExtensionModuleTransaction(ManagedConnection connection, boolean readonly) throws ManagedConnectionException {
        super(connection, readonly);
    }

    public ExtensionModuleDescriptor addSource(String principalName, String type, String sourceName, byte[] source, long checksum, String description, boolean enabled) throws DuplicateExtensionModuleException, MetaMatrixComponentException {
        if (sourceNames.contains(sourceName)) {
            throw new DuplicateExtensionModuleException(sourceName);
        }
        sourceNames.add(sourceName);
        String currentDate = DateUtil.getCurrentDateAsString();
        Desc desc = new Desc();
        desc.name = sourceName;
        desc.type = type;
        desc.position = InMemoryExtensionModuleTransaction.sourceNames.size() - 1;
        desc.enabled = enabled;
        desc.desc = description;
        desc.createdBy = principalName;
        desc.creationDate = currentDate;
        desc.lastUpdatedBy = principalName;
        desc.lastUpdatedDate = currentDate;
        desc.checksum = checksum;
        sourceCache.put(sourceName, source);
        descCache.put(sourceName, desc);
        LogManager.logTrace((String)LOG_CONTEXT, (Object[])new Object[]{"Added source", sourceName, "to cache."});
        return new Desc(desc);
    }

    public void removeSource(String principalName, String sourceName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        if (!sourceNames.remove(sourceName)) {
            throw new ExtensionModuleNotFoundException(sourceName);
        }
        sourceCache.remove(sourceName);
        descCache.remove(sourceName);
        LogManager.logTrace((String)LOG_CONTEXT, (Object[])new Object[]{"Removed source", sourceName, "from cache."});
    }

    public List getSourceNames() throws MetaMatrixComponentException {
        return new ArrayList(sourceNames);
    }

    public List getSourceDescriptors() throws MetaMatrixComponentException {
        Iterator iter = sourceNames.iterator();
        ArrayList<Desc> result = new ArrayList<Desc>();
        Desc desc = null;
        while (iter.hasNext()) {
            desc = (Desc)descCache.get(iter.next());
            result.add(new Desc(desc));
        }
        return result;
    }

    public List getSourceDescriptors(String type, boolean includeDisabled) throws MetaMatrixComponentException {
        Iterator iter = sourceNames.iterator();
        ArrayList<Desc> result = new ArrayList<Desc>();
        Desc desc = null;
        while (iter.hasNext()) {
            desc = (Desc)descCache.get(iter.next());
            if (!desc.type.equals(type) || !includeDisabled && !desc.isEnabled()) continue;
            result.add(new Desc(desc));
            if (includeDisabled) continue;
            LogManager.logTrace((String)LOG_CONTEXT, (Object[])new Object[]{"<!><!><!>descriptor:" + desc.getName()});
            LogManager.logTrace((String)LOG_CONTEXT, (Object[])new Object[]{"<!><!><!>   enabled:" + desc.isEnabled()});
        }
        return result;
    }

    public ExtensionModuleDescriptor getSourceDescriptor(String sourceName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        Desc desc = (Desc)descCache.get(sourceName);
        if (desc == null) {
            throw new ExtensionModuleNotFoundException("No extension source named " + sourceName);
        }
        return new Desc(desc);
    }

    public void setSearchOrder(String principalName, List sourceNames) throws ExtensionModuleOrderingException, MetaMatrixComponentException {
        if (!InMemoryExtensionModuleTransaction.sourceNames.containsAll(sourceNames) || !sourceNames.containsAll(InMemoryExtensionModuleTransaction.sourceNames)) {
            throw new ExtensionModuleOrderingException("The list of sourceNames provided does not match the list in storage.");
        }
        InMemoryExtensionModuleTransaction.sourceNames = sourceNames;
    }

    public void setEnabled(String principalName, Collection sourceNames, boolean enabled) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        Iterator iter = sourceNames.iterator();
        ArrayList<Desc> result = new ArrayList<Desc>();
        Desc desc = null;
        String name = null;
        while (iter.hasNext()) {
            name = iter.next().toString();
            try {
                desc = (Desc)descCache.get(name);
                desc.enabled = enabled;
            }
            catch (NullPointerException e) {
                throw new ExtensionModuleNotFoundException("No extension source named " + name);
            }
            result.add(new Desc(desc));
        }
    }

    public byte[] getSource(String sourceName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        LogManager.logTrace((String)LOG_CONTEXT, (Object[])new Object[]{"Getting source", sourceName, "from cache..."});
        byte[] source = (byte[])sourceCache.get(sourceName);
        if (source == null) {
            throw new ExtensionModuleNotFoundException("No extension source named " + sourceName);
        }
        return source;
    }

    public ExtensionModuleDescriptor setSource(String principalName, String sourceName, byte[] source, long checksum) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        Desc desc = (Desc)descCache.get(sourceName);
        try {
            desc.lastUpdatedBy = principalName;
            desc.lastUpdatedDate = DateUtil.getCurrentDateAsString();
            desc.checksum = checksum;
        }
        catch (NullPointerException e) {
            throw new ExtensionModuleNotFoundException("No extension source named " + sourceName);
        }
        sourceCache.put(sourceName, source);
        LogManager.logTrace((String)LOG_CONTEXT, (Object[])new Object[]{"Set source", sourceName, "to cache."});
        return new Desc(desc);
    }

    public ExtensionModuleDescriptor setSourceName(String principalName, String sourceName, String newName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        Desc desc = null;
        try {
            desc = (Desc)descCache.remove(sourceName);
            desc.name = newName;
        }
        catch (NullPointerException e) {
            throw new ExtensionModuleNotFoundException("No extension source named " + sourceName);
        }
        descCache.put(newName, desc);
        Object source = sourceCache.remove(sourceName);
        sourceCache.put(newName, source);
        sourceNames.set(sourceNames.indexOf(sourceName), newName);
        LogManager.logTrace((String)LOG_CONTEXT, (Object[])new Object[]{"Set new name", newName, "for source name", sourceName});
        return new Desc(desc);
    }

    public ExtensionModuleDescriptor setSourceDescription(String principalName, String sourceName, String description) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        Desc desc = null;
        try {
            desc = (Desc)descCache.get(sourceName);
            desc.desc = description;
            desc.lastUpdatedBy = principalName;
            desc.lastUpdatedDate = DateUtil.getCurrentDateAsString();
        }
        catch (NullPointerException e) {
            throw new ExtensionModuleNotFoundException("No extension source named " + sourceName);
        }
        return new Desc(desc);
    }

    public boolean needsRefresh() throws MetaMatrixComponentException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean isNameInUse(String sourceName) throws MetaMatrixComponentException {
        return descCache.containsKey(sourceName);
    }

    private static class Desc
    extends ExtensionModuleDescriptor
    implements Serializable {
        private String name;
        private String type;
        private int position;
        private boolean enabled;
        private String desc;
        private String createdBy;
        private String creationDate;
        private String lastUpdatedBy;
        private String lastUpdatedDate;
        private long checksum;

        private Desc() {
        }

        private Desc(Desc aDesc) {
            this.name = aDesc.name;
            this.type = aDesc.type;
            this.position = aDesc.position;
            this.enabled = aDesc.enabled;
            this.desc = aDesc.desc;
            this.createdBy = aDesc.createdBy;
            this.creationDate = aDesc.creationDate;
            this.lastUpdatedBy = aDesc.lastUpdatedBy;
            this.lastUpdatedDate = aDesc.lastUpdatedDate;
            this.checksum = aDesc.checksum;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public int getPosition() {
            return this.position;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getDescription() {
            return this.desc;
        }

        public String getCreatedBy() {
            return this.createdBy;
        }

        public String getCreationDate() {
            return this.creationDate;
        }

        public String getLastUpdatedBy() {
            return this.lastUpdatedBy;
        }

        public String getLastUpdatedDate() {
            return this.lastUpdatedDate;
        }

        public long getChecksum() {
            return this.checksum;
        }

        public int compareTo(Object obj) {
            ExtensionModuleDescriptor that = (ExtensionModuleDescriptor)obj;
            if (obj == null) {
                Assertion.isNotNull((Object)obj, (String)"Attempt to compare null");
            }
            if (obj == this) {
                return 0;
            }
            return this.position - that.getPosition();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ExtensionModuleDescriptor) {
                ExtensionModuleDescriptor that = (ExtensionModuleDescriptor)obj;
                return this.position == that.getPosition();
            }
            return false;
        }

        public String toString() {
            return this.name;
        }
    }
}

