/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.extensionmodule.spi.jdbc;

import com.metamatrix.common.extensionmodule.spi.jdbc.FileCache;
import junit.framework.TestCase;

public class TestFileCache
extends TestCase {
    private FileCache fileCache;

    public TestFileCache(String name) {
        super(name);
    }

    public void setUp() {
        this.fileCache = new FileCache();
    }

    public void testSetAndGet() {
        byte[] bytes1 = new byte[]{1};
        byte[] bytes2 = new byte[]{2};
        byte[] bytes3 = new byte[]{3};
        this.fileCache.addTypeToCache("JAR File");
        this.fileCache.put("key1", 1L, bytes1, "JAR File");
        this.fileCache.put("key2", 2L, bytes2, "JAR File");
        this.fileCache.put("key2", 3L, bytes3, "JAR File");
        TestFileCache.assertEquals((Object)bytes1, (Object)this.fileCache.getBytes("key1"));
        TestFileCache.assertEquals((long)1L, (long)this.fileCache.getChecksum("key1"));
        TestFileCache.assertEquals((Object)bytes3, (Object)this.fileCache.getBytes("key2"));
        TestFileCache.assertEquals((long)3L, (long)this.fileCache.getChecksum("key2"));
    }

    public void testFileTypes() {
        this.fileCache.addTypeToCache("JAR File");
        byte[] bytes1 = new byte[100];
        byte[] bytes2 = new byte[100];
        this.fileCache.put("key1", 1L, bytes1, "foo");
        TestFileCache.assertNull((Object)this.fileCache.getBytes("key1"));
        TestFileCache.assertEquals((long)-1L, (long)this.fileCache.getChecksum("key1"));
        this.fileCache = new FileCache();
        this.fileCache.addTypeToCache("type1");
        this.fileCache.addTypeToCache("type2");
        this.fileCache.put("key1", 1L, bytes1, "type1");
        this.fileCache.put("key2", 2L, bytes2, "type2");
        TestFileCache.assertEquals((Object)bytes1, (Object)this.fileCache.getBytes("key1"));
        TestFileCache.assertEquals((long)1L, (long)this.fileCache.getChecksum("key1"));
        TestFileCache.assertEquals((Object)bytes2, (Object)this.fileCache.getBytes("key2"));
        TestFileCache.assertEquals((long)2L, (long)this.fileCache.getChecksum("key2"));
    }

    public void testReplacement() {
        int i;
        byte[] bytes1 = new byte[100];
        byte[] bytes2 = new byte[100];
        this.fileCache.addTypeToCache("JAR File");
        this.fileCache.put("key1", 1L, bytes1, "JAR File");
        this.fileCache.put("key2", 2L, bytes2, "JAR File");
        for (i = 0; i < 10; ++i) {
            System.gc();
        }
        TestFileCache.assertEquals((Object)bytes1, (Object)this.fileCache.getBytes("key1"));
        TestFileCache.assertEquals((Object)bytes2, (Object)this.fileCache.getBytes("key2"));
        TestFileCache.assertEquals((int)2, (int)this.fileCache.size());
        bytes1 = null;
        bytes2 = null;
        for (i = 0; i < 10; ++i) {
            System.gc();
        }
        TestFileCache.assertNotNull((Object)this.fileCache.getBytes("key1"));
        TestFileCache.assertNotNull((Object)this.fileCache.getBytes("key2"));
        TestFileCache.assertEquals((int)2, (int)this.fileCache.size());
    }
}

