/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.jdbc;

import com.metamatrix.common.jdbc.JDBCURL;
import junit.framework.TestCase;

public class TestJDBCURL
extends TestCase {
    public TestJDBCURL(String arg0) {
        super(arg0);
    }

    public void testNativeOracle() throws Exception {
        String p2 = "oracle:thin";
        String d2 = "@slntds04:1521:ds0";
        String url2 = "jdbc:" + p2 + d2;
        JDBCURL j2 = new JDBCURL(url2);
        if (!p2.equalsIgnoreCase(j2.getProtocol())) {
            TestJDBCURL.fail((String)("Protocol " + p2 + " does not equal " + j2.getProtocol()));
        }
        if (!d2.endsWith(j2.getDataConnectionInfo())) {
            TestJDBCURL.fail((String)("DatabaseInfo " + d2 + " does not equal " + j2.getDataConnectionInfo()));
        }
    }

    public void testMMOracle() throws Exception {
        String p1 = "mmx:oracle";
        String d1 = "//slntdb01:1521;SID=db01";
        String url1 = "jdbc:" + p1 + d1;
        JDBCURL j1 = new JDBCURL(url1);
        if (!p1.equalsIgnoreCase(j1.getProtocol())) {
            TestJDBCURL.fail((String)("Protocol " + p1 + " does not equal " + j1.getProtocol()));
        }
        if (!d1.endsWith(j1.getDataConnectionInfo())) {
            TestJDBCURL.fail((String)("DatabaseInfo " + d1 + " does not equal " + j1.getDataConnectionInfo()));
        }
    }

    public void testWeblogicSQLServer() throws Exception {
        String p3 = "weblogic:mssqlserver4";
        String d3 = "//slntdb01:1521;database=gg_vhalbert";
        String url3 = "jdbc:" + p3 + d3;
        JDBCURL j3 = new JDBCURL(url3);
        if (!p3.equalsIgnoreCase(j3.getProtocol())) {
            TestJDBCURL.fail((String)("Protocol " + p3 + " does not equal " + j3.getProtocol()));
        }
        if (!d3.endsWith(j3.getDataConnectionInfo())) {
            TestJDBCURL.fail((String)("DatabaseInfo " + d3 + " does not equal " + j3.getDataConnectionInfo()));
        }
    }

    public void testMetaMatrixJDBC() throws Exception {
        String p4 = "metamatrix:QT_Ora9DS";
        String d4 = "@slntdb01:1521;";
        String url4 = "jdbc:" + p4 + d4;
        JDBCURL j4 = new JDBCURL(url4);
        if (!p4.equalsIgnoreCase(j4.getProtocol())) {
            TestJDBCURL.fail((String)("Protocol " + p4 + " does not equal " + j4.getProtocol()));
        }
        if (!d4.endsWith(j4.getDataConnectionInfo())) {
            TestJDBCURL.fail((String)("DatabaseInfo " + d4 + " does not equal " + j4.getDataConnectionInfo()));
        }
    }
}

