/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime.model;

import com.metamatrix.core.util.ObjectConverterUtil;
import com.metamatrix.metadata.runtime.api.Group;
import com.metamatrix.metadata.runtime.api.ModelID;
import com.metamatrix.metadata.runtime.model.BasicModelID;
import com.metamatrix.metadata.runtime.model.MetadataCache;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class TestMetadataCache
extends TestCase {
    private MetadataCache cache;

    public TestMetadataCache(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        System.setProperty("metamatrix.config.none", "true");
        this.cache = new MetadataCache();
        this.cache.init("testvdb", "1", "testvdb.vdb", ObjectConverterUtil.convertToByteArray((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("PartsSupplier.vdb")));
    }

    public void testBuildGroupObjects_TABLE() throws Exception {
        ArrayList<Object> row1 = new ArrayList<Object>();
        row1.add("1");
        row1.add("group1");
        row1.add("model1.group1");
        row1.add(new Integer(0));
        row1.add(new Boolean(true));
        row1.add(new Boolean(false));
        row1.add("model1");
        row1.add(new Boolean(false));
        ArrayList<ArrayList<Object>> rowList = new ArrayList<ArrayList<Object>>();
        rowList.add(row1);
        this.cache.buildGroupObjects(rowList.iterator());
        BasicModelID modelID = new BasicModelID("model1");
        List groups = this.cache.getGroups((ModelID)modelID);
        TestMetadataCache.assertEquals((int)1, (int)groups.size());
        Group group1 = (Group)groups.get(0);
        TestMetadataCache.assertEquals((String)"group1", (String)group1.getName());
        TestMetadataCache.assertFalse((boolean)group1.supportsUpdate());
        TestMetadataCache.assertFalse((boolean)group1.isVirtualDocument());
    }

    public void testBuildGroupObjects_VIEW() throws Exception {
        ArrayList<Object> row1 = new ArrayList<Object>();
        row1.add("1");
        row1.add("group1");
        row1.add("model1.group1");
        row1.add(new Integer(1));
        row1.add(new Boolean(true));
        row1.add(new Boolean(false));
        row1.add("model1");
        row1.add(new Boolean(false));
        ArrayList<ArrayList<Object>> rowList = new ArrayList<ArrayList<Object>>();
        rowList.add(row1);
        this.cache.buildGroupObjects(rowList.iterator());
        BasicModelID modelID = new BasicModelID("model1");
        List groups = this.cache.getGroups((ModelID)modelID);
        TestMetadataCache.assertEquals((int)1, (int)groups.size());
        Group group1 = (Group)groups.get(0);
        TestMetadataCache.assertEquals((String)"group1", (String)group1.getName());
        TestMetadataCache.assertFalse((boolean)group1.supportsUpdate());
        TestMetadataCache.assertFalse((boolean)group1.isVirtualDocument());
    }

    public void testBuildGroupObjects_DOCUMENT() throws Exception {
        ArrayList<Object> row1 = new ArrayList<Object>();
        row1.add("1");
        row1.add("group1");
        row1.add("model1.group1");
        row1.add(new Integer(2));
        row1.add(new Boolean(true));
        row1.add(new Boolean(false));
        row1.add("model1");
        row1.add(new Boolean(false));
        ArrayList<ArrayList<Object>> rowList = new ArrayList<ArrayList<Object>>();
        rowList.add(row1);
        this.cache.buildGroupObjects(rowList.iterator());
        BasicModelID modelID = new BasicModelID("model1");
        List groups = this.cache.getGroups((ModelID)modelID);
        TestMetadataCache.assertEquals((int)1, (int)groups.size());
        Group group1 = (Group)groups.get(0);
        TestMetadataCache.assertEquals((String)"group1", (String)group1.getName());
        TestMetadataCache.assertFalse((boolean)group1.supportsUpdate());
        TestMetadataCache.assertTrue((boolean)group1.isVirtualDocument());
    }

    public void testBuildGroupObjects_MATERIALIZED() throws Exception {
        ArrayList<Object> row1 = new ArrayList<Object>();
        row1.add("1");
        row1.add("group1");
        row1.add("model1.group1");
        row1.add(new Integer(5));
        row1.add(new Boolean(false));
        row1.add(new Boolean(true));
        row1.add("model1");
        row1.add(new Boolean(false));
        ArrayList<ArrayList<Object>> rowList = new ArrayList<ArrayList<Object>>();
        rowList.add(row1);
        this.cache.buildGroupObjects(rowList.iterator());
        BasicModelID modelID = new BasicModelID("model1");
        List groups = this.cache.getGroups((ModelID)modelID);
        TestMetadataCache.assertEquals((int)1, (int)groups.size());
        Group group1 = (Group)groups.get(0);
        TestMetadataCache.assertEquals((String)"group1", (String)group1.getName());
        TestMetadataCache.assertFalse((boolean)group1.isVirtualDocument());
        TestMetadataCache.assertTrue((boolean)group1.supportsUpdate());
    }

    public void testBuildGroupObjects_XML_STAGING_TABLE() throws Exception {
        ArrayList<Object> row1 = new ArrayList<Object>();
        row1.add("1");
        row1.add("group1");
        row1.add("model1.group1");
        row1.add(new Integer(4));
        row1.add(new Boolean(false));
        row1.add(new Boolean(true));
        row1.add("model1");
        row1.add(new Boolean(false));
        ArrayList<ArrayList<Object>> rowList = new ArrayList<ArrayList<Object>>();
        rowList.add(row1);
        this.cache.buildGroupObjects(rowList.iterator());
        BasicModelID modelID = new BasicModelID("model1");
        List groups = this.cache.getGroups((ModelID)modelID);
        TestMetadataCache.assertEquals((int)0, (int)groups.size());
    }

    public void testBuildGroupObjects_XML_MAPPING_CLASS() throws Exception {
        ArrayList<Object> row1 = new ArrayList<Object>();
        row1.add("1");
        row1.add("group1");
        row1.add("model1.group1");
        row1.add(new Integer(3));
        row1.add(new Boolean(false));
        row1.add(new Boolean(true));
        row1.add("model1");
        row1.add(new Boolean(false));
        ArrayList<ArrayList<Object>> rowList = new ArrayList<ArrayList<Object>>();
        rowList.add(row1);
        this.cache.buildGroupObjects(rowList.iterator());
        BasicModelID modelID = new BasicModelID("model1");
        List groups = this.cache.getGroups((ModelID)modelID);
        TestMetadataCache.assertEquals((int)0, (int)groups.size());
    }
}

