/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.config;

import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.model.BasicConfigurationObjectEditor;
import com.metamatrix.common.connection.ManagedConnection;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.platform.config.persistence.api.PersistentConnectionFactory;
import com.metamatrix.platform.config.spi.xml.XMLConfigurationConnector;
import com.metamatrix.platform.config.spi.xml.XMLConfigurationConnectorFactory;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;

public abstract class BaseTest
extends TestCase {
    private static final String path = UnitTestUtil.getTestScratchPath() + File.separator + "config";
    protected boolean printMessages = false;
    protected static final String CONFIG_FILE = "config.xml";
    private static BasicConfigurationObjectEditor editor = new BasicConfigurationObjectEditor(true);
    private static XMLConfigurationConnectorFactory factory = new XMLConfigurationConnectorFactory();
    private XMLConfigurationConnector writer = null;
    private ManagedConnection conn = null;

    public BaseTest(String name) {
        super(name);
        this.initData();
        Properties sysProps = System.getProperties();
        sysProps.put("metamatrix.message.bus.type", "noop.message.bus");
        System.setProperties(sysProps);
    }

    public BaseTest(String name, boolean useNoOpConfig) {
        super(name);
        this.initData();
        if (!useNoOpConfig) {
            Properties sysProps = System.getProperties();
            System.setProperties(sysProps);
        }
    }

    protected String getPath() {
        return path;
    }

    protected void printMsg(String msg) {
        if (this.printMessages) {
            System.out.println(msg);
        }
    }

    protected static Properties createSystemProperties(String fileName) {
        Properties cfg_props = BaseTest.createProperties(fileName);
        Properties sysProps = System.getProperties();
        sysProps.putAll((Map<?, ?>)cfg_props);
        System.setProperties(sysProps);
        return cfg_props;
    }

    public static Properties createProperties(String fileName) {
        Properties props = new Properties();
        if (fileName != null) {
            props.setProperty("metamatrix.config.ns.filename", fileName);
            props.setProperty("metamatrix.config.persistent.factory", PersistentConnectionFactory.FILE_FACTORY_NAME);
        }
        if (path != null) {
            props.setProperty("metamatrix.config.modelsDir", path);
        }
        return props;
    }

    public void initTransactions(Properties props) throws Exception {
        this.conn = factory.createConnection(props, this.getName());
        this.writer = (XMLConfigurationConnector)factory.createTransaction(this.conn, false);
    }

    public BasicConfigurationObjectEditor getEditor() {
        return editor;
    }

    public ConfigurationModelContainer getConfigModel() throws Exception {
        ConfigurationModelContainer config = CurrentConfiguration.getInstance().getConfigurationModel();
        return config;
    }

    public void commit() throws Exception {
        try {
            this.writer.executeActions(editor.getDestination().popActions(), this.getName());
            this.writer.commit();
        }
        catch (Exception e) {
            this.writer.rollback();
            throw e;
        }
        this.writer = (XMLConfigurationConnector)factory.createTransaction(this.conn, false);
    }

    protected XMLConfigurationConnector getWriter() {
        return this.writer;
    }

    private void initData() {
        File scratch = new File(path);
        if (scratch.exists()) {
            FileUtils.removeDirectoryAndChildren((File)scratch);
        }
        scratch.mkdir();
        try {
            FileUtils.copyDirectoryContentsRecursively((File)UnitTestUtil.getTestDataFile((String)"config"), (File)scratch);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

