/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.config;

import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.platform.config.persistence.api.PersistentConnection;
import com.metamatrix.platform.config.persistence.api.PersistentConnectionFactory;
import java.util.Map;
import java.util.Properties;

public class CurrentConfigHelper {
    protected CurrentConfigHelper() {
    }

    public static void initConfig(String fileName, String path, String principal) throws Exception {
        Properties sysProps = new Properties();
        sysProps.put("metamatrix.message.bus.type", "noop.message.bus");
        sysProps.put("metamatrix.config.reader", "com.metamatrix.platform.config.spi.xml.XMLCurrentConfigurationReader");
        sysProps.put("metamatrix.security.password.PasswordKeyStore", "c3B1dG5pazEz");
        CurrentConfigHelper.initConfig(fileName, path, sysProps, principal);
    }

    static void initConfig(String fileName, String path, Properties properties, String principal) throws Exception {
        Properties sysProps = System.getProperties();
        sysProps.putAll((Map<?, ?>)properties);
        System.setProperties(sysProps);
        CurrentConfigHelper.cleanModelFile(principal, fileName, path);
        CurrentConfiguration.getInstance().reset();
        CurrentConfigHelper.createSystemProperties(fileName, path);
        CurrentConfiguration.getInstance().performSystemInitialization(true);
        CurrentConfiguration.getInstance().getConfiguration();
    }

    protected static void cleanModelFile(String principal, String fileName, String path) throws Exception {
        Properties props = CurrentConfigHelper.createSystemProperties("config.xml", path);
        CurrentConfigHelper.deleteModel(Configuration.NEXT_STARTUP_ID, props, principal);
        CurrentConfigHelper.deleteModel(Configuration.STARTUP_ID, props, principal);
    }

    protected static Properties createSystemProperties(String fileName, String path) {
        Properties cfg_props = CurrentConfigHelper.createProperties(fileName, path);
        Properties sysProps = System.getProperties();
        sysProps.putAll((Map<?, ?>)cfg_props);
        System.setProperties(sysProps);
        return cfg_props;
    }

    protected static Properties createProperties(String fileName, String path) {
        Properties props = new Properties();
        if (fileName != null) {
            props.setProperty("metamatrix.config.ns.filename", fileName);
            props.setProperty("metamatrix.config.persistent.factory", PersistentConnectionFactory.FILE_FACTORY_NAME);
        }
        if (path != null) {
            props.setProperty("metamatrix.config.modelsDir", path);
        }
        return props;
    }

    public static void deleteModel(ConfigurationID configID, Properties props, String principal) throws Exception {
        PersistentConnectionFactory pf = PersistentConnectionFactory.createPersistentConnectionFactory((Properties)props);
        PersistentConnection readin = pf.createPersistentConnection();
        readin.delete(configID, principal);
    }
}

