/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.config.spi.xml;

import com.metamatrix.common.config.api.AuthenticationProvider;
import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.SharedResource;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.core.util.ArgCheck;
import java.util.Collection;

public class HelperTestConfiguration {
    public static void validateModelContents(ConfigurationModelContainer config) throws ConfigurationException {
        HelperTestConfiguration.validateConfigContents(config.getConfiguration());
        HelperTestConfiguration.validateComponentTypes(config.getComponentTypes().values());
        HelperTestConfiguration.validateResources(config.getResources());
    }

    public static void validateConfigContents(Configuration config) throws ConfigurationException {
        Collection providers;
        if (config == null) {
            throw new ConfigurationException("Unable to validate Configuration, the configuration is null");
        }
        if (config.getProperties() == null || config.getProperties().isEmpty()) {
            throw new ConfigurationException("Configuration " + config.getID() + " does not contain any global properties");
        }
        Collection vms = config.getVMComponentDefns();
        HelperTestConfiguration.validateComponentDefns(vms);
        Collection defns = config.getServiceComponentDefns();
        HelperTestConfiguration.validateComponentDefns(defns);
        Collection bindings = config.getConnectorBindings();
        if (bindings != null && bindings.size() > 0) {
            HelperTestConfiguration.validateConnectorBindings(bindings);
        }
        if ((providers = config.getAuthenticationProviders()) != null && providers.size() > 0) {
            HelperTestConfiguration.validateAuthenticationProviders(providers);
        }
        Collection dcs = config.getDeployedComponents();
        HelperTestConfiguration.validateDeployedComponents(dcs);
        Collection hosts = config.getHosts();
        HelperTestConfiguration.validateHosts(hosts);
    }

    public static void validateHosts(Collection defns) throws ConfigurationException {
        if (defns == null || defns.isEmpty()) {
            throw new ConfigurationException("No hosts exist");
        }
        for (Host t : defns) {
            HelperTestConfiguration.validateHost(t);
        }
    }

    public static void validateHost(Host h) throws ConfigurationException {
        ArgCheck.isNotNull((Object)h, (String)"Host is null");
        HelperTestConfiguration.validateComponentObject((ComponentObject)h);
        ArgCheck.isNotNull((Object)h.getProperties(), (String)"Host does not have any properties");
    }

    public static void validateAuthenticationProviders(Collection providers) throws ConfigurationException {
        for (AuthenticationProvider t : providers) {
            HelperTestConfiguration.validateAuthenticationProvider(t);
        }
    }

    public static void validateAuthenticationProvider(AuthenticationProvider h) throws ConfigurationException {
        ArgCheck.isNotNull((Object)h, (String)"AuthenticationProvider is null");
        HelperTestConfiguration.validateComponentObject((ComponentObject)h);
        ArgCheck.isNotNull((Object)h.getProperties(), (String)"AuthenticationProvider does not have any properties");
    }

    public static void validateComponentDefns(Collection defns) throws ConfigurationException {
        if (defns == null || defns.isEmpty()) {
            throw new ConfigurationException("No component definitions exist");
        }
        for (ComponentDefn t : defns) {
            HelperTestConfiguration.validateComponentDefn(t);
        }
    }

    public static void validateComponentDefn(ComponentDefn defn) throws ConfigurationException {
        ArgCheck.isNotNull((Object)defn, (String)"ComponentDefn is null");
        HelperTestConfiguration.validateComponentObject((ComponentObject)defn);
    }

    public static void validateConnectorBindings(Collection bindings) throws ConfigurationException {
        for (ConnectorBinding t : bindings) {
            HelperTestConfiguration.validateConnectorBinding(t);
        }
    }

    public static void validateConnectorBinding(ConnectorBinding binding) throws ConfigurationException {
        ArgCheck.isNotNull((Object)binding, (String)"Connector Binding is null");
        HelperTestConfiguration.validateComponentObject((ComponentObject)binding);
        ArgCheck.isNotNull((Object)binding.getRoutingUUID(), (String)("ConnectorBinding " + binding.getFullName() + " does not have a routing number"));
    }

    public static void validateDeployedComponents(Collection defns) throws ConfigurationException {
        if (defns == null || defns.isEmpty()) {
            throw new ConfigurationException("No component definitions exist");
        }
        for (DeployedComponent t : defns) {
            HelperTestConfiguration.validateComponentObject((ComponentObject)t);
        }
    }

    public static void validateComponentTypes(Collection types) throws ConfigurationException {
        if (types == null || types.isEmpty()) {
            throw new ConfigurationException("No component types exist");
        }
        for (ComponentType t : types) {
            HelperTestConfiguration.validateComponentType(t);
        }
    }

    public static void validateResources(Collection resources) throws ConfigurationException {
        if (resources == null || resources.isEmpty()) {
            throw new ConfigurationException("No resources exist");
        }
        for (SharedResource t : resources) {
            HelperTestConfiguration.validateComponentObject((ComponentObject)t);
        }
    }

    public static void validateComponentObject(ComponentObject c) throws ConfigurationException {
        ArgCheck.isNotNull((Object)c, (String)"ComponentObject is null");
        ArgCheck.isNotNull((Object)c.getID(), (String)"ComponentObject ID is null");
        String fullName = c.getFullName();
        ArgCheck.isNotNull((Object)c.getComponentTypeID(), (String)("ComponentObject " + fullName + " does not have a valid component type id"));
        ArgCheck.isNotNull((Object)c.getCreatedBy(), (String)("ComponentObject " + fullName + " does not have a created by name"));
        ArgCheck.isNotNull((Object)c.getLastChangedBy(), (String)("ComponentObject " + fullName + " does not have a last changed by name"));
        ArgCheck.isNotNull((Object)c.getCreatedDate(), (String)("ComponentObject " + fullName + " does not have a created by date"));
        ArgCheck.isNotNull((Object)c.getLastChangedDate(), (String)("ComponentObject " + fullName + " does not have a last changed by date"));
    }

    public static void validateComponentType(ComponentType c) throws ConfigurationException {
        ArgCheck.isNotNull((Object)c, (String)"ComponentType is null");
        ArgCheck.isNotNull((Object)c.getID(), (String)"ComponentType ID is null");
        String fullName = c.getFullName();
        ArgCheck.isNotNull((Object)c.getCreatedBy(), (String)("ComponentType " + fullName + " does not have a created by name"));
        ArgCheck.isNotNull((Object)c.getLastChangedBy(), (String)("ComponentType " + fullName + " does not have a last changed by name"));
        ArgCheck.isNotNull((Object)c.getCreatedDate(), (String)("ComponentType " + fullName + " does not have a created by date"));
        ArgCheck.isNotNull((Object)c.getLastChangedDate(), (String)("ComponentType " + fullName + " does not have a last changed by date"));
    }
}

