/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.config.spi.xml;

import com.metamatrix.common.transaction.TransactionException;
import com.metamatrix.common.transaction.TransactionNotSupportedException;
import com.metamatrix.platform.config.BaseTest;
import com.metamatrix.platform.config.spi.xml.ConfigTransactionException;
import com.metamatrix.platform.config.spi.xml.ConfigUserTransaction;
import com.metamatrix.platform.config.spi.xml.ConfigUserTransactionFactory;
import com.metamatrix.platform.config.spi.xml.XMLConfigurationWriter;
import java.util.ArrayList;
import java.util.Date;

public class TestConfigTransactions
extends BaseTest {
    public TestConfigTransactions(String name) {
        super(name);
        this.printMessages = false;
    }

    public void testReadTransaction() {
        this.printMsg("Starting readTransaction");
        ConfigUserTransaction userTrans = null;
        try {
            ConfigUserTransactionFactory factory = new ConfigUserTransactionFactory();
            userTrans = factory.createReadTransaction("TestConfigTransactions.testReadTransaction");
            userTrans.begin();
            userTrans.commit();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            TestConfigTransactions.fail((String)e.getMessage());
        }
        this.printMsg("Completed readTransaction");
    }

    public void testWriteTransaction() throws Exception {
        this.printMsg("Starting testWriteTransaction");
        ConfigUserTransactionFactory factory = new ConfigUserTransactionFactory();
        ConfigUserTransaction userTrans = factory.createWriteTransaction("TestConfigTransactions.testReadTransaction");
        TestConfigTransactions.assertNotNull((String)"Unable to obtain a user write transaction, userTrans is null", (Object)userTrans);
        userTrans.begin();
        try {
            userTrans.commit();
            TestConfigTransactions.fail((String)"expected exception");
        }
        catch (ConfigTransactionException e) {
            TestConfigTransactions.assertEquals((String)"Configuration Transaction Error: Unable to set configuration changes due to there are not changes in the Transaction object.", (String)e.getMessage());
        }
        this.printMsg("Completed testWriteTransaction");
    }

    public void testNegSimultaneousWriteSameThread() throws Exception {
        this.printMsg("Starting testNegSimultaneousReadTransactions");
        int num = 5;
        ArrayList<ConfigUserTransaction> trans = new ArrayList<ConfigUserTransaction>();
        try {
            ConfigUserTransactionFactory factory = new ConfigUserTransactionFactory();
            for (int i = 0; i < num; ++i) {
                String user = "TestConfigTransactions.testWriteTransaction" + i;
                ConfigUserTransaction userTrans = factory.createWriteTransaction(user);
                userTrans.begin();
                trans.add(userTrans);
            }
            for (ConfigUserTransaction ut : trans) {
                ut.commit();
            }
        }
        catch (TransactionException e) {
            this.printMsg("negSimultaneousWriteTransactions failed correctly");
            for (ConfigUserTransaction ut : trans) {
                try {
                    ut.rollback();
                }
                catch (Exception re) {}
            }
        }
        this.printMsg("Completed testNegSimultaneousReadTransactions");
    }

    public void testNegSimultaneousReadSameThread() {
        this.printMsg("Starting testNegSimultaneousReadTransactions");
        int num = 5;
        try {
            ConfigUserTransactionFactory factory = new ConfigUserTransactionFactory();
            ArrayList<ConfigUserTransaction> trans = new ArrayList<ConfigUserTransaction>();
            for (int i = 0; i < num; ++i) {
                String user = "TestConfigTransactions.testReadTransaction" + i;
                ConfigUserTransaction userTrans = factory.createReadTransaction(user);
                userTrans.begin();
                trans.add(userTrans);
            }
            for (ConfigUserTransaction ut : trans) {
                ut.commit();
            }
        }
        catch (Exception e) {
            if (e instanceof TransactionNotSupportedException) {
                this.printMsg("negSimultaneousReadTransactions failed correctly");
            }
            TestConfigTransactions.fail((String)e.getMessage());
        }
        this.printMsg("Completed testNegSimultaneousReadTransactions");
    }

    public void testMultiThreadSimultaneousReadTransactions() {
        this.printMsg("Starting testMultiThreadSimultaneousReadTransactions");
        ConfigUserTransactionFactory factory = new ConfigUserTransactionFactory();
        int threadCnt = 500;
        int threadTries = 1;
        BaseThread[] ts = new ReadTransThread[threadCnt];
        for (int count = 0; count < threadCnt; ++count) {
            ts[count] = new ReadTransThread(factory, threadTries, count);
        }
        Exception e = this.helperMultiThreadSimultaneousTransactions(threadCnt, threadTries, ts);
        if (e != null) {
            TestConfigTransactions.fail((String)e.getMessage());
        }
        this.printMsg("Completed testMultiThreadSimultaneousReadTransactions");
    }

    private Exception helperMultiThreadSimultaneousTransactions(int threadCnt, int threadTries, BaseThread[] ts) {
        int k;
        for (k = 0; k < threadCnt; ++k) {
            ts[k].start();
        }
        try {
            for (k = 0; k < threadCnt; ++k) {
                ts[k].join();
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Exception te = null;
        for (int k2 = 0; k2 < threadCnt; ++k2) {
            Exception e;
            if (!ts[k2].hasException()) continue;
            te = e = ts[k2].getException();
            break;
        }
        return te;
    }

    protected class BaseThread
    extends Thread {
        protected String objName;
        protected int perThreadCnt = 1;
        private Exception t = null;

        public BaseThread(int iterationCnt, int num) {
            this.perThreadCnt = iterationCnt;
            this.objName = "Thread " + num;
        }

        public Exception getException() {
            return this.t;
        }

        public void setException(Exception te) {
            this.t = te;
        }

        public boolean hasException() {
            return this.t != null;
        }
    }

    protected class WriteTransThread
    extends BaseThread {
        private ConfigUserTransactionFactory factory;

        public WriteTransThread(ConfigUserTransactionFactory factory, int tries, int num) {
            super(tries, num);
            this.factory = factory;
        }

        @Override
        public void run() {
            TestConfigTransactions.this.printMsg("<" + this.objName + ">Start thread " + new Date());
            ArrayList<ConfigUserTransaction> trans = new ArrayList<ConfigUserTransaction>();
            for (int i = 0; i < this.perThreadCnt; ++i) {
                try {
                    ConfigUserTransaction userTrans = XMLConfigurationWriter.getWriteTransactionWithRetry((String)this.objName, (ConfigUserTransactionFactory)this.factory);
                    TestConfigTransactions.this.printMsg("<" + this.objName + ">Started write trans in thread ");
                    trans.add(userTrans);
                    continue;
                }
                catch (Exception toe) {
                    this.setException(toe);
                }
            }
            try {
                for (ConfigUserTransaction ut : trans) {
                    ut.commit();
                    TestConfigTransactions.this.printMsg("<" + this.objName + ">Committed write trans in thread ");
                }
            }
            catch (Exception te) {
                this.setException(te);
            }
        }
    }

    protected class ReadTransThread
    extends BaseThread {
        private ConfigUserTransactionFactory factory;

        public ReadTransThread(ConfigUserTransactionFactory factory, int tries, int num) {
            super(tries, num);
            this.factory = factory;
        }

        @Override
        public void run() {
            ArrayList<ConfigUserTransaction> trans = new ArrayList<ConfigUserTransaction>();
            for (int i = 0; i < this.perThreadCnt; ++i) {
                try {
                    ConfigUserTransaction userTrans = this.factory.createReadTransaction(this.objName);
                    userTrans.begin();
                    trans.add(userTrans);
                    continue;
                }
                catch (Exception toe) {
                    this.setException(toe);
                }
            }
            try {
                for (ConfigUserTransaction ut : trans) {
                    ut.commit();
                }
            }
            catch (Exception te) {
                this.setException(te);
            }
        }
    }
}

