/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.config.spi.xml;

import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.platform.config.BaseTest;
import com.metamatrix.platform.config.CurrentConfigHelper;
import com.metamatrix.platform.config.spi.xml.HelperTestConfiguration;
import java.util.Properties;

public class TestCurrentConfiguration
extends BaseTest {
    protected static final String CONFIG_30_FILE = "config_30.xml";
    private static String PRINCIPAL = "TestCurrentConfiguration";

    public TestCurrentConfiguration(String name) {
        super(name);
        this.printMessages = false;
        System.setProperty("metamatrix.encryption.jce.provider", "none");
    }

    protected void init(String cfgFile) throws Exception {
        CurrentConfigHelper.initConfig(cfgFile, this.getPath(), PRINCIPAL);
    }

    public void testValidateConfiguration() {
        this.printMsg("Starting testValidateConfiguration");
        try {
            this.init("config.xml");
            this.validConfigurationModel();
        }
        catch (Exception e) {
            TestCurrentConfiguration.fail((String)e.getMessage());
        }
        this.printMsg("Completed testValidateConfiguration");
    }

    public void testSystemInitialization() {
        this.printMsg("Starting testSystemInitialization");
        try {
            this.init("config.xml");
            CurrentConfiguration.getInstance().performSystemInitialization(true);
            this.validConfigurationModel();
            Properties configProps = CurrentConfiguration.getInstance().getProperties();
            if (configProps == null || configProps.isEmpty()) {
                TestCurrentConfiguration.fail((String)"No Global Configuration Properties were found");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCurrentConfiguration.fail((String)e.getMessage());
        }
        this.printMsg("Completed testSystemInitialization");
    }

    public void testCurrentHost() {
        this.printMsg("Starting testCurrentHost");
        try {
            System.setProperty("configuration.name", "DummyHost");
            System.setProperty("metamatrix.vmname", "MetaMatrixProcess");
            this.init("config.xml");
            CurrentConfiguration.getInstance().performSystemInitialization(true);
            Host host = CurrentConfiguration.getInstance().getDefaultHost();
            if (!host.getFullName().equals("DummyHost")) {
                TestCurrentConfiguration.fail((String)"DummyHost host was not the default host in the configuration");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCurrentConfiguration.fail((String)e.getMessage());
        }
        this.printMsg("Completed testCurrentHost");
    }

    public void test30SystemInitialization() {
        this.printMsg("**** Starting test30SystemInitialization");
        try {
            this.init(CONFIG_30_FILE);
            CurrentConfiguration.getInstance().performSystemInitialization(true);
            Configuration config = CurrentConfiguration.getInstance().getConfiguration();
            if (config == null) {
                TestCurrentConfiguration.fail((String)"Configuration was not obtained from CurrentConfiguration after system initialization is performed.");
            }
            HelperTestConfiguration.validateConfigContents(config);
            Properties configProps = CurrentConfiguration.getInstance().getProperties();
            if (configProps == null || configProps.isEmpty()) {
                TestCurrentConfiguration.fail((String)"No Global Configuration Properties were found");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCurrentConfiguration.fail((String)e.getMessage());
        }
        this.printMsg("**** Completed test30SystemInitialization");
    }

    private void validConfigurationModel() throws Exception {
        ConfigurationModelContainer ccm = CurrentConfiguration.getInstance().getConfigurationModel();
        if (ccm == null) {
            TestCurrentConfiguration.fail((String)"Configuration Model was not obtained from CurrentConfiguration.getInstance().");
        }
        HelperTestConfiguration.validateModelContents(ccm);
    }
}

