/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.config.spi.xml;

import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.platform.config.BaseTest;
import com.metamatrix.platform.config.CurrentConfigHelper;
import com.metamatrix.platform.config.spi.xml.HelperTestConfiguration;
import com.metamatrix.platform.config.spi.xml.XMLConfigurationMgr;

public class TestCurrentConfigurationShutdown
extends BaseTest {
    private static String PRINCIPAL = "TestCurrentConfigurationShutdown";

    public TestCurrentConfigurationShutdown(String name) {
        super(name);
        this.printMessages = false;
    }

    public void testSystemShutdown() throws Exception {
        this.printMsg("Starting testSystemShutdown");
        CurrentConfigHelper.initConfig("config.xml", this.getPath(), PRINCIPAL);
        this.validConfigurationModel();
        this.printMsg("Call Configuration to Shutdown System");
        CurrentConfiguration.getInstance().indicateSystemShutdown();
        this.printMsg("Shutdown System");
        XMLConfigurationMgr mgr = XMLConfigurationMgr.getInstance();
        this.printMsg("Check System State");
        int state = mgr.getServerStartupState();
        if (state != 0) {
            String lbl = state == 2 ? "STARTED" : (state == 1 ? "STARTING" : "UNDEFINED STATE CODE of " + state);
            TestCurrentConfigurationShutdown.fail((String)("Server State was not set to STOPPED but is currently set to " + lbl));
        }
        this.printMsg("Completed testSystemShutdown");
    }

    private void validConfigurationModel() throws Exception {
        ConfigurationModelContainer ccm = CurrentConfiguration.getInstance().getConfigurationModel();
        if (ccm == null) {
            TestCurrentConfigurationShutdown.fail((String)"Configuration Model was not obtained from CurrentConfiguration");
        }
        HelperTestConfiguration.validateModelContents(ccm);
    }
}

