/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.config.spi.xml;

import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.platform.config.BaseTest;
import com.metamatrix.platform.config.CurrentConfigHelper;
import com.metamatrix.platform.config.spi.xml.HelperTestConfiguration;
import java.util.Collection;

public class TestInitialConfigurationRead
extends BaseTest {
    private static String PRINCIPAL = "TestInitialConfigurationRead";

    public TestInitialConfigurationRead(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        CurrentConfigHelper.initConfig("config.xml", this.getPath(), PRINCIPAL);
    }

    public void testValidateReader() {
        this.printMsg("Starting TestInititaltConfigurationRead");
        try {
            TestInitialConfigurationRead.createSystemProperties("config.xml");
            CurrentConfiguration.getInstance().reset();
            this.validConfigurationModel();
        }
        catch (Exception e) {
            TestInitialConfigurationRead.fail((String)e.getMessage());
        }
        this.printMsg("Completed TestInititaltConfigurationRead");
    }

    private void validConfigurationModel() throws Exception {
        Collection providers;
        ConfigurationModelContainer ccm = CurrentConfiguration.getInstance().getConfigurationModel();
        if (ccm == null) {
            TestInitialConfigurationRead.fail((String)"Configuration Model was not obtained from CurrentConfiguration");
        }
        if ((providers = ccm.getConfiguration().getAuthenticationProviders()) == null || providers.size() == 0) {
            TestInitialConfigurationRead.fail((String)"no providers");
        }
        HelperTestConfiguration.validateModelContents(ccm);
        System.out.println("Providers " + providers.size());
    }
}

