/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.config.spi.xml;

import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.common.config.api.ComponentDefnID;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ProductServiceConfigID;
import com.metamatrix.common.config.api.ProductType;
import com.metamatrix.common.config.api.ProductTypeID;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.model.BasicConfigurationObjectEditor;
import com.metamatrix.common.config.util.ConfigUtil;
import com.metamatrix.common.config.xml.XMLConfigurationImportExportUtility;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.util.DateUtil;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.config.BaseTest;
import com.metamatrix.platform.config.CurrentConfigHelper;
import com.metamatrix.platform.config.persistence.api.PersistentConnection;
import com.metamatrix.platform.config.persistence.api.PersistentConnectionFactory;
import com.metamatrix.platform.config.persistence.impl.file.FilePersistentUtil;
import com.metamatrix.platform.config.spi.xml.HelperTestConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;

public class TestXMLConfigImportExport
extends BaseTest {
    private static String PRINCIPAL = "TestXMLConfigImportExport";
    private static final String CDK_FILE = "GateaConnector.cdk";

    public TestXMLConfigImportExport(String name) {
        super(name);
    }

    private void initializeConfig(String fileName) throws Exception {
        this.printMsg("Perform initializeConfig using " + fileName);
        CurrentConfigHelper.initConfig(fileName, this.getPath(), PRINCIPAL);
        this.initTransactions(new Properties());
        this.printMsg("Completed initializeConfig");
    }

    public void testImportNewStartupConfiguration() throws Exception {
        this.printMsg("Starting testImportNewStartupConfiguration");
        this.initializeConfig("config.xml");
        FileUtils.copy((String)(UnitTestUtil.getTestDataPath() + "/config/config.xml"), (String)(UnitTestUtil.getTestScratchPath() + "/config_future.xml"));
        Properties props = new Properties();
        props.setProperty("metamatrix.config.modelsDir", UnitTestUtil.getTestScratchPath());
        props.setProperty("metamatrix.config.ns.filename", "config_ns.xml");
        props.setProperty("metamatrix.config.persistent.factory", PersistentConnectionFactory.FILE_FACTORY_NAME);
        TestXMLConfigImportExport.importConfiguration("config_future.xml", props, PRINCIPAL);
        this.printMsg("Completed testImportNewStartupConfiguration");
    }

    public static void importConfiguration(String fileName, Properties properties, String principal) throws ConfigurationException {
        ConfigurationModelContainer nsModel = null;
        try {
            nsModel = FilePersistentUtil.readModel((String)fileName, (String)properties.getProperty("metamatrix.config.modelsDir"), (ConfigurationID)Configuration.NEXT_STARTUP_ID);
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e, "ERR.014.002.0186", PlatformPlugin.Util.getString("ERR.014.002.0186", new Object[]{fileName}));
        }
        Properties props = PropertiesUtils.clone((Properties)properties, (boolean)false);
        PersistentConnectionFactory pf = PersistentConnectionFactory.createPersistentConnectionFactory((Properties)props);
        PersistentConnection pc = pf.createPersistentConnection();
        pc.delete(Configuration.NEXT_STARTUP_ID, principal);
        pc.write(nsModel, principal);
    }

    private void helperImportConnectorType() throws Exception {
        this.printMsg("Starting helperImportConnectorType");
        File cdkFile = new File(this.getPath(), CDK_FILE);
        InputStream inputStream = this.readFile(cdkFile.getPath());
        XMLConfigurationImportExportUtility io = new XMLConfigurationImportExportUtility();
        ComponentType type = io.importComponentType(inputStream, (ConfigurationObjectEditor)this.getEditor(), null);
        this.commit();
        ComponentType newType = this.getWriter().getComponentType((ComponentTypeID)type.getID());
        if (newType == null) {
            TestXMLConfigImportExport.fail((String)("Import of connector type " + type.getID() + " was not successfull."));
        }
        HelperTestConfiguration.validateComponentType(newType);
        this.printMsg("Completed helperImportConnectorType");
    }

    private void helperImportConnectorBinding(String file) throws Exception {
        this.printMsg("Starting helperImportConnectorBinding");
        File connFile = new File(this.getPath(), file);
        InputStream inputStream = this.readFile(connFile.getPath());
        XMLConfigurationImportExportUtility io = new XMLConfigurationImportExportUtility();
        BasicConfigurationObjectEditor editor = new BasicConfigurationObjectEditor(false);
        ConnectorBinding defn = io.importConnectorBinding(inputStream, (ConfigurationObjectEditor)editor, null);
        if (defn == null) {
            TestXMLConfigImportExport.fail((String)"No connector binding was imported");
        }
        ConfigurationModelContainer config = this.getWriter().getConfigurationModel("Next Startup");
        ConnectorBinding newdefn = this.getEditor().createConnectorComponent(Configuration.NEXT_STARTUP_ID, defn, defn.getFullName(), defn.getRoutingUUID());
        this.commit();
        ProductServiceConfig psc = ConfigUtil.getFirstDeployedConnectorProductTypePSC((ConfigurationModelContainer)config);
        ProductServiceConfigID pscID = null;
        if (psc != null) {
            pscID = (ProductServiceConfigID)psc.getID();
        } else {
            psc = this.helperTestAddPSC("TestPSC_" + String.valueOf(new Date().getTime()), (ServiceComponentDefnID)newdefn.getID(), Configuration.NEXT_STARTUP_ID);
            pscID = (ProductServiceConfigID)psc.getID();
        }
        psc = this.getEditor().addServiceComponentDefn(psc, (ServiceComponentDefnID)newdefn.getID());
        this.getEditor().deployServiceDefn(config.getConfiguration(), (ServiceComponentDefn)newdefn, pscID);
        this.commit();
        ConnectorBinding newDefn = (ConnectorBinding)this.getWriter().getComponentDefinition((ComponentDefnID)defn.getID(), Configuration.NEXT_STARTUP_ID);
        if (newDefn == null) {
            TestXMLConfigImportExport.fail((String)"Import of connector binding was not successfull, no obect found when reading.");
        }
        HelperTestConfiguration.validateConnectorBinding(newDefn);
        this.printMsg("Completed helperImportConnectorBinding");
    }

    private ProductServiceConfig helperTestAddPSC(String pscName, ServiceComponentDefnID id, ConfigurationID configID) {
        this.printMsg("Starting helperTestAddPSC");
        ProductServiceConfig newDefn = null;
        try {
            Configuration config = this.getConfigModel().getConfiguration();
            Collection types = this.getConfigModel().getProductTypes();
            ConnectorBinding defn = config.getConnectorBinding((ComponentDefnID)id);
            newDefn = this.addPSC(pscName, (ServiceComponentDefn)defn, config, types, this.getEditor());
            this.printMsg("helperTestAddPSC actions committed");
            HelperTestConfiguration.validateComponentDefn((ComponentDefn)newDefn);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestXMLConfigImportExport.fail((String)e.getMessage());
        }
        this.printMsg("Completed helperTestAddPSC");
        return newDefn;
    }

    private ProductServiceConfig addPSC(String name, ServiceComponentDefn svc, Configuration config, Collection types, BasicConfigurationObjectEditor editor) throws Exception {
        ProductType connType = this.findProductType("Connectors", types);
        if (connType == null) {
            throw new ConfigurationException("AddPSC Error - unable to fine component type Connectors");
        }
        this.printMsg("addPSC found product type " + connType.getFullName());
        ProductServiceConfig newPSC = this.getEditor().createProductServiceConfig((ConfigurationID)config.getID(), (ProductTypeID)connType.getID(), name);
        if (newPSC == null) {
            throw new ConfigurationException("AddPSC Error - editor is unable to create new PSC " + name + " of type " + connType.getFullName());
        }
        newPSC = (ProductServiceConfig)this.getEditor().setLastChangedHistory((ComponentObject)newPSC, PRINCIPAL, DateUtil.getCurrentDateAsString());
        newPSC = (ProductServiceConfig)this.getEditor().setCreationChangedHistory((ComponentObject)newPSC, PRINCIPAL, DateUtil.getCurrentDateAsString());
        this.printMsg("addPSC created new PSC " + newPSC.getFullName());
        this.getEditor().addServiceComponentDefn(config, newPSC, (ServiceComponentDefnID)svc.getID());
        this.printMsg("addPSC add service to PSC ");
        this.commit();
        ProductServiceConfig psc = CurrentConfiguration.getInstance().getConfiguration().getPSC((ComponentDefnID)((ProductServiceConfigID)newPSC.getID()));
        TestXMLConfigImportExport.assertNotNull((Object)psc);
        return newPSC;
    }

    public ProductType findProductType(String name, Collection types) {
        ProductType connType2 = null;
        for (ProductType connType2 : types) {
            if (connType2.getFullName().equals(name)) {
                return connType2;
            }
            connType2 = null;
        }
        return connType2;
    }

    private InputStream readFile(String fileName) throws ConfigurationException {
        FileInputStream inputStream = null;
        File configFile = new File(fileName);
        if (!configFile.exists()) {
            throw new ConfigurationException("Unable to read configuration file " + fileName + ", it does not exist.");
        }
        try {
            inputStream = new FileInputStream(configFile);
            return inputStream;
        }
        catch (IOException io) {
            throw new ConfigurationException((Throwable)io, "Unable to read configuration file " + fileName + ", error in reading file");
        }
    }
}

