/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.config.spi.xml;

import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.SharedResource;
import com.metamatrix.common.connection.ManagedConnection;
import com.metamatrix.platform.config.BaseTest;
import com.metamatrix.platform.config.CurrentConfigHelper;
import com.metamatrix.platform.config.spi.xml.HelperTestConfiguration;
import com.metamatrix.platform.config.spi.xml.XMLConfigurationConnector;
import com.metamatrix.platform.config.spi.xml.XMLConfigurationConnectorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class TestXMLConfigReader
extends BaseTest {
    private static String PRINCIPAL = "TestXMLConfigReader";
    protected static final String CONFIG_FILE = "config.xml";
    private ManagedConnection conn;
    private XMLConfigurationConnectorFactory factory;

    public TestXMLConfigReader(String name) {
        super(name);
        this.printMessages = false;
    }

    protected void setUp() throws Exception {
        super.setUp();
        CurrentConfigHelper.initConfig(CONFIG_FILE, this.getPath(), PRINCIPAL);
        this.factory = new XMLConfigurationConnectorFactory();
        this.conn = this.factory.createConnection(new Properties(), PRINCIPAL);
    }

    public void testValidateReader() throws Exception {
        XMLConfigurationConnector reader = (XMLConfigurationConnector)this.factory.createTransaction(this.conn, true);
        this.printMsg("Validate ComponentTypes Exists");
        Collection compTypes = reader.getAllComponentTypes(true);
        HelperTestConfiguration.validateComponentTypes(compTypes);
        ArrayList<ComponentType> keepTypes = new ArrayList<ComponentType>(5);
        int xacnt = 0;
        for (ComponentType type : compTypes) {
            if (type.getComponentTypeCode() == 4) {
                if (type.getID().equals((Object)SharedResource.JDBC_COMPONENT_TYPE_ID)) {
                    keepTypes.add(type);
                } else if (type.getID().equals((Object)SharedResource.SEARCHBASE_COMPONENT_TYPE_ID)) {
                    keepTypes.add(type);
                }
            }
            if (type.getComponentTypeCode() != 2 || !type.isOfTypeXAConnector()) continue;
            if (!type.isOfTypeConnector()) {
                TestXMLConfigReader.fail((String)("XA Connector Type " + type.getFullName() + " must also be a connector type"));
            }
            ++xacnt;
        }
        if (keepTypes.size() == 0) {
            TestXMLConfigReader.fail((String)"No Poolable ComponentTypes");
        }
        if (xacnt != 6) {
            TestXMLConfigReader.fail((String)("The number XA Connector Types should have been 5, but found " + xacnt));
        }
        this.printMsg("Validate Resources Exists");
        Collection resources = reader.getResources();
        HelperTestConfiguration.validateResources(resources);
        this.printMsg("Validate NextStartup Config");
        Configuration ns = reader.getDesignatedConfiguration("Next Startup");
        HelperTestConfiguration.validateConfigContents(ns);
        this.printMsg("Validate ComponentDefns");
        Map defns = reader.getComponentDefinitions(Configuration.NEXT_STARTUP_ID);
        HelperTestConfiguration.validateComponentDefns(defns.values());
        this.printMsg("Validate Deployed Components");
        List dc = reader.getDeployedComponents(Configuration.NEXT_STARTUP_ID);
        HelperTestConfiguration.validateDeployedComponents(dc);
        this.printMsg("Validate Hosts");
        Collection hosts = reader.getHosts();
        HelperTestConfiguration.validateHosts(hosts);
    }

    public void testComponentTypeDefn() throws Exception {
        ComponentTypeDefn ctd;
        ConfigurationModelContainer cmc = CurrentConfiguration.getInstance().getConfigurationModel();
        ComponentType ct = cmc.getComponentType("Connector");
        if (ct == null) {
            TestXMLConfigReader.fail((String)"No componenttype found for Connector");
        }
        if ((ctd = cmc.getComponentTypeDefinition((ComponentTypeID)ct.getID(), "ServiceClassName")) == null) {
            TestXMLConfigReader.fail((String)"ComponentTypeDefn for ServiceClassName from super type Connector was not found.");
        }
    }
}

