/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.registry;

import com.metamatrix.admin.server.FakeCacheAdmin;
import com.metamatrix.admin.server.FakeConfiguration;
import com.metamatrix.admin.server.FakeQueryService;
import com.metamatrix.cache.CacheFactory;
import com.metamatrix.cache.FakeCache;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConnectorBindingID;
import com.metamatrix.common.config.api.ConnectorBindingType;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.DeployedComponentID;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.ProductServiceConfigID;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.api.VMComponentDefnID;
import com.metamatrix.common.config.model.BasicDeployedComponent;
import com.metamatrix.common.config.model.BasicVMComponentDefn;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.common.messaging.NoOpMessageBus;
import com.metamatrix.platform.registry.ClusteredRegistryState;
import com.metamatrix.platform.registry.HostControllerRegistryBinding;
import com.metamatrix.platform.registry.ProcessRegistryBinding;
import com.metamatrix.platform.registry.ServiceRegistryBinding;
import com.metamatrix.platform.service.api.ServiceID;
import com.metamatrix.platform.service.api.ServiceInterface;
import com.metamatrix.platform.vm.api.controller.ProcessManagement;
import java.net.InetAddress;
import java.util.Date;
import java.util.Properties;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.mockito.Mockito;

@CacheListener
public class FakeRegistryUtil {
    private static ClusteredRegistryState registry;

    public static ClusteredRegistryState getFakeRegistry() throws Exception {
        if (registry != null) {
            return registry;
        }
        registry = new ClusteredRegistryState((CacheFactory)new FakeCache.FakeCacheFactory());
        HostControllerRegistryBinding host1 = FakeRegistryUtil.buildHostRegistryBinding("2.2.2.2");
        HostControllerRegistryBinding host2 = FakeRegistryUtil.buildHostRegistryBinding("3.3.3.3");
        registry.addHost(host1);
        registry.addHost(host2);
        ProcessRegistryBinding vmBinding2 = FakeRegistryUtil.buildVMRegistryBinding("2.2.2.2", "process2");
        ServiceRegistryBinding serviceBinding2 = FakeRegistryUtil.buildServiceRegistryBinding("connectorBinding2", 2, vmBinding2, "Cache", "psc2");
        registry.addProcess(vmBinding2.getHostName(), vmBinding2.getProcessName(), vmBinding2);
        registry.addServiceBinding(vmBinding2.getHostName(), vmBinding2.getProcessName(), serviceBinding2);
        ProcessRegistryBinding vmBinding3 = FakeRegistryUtil.buildVMRegistryBinding("3.3.3.3", "process3");
        ServiceRegistryBinding serviceBinding3 = FakeRegistryUtil.buildServiceRegistryBinding("connectorBinding3", 3, vmBinding3, "Cache", "psc3");
        registry.addProcess(vmBinding3.getHostName(), vmBinding3.getProcessName(), vmBinding3);
        registry.addServiceBinding(vmBinding3.getHostName(), vmBinding3.getProcessName(), serviceBinding3);
        ServiceID sid1 = new ServiceID(5L, vmBinding2.getHostName(), vmBinding2.getProcessName());
        registry.addServiceBinding(vmBinding2.getHostName(), vmBinding2.getProcessName(), new ServiceRegistryBinding(sid1, (ServiceInterface)new FakeQueryService(sid1), "QueryService", "dqp2", "QueryService", "dqp2", "2.2.2.2", (DeployedComponent)new FakeConfiguration().deployedComponents.get(4), null, 2, new Date(), false, (MessageBus)new NoOpMessageBus()));
        ServiceID sid2 = new ServiceID(6L, vmBinding3.getHostName(), vmBinding3.getProcessName());
        registry.addServiceBinding(vmBinding3.getHostName(), vmBinding3.getProcessName(), new ServiceRegistryBinding(sid2, (ServiceInterface)new FakeQueryService(sid2), "QueryService", "dqp3", "QueryService", "dqp3", "3.3.3.3", (DeployedComponent)new FakeConfiguration().deployedComponents.get(5), null, 2, new Date(), false, (MessageBus)new NoOpMessageBus()));
        return registry;
    }

    public static ProcessRegistryBinding buildVMRegistryBinding(String hostName, String processName) throws Exception {
        HostID hostID1 = new HostID(hostName);
        VMComponentDefnID defnID1 = new VMComponentDefnID(Configuration.NEXT_STARTUP_ID, hostID1, processName);
        BasicVMComponentDefn defn1 = new BasicVMComponentDefn(Configuration.NEXT_STARTUP_ID, hostID1, defnID1, new ComponentTypeID("VM"));
        ProcessManagement vmInterface1 = (ProcessManagement)Mockito.mock(ProcessManagement.class);
        Mockito.stub((Object)vmInterface1.getAddress()).toReturn((Object)InetAddress.getLocalHost());
        ProcessRegistryBinding binding = new ProcessRegistryBinding(hostName, processName, (VMComponentDefn)defn1, vmInterface1, (MessageBus)new NoOpMessageBus());
        binding.setAlive(true);
        return binding;
    }

    public static ServiceRegistryBinding buildServiceRegistryBinding(String name, int id, ProcessRegistryBinding vm, String type, String psc) {
        ServiceID sid = new ServiceID((long)id, vm.getHostName(), vm.getProcessName());
        DeployedComponentID deployedComponentID1 = new DeployedComponentID(name, Configuration.NEXT_STARTUP_ID, vm.getDeployedComponent().getHostID(), (VMComponentDefnID)vm.getDeployedComponent().getID());
        ConnectorBindingID connectorBindingID1 = new ConnectorBindingID(Configuration.NEXT_STARTUP_ID, name);
        ProductServiceConfigID pscID = new ProductServiceConfigID(Configuration.NEXT_STARTUP_ID, psc);
        BasicDeployedComponent deployedComponent = new BasicDeployedComponent(deployedComponentID1, Configuration.NEXT_STARTUP_ID, vm.getDeployedComponent().getHostID(), (VMComponentDefnID)vm.getDeployedComponent().getID(), (ServiceComponentDefnID)connectorBindingID1, pscID, ConnectorBindingType.CONNECTOR_TYPE_ID);
        deployedComponent.setDescription(name);
        return new ServiceRegistryBinding(sid, (ServiceInterface)new FakeCacheAdmin(sid), type, "instance-" + id, null, name, vm.getHostName(), (DeployedComponent)deployedComponent, null, 1, new Date(), false, (MessageBus)new NoOpMessageBus());
    }

    static HostControllerRegistryBinding buildHostRegistryBinding(String name) {
        return new HostControllerRegistryBinding(name, new Properties(), null, (MessageBus)new NoOpMessageBus());
    }
}

