/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.registry;

import com.metamatrix.cache.Cache;
import com.metamatrix.cache.CacheFactory;
import com.metamatrix.cache.FakeCache;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.api.VMComponentDefnID;
import com.metamatrix.common.config.model.BasicVMComponentDefn;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.common.messaging.NoOpMessageBus;
import com.metamatrix.core.util.SimpleMock;
import com.metamatrix.platform.registry.ClusteredRegistryState;
import com.metamatrix.platform.registry.HostControllerRegistryBinding;
import com.metamatrix.platform.registry.ProcessRegistryBinding;
import com.metamatrix.platform.registry.ResourceAlreadyBoundException;
import com.metamatrix.platform.registry.ServiceRegistryBinding;
import com.metamatrix.platform.service.api.ServiceID;
import com.metamatrix.platform.vm.api.controller.ProcessManagement;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class TestClusteredRegistryState
extends TestCase {
    CacheFactory factory = new FakeCache.FakeCacheFactory();

    private String key(String key) {
        return key.toUpperCase();
    }

    public void testAddVM() throws Exception {
        ClusteredRegistryState state = new ClusteredRegistryState(this.factory);
        Cache rootNode = state.cache;
        HostControllerRegistryBinding host1 = TestClusteredRegistryState.buildHostRegistryBinding("host-1");
        HostControllerRegistryBinding host2 = TestClusteredRegistryState.buildHostRegistryBinding("host-2");
        state.addHost(host1);
        state.addHost(host2);
        ProcessRegistryBinding vm1 = TestClusteredRegistryState.buildVMRegistryBinding("host-1", "1");
        ProcessRegistryBinding vm2 = TestClusteredRegistryState.buildVMRegistryBinding("host-1", "2");
        ProcessRegistryBinding vm3 = TestClusteredRegistryState.buildVMRegistryBinding("host-1", "3");
        state.addProcess("host-1", "vm-1", vm1);
        state.addProcess("host-1", "vm-2", vm2);
        state.addProcess("host-2", "vm-1", vm3);
        TestClusteredRegistryState.assertEquals((int)rootNode.getChildren().size(), (int)2);
        TestClusteredRegistryState.assertNotNull((Object)rootNode.getChild(this.key("host-1")));
        TestClusteredRegistryState.assertNotNull((Object)rootNode.getChild(this.key("host-2")));
        TestClusteredRegistryState.assertNotNull((Object)rootNode.getChild(this.key("host-2")).getChild(this.key("vm-1")));
        TestClusteredRegistryState.assertEquals((Object)rootNode.getChild(this.key("host-1")).get((Object)"Name"), (Object)"HOST-1");
        TestClusteredRegistryState.assertEquals((Object)rootNode.getChild(this.key("host-1")).getChild(this.key("vm-1")).get((Object)"Name"), (Object)"vm-1");
    }

    public void testRemoveVM() throws Exception {
        ClusteredRegistryState state = new ClusteredRegistryState(this.factory);
        Cache rootNode = state.cache;
        HostControllerRegistryBinding host1 = TestClusteredRegistryState.buildHostRegistryBinding("host-1");
        HostControllerRegistryBinding host2 = TestClusteredRegistryState.buildHostRegistryBinding("host-2");
        state.addHost(host1);
        state.addHost(host2);
        ProcessRegistryBinding vm1 = TestClusteredRegistryState.buildVMRegistryBinding("host-1", "1");
        ProcessRegistryBinding vm2 = TestClusteredRegistryState.buildVMRegistryBinding("host-1", "2");
        ProcessRegistryBinding vm3 = TestClusteredRegistryState.buildVMRegistryBinding("host-1", "3");
        state.addProcess("host-1", "vm-1", vm1);
        state.addProcess("host-1", "vm-2", vm2);
        state.addProcess("host-2", "vm-1", vm3);
        TestClusteredRegistryState.assertEquals((int)rootNode.getChildren().size(), (int)2);
        state.removeProcess("host-1", "vm-1");
        TestClusteredRegistryState.assertNull((Object)rootNode.getChild(this.key("host-1")).getChild(this.key("vm-1")));
        TestClusteredRegistryState.assertNotNull((Object)rootNode.getChild(this.key("host-1")).getChild(this.key("vm-2")));
        TestClusteredRegistryState.assertNotNull((Object)rootNode.getChild(this.key("host-2")).getChild(this.key("vm-1")));
    }

    public void testGetVMs() throws Exception {
        ClusteredRegistryState state = new ClusteredRegistryState(this.factory);
        HostControllerRegistryBinding host1 = TestClusteredRegistryState.buildHostRegistryBinding("host-1");
        HostControllerRegistryBinding host2 = TestClusteredRegistryState.buildHostRegistryBinding("host-2");
        state.addHost(host1);
        state.addHost(host2);
        ProcessRegistryBinding vm1 = TestClusteredRegistryState.buildVMRegistryBinding("host-1", "1");
        ProcessRegistryBinding vm2 = TestClusteredRegistryState.buildVMRegistryBinding("host-1", "2");
        ProcessRegistryBinding vm3 = TestClusteredRegistryState.buildVMRegistryBinding("host-1", "3");
        state.addProcess("host-1", "vm-1", vm1);
        state.addProcess("host-1", "vm-2", vm2);
        state.addProcess("host-2", "vm-1", vm3);
        TestClusteredRegistryState.assertEquals((int)0, (int)state.getVMs("unknown").size());
        TestClusteredRegistryState.assertEquals((int)2, (int)state.getVMs("host-1").size());
        TestClusteredRegistryState.assertEquals((int)1, (int)state.getVMs("host-2").size());
        TestClusteredRegistryState.assertEquals((int)3, (int)state.getVMs(null).size());
        TestClusteredRegistryState.assertEquals((Object)vm2, (Object)state.getProcessBinding("host-1", "vm-2"));
    }

    public void testHosts() throws Exception {
        ClusteredRegistryState state = new ClusteredRegistryState(this.factory);
        HostControllerRegistryBinding host1 = TestClusteredRegistryState.buildHostRegistryBinding("host-1");
        HostControllerRegistryBinding host2 = TestClusteredRegistryState.buildHostRegistryBinding("host-2");
        state.addHost(host1);
        state.addHost(host2);
        ProcessRegistryBinding vm1 = TestClusteredRegistryState.buildVMRegistryBinding("host-1", "1");
        ProcessRegistryBinding vm2 = TestClusteredRegistryState.buildVMRegistryBinding("host-1", "2");
        ProcessRegistryBinding vm3 = TestClusteredRegistryState.buildVMRegistryBinding("host-1", "3");
        state.addProcess("host-1", "vm-1", vm1);
        state.addProcess("host-1", "vm-2", vm2);
        state.addProcess("host-2", "vm-1", vm3);
        TestClusteredRegistryState.assertEquals((int)2, (int)state.getHosts().size());
        state.getHosts().contains("host-1");
        state.getHosts().contains("host-2");
    }

    public void testAddServiceBinding() throws Exception {
        ClusteredRegistryState state = this.buildRegistry();
        Cache rootNode = state.cache;
        TestClusteredRegistryState.assertEquals((int)2, (int)rootNode.getChild(this.key("host-1")).getChild(this.key("vm-1")).getChild("Services").values().size());
        TestClusteredRegistryState.assertEquals((int)1, (int)rootNode.getChild(this.key("host-1")).getChild(this.key("vm-2")).getChild("Services").values().size());
        TestClusteredRegistryState.assertEquals((int)3, (int)rootNode.getChild(this.key("host-2")).getChild(this.key("vm-1")).getChild("Services").values().size());
    }

    ClusteredRegistryState buildRegistry() throws ResourceAlreadyBoundException, ClusteredRegistryState.CacheNodeNotFoundException {
        ClusteredRegistryState state = new ClusteredRegistryState(this.factory);
        HostControllerRegistryBinding host1 = TestClusteredRegistryState.buildHostRegistryBinding("host-1");
        HostControllerRegistryBinding host2 = TestClusteredRegistryState.buildHostRegistryBinding("host-2");
        state.addHost(host1);
        state.addHost(host2);
        ProcessRegistryBinding vm1 = TestClusteredRegistryState.buildVMRegistryBinding("host-1", "1");
        ProcessRegistryBinding vm2 = TestClusteredRegistryState.buildVMRegistryBinding("host-1", "2");
        ProcessRegistryBinding vm3 = TestClusteredRegistryState.buildVMRegistryBinding("host-1", "3");
        state.addProcess("host-1", "vm-1", vm1);
        state.addProcess("host-1", "vm-2", vm2);
        state.addProcess("host-2", "vm-1", vm3);
        ServiceRegistryBinding s1 = TestClusteredRegistryState.buildServiceRegistryBinding(1, vm1, "Query");
        ServiceRegistryBinding s2 = TestClusteredRegistryState.buildServiceRegistryBinding(2, vm2, "Query");
        ServiceRegistryBinding s3 = TestClusteredRegistryState.buildServiceRegistryBinding(3, vm1, "Index");
        ServiceRegistryBinding s4 = TestClusteredRegistryState.buildServiceRegistryBinding(4, vm3, "Query");
        ServiceRegistryBinding s5 = TestClusteredRegistryState.buildServiceRegistryBinding(5, vm3, "Session");
        ServiceRegistryBinding s6 = TestClusteredRegistryState.buildServiceRegistryBinding(6, vm3, "Auth");
        state.addServiceBinding("host-1", "vm-1", s1);
        state.addServiceBinding("host-1", "vm-1", s3);
        state.addServiceBinding("host-1", "vm-2", s2);
        state.addServiceBinding("host-2", "vm-1", s4);
        state.addServiceBinding("host-2", "vm-1", s5);
        state.addServiceBinding("host-2", "vm-1", s6);
        return state;
    }

    public void testGetServiceBinding() throws Exception {
        ClusteredRegistryState state = this.buildRegistry();
        List list = state.getServiceBindings("Query");
        TestClusteredRegistryState.assertEquals((int)3, (int)list.size());
        list = state.getServiceBindings("host-1", "vm-1");
        TestClusteredRegistryState.assertEquals((int)2, (int)list.size());
        list = state.getServiceBindings("host-1", "vm-2");
        TestClusteredRegistryState.assertEquals((int)1, (int)list.size());
        list = state.getServiceBindings("host-2", "vm-1");
        TestClusteredRegistryState.assertEquals((int)3, (int)list.size());
        list = state.getServiceBindings("host-1", null);
        TestClusteredRegistryState.assertEquals((int)3, (int)list.size());
        list = state.getServiceBindings(null, null);
        TestClusteredRegistryState.assertEquals((int)6, (int)list.size());
    }

    public void testRemoveServiceBinding() throws Exception {
        ClusteredRegistryState state = new ClusteredRegistryState(this.factory);
        HostControllerRegistryBinding host1 = TestClusteredRegistryState.buildHostRegistryBinding("host-1");
        HostControllerRegistryBinding host2 = TestClusteredRegistryState.buildHostRegistryBinding("host-2");
        state.addHost(host1);
        state.addHost(host2);
        ProcessRegistryBinding vm1 = TestClusteredRegistryState.buildVMRegistryBinding("host-1", "1");
        ProcessRegistryBinding vm2 = TestClusteredRegistryState.buildVMRegistryBinding("host-1", "2");
        ProcessRegistryBinding vm3 = TestClusteredRegistryState.buildVMRegistryBinding("host-1", "3");
        state.addProcess("host-1", "vm-1", vm1);
        state.addProcess("host-1", "vm-2", vm2);
        state.addProcess("host-2", "vm-1", vm3);
        ServiceRegistryBinding s1 = TestClusteredRegistryState.buildServiceRegistryBinding(1, vm1, "Query");
        ServiceRegistryBinding s2 = TestClusteredRegistryState.buildServiceRegistryBinding(2, vm2, "Query");
        ServiceRegistryBinding s3 = TestClusteredRegistryState.buildServiceRegistryBinding(3, vm1, "Index");
        ServiceRegistryBinding s4 = TestClusteredRegistryState.buildServiceRegistryBinding(4, vm3, "Query");
        ServiceRegistryBinding s5 = TestClusteredRegistryState.buildServiceRegistryBinding(5, vm3, "Session");
        ServiceRegistryBinding s6 = TestClusteredRegistryState.buildServiceRegistryBinding(6, vm3, "Auth");
        state.addServiceBinding("host-1", "vm-1", s1);
        state.addServiceBinding("host-1", "vm-1", s3);
        state.addServiceBinding("host-1", "vm-2", s2);
        state.addServiceBinding("host-2", "vm-1", s4);
        state.addServiceBinding("host-2", "vm-1", s5);
        state.addServiceBinding("host-2", "vm-1", s6);
        state.removeServiceBinding("host-1", "vm-1", s1.getServiceID());
        state.removeServiceBinding("host-2", "vm-1", s6.getServiceID());
        List list = state.getServiceBindings("Query");
        TestClusteredRegistryState.assertEquals((int)2, (int)list.size());
        list = state.getServiceBindings("host-1", "vm-1");
        TestClusteredRegistryState.assertEquals((int)1, (int)list.size());
        list = state.getServiceBindings("host-1", "vm-2");
        TestClusteredRegistryState.assertEquals((int)1, (int)list.size());
        list = state.getServiceBindings("host-2", "vm-1");
        TestClusteredRegistryState.assertEquals((int)2, (int)list.size());
        list = state.getServiceBindings("host-1", null);
        TestClusteredRegistryState.assertEquals((int)2, (int)list.size());
        list = state.getServiceBindings(null, null);
        TestClusteredRegistryState.assertEquals((int)4, (int)list.size());
    }

    public void testUpdate() {
        ClusteredRegistryState state = new ClusteredRegistryState(this.factory);
        Cache rootNode = state.cache;
        Cache n = rootNode.addChild("test");
        n.put((Object)"x", (Object)new Foo());
        Foo f = (Foo)n.get((Object)"x");
        f.update = "updated";
        f = (Foo)n.get((Object)"x");
        TestClusteredRegistryState.assertEquals((String)"updated", (String)f.update);
    }

    static ProcessRegistryBinding buildVMRegistryBinding(String hostName, String vmID) {
        HostID hostID1 = new HostID(hostName);
        VMComponentDefnID defnID1 = new VMComponentDefnID(Configuration.NEXT_STARTUP_ID, hostID1, "process1");
        BasicVMComponentDefn defn1 = new BasicVMComponentDefn(Configuration.NEXT_STARTUP_ID, hostID1, defnID1, new ComponentTypeID("VM"));
        ProcessManagement vmInterface1 = (ProcessManagement)SimpleMock.createSimpleMock(ProcessManagement.class);
        ProcessRegistryBinding binding = new ProcessRegistryBinding(hostName, vmID, (VMComponentDefn)defn1, vmInterface1, (MessageBus)new NoOpMessageBus());
        binding.setAlive(true);
        return binding;
    }

    static ServiceRegistryBinding buildServiceRegistryBinding(int id, ProcessRegistryBinding process, String type) {
        ServiceID sid = new ServiceID((long)id, process.getHostName(), process.getProcessName());
        return new ServiceRegistryBinding(sid, null, type, "instance-" + id, null, "deployed-" + id, process.getHostName(), null, null, 1, new Date(), false, (MessageBus)new NoOpMessageBus());
    }

    static HostControllerRegistryBinding buildHostRegistryBinding(String name) {
        return new HostControllerRegistryBinding(name, new Properties(), null, (MessageBus)new NoOpMessageBus());
    }

    static class Foo {
        String update = "start";

        Foo() {
        }
    }
}

