/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.registry;

import com.metamatrix.admin.server.FakeConfiguration;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.common.messaging.NoOpMessageBus;
import com.metamatrix.platform.registry.FakeRegistryUtil;
import com.metamatrix.platform.registry.ProcessRegistryBinding;
import com.metamatrix.platform.registry.ServiceRegistryBinding;
import com.metamatrix.platform.service.api.ServiceID;
import com.metamatrix.platform.service.api.ServiceInterface;
import com.metamatrix.platform.service.api.exception.ServiceClosedException;
import com.metamatrix.platform.service.controller.AbstractService;
import java.util.Date;
import java.util.Properties;
import junit.framework.TestCase;

public class TestServiceRegistryBinding
extends TestCase {
    public void testStateCheckingProxy() throws Exception {
        System.setProperty("metamatrix.message.bus.type", "noop.message.bus");
        FakeServiceImpl service = new FakeServiceImpl();
        ProcessRegistryBinding vmBinding2 = FakeRegistryUtil.buildVMRegistryBinding("2.2.2.2", "process2");
        ServiceID sid1 = new ServiceID(5L, vmBinding2.getHostName(), vmBinding2.getProcessName());
        ServiceRegistryBinding binding = new ServiceRegistryBinding(sid1, (ServiceInterface)service, "QueryService", "dqp2", "QueryService", "dqp2", "2.2.2.2", (DeployedComponent)new FakeConfiguration().deployedComponents.get(4), null, 2, new Date(), false, (MessageBus)new NoOpMessageBus());
        TestServiceRegistryBinding.assertEquals((int)1, (int)((FakeServiceInterface)binding.getService()).doSomething(1));
        service.die();
        ((FakeServiceInterface)binding.getService()).die();
        try {
            ((FakeServiceInterface)binding.getService()).doSomething(1);
            TestServiceRegistryBinding.fail((String)"expected exception");
        }
        catch (ServiceClosedException e) {
            // empty catch block
        }
    }

    private static class FakeServiceImpl
    extends AbstractService
    implements FakeServiceInterface {
        public FakeServiceImpl() {
            this.updateState(1);
        }

        protected void closeService() throws Exception {
        }

        protected void initService(Properties props) throws Exception {
        }

        protected void killService() {
        }

        protected void waitForServiceToClear() throws Exception {
        }

        @Override
        public int doSomething(int arg) {
            return arg;
        }
    }

    private static interface FakeServiceInterface
    extends ServiceInterface {
        public int doSomething(int var1);
    }
}

