/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.cache.Cache;
import com.metamatrix.cache.FakeCache;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.security.authorization.cache.AuthorizationCache;
import java.util.Collection;
import java.util.LinkedList;
import junit.framework.TestCase;
import org.jboss.cache.DefaultCacheFactory;

public class TestAuthorizationCache
extends TestCase {
    org.jboss.cache.Cache cacheStore;

    protected void setUp() throws Exception {
        DefaultCacheFactory factory = new DefaultCacheFactory();
        this.cacheStore = factory.createCache();
    }

    protected void tearDown() throws Exception {
        this.cacheStore.stop();
    }

    public void testFindPolicyIdsWithNoResult() throws Exception {
        AuthorizationCache cache = new AuthorizationCache((Cache)new FakeCache(), (Cache)new FakeCache(), null);
        Collection result = cache.findPolicyIDs(new MetaMatrixPrincipalName("a", 0), null);
        TestAuthorizationCache.assertTrue((boolean)result.isEmpty());
    }

    public void testFindPolicyIds() throws Exception {
        AuthorizationCache cache = new AuthorizationCache((Cache)new FakeCache(), (Cache)new FakeCache(), null);
        LinkedList<Integer> policyIDs = new LinkedList<Integer>();
        policyIDs.add(new Integer(1));
        SessionToken token = new SessionToken(new MetaMatrixSessionID(1L), "dummy");
        cache.cachePolicyIDsForPrincipal(new MetaMatrixPrincipalName("a", 0), token, policyIDs);
        Collection result = cache.findPolicyIDs(new MetaMatrixPrincipalName("a", 0), new SessionToken(new MetaMatrixSessionID(2L), "dummy"));
        TestAuthorizationCache.assertTrue((boolean)result.isEmpty());
        result = cache.findPolicyIDs(new MetaMatrixPrincipalName("a", 0), token);
        TestAuthorizationCache.assertEquals(result.iterator().next(), (Object)new Integer(1));
    }
}

