/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.common.tree.basic.BasicTreeNode;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.id.ObjectIDFactory;
import com.metamatrix.core.id.UUIDFactory;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.platform.admin.api.PermissionDataNodeDefinition;
import com.metamatrix.platform.admin.api.PermissionDataNodeTreeView;
import com.metamatrix.platform.admin.api.PermissionNode;
import com.metamatrix.platform.admin.api.PermissionTreeView;
import com.metamatrix.platform.admin.apiimpl.PermissionDataNodeDefinitionImpl;
import com.metamatrix.platform.admin.apiimpl.PermissionDataNodeImpl;
import com.metamatrix.platform.admin.apiimpl.PermissionDataNodeTreeViewImpl;
import com.metamatrix.platform.security.api.AuthorizationActions;
import com.metamatrix.platform.security.api.AuthorizationObjectEditor;
import com.metamatrix.platform.security.api.AuthorizationPermission;
import com.metamatrix.platform.security.api.AuthorizationPolicy;
import com.metamatrix.platform.security.api.AuthorizationPolicyID;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.AuthorizationResource;
import com.metamatrix.platform.security.api.BasicAuthorizationPermissionFactory;
import com.metamatrix.platform.security.api.DataAccessResource;
import com.metamatrix.platform.security.api.StandardAuthorizationActions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;

public final class TestAuthorizationObjectEditor
extends TestCase {
    private static BasicAuthorizationPermissionFactory bapFactory = new BasicAuthorizationPermissionFactory();
    private static AuthorizationRealm aRealm = new AuthorizationRealm("VDB1", "Vers1", "The test realm");
    private static String[] resources = new String[]{"Model_0.catalog_0.group_0.element_0", "Model_0.catalog_0.group_0.element_1", "Model_0.catalog_0.group_1.element_0", "Model_0.catalog_1.group_0.element_0", "Model_0.catalog_1.group_0.element_1", "Model_0.catalog_1.group_0.element_2", "Model_0.catalog_1.group_0.element_3", "Model_0.catalog_1.group_0.element_4", "Model_0.catalog_1.group_1.element_0", "Model_0.catalog_1.group_1.element_1", "Model_1.catalog_0.group_0.element_0", "Model_1.catalog_0.group_0.element_1", "Model_1.catalog_0.group_0.element_2", "Model_1.catalog_0.group_0.element_3", "Model_1.catalog_0.group_0.element_4", "Model_1.catalog_0.group_1.element_0", "Model_1.catalog_0.group_1.element_1", "Model_1.catalog_0.group_1.element_2", "Model_1.catalog_0.group_1.element_3", "Model_1.catalog_0.group_1.element_4", "Model_2.catalog_0.group_0.element_0", "Model_2.catalog_0.group_1.element_0", "Model_2.catalog_0.group_2.element_0", "Model_2.catalog_0.group_3.element_0", "Model_2.catalog_0.group_4.element_0", "Model_2.catalog_0.group_5.element_0", "Model_2.catalog_0.group_6.element_0", "Model_2.catalog_0.group_7.element_0", "Model_2.catalog_0.group_8.element_0", "Model_2.catalog_0.group_9.element_0"};
    private Set policyPerms = new HashSet();
    private Set permsToModify = new HashSet();
    private PermissionDataNodeTreeView treeView;
    private AuthorizationPolicy policyToModify;
    private Set modifiedResources = new HashSet();

    public TestAuthorizationObjectEditor(String name) {
        super(name);
        this.oneTimeSetUp();
    }

    public void oneTimeSetUp() {
        this.setupPolicyAndPermsToModify();
        this.setupTreeView();
    }

    public static void oneTimeTearDown() {
    }

    private void setupPolicyAndPermsToModify() {
        for (int i = 0; i < resources.length; ++i) {
            AuthorizationPermission aPerm = bapFactory.create((AuthorizationResource)new DataAccessResource(resources[i]), aRealm, StandardAuthorizationActions.ALL, null);
            this.policyPerms.add(aPerm);
            if (i % 2 != 0) continue;
            this.permsToModify.add(aPerm);
            this.modifiedResources.add(resources[i]);
        }
        this.policyToModify = new AuthorizationPolicy(new AuthorizationPolicyID("Test policy", "A test policy", aRealm), null, this.policyPerms);
    }

    private void setupTreeView() {
        List dataNodes = this.getResourcesAsList();
        IDGenerator idGenerator = IDGenerator.getInstance();
        idGenerator.setDefaultFactory((ObjectIDFactory)new UUIDFactory());
        ObjectID fakeRootID = idGenerator.create();
        PermissionDataNodeImpl root = new PermissionDataNodeImpl(null, StandardAuthorizationActions.NONE, (PermissionDataNodeDefinition)new PermissionDataNodeDefinitionImpl("root", "root", 0), false, fakeRootID);
        this.buildPermissionTree(root, dataNodes, this.policyToModify, idGenerator);
        this.treeView = new PermissionDataNodeTreeViewImpl((PermissionNode)root);
    }

    private List getResourcesAsList() {
        ArrayList<String> resourceList = new ArrayList<String>(resources.length);
        for (int i = 0; i < resources.length; ++i) {
            String resource = resources[i];
            resourceList.add(resource);
        }
        return resourceList;
    }

    private Map buildPermissionTree(PermissionDataNodeImpl root, List nodes, AuthorizationPolicy policy, IDGenerator idGenerator) {
        HashMap parentChildMap = new HashMap();
        String sepStr = ".";
        PermissionDataNodeImpl parent = root;
        parentChildMap.put(parent, new ArrayList());
        HashMap<String, PermissionDataNodeImpl> resourceToChild = new HashMap<String, PermissionDataNodeImpl>();
        for (String branch : nodes) {
            List nodeList = StringUtil.split((String)branch, (String)sepStr);
            for (String nodeName : nodeList) {
                String pathName = parent.equals((Object)root) ? nodeName : parent.getResourceName() + sepStr + nodeName;
                PermissionDataNodeImpl child = null;
                if (resourceToChild.containsKey(pathName)) {
                    child = (PermissionDataNodeImpl)resourceToChild.get(pathName);
                } else {
                    PermissionDataNodeDefinitionImpl nodeDef;
                    DataAccessResource theResource = new DataAccessResource(pathName);
                    AuthorizationPermission aPermission = policy.findPermissionWithResource((AuthorizationResource)theResource);
                    AuthorizationActions actions = StandardAuthorizationActions.NONE;
                    if (aPermission != null) {
                        actions = aPermission.getActions();
                    }
                    if (this.inModifiedRecources(child = new PermissionDataNodeImpl((BasicTreeNode)parent, actions, (PermissionDataNodeDefinition)(nodeDef = new PermissionDataNodeDefinitionImpl(pathName, nodeName, 4)), true, idGenerator.create()))) {
                        child.setModified(true);
                    }
                    resourceToChild.put(pathName, child);
                }
                List children = (List)parentChildMap.get(parent);
                if (children != null && !children.contains(child)) {
                    children.add(child);
                }
                if (!parentChildMap.containsKey(child)) {
                    parentChildMap.put(child, new ArrayList());
                }
                parent = child;
            }
            parent = root;
        }
        return parentChildMap;
    }

    private boolean inModifiedRecources(PermissionDataNodeImpl aNode) {
        return this.modifiedResources.contains(aNode.getResourceName());
    }

    private boolean helpTestPermissionCollectionsEqual(Collection collection_1, Collection collection_2) {
        boolean succeded = true;
        if (collection_1.size() != collection_2.size()) {
            return false;
        }
        for (AuthorizationPermission aPermToModify : collection_1) {
            if (collection_2.contains(aPermToModify)) continue;
            return false;
        }
        for (AuthorizationPermission aModifiedPerm : collection_2) {
            if (collection_1.contains(aModifiedPerm)) continue;
            return false;
        }
        return succeded;
    }

    public void testModifyPermissions() {
        AuthorizationObjectEditor aoe = new AuthorizationObjectEditor();
        Collection modifiedPerms = aoe.modifyPermissions((PermissionTreeView)this.treeView, this.policyToModify);
        TestAuthorizationObjectEditor.assertTrue((String)("Expected: " + this.permsToModify + " got: " + modifiedPerms), (boolean)this.helpTestPermissionCollectionsEqual(this.permsToModify, modifiedPerms));
    }
}

