/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.core.util.FileUtil;
import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.platform.security.api.AuthorizationPolicy;
import com.metamatrix.platform.security.api.AuthorizationPolicyFactory;
import com.metamatrix.platform.security.api.AuthorizationPolicyID;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.BasicAuthorizationPermissionFactory;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.platform.security.api.StandardAuthorizationActions;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.TestCase;
import org.xml.sax.SAXException;

public final class TestAuthorizationPolicyFactory
extends TestCase {
    static String[] roleNames = new String[]{"admin", "user", "other"};
    static String[] descriptions = new String[]{"This is a description", null, "I have no permissions"};
    static String[][] resourceNames = new String[][]{{"x", "y"}, {"a"}, new String[0]};
    static String[][] groupNames = new String[][]{{"group1", "group2"}, new String[0], {"group3"}};
    static int[][] actionValues = new int[][]{{15, 1}, {13}, new int[0]};

    public TestAuthorizationPolicyFactory(String name) {
        super(name);
    }

    public void testExport() throws Exception {
        String vdbName = "vdbName";
        String vdbVersion = "1";
        AuthorizationRealm realm = new AuthorizationRealm(vdbName, vdbVersion);
        BasicAuthorizationPermissionFactory bapf = new BasicAuthorizationPermissionFactory();
        ArrayList<AuthorizationPolicy> policies = new ArrayList<AuthorizationPolicy>();
        for (int i = 0; i < roleNames.length; ++i) {
            int j;
            AuthorizationPolicyID policyID = new AuthorizationPolicyID(roleNames[i], vdbName, vdbVersion);
            AuthorizationPolicy policy = new AuthorizationPolicy(policyID);
            policy.setDescription(descriptions[i]);
            policies.add(policy);
            for (j = 0; j < resourceNames[i].length; ++j) {
                policy.addPermission(bapf.create(resourceNames[i][j], realm, StandardAuthorizationActions.getAuthorizationActions((int)actionValues[i][j])));
            }
            for (j = 0; j < groupNames[i].length; ++j) {
                policy.addPrincipal(new MetaMatrixPrincipalName(groupNames[i][j], 1));
            }
        }
        char[] result = AuthorizationPolicyFactory.exportPolicies(policies);
        String expected = FileUtil.read((Reader)new FileReader(UnitTestUtil.getTestDataPath() + File.separator + "permissions.xml"));
        String actual = new String(result).replaceAll("\r\n", "\n");
        TestAuthorizationPolicyFactory.assertEquals((String)expected, (String)actual);
    }

    public void testImport() throws Exception {
        String vdbName = "vdbNamexx";
        String vdbVersion = "11";
        Collection roles = AuthorizationPolicyFactory.buildPolicies((String)vdbName, (String)vdbVersion, (char[])FileUtil.read((Reader)new FileReader(UnitTestUtil.getTestDataPath() + File.separator + "permissions.xml")).toCharArray());
        TestAuthorizationPolicyFactory.assertEquals((int)3, (int)roles.size());
        Iterator i = roles.iterator();
        while (i.hasNext()) {
            AuthorizationPolicy policy = (AuthorizationPolicy)i.next();
            AuthorizationPolicyID policyID = policy.getAuthorizationPolicyID();
            TestAuthorizationPolicyFactory.assertTrue((Arrays.asList(roleNames).indexOf(policyID.getDisplayName()) != -1 ? 1 : 0) != 0);
            int index = Arrays.asList(roleNames).indexOf(policyID.getDisplayName());
            if (index == 2) {
                i.remove();
            }
            if (index != 1) continue;
            policy.removePermissions();
        }
        char[] result = AuthorizationPolicyFactory.exportPolicies((Collection)roles);
        String expected = FileUtil.read((Reader)new FileReader(UnitTestUtil.getTestDataPath() + "/permissions2.xml"));
        String actual = new String(result).replaceAll("\r\n", "\n");
        TestAuthorizationPolicyFactory.assertEquals((String)expected, (String)actual);
    }

    public void testParsingFails() throws Exception {
        try {
            AuthorizationPolicyFactory.buildPolicies((String)"foo", (String)"bar", (char[])"<notvalid/>".toCharArray());
            TestAuthorizationPolicyFactory.fail((String)"expected exception");
        }
        catch (SAXException e) {
            TestAuthorizationPolicyFactory.assertEquals((String)"Error during parsing authorizations: cvc-elt.1: Cannot find the declaration of element 'notvalid'.", (String)e.getMessage());
        }
    }
}

