/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.platform.security.api.AuthorizationPermission;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.BasicAuthorizationPermissionFactory;
import com.metamatrix.platform.security.api.StandardAuthorizationActions;
import com.metamatrix.platform.security.util.RolePermissionFactory;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestBasicAuthorizationPermission
extends TestCase {
    private static BasicAuthorizationPermissionFactory bapFactory;
    private static RolePermissionFactory rpFactory;
    private static AuthorizationRealm realm_00;
    private static AuthorizationRealm realm_01;
    private static AuthorizationRealm realm_10;
    private static String invariantResource;
    private static String longResource;
    private static String groupResource;
    private static String groupRecursiveResource;
    private static String catalogResource;
    private static AuthorizationPermission source;
    private static AuthorizationPermission wrongInstancePerm;
    private static AuthorizationPermission wrongSuperRealmPerm;
    private static AuthorizationPermission wrongSubRealmPerm;
    private static AuthorizationPermission longResourcePerm;
    private static AuthorizationPermission catalogResourcePerm;
    private static AuthorizationPermission groupReadPerm;
    private static AuthorizationPermission groupRecursiveReadPerm;
    private static AuthorizationPermission memberOfGroupPerm;
    private static AuthorizationPermission allActionPerm;
    private static AuthorizationPermission noneActionPerm;
    private static AuthorizationPermission createActionPerm;
    private static AuthorizationPermission readActionPerm;
    private static AuthorizationPermission updateActionPerm;
    private static AuthorizationPermission deleteActionPerm;
    private static final boolean SUCCEED = true;
    private static final boolean FAIL = false;

    private static void initTestObjects() {
        realm_00 = new AuthorizationRealm("superRealm_0", "subRealm_0");
        realm_01 = new AuthorizationRealm("superRealm_0", "subRealm_1");
        realm_10 = new AuthorizationRealm("superRealm_1", "subRealm_0");
        new AuthorizationRealm("superRealm_1", "subRealm_1");
        bapFactory = new BasicAuthorizationPermissionFactory();
        rpFactory = new RolePermissionFactory();
        source = bapFactory.create(invariantResource, realm_00, StandardAuthorizationActions.ALL);
        allActionPerm = bapFactory.create(invariantResource, realm_00, StandardAuthorizationActions.ALL);
        noneActionPerm = bapFactory.create(invariantResource, realm_00, StandardAuthorizationActions.NONE);
        createActionPerm = bapFactory.create(invariantResource, realm_00, StandardAuthorizationActions.DATA_CREATE);
        readActionPerm = bapFactory.create(invariantResource, realm_00, StandardAuthorizationActions.DATA_READ);
        updateActionPerm = bapFactory.create(invariantResource, realm_00, StandardAuthorizationActions.DATA_UPDATE);
        deleteActionPerm = bapFactory.create(invariantResource, realm_00, StandardAuthorizationActions.DATA_DELETE);
        wrongInstancePerm = rpFactory.create(invariantResource, realm_00, StandardAuthorizationActions.ALL);
        wrongSuperRealmPerm = bapFactory.create(invariantResource, realm_10, StandardAuthorizationActions.ALL);
        wrongSubRealmPerm = bapFactory.create(invariantResource, realm_01, StandardAuthorizationActions.ALL);
        longResourcePerm = bapFactory.create(longResource, realm_00, StandardAuthorizationActions.ALL);
        catalogResourcePerm = bapFactory.create(catalogResource, realm_00, StandardAuthorizationActions.ALL);
        groupRecursiveReadPerm = bapFactory.create(groupRecursiveResource, realm_00, StandardAuthorizationActions.DATA_READ);
        groupReadPerm = bapFactory.create(groupResource, realm_00, StandardAuthorizationActions.DATA_READ);
        memberOfGroupPerm = bapFactory.create(invariantResource, realm_00, StandardAuthorizationActions.DATA_READ);
    }

    public TestBasicAuthorizationPermission(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(TestBasicAuthorizationPermission.class);
        return new TestSetup((Test)suite){

            public void setUp() {
                TestBasicAuthorizationPermission.initTestObjects();
            }

            public void tearDown() {
            }
        };
    }

    private static void helpTestImplies(AuthorizationPermission p1, AuthorizationPermission p2, boolean shouldImply) {
        boolean implied = p1.implies(p2);
        if (implied && shouldImply) {
            TestBasicAuthorizationPermission.assertTrue((String)("AuthorizationPermission.implies() check succeeded, should have succeeded: " + p1 + " => " + p2 + " <> p1 => p2 ? " + implied + ": shouldBeValid? " + shouldImply), (implied && shouldImply ? 1 : 0) != 0);
        } else if (!implied && !shouldImply) {
            TestBasicAuthorizationPermission.assertTrue((String)("AuthorizationPermission.implies() check failed, should have failed: " + p1 + " ! => " + p2 + " <> p1 => p2 ? " + implied + ": shouldBeValid? " + shouldImply), (!implied && !shouldImply ? 1 : 0) != 0);
        } else if (!implied && shouldImply) {
            TestBasicAuthorizationPermission.assertTrue((String)("AuthorizationPermission.implies() check failed, should have succeeded: " + p1 + " => " + p2 + " <> p1 => p2 ? " + implied + ": shouldBeValid? " + shouldImply), (!implied && !shouldImply ? 1 : 0) != 0);
        } else if (implied && !shouldImply) {
            TestBasicAuthorizationPermission.assertTrue((String)("AuthorizationPermission.implies() check succeded, should have failed: " + p1 + " ! => " + p2 + " <> p1 => p2 ? " + implied + ": shouldImply? " + shouldImply), (implied && shouldImply ? 1 : 0) != 0);
        }
    }

    public void testPos_RecursiveGroupAllowsElementRead() {
        TestBasicAuthorizationPermission.helpTestImplies(groupRecursiveReadPerm, memberOfGroupPerm, true);
    }

    public void testPos_ElementAllowsGroupRead() {
        TestBasicAuthorizationPermission.helpTestImplies(memberOfGroupPerm, groupReadPerm, true);
    }

    public void testPos_allImpliesAll() {
        TestBasicAuthorizationPermission.helpTestImplies(allActionPerm, allActionPerm, true);
    }

    public void testPos_allImpliesCreate() {
        TestBasicAuthorizationPermission.helpTestImplies(allActionPerm, createActionPerm, true);
    }

    public void testPos_allImpliesRead() {
        TestBasicAuthorizationPermission.helpTestImplies(allActionPerm, readActionPerm, true);
    }

    public void testPos_allImpliesUpdate() {
        TestBasicAuthorizationPermission.helpTestImplies(allActionPerm, updateActionPerm, true);
    }

    public void testPos_allImpliesDelete() {
        TestBasicAuthorizationPermission.helpTestImplies(allActionPerm, deleteActionPerm, true);
    }

    public void testPos_createImpliesCreate() {
        TestBasicAuthorizationPermission.helpTestImplies(createActionPerm, createActionPerm, true);
    }

    public void testPos_readImpliesRead() {
        TestBasicAuthorizationPermission.helpTestImplies(readActionPerm, readActionPerm, true);
    }

    public void testPos_updateImpliesUpdate() {
        TestBasicAuthorizationPermission.helpTestImplies(updateActionPerm, updateActionPerm, true);
    }

    public void testPos_deleteImpliesDelete() {
        TestBasicAuthorizationPermission.helpTestImplies(deleteActionPerm, deleteActionPerm, true);
    }

    public void testNeg_Implies_WrongInstance() {
        TestBasicAuthorizationPermission.helpTestImplies(source, wrongInstancePerm, false);
    }

    public void testNeg_Implies_WrongSuperRealm() {
        TestBasicAuthorizationPermission.helpTestImplies(source, wrongSuperRealmPerm, false);
    }

    public void testNeg_Implies_WrongSubRealm() {
        TestBasicAuthorizationPermission.helpTestImplies(source, wrongSubRealmPerm, false);
    }

    public void testNeg_Implies_LongResource() {
        TestBasicAuthorizationPermission.helpTestImplies(source, longResourcePerm, false);
    }

    public void testNeg_ElementImpliesCatalog() {
        TestBasicAuthorizationPermission.helpTestImplies(source, catalogResourcePerm, false);
    }

    public void testNeg_ElementImpliesRecursiveGroupRead() {
        TestBasicAuthorizationPermission.helpTestImplies(memberOfGroupPerm, groupRecursiveReadPerm, false);
    }

    public void testNeg_createImpliesDelete() {
        TestBasicAuthorizationPermission.helpTestImplies(createActionPerm, deleteActionPerm, false);
    }

    public void testNeg_createImpliesRead() {
        TestBasicAuthorizationPermission.helpTestImplies(createActionPerm, readActionPerm, false);
    }

    public void testNeg_createImpliesUpdate() {
        TestBasicAuthorizationPermission.helpTestImplies(createActionPerm, updateActionPerm, false);
    }

    public void testNeg_createImpliesAll() {
        TestBasicAuthorizationPermission.helpTestImplies(createActionPerm, allActionPerm, false);
    }

    public void testNeg_createImpliesNone() {
        TestBasicAuthorizationPermission.helpTestImplies(createActionPerm, noneActionPerm, false);
    }

    public void testNeg_updateImpliesCreate() {
        TestBasicAuthorizationPermission.helpTestImplies(updateActionPerm, createActionPerm, false);
    }

    public void testNeg_updateImpliesRead() {
        TestBasicAuthorizationPermission.helpTestImplies(updateActionPerm, readActionPerm, false);
    }

    public void testNeg_updateImpliesDelete() {
        TestBasicAuthorizationPermission.helpTestImplies(updateActionPerm, deleteActionPerm, false);
    }

    public void testNeg_updateImpliesAll() {
        TestBasicAuthorizationPermission.helpTestImplies(updateActionPerm, allActionPerm, false);
    }

    public void testNeg_updateImpliesNone() {
        TestBasicAuthorizationPermission.helpTestImplies(updateActionPerm, noneActionPerm, false);
    }

    public void testNeg_readImpliesCreate() {
        TestBasicAuthorizationPermission.helpTestImplies(readActionPerm, createActionPerm, false);
    }

    public void testNeg_readImpliesUpdate() {
        TestBasicAuthorizationPermission.helpTestImplies(readActionPerm, updateActionPerm, false);
    }

    public void testNeg_readImpliesDelete() {
        TestBasicAuthorizationPermission.helpTestImplies(readActionPerm, deleteActionPerm, false);
    }

    public void testNeg_readImpliesAll() {
        TestBasicAuthorizationPermission.helpTestImplies(readActionPerm, allActionPerm, false);
    }

    public void testNeg_readImpliesNone() {
        TestBasicAuthorizationPermission.helpTestImplies(readActionPerm, noneActionPerm, false);
    }

    public void testNeg_deleteImpliesCreate() {
        TestBasicAuthorizationPermission.helpTestImplies(deleteActionPerm, createActionPerm, false);
    }

    public void testNeg_deleteImpliesRead() {
        TestBasicAuthorizationPermission.helpTestImplies(deleteActionPerm, readActionPerm, false);
    }

    public void testNeg_deleteImpliesUpdate() {
        TestBasicAuthorizationPermission.helpTestImplies(deleteActionPerm, updateActionPerm, false);
    }

    public void testNeg_deleteImpliesAll() {
        TestBasicAuthorizationPermission.helpTestImplies(deleteActionPerm, allActionPerm, false);
    }

    public void testNeg_deleteImpliesNone() {
        TestBasicAuthorizationPermission.helpTestImplies(deleteActionPerm, noneActionPerm, false);
    }

    public void testNeg_noneImpliesCreate() {
        TestBasicAuthorizationPermission.helpTestImplies(noneActionPerm, createActionPerm, false);
    }

    public void testNeg_noneImpliesRead() {
        TestBasicAuthorizationPermission.helpTestImplies(noneActionPerm, readActionPerm, false);
    }

    public void testNeg_noneImpliesUpdate() {
        TestBasicAuthorizationPermission.helpTestImplies(noneActionPerm, updateActionPerm, false);
    }

    public void testNeg_noneImpliesDelete() {
        TestBasicAuthorizationPermission.helpTestImplies(noneActionPerm, deleteActionPerm, false);
    }

    public void testNeg_noneImpliesAll() {
        TestBasicAuthorizationPermission.helpTestImplies(noneActionPerm, allActionPerm, false);
    }

    public void testNeg_allImpliesNone() {
        TestBasicAuthorizationPermission.helpTestImplies(allActionPerm, noneActionPerm, false);
    }

    public void testNeg_noneImpliesNone() {
        TestBasicAuthorizationPermission.helpTestImplies(noneActionPerm, noneActionPerm, false);
    }

    static {
        invariantResource = "Model.catalog.group.element_0";
        longResource = invariantResource + ".fred";
        groupResource = "Model.catalog.group";
        groupRecursiveResource = "Model.catalog.group.*";
        catalogResource = "Model.catalog";
    }
}

