/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.authorization.service;

import com.metamatrix.api.exception.security.AuthorizationMgmtException;
import com.metamatrix.api.exception.security.InvalidPrincipalException;
import com.metamatrix.cache.Cache;
import com.metamatrix.cache.FakeCache;
import com.metamatrix.common.connection.ManagedConnectionException;
import com.metamatrix.platform.security.api.BasicMetaMatrixPrincipal;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.security.api.service.MembershipServiceInterface;
import com.metamatrix.platform.security.authorization.cache.AuthorizationCache;
import com.metamatrix.platform.security.authorization.service.AuthorizationServiceImpl;
import com.metamatrix.platform.security.authorization.spi.AuthorizationSourceTransaction;
import com.metamatrix.platform.security.authorization.spi.FakeAuthorizationSource;
import com.metamatrix.platform.security.authorization.spi.TestFakeAuthorizationSource;
import com.metamatrix.platform.service.api.exception.ServiceException;
import java.util.Collection;
import junit.framework.TestCase;
import org.jboss.cache.DefaultCacheFactory;
import org.mockito.Mockito;

public class TestAuthorizationServiceImpl
extends TestCase {
    private static final String TEST_GROUP = "g1+p1";
    private static final String INVALID_GROUP = "foo";
    org.jboss.cache.Cache cacheStore;
    private static final SessionToken TEST_SESSION_TOKEN = new SessionToken();

    protected void setUp() throws Exception {
        DefaultCacheFactory factory = new DefaultCacheFactory();
        this.cacheStore = factory.createCache();
    }

    protected void tearDown() throws Exception {
        this.cacheStore.stop();
    }

    public void testGetRolesForGroup() throws Exception {
        FakeAuthorizationService service = new FakeAuthorizationService();
        String groupName = TEST_GROUP;
        Collection roles = service.getRoleNamesForPrincipal(TEST_SESSION_TOKEN, new MetaMatrixPrincipalName(groupName, 1));
        TestAuthorizationServiceImpl.assertEquals((int)1, (int)roles.size());
        TestAuthorizationServiceImpl.assertEquals((Object)"Policy1", roles.iterator().next());
    }

    public void testGetRolesForGroupWithInvalidGroup() throws Exception {
        FakeAuthorizationService service = new FakeAuthorizationService();
        String groupName = INVALID_GROUP;
        try {
            service.getRoleNamesForPrincipal(TEST_SESSION_TOKEN, new MetaMatrixPrincipalName(groupName, 1));
            TestAuthorizationServiceImpl.fail((String)"expected exception");
        }
        catch (AuthorizationMgmtException authorizationMgmtException) {
            // empty catch block
        }
    }

    public class FakeAuthorizationService
    extends AuthorizationServiceImpl {
        public FakeAuthorizationService() throws Exception {
            this.authorizationCache = new AuthorizationCache((Cache)new FakeCache(), (Cache)new FakeCache(), null);
            this.membershipServiceProxy = (MembershipServiceInterface)Mockito.mock(MembershipServiceInterface.class);
            Mockito.stub((Object)this.membershipServiceProxy.getPrincipal(new MetaMatrixPrincipalName(TestAuthorizationServiceImpl.TEST_GROUP, 1))).toReturn((Object)new BasicMetaMatrixPrincipal(TestAuthorizationServiceImpl.TEST_GROUP, 1));
            Mockito.stub((Object)this.membershipServiceProxy.getPrincipal(new MetaMatrixPrincipalName(TestAuthorizationServiceImpl.INVALID_GROUP, 1))).toThrow((Throwable)new InvalidPrincipalException());
        }

        protected AuthorizationSourceTransaction getReadTransaction() throws ManagedConnectionException {
            FakeAuthorizationSource source = new FakeAuthorizationSource();
            TestFakeAuthorizationSource.helpPopulate(source);
            return source;
        }

        protected boolean isEntitled(String principal) throws ServiceException {
            return false;
        }
    }
}

