/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.authorization.spi;

import com.metamatrix.platform.security.api.AuthorizationActions;
import com.metamatrix.platform.security.api.AuthorizationPermission;
import com.metamatrix.platform.security.api.AuthorizationPermissionFactory;
import com.metamatrix.platform.security.api.AuthorizationPolicy;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.AuthorizationResource;
import com.metamatrix.platform.security.api.DataAccessResource;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.platform.security.api.StandardAuthorizationActions;
import com.metamatrix.platform.security.util.RolePermissionFactory;
import java.util.HashSet;

public final class AuthorizationTestUtil {
    static final String METABASE_REALM_NAME = "MetaBase";
    public static final int PRINCIPAL_TYPE_USER = 0;
    public static final int PRINCIPAL_TYPE_GROUP = 1;
    public static final int PRINCIPAL_TYPE_ADMIN = 2;
    public static final AuthorizationPermissionFactory METABASE_FACTORY = new RolePermissionFactory();
    private static final int crudInt = 15;
    private static final int rInt = 2;
    private static final int cInt = 1;
    private static final int ruInt = 6;
    private static final int rdInt = 10;
    private static final int crInt = 3;
    private static final int rudInt = 14;
    public static final AuthorizationActions CRUD = StandardAuthorizationActions.getAuthorizationActions((int)15);
    public static final AuthorizationActions C = StandardAuthorizationActions.getAuthorizationActions((int)1);
    public static final AuthorizationActions R = StandardAuthorizationActions.getAuthorizationActions((int)2);
    public static final AuthorizationActions RU = StandardAuthorizationActions.getAuthorizationActions((int)6);
    public static final AuthorizationActions RD = StandardAuthorizationActions.getAuthorizationActions((int)10);
    public static final AuthorizationActions CR = StandardAuthorizationActions.getAuthorizationActions((int)3);
    public static final AuthorizationActions RUD = StandardAuthorizationActions.getAuthorizationActions((int)14);

    private AuthorizationTestUtil() {
    }

    public static AuthorizationRealm getRealm() {
        return RolePermissionFactory.getRealm();
    }

    public static MetaMatrixPrincipalName createUserName(String name) {
        return new MetaMatrixPrincipalName(name, 0);
    }

    public static MetaMatrixPrincipalName createGroupName(String name) {
        return new MetaMatrixPrincipalName(name, 1);
    }

    public static void addPrincipalsToPolicy(AuthorizationPolicy policy, MetaMatrixPrincipalName[] names) {
        HashSet<MetaMatrixPrincipalName> newPrincipalNames = new HashSet<MetaMatrixPrincipalName>();
        for (int i = 0; i != names.length; ++i) {
            newPrincipalNames.add(names[i]);
        }
        policy.addAllPrincipals(newPrincipalNames);
    }

    public static void removePrincipalsFromPolicy(AuthorizationPolicy policy, MetaMatrixPrincipalName[] names) {
        for (int i = 0; i != names.length; ++i) {
            policy.removePrincipal(names[i]);
        }
    }

    public static void addPermissionToPolicy(AuthorizationPolicy policy, String realmName, String resourceName, AuthorizationActions actions) {
        AuthorizationPermission perm = AuthorizationTestUtil.createPermission(realmName, resourceName, actions);
        policy.addPermission(perm);
    }

    public static AuthorizationPermission createPermission(String realmName, String resourceName, AuthorizationActions actions) {
        DataAccessResource resource = new DataAccessResource(resourceName);
        AuthorizationRealm realm = new AuthorizationRealm(realmName);
        String contentModifier = "";
        return METABASE_FACTORY.create((AuthorizationResource)resource, realm, actions, "");
    }
}

