/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.authorization.spi;

import com.metamatrix.api.exception.security.AuthorizationMgmtException;
import com.metamatrix.common.connection.ManagedConnectionException;
import com.metamatrix.platform.security.api.AuthorizationPermission;
import com.metamatrix.platform.security.api.AuthorizationPolicy;
import com.metamatrix.platform.security.api.AuthorizationPolicyID;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.AuthorizationResource;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.platform.security.authorization.spi.AuthorizationSourceConnectionException;
import com.metamatrix.platform.security.authorization.spi.AuthorizationSourceException;
import com.metamatrix.platform.security.authorization.spi.AuthorizationSourceTransaction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FakeAuthorizationSource
implements AuthorizationSourceTransaction {
    private boolean closed;
    private final Set realmNames = new HashSet();
    private final Map authPoliciesByID = new HashMap();

    public Map getGroupEntitlements(AuthorizationRealm realm, String fullyQualifiedGroupName) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        throw new UnsupportedOperationException("Method needed to support MetaMatrix JDBC driver");
    }

    public Map getElementEntitlements(AuthorizationRealm realm, String elementNamePattern) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        throw new UnsupportedOperationException("Method needed to support MetaMatrix JDBC driver");
    }

    public Collection getRealmNames() throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        return this.realmNames;
    }

    public boolean containsPolicy(AuthorizationPolicyID id) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        return this.authPoliciesByID.containsKey(id);
    }

    public Collection findAllPolicyIDs() throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        return this.authPoliciesByID.keySet();
    }

    public Collection findPolicyIDs(Collection principals, AuthorizationRealm realm) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        HashSet<AuthorizationPolicyID> results = new HashSet<AuthorizationPolicyID>();
        block0: for (AuthorizationPolicy policy : this.authPoliciesByID.values()) {
            Set policyPrincipals = policy.getPrincipals();
            for (MetaMatrixPrincipalName principalName : principals) {
                if (!policyPrincipals.contains(principalName)) continue;
                results.add(policy.getAuthorizationPolicyID());
                continue block0;
            }
        }
        return results;
    }

    public Collection findPolicyIDs(Collection principals) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        HashSet<AuthorizationPolicyID> results = new HashSet<AuthorizationPolicyID>();
        block0: for (AuthorizationPolicy policy : this.authPoliciesByID.values()) {
            Set policyPrincipals = policy.getPrincipals();
            for (MetaMatrixPrincipalName principalName : principals) {
                if (!policyPrincipals.contains(principalName)) continue;
                results.add(policy.getAuthorizationPolicyID());
                continue block0;
            }
        }
        return results;
    }

    public Collection getPolicies(Collection policyIDs) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        HashSet<AuthorizationPolicy> results = new HashSet<AuthorizationPolicy>();
        for (AuthorizationPolicyID policyID : policyIDs) {
            AuthorizationPolicy policy = this.getPolicy(policyID);
            results.add(policy);
        }
        return results;
    }

    public AuthorizationPolicy getPolicy(AuthorizationPolicyID policyID) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        AuthorizationPolicy policy = (AuthorizationPolicy)this.authPoliciesByID.get(policyID);
        if (policy != null) {
            this.updateResourcesForPermissions(policy);
        }
        return policy;
    }

    public void close() {
        this.closed = true;
    }

    public Set executeActions(AuthorizationPolicyID target, List actions, String grantor) throws AuthorizationSourceConnectionException, AuthorizationSourceException, AuthorizationMgmtException {
        throw new UnsupportedOperationException("Method is only called from AdminAPI and the VDB delete utility");
    }

    public Map getRoleDescriptions() throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        throw new UnsupportedOperationException("Method is only called from AdminAPI");
    }

    public Collection getPrincipalsForRole(String roleName) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        throw new UnsupportedOperationException("Method is only called from AdminAPI");
    }

    public Collection getRoleNamesForPrincipal(Collection principals) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        throw new UnsupportedOperationException("Method is only called from AdminAPI");
    }

    public boolean removePrincipalFromAllPolicies(MetaMatrixPrincipalName principal) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        boolean result = false;
        for (AuthorizationPolicy policy : this.authPoliciesByID.values()) {
            if (!policy.getPrincipals().contains(principal)) continue;
            policy.removePrincipal(principal);
            result = true;
        }
        return result;
    }

    public Collection getPolicyIDsWithPermissionsInRealm(AuthorizationRealm realm) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        throw new UnsupportedOperationException("Method is only called from AdminAPI and the VDB delete utility");
    }

    public Collection getPolicyIDsInRealm(AuthorizationRealm realm) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        throw new UnsupportedOperationException("Method is only called from AdminAPI");
    }

    public Collection getPolicyIDsInPartialRealm(AuthorizationRealm realm) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        throw new UnsupportedOperationException("Method is only called from AdminAPI");
    }

    public Collection getPolicyIDsForResourceInRealm(AuthorizationRealm realm, String resourceName) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        throw new UnsupportedOperationException("Method is only called from AdminAPI");
    }

    public Set getPermissionsForPolicy(AuthorizationPolicyID policyID) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        AuthorizationPolicy policy = (AuthorizationPolicy)this.authPoliciesByID.get(policyID);
        if (policy != null) {
            return policy.getPermissions();
        }
        return Collections.EMPTY_SET;
    }

    public void addPermissionsWithResourcesToParent(String parent, Collection resources, AuthorizationRealm realm) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        throw new UnsupportedOperationException("Service shouldn't be calling this method");
    }

    public void removePermissionsWithResources(Collection resources, AuthorizationRealm realm) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        for (AuthorizationPolicy policy : this.authPoliciesByID.values()) {
            for (AuthorizationPermission perm : policy.getPermissions()) {
                AuthorizationResource resource = perm.getResource();
                if (!resources.contains(resource)) continue;
                policy.removePermission(perm);
            }
        }
    }

    public void removePrincipalsAndPoliciesForRealm(AuthorizationRealm realm) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
    }

    public Collection getDependantPermissions(AuthorizationPermission request) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        return null;
    }

    public void commit() throws ManagedConnectionException {
    }

    public void rollback() throws ManagedConnectionException {
    }

    public boolean isReadonly() {
        return false;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public AuthorizationPolicy findPolicy(String name) {
        AuthorizationPolicyID id = new AuthorizationPolicyID(name, "");
        return (AuthorizationPolicy)this.authPoliciesByID.get(id);
    }

    public AuthorizationPolicy createPolicy(String name) {
        AuthorizationPolicyID id = new AuthorizationPolicyID(name, "");
        AuthorizationPolicy policy = new AuthorizationPolicy(id);
        this.authPoliciesByID.put(id, policy);
        return policy;
    }

    public void removePolicy(AuthorizationPolicy policy) {
        this.authPoliciesByID.remove(policy.getAuthorizationPolicyID());
    }

    private void updateResourcesForPermissions(AuthorizationPolicy policy) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        for (AuthorizationPermission permission : policy.getPermissions()) {
            permission.getResource();
        }
    }
}

