/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.authorization.spi;

import com.metamatrix.platform.security.api.AuthorizationActions;
import com.metamatrix.platform.security.api.AuthorizationPermission;
import com.metamatrix.platform.security.api.AuthorizationPolicy;
import com.metamatrix.platform.security.api.AuthorizationPolicyID;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.platform.security.api.StandardAuthorizationActions;
import com.metamatrix.platform.security.authorization.spi.AuthorizationSourceConnectionException;
import com.metamatrix.platform.security.authorization.spi.AuthorizationSourceException;
import com.metamatrix.platform.security.authorization.spi.AuthorizationSourceTransaction;
import com.metamatrix.platform.security.authorization.spi.AuthorizationTestUtil;
import com.metamatrix.platform.security.authorization.spi.FakeAuthorizationSource;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;

public class TestFakeAuthorizationSource
extends TestCase {
    public TestFakeAuthorizationSource(String arg0) {
        super(arg0);
    }

    public static void helpPopulate(FakeAuthorizationSource source) {
        String realmName = "MetaBase";
        AuthorizationPolicy policy1 = source.createPolicy("Policy1");
        AuthorizationPolicy policy2 = source.createPolicy("Policy2");
        AuthorizationPolicy policy3 = source.createPolicy("Policy3");
        MetaMatrixPrincipalName u1 = AuthorizationTestUtil.createUserName("u1+p1");
        MetaMatrixPrincipalName u2 = AuthorizationTestUtil.createUserName("u2+p1+p2");
        MetaMatrixPrincipalName u3 = AuthorizationTestUtil.createUserName("u3+p2");
        MetaMatrixPrincipalName u4 = AuthorizationTestUtil.createUserName("u4+p3");
        MetaMatrixPrincipalName u5 = AuthorizationTestUtil.createUserName("u4+p1+p2+p3");
        MetaMatrixPrincipalName g1 = AuthorizationTestUtil.createGroupName("g1+p1");
        AuthorizationTestUtil.addPrincipalsToPolicy(policy1, new MetaMatrixPrincipalName[]{u1, u2, g1, u5});
        AuthorizationTestUtil.addPrincipalsToPolicy(policy2, new MetaMatrixPrincipalName[]{u2, u3, u5});
        AuthorizationTestUtil.addPrincipalsToPolicy(policy3, new MetaMatrixPrincipalName[]{u4, u5});
        AuthorizationTestUtil.addPermissionToPolicy(policy1, "MetaBase", "f1", AuthorizationTestUtil.R);
        AuthorizationTestUtil.addPermissionToPolicy(policy1, "MetaBase", "f1/f12", AuthorizationTestUtil.CR);
        AuthorizationTestUtil.addPermissionToPolicy(policy1, "MetaBase", "f1/f12/m121", AuthorizationTestUtil.R);
        AuthorizationTestUtil.addPermissionToPolicy(policy1, "MetaBase", "f1/f12/m122", AuthorizationTestUtil.RU);
        AuthorizationTestUtil.addPermissionToPolicy(policy1, "MetaBase", "f1/f12/m123", AuthorizationTestUtil.CRUD);
        AuthorizationTestUtil.addPermissionToPolicy(policy1, "MetaBase", "f1/f12/m124", AuthorizationTestUtil.CRUD);
        AuthorizationTestUtil.addPermissionToPolicy(policy2, "MetaBase", "f1", AuthorizationTestUtil.CR);
        AuthorizationTestUtil.addPermissionToPolicy(policy2, "MetaBase", "f1/f11", AuthorizationTestUtil.R);
        AuthorizationTestUtil.addPermissionToPolicy(policy2, "MetaBase", "f1/f11/m111", AuthorizationTestUtil.RU);
        AuthorizationTestUtil.addPermissionToPolicy(policy2, "MetaBase", "f1/f12", AuthorizationTestUtil.R);
        AuthorizationTestUtil.addPermissionToPolicy(policy2, "MetaBase", "f1/f12/m121", AuthorizationTestUtil.CRUD);
        AuthorizationTestUtil.addPermissionToPolicy(policy2, "MetaBase", "f1/f12/m122", AuthorizationTestUtil.R);
        AuthorizationTestUtil.addPermissionToPolicy(policy3, "MetaBase", "f1", AuthorizationTestUtil.RUD);
        AuthorizationTestUtil.addPermissionToPolicy(policy3, "MetaBase", "f1/f11", AuthorizationTestUtil.CRUD);
        AuthorizationTestUtil.addPermissionToPolicy(policy3, "MetaBase", "f1/f11/m111", AuthorizationTestUtil.CRUD);
        AuthorizationTestUtil.addPermissionToPolicy(policy3, "MetaBase", "f1/f12", AuthorizationTestUtil.CRUD);
        AuthorizationTestUtil.addPermissionToPolicy(policy3, "MetaBase", "f1/f12/m121", AuthorizationTestUtil.RD);
        AuthorizationTestUtil.addPermissionToPolicy(policy3, "MetaBase", "f1/f12/m122", AuthorizationTestUtil.RD);
    }

    public void helpTestFindPolicies(AuthorizationSourceTransaction source, String[] userNames, String[] groupNames, String[] policyNames) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        int i;
        HashSet<MetaMatrixPrincipalName> principals = new HashSet<MetaMatrixPrincipalName>();
        for (i = 0; i != userNames.length; ++i) {
            principals.add(AuthorizationTestUtil.createUserName(userNames[i]));
        }
        for (i = 0; i != groupNames.length; ++i) {
            principals.add(AuthorizationTestUtil.createGroupName(groupNames[i]));
        }
        Collection policyIDs = source.findPolicyIDs(principals, AuthorizationTestUtil.getRealm());
        List<String> policyNameList = Arrays.asList(policyNames);
        Iterator iter = policyIDs.iterator();
        while (iter.hasNext()) {
            AuthorizationPolicyID policyID = (AuthorizationPolicyID)iter.next();
            if (!policyNameList.contains(policyID.getName())) {
                TestFakeAuthorizationSource.fail((String)("Unable to find expected policy \"" + policyID.getName() + "\""));
                continue;
            }
            iter.next();
        }
        if (policyIDs.size() != 0) {
            TestFakeAuthorizationSource.fail((String)("Found " + policyIDs.size() + " unexpected policies: " + policyIDs));
        }
    }

    public void helpTestAuthorization(FakeAuthorizationSource source, String username, AuthorizationActions actions, boolean expectedAuthorization, String resourceName) throws AuthorizationSourceConnectionException, AuthorizationSourceException {
        HashSet<MetaMatrixPrincipalName> principals = new HashSet<MetaMatrixPrincipalName>();
        principals.add(AuthorizationTestUtil.createUserName(username));
        AuthorizationPermission perm = AuthorizationTestUtil.createPermission("MetaBase", resourceName, actions);
        boolean authorized = false;
        Collection policyIDs = source.findPolicyIDs(principals, AuthorizationTestUtil.getRealm());
        for (AuthorizationPolicyID policyID : policyIDs) {
            AuthorizationPolicy policy = source.getPolicy(policyID);
            if (!policy.implies(perm)) continue;
            authorized = true;
            break;
        }
        if (authorized && !expectedAuthorization) {
            TestFakeAuthorizationSource.fail((String)("Unexpectedly authorized for resource \"" + resourceName + "\" [" + actions + "]"));
        }
    }

    public void testFindPolicy() {
        FakeAuthorizationSource source = new FakeAuthorizationSource();
        TestFakeAuthorizationSource.helpPopulate(source);
        AuthorizationPolicy policy = source.findPolicy("Policy1");
        if (!policy.getAuthorizationPolicyID().getName().equals("Policy1")) {
            TestFakeAuthorizationSource.fail((String)"Unable to find the correct policy");
        }
    }

    public void testPolicyForPrincipals1() throws Exception {
        FakeAuthorizationSource source = new FakeAuthorizationSource();
        TestFakeAuthorizationSource.helpPopulate(source);
        String[] userNames = new String[]{"u1"};
        String[] groupNames = new String[]{};
        String[] policyNames = new String[]{"Policy1"};
        this.helpTestFindPolicies(source, userNames, groupNames, policyNames);
    }

    public void testPolicyForPrincipals2() throws Exception {
        FakeAuthorizationSource source = new FakeAuthorizationSource();
        TestFakeAuthorizationSource.helpPopulate(source);
        String[] userNames = new String[]{"u1"};
        String[] groupNames = new String[]{"g1"};
        String[] policyNames = new String[]{"Policy1"};
        this.helpTestFindPolicies(source, userNames, groupNames, policyNames);
    }

    public void testPolicyForPrincipals3() throws Exception {
        FakeAuthorizationSource source = new FakeAuthorizationSource();
        TestFakeAuthorizationSource.helpPopulate(source);
        String[] userNames = new String[]{"u1"};
        String[] groupNames = new String[]{"g1"};
        String[] policyNames = new String[]{"Policy1"};
        this.helpTestFindPolicies(source, userNames, groupNames, policyNames);
    }

    public void testPolicyForPrincipals4() throws Exception {
        FakeAuthorizationSource source = new FakeAuthorizationSource();
        TestFakeAuthorizationSource.helpPopulate(source);
        String[] userNames = new String[]{"u2"};
        String[] groupNames = new String[]{};
        String[] policyNames = new String[]{"Policy1", "Policy2"};
        this.helpTestFindPolicies(source, userNames, groupNames, policyNames);
    }

    public void testPolicyForPrincipals5() throws Exception {
        FakeAuthorizationSource source = new FakeAuthorizationSource();
        TestFakeAuthorizationSource.helpPopulate(source);
        String[] userNames = new String[]{"u5"};
        String[] groupNames = new String[]{};
        String[] policyNames = new String[]{"Policy1", "Policy2", "Policy3"};
        this.helpTestFindPolicies(source, userNames, groupNames, policyNames);
    }

    public void testAuthorization1() throws Exception {
        FakeAuthorizationSource source = new FakeAuthorizationSource();
        TestFakeAuthorizationSource.helpPopulate(source);
        String userName = "u5";
        AuthorizationActions actions = StandardAuthorizationActions.ALL;
        this.helpTestAuthorization(source, "u5", actions, true, "f1");
        this.helpTestAuthorization(source, "u5", actions, true, "f1/f11");
        this.helpTestAuthorization(source, "u5", actions, true, "f1/f11/m111");
        this.helpTestAuthorization(source, "u5", actions, true, "f1/f12");
        this.helpTestAuthorization(source, "u5", actions, true, "f1/f12/m121");
        this.helpTestAuthorization(source, "u5", actions, true, "f1/f12/m122");
        this.helpTestAuthorization(source, "u5", actions, true, "f1/f12/m123");
        this.helpTestAuthorization(source, "u5", actions, true, "f1/f12/m124");
    }

    public void testAuthorization2() throws Exception {
        FakeAuthorizationSource source = new FakeAuthorizationSource();
        TestFakeAuthorizationSource.helpPopulate(source);
        String userName = "u1";
        this.helpTestAuthorization(source, "u1", AuthorizationTestUtil.R, true, "f1");
        this.helpTestAuthorization(source, "u1", AuthorizationTestUtil.CR, true, "f1/f12");
        this.helpTestAuthorization(source, "u1", AuthorizationTestUtil.R, true, "f1/f12/m121");
        this.helpTestAuthorization(source, "u1", AuthorizationTestUtil.RU, true, "f1/f12/m122");
        this.helpTestAuthorization(source, "u1", AuthorizationTestUtil.CRUD, true, "f1/f12/m123");
        this.helpTestAuthorization(source, "u1", AuthorizationTestUtil.CRUD, true, "f1/f12/m124");
        this.helpTestAuthorization(source, "u1", AuthorizationTestUtil.RU, false, "f1");
        this.helpTestAuthorization(source, "u1", AuthorizationTestUtil.RUD, false, "f1");
        this.helpTestAuthorization(source, "u1", AuthorizationTestUtil.C, false, "f1");
        this.helpTestAuthorization(source, "u1", AuthorizationTestUtil.R, false, "f1/f11");
    }
}

