/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.membership.service;

import com.metamatrix.api.exception.security.InvalidPrincipalException;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.platform.security.api.Credentials;
import com.metamatrix.platform.security.api.MetaMatrixPrincipal;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.platform.security.membership.service.AuthenticationToken;
import com.metamatrix.platform.security.membership.service.MembershipServiceImpl;
import com.metamatrix.platform.security.membership.service.SuccessfulAuthenticationToken;
import com.metamatrix.platform.security.membership.spi.MembershipDomain;
import com.metamatrix.platform.security.membership.spi.file.TestFileMembershipDomain;
import com.metamatrix.platform.service.api.exception.ServiceStateException;
import java.util.Properties;
import junit.framework.TestCase;

public class TestMembershipServiceImpl
extends TestCase {
    public void testInitialization() throws Exception {
        Properties p = new Properties();
        p.setProperty("security.membership.admin.username", "metamatrixadmin");
        p.setProperty("security.membership.admin.password", CryptoUtil.getCryptor().encrypt("mm"));
        p.setProperty("security.membership.security.enabled", Boolean.TRUE.toString());
        MembershipServiceImpl membershipServiceImpl = new MembershipServiceImpl();
        membershipServiceImpl.initService(p);
        TestMembershipServiceImpl.assertEquals((int)0, (int)membershipServiceImpl.getDomains().size());
        TestMembershipServiceImpl.assertTrue((boolean)membershipServiceImpl.isSecurityEnabled());
    }

    public void testInitialization1() throws Exception {
        Properties p = new Properties();
        p.setProperty("security.membership.admin.username", "metamatrixadmin");
        p.setProperty("security.membership.admin.password", CryptoUtil.getCryptor().encrypt("mm"));
        p.setProperty("security.membership.security.enabled", Boolean.FALSE.toString());
        MembershipServiceImpl membershipServiceImpl = new MembershipServiceImpl();
        membershipServiceImpl.initService(p);
        TestMembershipServiceImpl.assertEquals((int)0, (int)membershipServiceImpl.getDomains().size());
        TestMembershipServiceImpl.assertFalse((boolean)membershipServiceImpl.isSecurityEnabled());
        TestMembershipServiceImpl.assertTrue((boolean)(membershipServiceImpl.authenticateUser("foo", new Credentials("bar".toCharArray()), null, null) instanceof SuccessfulAuthenticationToken));
    }

    public void testBaseUsername() throws Exception {
        TestMembershipServiceImpl.assertEquals((String)"foo@bar.com", (String)MembershipServiceImpl.getBaseUsername((String)"foo\\@bar.com@foo"));
        TestMembershipServiceImpl.assertEquals((String)"foo", (String)MembershipServiceImpl.getDomainName((String)"me\\@bar.com@foo"));
        TestMembershipServiceImpl.assertEquals(null, (String)MembershipServiceImpl.getDomainName((String)"@"));
        TestMembershipServiceImpl.assertEquals((String)"@", (String)MembershipServiceImpl.getBaseUsername((String)"@"));
    }

    private MembershipServiceImpl createMembershipService() throws ServiceStateException {
        MembershipServiceImpl membershipService = new MembershipServiceImpl();
        MembershipServiceImpl.MembershipDomainHolder membershipDomainHolder = new MembershipServiceImpl.MembershipDomainHolder((MembershipDomain)TestFileMembershipDomain.createFileMembershipDomain(), "testFile");
        membershipService.getDomains().add(membershipDomainHolder);
        return membershipService;
    }

    public void testGetPrincipal() throws Exception {
        MembershipServiceImpl membershipService = this.createMembershipService();
        MetaMatrixPrincipal principal = membershipService.getPrincipal(new MetaMatrixPrincipalName("user1@testFile", 0));
        TestMembershipServiceImpl.assertEquals((String)"user1@testFile", (String)principal.getName());
    }

    public void testAuthenticate() throws Exception {
        MembershipServiceImpl membershipService = this.createMembershipService();
        AuthenticationToken at = membershipService.authenticateUser("user1", new Credentials("pass1".toCharArray()), null, null);
        TestMembershipServiceImpl.assertEquals((String)"user1@testFile", (String)at.getUserName());
    }

    public void testGetPrincipalForGroup() throws Exception {
        MembershipServiceImpl membershipService = this.createMembershipService();
        MetaMatrixPrincipal principal = membershipService.getPrincipal(new MetaMatrixPrincipalName("group1@testFile", 1));
        TestMembershipServiceImpl.assertEquals((String)"group1@testFile", (String)principal.getName());
        TestMembershipServiceImpl.assertEquals((int)1, (int)principal.getType());
    }

    public void testGetPrincipalForInvalidGroup() throws Exception {
        MembershipServiceImpl membershipService = this.createMembershipService();
        try {
            membershipService.getPrincipal(new MetaMatrixPrincipalName("groupX@testFile", 1));
        }
        catch (InvalidPrincipalException e) {
            TestMembershipServiceImpl.assertEquals((String)"The principal 'groupX@testFile' does not exist in domain 'testFile'", (String)e.getMessage());
        }
    }
}

