/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.membership.spi.file;

import com.metamatrix.api.exception.security.InvalidUserException;
import com.metamatrix.api.exception.security.LogonException;
import com.metamatrix.api.exception.security.UnsupportedCredentialException;
import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.platform.security.api.Credentials;
import com.metamatrix.platform.security.membership.service.SuccessfulAuthenticationToken;
import com.metamatrix.platform.security.membership.spi.file.FileMembershipDomain;
import com.metamatrix.platform.service.api.exception.ServiceStateException;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;

public class TestFileMembershipDomain
extends TestCase {
    public static final String TEST_DOMAIN_NAME = "testFile";

    public void testInvalidInit1() throws Exception {
        FileMembershipDomain domain = new FileMembershipDomain();
        Properties p = new Properties();
        try {
            domain.initialize(p);
            TestFileMembershipDomain.fail((String)"expected exception");
        }
        catch (ServiceStateException e) {
            TestFileMembershipDomain.assertEquals((String)"Required property usersFile was missing.", (String)e.getMessage());
        }
    }

    public void testInvalidInit2() throws Exception {
        FileMembershipDomain domain = new FileMembershipDomain();
        Properties p = new Properties();
        File usersFile = UnitTestUtil.getTestDataFile((String)"users.properties");
        p.setProperty("usersFile", usersFile.getAbsolutePath());
        try {
            domain.initialize(p);
            TestFileMembershipDomain.fail((String)"expected exception");
        }
        catch (ServiceStateException e) {
            TestFileMembershipDomain.assertEquals((String)"Required property groupsFile was missing.", (String)e.getMessage());
        }
    }

    public void testInvalidInit3() throws Exception {
        FileMembershipDomain domain = new FileMembershipDomain();
        Properties p = new Properties();
        File groupsFile = UnitTestUtil.getTestDataFile((String)"groups.properties");
        p.setProperty("groupsFile", groupsFile.getAbsolutePath());
        try {
            domain.initialize(p);
            TestFileMembershipDomain.fail((String)"expected exception");
        }
        catch (ServiceStateException e) {
            TestFileMembershipDomain.assertEquals((String)"Required property usersFile was missing.", (String)e.getMessage());
        }
    }

    public void testBadUsersFile() throws Exception {
        FileMembershipDomain domain = new FileMembershipDomain();
        Properties p = new Properties();
        File usersFile = UnitTestUtil.getTestDataFile((String)"ohCrap");
        File groupsFile = UnitTestUtil.getTestDataFile((String)"groups.properties");
        p.setProperty("usersFile", usersFile.getAbsolutePath());
        p.setProperty("groupsFile", groupsFile.getAbsolutePath());
        try {
            domain.initialize(p);
            TestFileMembershipDomain.fail((String)"expected exception");
        }
        catch (ServiceStateException e) {
            TestFileMembershipDomain.assertTrue((boolean)e.getMessage().startsWith("Could not load file"));
        }
    }

    public void testBadGroupsFile() throws Exception {
        FileMembershipDomain domain = new FileMembershipDomain();
        Properties p = new Properties();
        File usersFile = UnitTestUtil.getTestDataFile((String)"users.properties");
        File groupsFile = UnitTestUtil.getTestDataFile((String)"bad");
        p.setProperty("usersFile", usersFile.getAbsolutePath());
        p.setProperty("groupsFile", groupsFile.getAbsolutePath());
        try {
            domain.initialize(p);
            TestFileMembershipDomain.fail((String)"expected exception");
        }
        catch (ServiceStateException e) {
            TestFileMembershipDomain.assertTrue((boolean)e.getMessage().startsWith("Could not load file"));
        }
    }

    public void testValidInit() throws Exception {
        FileMembershipDomain domain = new FileMembershipDomain();
        Properties p = new Properties();
        File usersFile = UnitTestUtil.getTestDataFile((String)"users.properties");
        File groupsFile = UnitTestUtil.getTestDataFile((String)"groups.properties");
        p.setProperty("usersFile", usersFile.getAbsolutePath());
        p.setProperty("groupsFile", groupsFile.getAbsolutePath());
        try {
            domain.initialize(p);
        }
        catch (ServiceStateException e) {
            TestFileMembershipDomain.fail((String)"unexpected exception");
        }
    }

    public void testValidUserAuthentication() throws Exception {
        FileMembershipDomain domain = TestFileMembershipDomain.createFileMembershipDomain();
        SuccessfulAuthenticationToken sat = domain.authenticateUser("user1", new Credentials("pass1".toCharArray()), null, null);
        TestFileMembershipDomain.assertNull((Object)sat.getPayload());
    }

    public void testInValidUserAuthentication() throws Exception {
        FileMembershipDomain domain = TestFileMembershipDomain.createFileMembershipDomain();
        try {
            domain.authenticateUser("user1", null, null, null);
            TestFileMembershipDomain.fail((String)"Expected exception");
        }
        catch (UnsupportedCredentialException unsupportedCredentialException) {
            // empty catch block
        }
    }

    public static FileMembershipDomain createFileMembershipDomain() throws ServiceStateException {
        return TestFileMembershipDomain.createFileMembershipDomain(true);
    }

    public static FileMembershipDomain createFileMembershipDomain(boolean checkPassword) throws ServiceStateException {
        FileMembershipDomain domain = new FileMembershipDomain();
        Properties p = new Properties();
        File usersFile = UnitTestUtil.getTestDataFile((String)"users.properties");
        File groupsFile = UnitTestUtil.getTestDataFile((String)"groups.properties");
        p.setProperty("usersFile", usersFile.getAbsolutePath());
        p.setProperty("groupsFile", groupsFile.getAbsolutePath());
        p.setProperty("checkPassword", Boolean.toString(checkPassword));
        p.setProperty("domainName", TEST_DOMAIN_NAME);
        domain.initialize(p);
        return domain;
    }

    public void testInvalidUserAuthentication() throws Exception {
        FileMembershipDomain domain = TestFileMembershipDomain.createFileMembershipDomain();
        try {
            domain.authenticateUser("joe", new Credentials("pass1".toCharArray()), null, null);
            TestFileMembershipDomain.fail((String)"expected exception");
        }
        catch (InvalidUserException e) {
            TestFileMembershipDomain.assertEquals((String)e.getMessage(), (String)"user joe is invalid");
        }
    }

    public void testInvalidPasswordAuthentication() throws Exception {
        FileMembershipDomain domain = TestFileMembershipDomain.createFileMembershipDomain();
        try {
            domain.authenticateUser("user1", new Credentials("pass2".toCharArray()), null, null);
            TestFileMembershipDomain.fail((String)"expected exception");
        }
        catch (LogonException e) {
            TestFileMembershipDomain.assertEquals((String)e.getMessage(), (String)"user user1 could not be authenticated");
        }
    }

    public void testInvalidUserWithCheckingFalse() throws Exception {
        FileMembershipDomain domain = TestFileMembershipDomain.createFileMembershipDomain();
        try {
            domain.authenticateUser("joe", new Credentials("pass1".toCharArray()), null, null);
            TestFileMembershipDomain.fail((String)"expected exception");
        }
        catch (InvalidUserException e) {
            TestFileMembershipDomain.assertEquals((String)e.getMessage(), (String)"user joe is invalid");
        }
    }

    public void testInvalidPasswordWithCheckingFalse() throws Exception {
        FileMembershipDomain domain = TestFileMembershipDomain.createFileMembershipDomain(false);
        SuccessfulAuthenticationToken sat = domain.authenticateUser("user1", new Credentials("pass2".toCharArray()), null, null);
        TestFileMembershipDomain.assertNull((Object)sat.getPayload());
    }

    public void testGetGroupNames() throws Exception {
        FileMembershipDomain domain = TestFileMembershipDomain.createFileMembershipDomain();
        Set groupNames = domain.getGroupNames();
        TestFileMembershipDomain.assertEquals(new HashSet<Object>(Arrays.asList("group1", "group2", "group3")), (Object)groupNames);
    }

    public void testGetGroupNamesForUser() throws Exception {
        FileMembershipDomain domain = TestFileMembershipDomain.createFileMembershipDomain();
        Set groupNames = domain.getGroupNamesForUser("user2");
        TestFileMembershipDomain.assertEquals(new HashSet<Object>(Arrays.asList("group1", "group2")), (Object)groupNames);
    }

    public void testGetGroupNamesForInvalidUser() throws Exception {
        FileMembershipDomain domain = TestFileMembershipDomain.createFileMembershipDomain();
        try {
            domain.getGroupNamesForUser("markyMark");
            TestFileMembershipDomain.fail((String)"expected exception");
        }
        catch (Exception e) {
            TestFileMembershipDomain.assertTrue((boolean)(e instanceof InvalidUserException));
        }
    }

    public void testInitializeWithClasspathFiles() throws Exception {
        FileMembershipDomain domain = new FileMembershipDomain();
        Properties p = new Properties();
        String usersFile = "users.properties";
        String groupsFile = "groups.properties";
        p.setProperty("usersFile", usersFile);
        p.setProperty("groupsFile", groupsFile);
        p.setProperty("domainName", TEST_DOMAIN_NAME);
        domain.initialize(p);
        TestFileMembershipDomain.assertEquals((int)3, (int)domain.getUsers().size());
    }
}

