/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.membership.spi.ldap;

import com.metamatrix.platform.security.membership.spi.ldap.LDAPMembershipDomain;
import com.metamatrix.platform.service.api.exception.ServiceStateException;
import java.util.Properties;
import junit.framework.TestCase;

public class TestLDAPMembershipDomainConfiguration
extends TestCase {
    private LDAPMembershipDomain getLdapMembershipDomainWithMultipleContexts() throws ServiceStateException {
        LDAPMembershipDomain domain = new LDAPMembershipDomain();
        Properties p = new Properties();
        p.setProperty("ldapURL", "ldap://sluxtech09:389");
        p.setProperty("users.rootContext", "ou=people,dc=metamatrix,dc=com?ou=people,dc=quadrian,dc=com");
        p.setProperty("groups.rootContext", "ou=groups,dc=metamatrix,dc=com?ou=groups,dc=quadrian,dc=com");
        p.setProperty("groups.groupMember.attribute", "uniquemember");
        p.setProperty("ldapAdmin.dn", "cn=Directory Manager");
        p.setProperty("ldapAdmin.password", "stladmin");
        p.setProperty("domainName", "testDomain");
        domain.initialize(p);
        return domain;
    }

    public void testInvalidInit1() throws Exception {
        LDAPMembershipDomain domain = new LDAPMembershipDomain();
        Properties p = new Properties();
        try {
            domain.initialize(p);
            TestLDAPMembershipDomainConfiguration.fail((String)"expected exception");
        }
        catch (ServiceStateException e) {
            TestLDAPMembershipDomainConfiguration.assertEquals((String)"Required property ldapURL was missing.", (String)e.getMessage());
        }
    }

    public void testInvalidInit2() throws Exception {
        LDAPMembershipDomain domain = new LDAPMembershipDomain();
        Properties p = new Properties();
        p.setProperty("ldapURL", "ldap://sluxtech09:389");
        try {
            domain.initialize(p);
            TestLDAPMembershipDomainConfiguration.fail((String)"expected exception");
        }
        catch (ServiceStateException e) {
            TestLDAPMembershipDomainConfiguration.assertEquals((String)"Required property users.rootContext was missing.", (String)e.getMessage());
        }
    }

    public void testInvalidInit3() throws Exception {
        LDAPMembershipDomain domain = new LDAPMembershipDomain();
        Properties p = new Properties();
        p.setProperty("ldapURL", "ldap://sluxtech09:389");
        p.setProperty("users.rootContext", "ou=people,dc=metamatrix,dc=com");
        try {
            domain.initialize(p);
            TestLDAPMembershipDomainConfiguration.fail((String)"expected exception");
        }
        catch (ServiceStateException e) {
            TestLDAPMembershipDomainConfiguration.assertEquals((String)"Required property groups.rootContext was missing.", (String)e.getMessage());
        }
    }

    public void testValidInit() throws Exception {
        LDAPMembershipDomain domain = new LDAPMembershipDomain();
        Properties p = new Properties();
        p.setProperty("ldapURL", "ldap://sluxtech09:389");
        p.setProperty("users.rootContext", "ou=people,dc=metamatrix,dc=com");
        p.setProperty("groups.rootContext", "ou=groups,dc=metamatrix,dc=com");
        p.setProperty("users.memberOf.attribute", "memberOf");
        try {
            domain.initialize(p);
        }
        catch (ServiceStateException e) {
            TestLDAPMembershipDomainConfiguration.fail((String)"Encountered initialization exception");
        }
    }

    public void testUsernameEscaping() {
        TestLDAPMembershipDomainConfiguration.assertEquals((String)"\\2a", (String)LDAPMembershipDomain.escapeLDAPSearchFilter((String)"*"));
    }

    public void testMultipleContexts() throws Exception {
        LDAPMembershipDomain domain = this.getLdapMembershipDomainWithMultipleContexts();
        TestLDAPMembershipDomainConfiguration.assertEquals((int)2, (int)domain.getUsersRootContexts().size());
        LDAPMembershipDomain.LdapContext context = (LDAPMembershipDomain.LdapContext)domain.getUsersRootContexts().get(1);
        TestLDAPMembershipDomainConfiguration.assertEquals((String)"ou=people,dc=quadrian,dc=com", (String)context.context);
    }
}

