/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.session.service;

import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.cache.Cache;
import com.metamatrix.cache.FakeCache;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.MetaMatrixSessionInfo;
import com.metamatrix.platform.security.api.service.MembershipServiceInterface;
import com.metamatrix.platform.security.membership.service.SuccessfulAuthenticationToken;
import com.metamatrix.platform.security.session.service.SessionServiceImpl;
import java.util.Properties;
import junit.framework.TestCase;
import org.mockito.Mockito;

public class TestSessionServiceImpl
extends TestCase {
    public void testValidateSession() throws Exception {
        SessionServiceImpl ssi = new SessionServiceImpl();
        ssi.setClusterName("test");
        ssi.setSessionCache((Cache)new FakeCache());
        MembershipServiceInterface msi = (MembershipServiceInterface)Mockito.mock(MembershipServiceInterface.class);
        Mockito.stub((Object)msi.authenticateUser("steve", null, null, "foo")).toReturn((Object)new SuccessfulAuthenticationToken(null, "steve@somedomain"));
        ssi.setMembershipService(msi);
        MetaMatrixSessionID id1 = new MetaMatrixSessionID(1L);
        try {
            ssi.validateSession(id1);
            TestSessionServiceImpl.fail((String)"exception expected");
        }
        catch (InvalidSessionException e) {
            // empty catch block
        }
        MetaMatrixSessionInfo info = ssi.createSession("steve", null, null, "foo", "test", new Properties());
        id1 = info.getSessionID();
        ssi.validateSession(id1);
        TestSessionServiceImpl.assertEquals((int)1, (int)ssi.getActiveSessionsCount());
        TestSessionServiceImpl.assertEquals((int)0, (int)ssi.getActiveConnectionsCountForProduct("x"));
        TestSessionServiceImpl.assertEquals((int)1, (int)ssi.getActiveConnectionsCountForProduct("test"));
        TestSessionServiceImpl.assertEquals((int)0, (int)ssi.getSessionsLoggedInToVDB("a", "1").size());
        ssi.closeSession(id1);
        try {
            ssi.validateSession(id1);
            TestSessionServiceImpl.fail((String)"exception expected");
        }
        catch (InvalidSessionException e) {
            // empty catch block
        }
        try {
            ssi.closeSession(id1);
            TestSessionServiceImpl.fail((String)"exception expected");
        }
        catch (InvalidSessionException e) {
            // empty catch block
        }
    }
}

