/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.service.proxy;

import com.metamatrix.admin.server.FakeConfiguration;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.common.messaging.NoOpMessageBus;
import com.metamatrix.platform.registry.FakeRegistryUtil;
import com.metamatrix.platform.registry.ProcessRegistryBinding;
import com.metamatrix.platform.registry.ServiceRegistryBinding;
import com.metamatrix.platform.service.api.ServiceID;
import com.metamatrix.platform.service.api.ServiceInterface;
import com.metamatrix.platform.service.api.exception.ServiceNotFoundException;
import com.metamatrix.platform.service.controller.FakeService;
import com.metamatrix.platform.service.controller.FakeServiceInterface;
import com.metamatrix.platform.service.proxy.ProxyManager;
import com.metamatrix.platform.service.proxy.ServiceSelectionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class TestProxies
extends TestCase {
    public void testMultipleInvocation() throws Exception {
        int i;
        FakeService[] fakeServices = new FakeService[]{new FakeService(), new FakeService()};
        ArrayList<ServiceRegistryBinding> serviceBindings = new ArrayList<ServiceRegistryBinding>();
        for (int i2 = 0; i2 < fakeServices.length; ++i2) {
            ProcessRegistryBinding vmBinding2 = FakeRegistryUtil.buildVMRegistryBinding("2.2.2.2", "process2");
            ServiceID sid1 = new ServiceID((long)i2, vmBinding2.getHostName(), vmBinding2.getProcessName());
            ServiceRegistryBinding binding = new ServiceRegistryBinding(sid1, (ServiceInterface)fakeServices[i2], "QueryService", "dqp2", "QueryService", "dqp2", "2.2.2.2", (DeployedComponent)new FakeConfiguration().deployedComponents.get(4), null, 2, new Date(), false, (MessageBus)new NoOpMessageBus());
            serviceBindings.add(binding);
        }
        FakePolicy policy = new FakePolicy(serviceBindings);
        Properties props = new Properties();
        props.put("metamatrix.core.proxy.serviceProxyClassName", FakeServiceInterface.class.getName());
        props.put("metamatrix.core.proxy.serviceMultipleDelegation", Boolean.TRUE.toString());
        FakeServiceInterface fakeService = (FakeServiceInterface)ProxyManager.createProxy((String)"foo", (Properties)props, (ServiceSelectionPolicy)policy);
        Collection result = fakeService.test2();
        TestProxies.assertNotNull((Object)result);
        TestProxies.assertTrue((boolean)result.isEmpty());
        fakeService.test1();
        for (i = 0; i < fakeServices.length; ++i) {
            TestProxies.assertEquals((int)1, (int)fakeServices[i].getTest1Count());
        }
        fakeService.test1();
        for (i = 0; i < fakeServices.length; ++i) {
            TestProxies.assertEquals((int)2, (int)fakeServices[i].getTest1Count());
        }
        result = fakeService.test4();
        TestProxies.assertEquals(Arrays.asList(new Integer(1), new Integer(1)), (Object)result);
    }

    public void testSingleInvocation() throws Exception {
        int i;
        FakeService[] fakeServices = new FakeService[]{new FakeService(), new FakeService()};
        ArrayList<ServiceRegistryBinding> serviceBindings = new ArrayList<ServiceRegistryBinding>();
        for (int i2 = 0; i2 < fakeServices.length; ++i2) {
            ProcessRegistryBinding vmBinding2 = FakeRegistryUtil.buildVMRegistryBinding("2.2.2.2", "process2");
            ServiceID sid1 = new ServiceID((long)i2, vmBinding2.getHostName(), vmBinding2.getProcessName());
            ServiceRegistryBinding binding = new ServiceRegistryBinding(sid1, (ServiceInterface)fakeServices[i2], "QueryService", "dqp2", "QueryService", "dqp2", "2.2.2.2", (DeployedComponent)new FakeConfiguration().deployedComponents.get(4), null, 2, new Date(), false, (MessageBus)new NoOpMessageBus());
            serviceBindings.add(binding);
        }
        FakePolicy policy = new FakePolicy(serviceBindings);
        Properties props = new Properties();
        props.put("metamatrix.core.proxy.serviceProxyClassName", FakeServiceInterface.class.getName());
        FakeServiceInterface fakeService = (FakeServiceInterface)ProxyManager.createProxy((String)"foo", (Properties)props, (ServiceSelectionPolicy)policy);
        Collection result = fakeService.test2();
        TestProxies.assertNotNull((Object)result);
        TestProxies.assertTrue((boolean)result.isEmpty());
        fakeService.test1();
        int total = 0;
        for (i = 0; i < fakeServices.length; ++i) {
            total += fakeServices[i].getTest1Count();
        }
        TestProxies.assertEquals((int)1, (int)total);
        fakeService.test1();
        total = 0;
        for (i = 0; i < fakeServices.length; ++i) {
            total += fakeServices[i].getTest1Count();
        }
        TestProxies.assertEquals((int)2, (int)total);
        TestProxies.assertFalse((boolean)fakeService.test3());
        result = fakeService.test4();
        TestProxies.assertEquals(Arrays.asList(new Integer(1)), (Object)result);
    }

    private final class FakePolicy
    implements ServiceSelectionPolicy {
        private final List bindings;
        int index = 0;

        private FakePolicy(List bindings) {
            this.bindings = bindings;
        }

        public String getServiceSelectionPolicyName() {
            return "Dummy";
        }

        public boolean prefersLocal() {
            return false;
        }

        public ServiceRegistryBinding getNextInstance() throws ServiceNotFoundException {
            return (ServiceRegistryBinding)this.bindings.get(this.index++ % this.bindings.size());
        }

        public List getInstances() throws ServiceNotFoundException {
            return this.bindings;
        }

        public void updateServices(List<ServiceRegistryBinding> localServices, List<ServiceRegistryBinding> remoteServices) {
        }
    }
}

