/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server.admin.apiimpl;

import com.metamatrix.cache.CacheFactory;
import com.metamatrix.cache.FakeCache;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.common.util.ByteArrayHelper;
import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.metadata.runtime.RuntimeMetadataCatalog;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseException;
import com.metamatrix.server.admin.api.MaterializationLoadScripts;
import com.metamatrix.server.admin.apiimpl.FakeModelInfo;
import com.metamatrix.server.admin.apiimpl.RuntimeMetadataHelper;
import com.metamatrix.vdb.materialization.DatabaseDialect;
import com.metamatrix.vdb.materialization.ScriptType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;
import org.mockito.Mockito;

public class TestRuntimeMetadataHelper
extends TestCase {
    private ModelInfo fakeMaterializationModel;

    protected void setUp() throws Exception {
        super.setUp();
        this.fakeMaterializationModel = new FakeModelInfo(10);
        try {
            RuntimeMetadataCatalog.getInstance().init(new Properties(), (MessageBus)Mockito.mock(MessageBus.class), (CacheFactory)new FakeCache.FakeCacheFactory());
        }
        catch (VirtualDatabaseException virtualDatabaseException) {
            // empty catch block
        }
    }

    public void testParseDatabaseType_Ora() {
        String oraURL = "jdbc:mmx:oracle://slntds04:1521;SID=ds04;DatabaseName=jcunningham_txn_test";
        String expected = "oracle";
        String actual = RuntimeMetadataHelper.parseDatabaseType((String)oraURL, (String)DatabaseDialect.ORACLE.getDriverClassname());
        TestRuntimeMetadataHelper.assertEquals((String)expected, (String)actual);
        this.assertCannonicalStringsMatch(expected, actual);
    }

    public void testParseDatabaseType_SQLServer() {
        String sqlURL = "jdbc:mmx:sqlserver://slntds05:1433;DatabaseName=jcunningham_txn_test";
        String expected = "sqlserver";
        String actual = RuntimeMetadataHelper.parseDatabaseType((String)sqlURL, (String)DatabaseDialect.SQL_SERVER.getDriverClassname());
        TestRuntimeMetadataHelper.assertEquals((String)expected, (String)actual);
        this.assertCannonicalStringsMatch(expected, actual);
    }

    public void testParseDatabaseType_DB2() {
        String db2URL = "jdbc:mmx:db2://slntds05:50000;DatabaseName=ds05;";
        String expected = "db2";
        String actual = RuntimeMetadataHelper.parseDatabaseType((String)db2URL, (String)DatabaseDialect.DB2.getDriverClassname());
        TestRuntimeMetadataHelper.assertEquals((String)expected, (String)actual);
        this.assertCannonicalStringsMatch(expected, actual);
    }

    public void testParseDatabaseType_SYBASE() {
        String db2URL = "jdbc:mmx:sybase://slntds17:5000;DatabaseName=dv_vhalbert2";
        String expected = "sybase";
        String actual = RuntimeMetadataHelper.parseDatabaseType((String)db2URL, (String)DatabaseDialect.SYBASE.getDriverClassname());
        TestRuntimeMetadataHelper.assertEquals((String)expected, (String)actual);
        this.assertCannonicalStringsMatch(expected, actual);
    }

    public void testParseDatabaseType_MySQL() {
        String mysqlURL = "jdbc:mysql://slntds03:3306/rep_unit_test";
        String expected = "mysql";
        String actual = RuntimeMetadataHelper.parseDatabaseType((String)mysqlURL, (String)DatabaseDialect.MYSQL.getDriverClassname());
        TestRuntimeMetadataHelper.assertEquals((String)expected, (String)actual);
        this.assertCannonicalStringsMatch(expected, actual);
    }

    public void testCreateMaterializedViewLoadPropertiesOracle() throws Exception {
        Map ddlFiles = this.setupMaterializationModelDDLFiles();
        this.fakeMaterializationModel.setDDLFiles(ddlFiles);
        String vdbName = "TestConnPropsVDB";
        String vdbVersion = null;
        String expectedLoadScriptFileName = ScriptType.connectionPropertyFileName((String)vdbName, (String)"1");
        MaterializationLoadScripts loadScript = RuntimeMetadataHelper.createMaterializedViewLoadProperties((ModelInfo)this.fakeMaterializationModel, (String)"jdbc:mmx:oracle://slntds04:1521;SID=ds04", (String)"com.metamatrix.jdbc.oracle.OracleDriver", (String)"matUser", (String)"matPwd", (String)"mmHost1", (String)"12345", (String)"com.metamatrix.jdbc.MMDriver", (boolean)false, (String)"aMMUser", (String)"aMMPwd", (String)vdbName, vdbVersion);
        String actualFileName = loadScript.getConnectionPropsFileName();
        InputStream connPropFileStream = loadScript.getConnectionPropsFileContents();
        this.helpSaveProps(actualFileName, connPropFileStream);
        this.checkProperties(actualFileName, expectedLoadScriptFileName);
        String expectedFileName = ScriptType.createScriptFileName((String)vdbName, (String)"1");
        TestRuntimeMetadataHelper.assertEquals((String)"Expected create script file names to be equal.", (String)expectedFileName, (String)loadScript.getCreateScriptFileName());
        this.checkFileContents("Expected create scripts to be equal.", (byte[])ddlFiles.get("MaterializationModel_Oracle_8i_9i_DDL.ddl"), ByteArrayHelper.toByteArray((InputStream)loadScript.getCreateScriptFile()));
    }

    public void testCreateMaterializedViewLoadPropertiesOracleUsingSSL() throws Exception {
        CurrentConfiguration.getInstance().getConfiguration();
        Map ddlFiles = this.setupMaterializationModelDDLFiles();
        this.fakeMaterializationModel.setDDLFiles(ddlFiles);
        String vdbName = "TestSSLConnPropsVDB";
        String vdbVersion = null;
        String expectedLoadScriptFileName = ScriptType.connectionPropertyFileName((String)vdbName, (String)"1");
        MaterializationLoadScripts loadScript = RuntimeMetadataHelper.createMaterializedViewLoadProperties((ModelInfo)this.fakeMaterializationModel, (String)"jdbc:mmx:oracle://slntds04:1521;SID=ds04", (String)"com.metamatrix.jdbc.oracle.OracleDriver", (String)"matUser", (String)"matPwd", (String)"mmHost1", (String)"12345", (String)"com.metamatrix.jdbc.MMDriver", (boolean)true, (String)"aMMUser", (String)"aMMPwd", (String)vdbName, vdbVersion);
        String actualFileName = loadScript.getConnectionPropsFileName();
        InputStream connPropFileStream = loadScript.getConnectionPropsFileContents();
        this.helpSaveProps(actualFileName, connPropFileStream);
        this.checkProperties(actualFileName, expectedLoadScriptFileName);
        String expectedFileName = ScriptType.createScriptFileName((String)vdbName, (String)"1");
        TestRuntimeMetadataHelper.assertEquals((String)"Expected create script file names to be equal.", (String)expectedFileName, (String)loadScript.getCreateScriptFileName());
        this.checkFileContents("Expected create scripts to be equal.", (byte[])ddlFiles.get("MaterializationModel_Oracle_8i_9i_DDL.ddl"), ByteArrayHelper.toByteArray((InputStream)loadScript.getCreateScriptFile()));
    }

    public void testCreateMaterializedViewLoadPropertiesSQLServer() throws Exception {
        Map ddlFiles = this.setupMaterializationModelDDLFilesReal();
        this.fakeMaterializationModel.setDDLFiles(ddlFiles);
        String vdbName = "PartsSupplier";
        String vdbVersion = "3";
        String expectedLoadScriptFileName = ScriptType.connectionPropertyFileName((String)vdbName, (String)vdbVersion);
        MaterializationLoadScripts loadScript = RuntimeMetadataHelper.createMaterializedViewLoadProperties((ModelInfo)this.fakeMaterializationModel, (String)"jdbc:mmx:sqlserver://slntds05:1433;DatabaseName=jcunningham_txn_test\\cha", (String)"com.metamatrix.jdbc.sqlserver.SQLServerDriver", (String)"matUser", (String)"matPwd", (String)"mmHost1", (String)"12345", (String)"com.metamatrix.jdbc.MMDriver", (boolean)false, (String)"aMMUser", (String)"aMMPwd", (String)vdbName, (String)vdbVersion);
        String actualFileName = loadScript.getConnectionPropsFileName();
        InputStream connPropFileStream = loadScript.getConnectionPropsFileContents();
        this.helpSaveProps(actualFileName, connPropFileStream);
        this.checkProperties(actualFileName, expectedLoadScriptFileName);
        String expectedFileName = ScriptType.createScriptFileName((String)vdbName, (String)vdbVersion);
        TestRuntimeMetadataHelper.assertEquals((String)"Expected create script file names to be equal.", (String)expectedFileName, (String)loadScript.getCreateScriptFileName());
        this.checkFileContents("Expected create scripts to be equal.", (byte[])ddlFiles.get("MaterializationModel_Microsoft_SQL_Server_DDL.ddl"), ByteArrayHelper.toByteArray((InputStream)loadScript.getCreateScriptFile()));
    }

    public void testCreateMaterializedViewLoadPropertiesDB2() throws Exception {
        Map ddlFiles = this.setupMaterializationModelDDLFilesReal();
        this.fakeMaterializationModel.setDDLFiles(ddlFiles);
        String vdbName = "RiggaMaRoll";
        String vdbVersion = "33";
        String expectedLoadScriptFileName = ScriptType.connectionPropertyFileName((String)vdbName, (String)vdbVersion);
        MaterializationLoadScripts loadScript = RuntimeMetadataHelper.createMaterializedViewLoadProperties((ModelInfo)this.fakeMaterializationModel, (String)"jdbc:mmx:db2://slntds05:50000;DatabaseName=ds05;", (String)"com.metamatrix.jdbc.db2.DB2Driver", (String)"matUser", (String)"matPwd", (String)"mmHost1", (String)"12345", (String)"com.metamatrix.jdbc.MMDriver", (boolean)false, (String)"aMMUser", (String)"aMMPwd", (String)vdbName, (String)vdbVersion);
        String actualFileName = loadScript.getConnectionPropsFileName();
        InputStream connPropFileStream = loadScript.getConnectionPropsFileContents();
        this.helpSaveProps(actualFileName, connPropFileStream);
        this.checkProperties(actualFileName, expectedLoadScriptFileName);
        String expectedFileName = ScriptType.createScriptFileName((String)vdbName, (String)vdbVersion);
        TestRuntimeMetadataHelper.assertEquals((String)"Expected create script file names to be equal.", (String)expectedFileName, (String)loadScript.getCreateScriptFileName());
        this.checkFileContents("Expected create scripts to be equal.", (byte[])ddlFiles.get("MaterializationModel_IBM_DB2_7_x_DDL.ddl"), ByteArrayHelper.toByteArray((InputStream)loadScript.getCreateScriptFile()));
    }

    public void testCreateMaterializedViewLoadPropertiesMySQL() throws Exception {
        Map ddlFiles = this.setupMaterializationModelDDLFilesReal();
        this.fakeMaterializationModel.setDDLFiles(ddlFiles);
        String vdbName = "MySQL";
        String vdbVersion = "1";
        String expectedLoadScriptFileName = ScriptType.connectionPropertyFileName((String)vdbName, (String)vdbVersion);
        MaterializationLoadScripts loadScript = RuntimeMetadataHelper.createMaterializedViewLoadProperties((ModelInfo)this.fakeMaterializationModel, (String)"jdbc:mysql://slntds03:3306/rep_unit_test", (String)"com.mysql.jdbc.Driver", (String)"rep_unit_test", (String)"mm", (String)"mmHost1", (String)"12345", (String)"com.metamatrix.jdbc.MMDriver", (boolean)false, (String)"aMMUser", (String)"aMMPwd", (String)vdbName, (String)vdbVersion);
        String actualFileName = loadScript.getConnectionPropsFileName();
        InputStream connPropFileStream = loadScript.getConnectionPropsFileContents();
        this.helpSaveProps(actualFileName, connPropFileStream);
        this.checkProperties(actualFileName, expectedLoadScriptFileName);
        String expectedFileName = ScriptType.createScriptFileName((String)vdbName, (String)vdbVersion);
        TestRuntimeMetadataHelper.assertEquals((String)"Expected create script file names to be equal.", (String)expectedFileName, (String)loadScript.getCreateScriptFileName());
        this.checkFileContents("Expected create scripts to be equal.", (byte[])ddlFiles.get("MaterializationModel_MySQL_x_DDL.ddl"), ByteArrayHelper.toByteArray((InputStream)loadScript.getCreateScriptFile()));
    }

    private void assertCannonicalStringsMatch(String expected, String actual) {
        TestRuntimeMetadataHelper.assertEquals((String)expected.toUpperCase(), (String)actual.toUpperCase());
    }

    private void helpSaveProps(String actualFileName, InputStream connPropFileStream) throws IOException {
        File scratchFile = UnitTestUtil.getTestScratchFile((String)actualFileName);
        FileUtils.write((InputStream)connPropFileStream, (File)scratchFile);
    }

    private void checkProperties(String actualPropertyFileName, String expectedPropertyFileName) throws IOException {
        Properties actualProps = new Properties();
        actualProps.load(new FileInputStream(UnitTestUtil.getTestScratchPath() + "/" + actualPropertyFileName));
        Properties expectedProps = new Properties();
        expectedProps.load(new FileInputStream(UnitTestUtil.getTestDataPath() + "/materializedView/expected/" + expectedPropertyFileName));
        Set<Object> actualReadPropKeys = actualProps.keySet();
        Set<Object> expectedReadPropKeys = expectedProps.keySet();
        TestRuntimeMetadataHelper.assertEquals((String)"Number of properties differ in prop files: ", (int)expectedReadPropKeys.size(), (int)actualReadPropKeys.size());
        TestRuntimeMetadataHelper.assertTrue((String)"Expected props is missing some actual prop keys: ", (boolean)expectedReadPropKeys.containsAll(actualReadPropKeys));
        TestRuntimeMetadataHelper.assertTrue((String)"Actual props is missing some expecte prop keys: ", (boolean)actualReadPropKeys.containsAll(expectedReadPropKeys));
        HashMap<String, String> non_matchingProps = new HashMap<String, String>();
        for (String string : expectedReadPropKeys) {
            String actualPropValue;
            String expectedPropValue = expectedProps.getProperty(string);
            if (expectedPropValue.equals(actualPropValue = actualProps.getProperty(string))) continue;
            non_matchingProps.put(string, "<" + expectedPropValue + ">\n<" + actualPropValue + ">");
        }
        if (!non_matchingProps.isEmpty()) {
            StringBuffer buf = new StringBuffer();
            for (String name : non_matchingProps.keySet()) {
                buf.append('[');
                buf.append(name);
                buf.append(":\n");
                buf.append(non_matchingProps.get(name));
                buf.append("]\n\n");
            }
            TestRuntimeMetadataHelper.fail((String)("These prop values didn't match:\n[propName:\n<expected>\n<actual>]\n" + buf.toString()));
        }
    }

    private void checkFileContents(String string, byte[] expectedFileConts, byte[] actualFileContents) {
        String theExpected = new String(expectedFileConts);
        String theActual = new String(actualFileContents);
        TestRuntimeMetadataHelper.assertEquals((String)"Expected create scripts to be equal.", (String)theExpected, (String)theActual);
    }

    protected Map setupMaterializationModelDDLFilesReal() {
        HashMap<String, byte[]> ddlFileNamesToFiles = new HashMap<String, byte[]>();
        String scriptContents = "// " + DatabaseDialect.ORACLE + " truncate script";
        ddlFileNamesToFiles.put("Oracle_Truncate_materialized_PS.DDL", scriptContents.getBytes());
        scriptContents = "// " + DatabaseDialect.ORACLE + " swap script";
        ddlFileNamesToFiles.put("Oracle_Swap_materialized_PS.DDL", scriptContents.getBytes());
        scriptContents = "// " + DatabaseDialect.DB2 + " truncate script";
        ddlFileNamesToFiles.put("DB2_Truncate_materialized_PS.DDL", scriptContents.getBytes());
        scriptContents = "// " + DatabaseDialect.DB2 + " swap script";
        ddlFileNamesToFiles.put("DB2_Swap_materialized_PS.DDL", scriptContents.getBytes());
        scriptContents = "// " + DatabaseDialect.SQL_SERVER + " truncate script";
        ddlFileNamesToFiles.put("SqlServer_Truncate_materialized_PS.DDL", scriptContents.getBytes());
        scriptContents = "// " + DatabaseDialect.SQL_SERVER + " swap script";
        ddlFileNamesToFiles.put("SqlServer_Swap_materialized_PS.DDL", scriptContents.getBytes());
        scriptContents = "// " + DatabaseDialect.MYSQL + " truncate script";
        ddlFileNamesToFiles.put("MySQL_Truncate_materialized_PS.DDL", scriptContents.getBytes());
        scriptContents = "// " + DatabaseDialect.MYSQL + " swap script";
        ddlFileNamesToFiles.put("MySQL_Swap_materialized_PS.DDL", scriptContents.getBytes());
        scriptContents = "// MetaMatrix load script";
        ddlFileNamesToFiles.put("MetaMatrix_Load_materialized_PS.DDL", scriptContents.getBytes());
        scriptContents = "// Oracle create DDL script";
        ddlFileNamesToFiles.put("MaterializationModel_Oracle_8i_9i_DDL.ddl", scriptContents.getBytes());
        scriptContents = "// DB2 create DDL script";
        ddlFileNamesToFiles.put("MaterializationModel_IBM_DB2_7_x_DDL.ddl", scriptContents.getBytes());
        scriptContents = "// Generic create DDL script";
        ddlFileNamesToFiles.put("MaterializationModel_Passthrough__intermediate_XML_form_.ddl", scriptContents.getBytes());
        scriptContents = "// SQL Server create DDL script";
        ddlFileNamesToFiles.put("MaterializationModel_Microsoft_SQL_Server_DDL.ddl", scriptContents.getBytes());
        scriptContents = "// MySQL create DDL script";
        ddlFileNamesToFiles.put("MaterializationModel_MySQL_x_DDL.ddl", scriptContents.getBytes());
        return ddlFileNamesToFiles;
    }

    protected Map setupMaterializationModelDDLFiles() {
        HashMap<String, byte[]> ddlFileNamesToFiles = new HashMap<String, byte[]>();
        String scriptContents = "// " + DatabaseDialect.ORACLE + " truncate script";
        ddlFileNamesToFiles.put(DatabaseDialect.ORACLE + "_" + "Truncate", scriptContents.getBytes());
        scriptContents = "// " + DatabaseDialect.ORACLE + " swap script";
        ddlFileNamesToFiles.put(DatabaseDialect.ORACLE + "_" + "Swap", scriptContents.getBytes());
        scriptContents = "// " + DatabaseDialect.DB2 + " truncate script";
        ddlFileNamesToFiles.put(DatabaseDialect.DB2 + "_" + "Truncate", scriptContents.getBytes());
        scriptContents = "// " + DatabaseDialect.DB2 + " swap script";
        ddlFileNamesToFiles.put(DatabaseDialect.DB2 + "_" + "Swap", scriptContents.getBytes());
        scriptContents = "// " + DatabaseDialect.SQL_SERVER + " truncate script";
        ddlFileNamesToFiles.put(DatabaseDialect.SQL_SERVER + "_" + "Truncate", scriptContents.getBytes());
        scriptContents = "// " + DatabaseDialect.SQL_SERVER + " swap script";
        ddlFileNamesToFiles.put(DatabaseDialect.SQL_SERVER + "_" + "Swap", scriptContents.getBytes());
        scriptContents = "// " + DatabaseDialect.MYSQL + " truncate script";
        ddlFileNamesToFiles.put(DatabaseDialect.MYSQL + "_" + "Truncate", scriptContents.getBytes());
        scriptContents = "// " + DatabaseDialect.MYSQL + " swap script";
        ddlFileNamesToFiles.put(DatabaseDialect.MYSQL + "_" + "Swap", scriptContents.getBytes());
        scriptContents = "// MetaMatrix load script";
        ddlFileNamesToFiles.put("MetaMatrix_Load", scriptContents.getBytes());
        scriptContents = "// Oracle create DDL script";
        ddlFileNamesToFiles.put("MaterializationModel_Oracle_8i_9i_DDL.ddl", scriptContents.getBytes());
        scriptContents = "// DB2 create DDL script";
        ddlFileNamesToFiles.put("MaterializationModel_IBM_DB2_7_x_DDL.ddl", scriptContents.getBytes());
        scriptContents = "// Generic create DDL script";
        ddlFileNamesToFiles.put("MaterializationModel_Passthrough__intermediate_XML_form_.ddl", scriptContents.getBytes());
        scriptContents = "// SQL Serve create DDL script";
        ddlFileNamesToFiles.put("MaterializationModel_Microsoft_SQL_Server_DDL.ddl", scriptContents.getBytes());
        scriptContents = "// MySQL create DDL script";
        ddlFileNamesToFiles.put("MaterializationModel_MySQL_x_DDL.ddl", scriptContents.getBytes());
        return ddlFileNamesToFiles;
    }
}

