/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.server;

import com.metamatrix.admin.api.exception.AdminComponentException;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.exception.AdminProcessingException;
import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.admin.api.objects.AdminObject;
import com.metamatrix.admin.api.objects.AdminOptions;
import com.metamatrix.admin.api.objects.VDB;
import com.metamatrix.admin.objects.MMAdminObject;
import com.metamatrix.admin.objects.MMConnectorBinding;
import com.metamatrix.admin.objects.MMModel;
import com.metamatrix.admin.objects.MMPropertyDefinition;
import com.metamatrix.admin.objects.MMVDB;
import com.metamatrix.admin.server.AdminServerPlugin;
import com.metamatrix.admin.server.ServerAdminImpl;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.api.exception.security.AuthorizationMgmtException;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.extensionmodule.ExtensionModuleManager;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.metadata.runtime.RuntimeMetadataCatalog;
import com.metamatrix.metadata.runtime.api.Model;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseException;
import com.metamatrix.metadata.runtime.model.BasicVirtualDatabaseID;
import com.metamatrix.platform.admin.api.EntitlementMigrationReport;
import com.metamatrix.platform.admin.apiimpl.RuntimeStateAdminAPIHelper;
import com.metamatrix.platform.config.api.service.ConfigurationServiceInterface;
import com.metamatrix.platform.registry.ClusteredRegistryState;
import com.metamatrix.platform.security.api.AuthorizationPolicyFactory;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.security.api.service.AuthorizationServiceInterface;
import com.metamatrix.platform.security.api.service.MembershipServiceInterface;
import com.metamatrix.platform.security.api.service.SessionServiceInterface;
import com.metamatrix.platform.service.api.ServiceID;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.vm.api.controller.ProcessManagement;
import com.metamatrix.server.admin.apiimpl.RuntimeMetadataHelper;
import com.metamatrix.server.query.service.QueryServiceInterface;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.xml.sax.SAXException;

public class AbstractAdminImpl {
    private static final String DOUBLE_ESCAPED_DELIMITER = "\\" + AdminObject.ESCAPED_DELIMITER;
    protected ServerAdminImpl parent = null;
    private static String regexpAnyCharZeroOrMore = ".*";
    protected ClusteredRegistryState registry;

    public AbstractAdminImpl(ServerAdminImpl parent, ClusteredRegistryState registry) {
        this.parent = parent;
        this.registry = registry;
    }

    protected String getParent(String identifier) {
        return MMAdminObject.getParentName((String)identifier);
    }

    protected String getName(String identifier) {
        return MMAdminObject.getNameFromIdentifier((String)identifier);
    }

    protected String getUserName() {
        return DQPWorkContext.getWorkContext().getSessionToken().getUsername();
    }

    protected MetaMatrixSessionID getSessionID() {
        return DQPWorkContext.getWorkContext().getSessionToken().getSessionID();
    }

    protected SessionToken validateSession() {
        return DQPWorkContext.getWorkContext().getSessionToken();
    }

    protected void throwProcessingException(String key, Object[] objects) throws AdminException {
        throw new AdminProcessingException(AdminServerPlugin.Util.getString(key, objects));
    }

    protected void logDetail(String key, Object[] params) {
        String msg = AdminServerPlugin.Util.getString(key, params);
        LogManager.logDetail((String)"ADMIN", (Object[])new Object[]{msg});
    }

    protected synchronized SessionServiceInterface getSessionServiceProxy() throws ServiceException {
        return this.parent.getSessionServiceProxy();
    }

    protected synchronized MembershipServiceInterface getMembershipServiceProxy() throws ServiceException {
        return this.parent.getMembershipServiceProxy();
    }

    protected synchronized AuthorizationServiceInterface getAuthorizationServiceProxy() throws ServiceException {
        return this.parent.getAuthorizationServiceProxy();
    }

    protected synchronized ConfigurationServiceInterface getConfigurationServiceProxy() throws ServiceException {
        return this.parent.getConfigurationServiceProxy();
    }

    protected synchronized QueryServiceInterface getQueryServiceProxy() throws ServiceException {
        return this.parent.getQueryServiceProxy();
    }

    protected ExtensionModuleManager getExtensionSourceManager() {
        return this.parent.getExtensionSourceManager();
    }

    protected RuntimeStateAdminAPIHelper getRuntimeStateAdminAPIHelper() throws ServiceException {
        return this.parent.getRuntimeStateAdminAPIHelper();
    }

    public static boolean identifierMatches(String query, String[] identifierPartsArray) {
        String identifier = MMAdminObject.buildIdentifier((String[])identifierPartsArray);
        return AbstractAdminImpl.identifierMatches(query, identifier);
    }

    protected static boolean identifierMatches(String query, String identifier) {
        if ("*".equals(query)) {
            return true;
        }
        query = query.toUpperCase();
        identifier = identifier.toUpperCase();
        int firstWildcardIndex = query.indexOf("*");
        boolean matches = false;
        if (firstWildcardIndex >= 0) {
            String regExQuery = query.replaceAll(AdminObject.ESCAPED_DELIMITER, DOUBLE_ESCAPED_DELIMITER);
            regExQuery = regExQuery.replaceAll("\\*", regexpAnyCharZeroOrMore);
            matches = identifier.matches(regExQuery);
        } else {
            matches = identifier.equals(query);
        }
        return matches;
    }

    protected VDB convertToAdminVDB(VirtualDatabase virtualDatabase) throws AdminException {
        MMVDB vdb = null;
        String vdbName = virtualDatabase.getName();
        String vdbVersion = virtualDatabase.getVirtualDatabaseID().getVersion();
        String[] identifierParts = new String[]{vdbName, vdbVersion};
        try {
            ConfigurationModelContainer cmc = this.getConfigurationModel();
            vdb = new MMVDB(identifierParts);
            vdb.setCreated(virtualDatabase.getCreationDate());
            vdb.setCreatedBy(virtualDatabase.getCreatedBy());
            vdb.setLastUpdated(virtualDatabase.getUpdateDate());
            vdb.setLastUpdatedBy(virtualDatabase.getUpdatedBy());
            vdb.setProperties(virtualDatabase.getProperties());
            vdb.setStatus(virtualDatabase.getStatus());
            vdb.setUID(((BasicVirtualDatabaseID)virtualDatabase.getVirtualDatabaseID()).getUID());
            vdb.setVersionedBy(virtualDatabase.getVersionBy());
            vdb.setVersionedDate(virtualDatabase.getVersionDate());
            vdb.setHasWSDL(virtualDatabase.hasWSDLDefined());
            Collection modelObjects = RuntimeMetadataCatalog.getInstance().getModels(virtualDatabase.getVirtualDatabaseID());
            for (Model modelObject : modelObjects) {
                String modelName = modelObject.getName();
                String[] modelIdentifierParts = new String[]{vdbName, modelName};
                MMModel model = new MMModel(modelIdentifierParts);
                model.setConnectorBindingNames(this.getConnectorBindingNamesFromUUIDs(modelObject.getConnectorBindingNames(), cmc));
                model.setMaterialization(modelObject.isMaterialization());
                if (modelObject.isMaterialization()) {
                    vdb.setMaterializedViews(true);
                }
                model.setModelType(modelObject.getModelTypeName());
                model.setModelURI(modelObject.getModelURI());
                model.setPhysical(modelObject.isPhysical());
                model.setProperties(modelObject.getProperties());
                model.setSupportsMultiSourceBindings(modelObject.supportsMultiSourceBindings());
                model.setVisible(modelObject.isVisible());
                vdb.addModel(model);
            }
        }
        catch (VirtualDatabaseException e) {
            throw new AdminProcessingException((Throwable)e);
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        return vdb;
    }

    protected List getVDBs(String identifier, Collection virtualDatabases) throws AdminException {
        ArrayList<VDB> results = new ArrayList<VDB>(virtualDatabases.size());
        if (identifier.indexOf(124) < 0 && identifier.indexOf("*") < 0) {
            identifier = identifier.concat("|*");
        }
        for (VirtualDatabase virtualDatabase : virtualDatabases) {
            String vdbVersion;
            String vdbName = virtualDatabase.getName();
            String[] identifierParts = new String[]{vdbName, vdbVersion = virtualDatabase.getVirtualDatabaseID().getVersion()};
            if (!AbstractAdminImpl.identifierMatches(identifier, identifierParts)) continue;
            VDB vdb = this.convertToAdminVDB(virtualDatabase);
            results.add(vdb);
        }
        Collections.sort(results);
        return results;
    }

    protected String getConnectorBindingNameFromUUID(String uuid) throws ConfigurationException {
        Configuration config = this.getConfigurationServiceProxy().getCurrentConfiguration();
        ConnectorBinding cb = config.getConnectorBindingByRoutingID(uuid);
        if (cb != null) {
            return cb.getName();
        }
        return null;
    }

    protected List getConnectorBindingNamesFromUUIDs(List uuids, ConfigurationModelContainer configModel) {
        ArrayList<String> results = new ArrayList<String>(uuids.size());
        for (String uuid : uuids) {
            ConnectorBinding cb = configModel.getConfiguration().getConnectorBindingByRoutingID(uuid);
            if (cb == null) continue;
            results.add(cb.getName());
        }
        return results;
    }

    protected List getConnectorBindingNamesFromUUIDs(List uuids) throws ConfigurationException, ServiceException {
        ConfigurationModelContainer cmc = this.getConfigurationModel();
        return this.getConnectorBindingNamesFromUUIDs(uuids, cmc);
    }

    protected Map getConnectorBindingNamesMapFromUUIDs(Collection uuids) throws ConfigurationException {
        Configuration config = this.getConfigurationServiceProxy().getCurrentConfiguration();
        HashMap<String, String> uuidMap = new HashMap<String, String>(uuids.size());
        for (String uuid : uuids) {
            ConnectorBinding cb = config.getConnectorBindingByRoutingID(uuid);
            if (cb == null) continue;
            uuidMap.put(uuid, cb.getName());
        }
        return uuidMap;
    }

    protected void shutDownConnectorBinding(MMConnectorBinding binding, boolean stopNow) throws AdminException {
        ServiceID serviceID = new ServiceID(binding.getServiceID(), binding.getHostName(), binding.getProcessName());
        try {
            ProcessManagement vmController = this.getProcessController(serviceID.getHostName(), serviceID.getProcessName());
            vmController.stopService(serviceID, stopNow, true);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    private ProcessManagement getProcessController(String hostName, String processName) throws MetaMatrixComponentException {
        return this.registry.getProcessBinding(hostName, processName).getProcessController();
    }

    protected Collection convertPropertyDefinitions(ComponentObject component) throws ConfigurationException {
        ComponentType ctype = this.getConfigurationServiceProxy().getComponentType(component.getComponentTypeID());
        Properties properties = component.getProperties();
        return this.convertPropertyDefinitions(ctype, properties);
    }

    protected Collection convertPropertyDefinitions(ComponentObject component, Properties properties) throws ConfigurationException {
        ComponentType ctype = this.getConfigurationServiceProxy().getComponentType(component.getComponentTypeID());
        return this.convertPropertyDefinitions(ctype, properties);
    }

    protected Collection convertPropertyDefinitions(ComponentType ctype, Properties properties) {
        ArrayList<MMPropertyDefinition> results = new ArrayList<MMPropertyDefinition>();
        for (ComponentTypeDefn cdefn : ctype.getComponentTypeDefinitions()) {
            PropertyDefinition pdefn = cdefn.getPropertyDefinition();
            MMPropertyDefinition result = new MMPropertyDefinition(new String[]{pdefn.getName()});
            result.setAllowedValues((Collection)pdefn.getAllowedValues());
            result.setConstrainedToAllowedValues(pdefn.isConstrainedToAllowedValues());
            result.setDefaultValue(pdefn.getDefaultValue());
            result.setDescription(pdefn.getShortDescription());
            result.setDisplayName(pdefn.getDisplayName());
            result.setExpert(pdefn.isExpert());
            result.setHidden(pdefn.isHidden());
            result.setMasked(pdefn.isMasked());
            result.setMinimumMultiplicity(pdefn.getMultiplicity().getMinimum());
            result.setMaximumMultiplicity(pdefn.getMultiplicity().getMaximum());
            result.setModifiable(pdefn.isModifiable());
            result.setPreferred(pdefn.isPreferred());
            result.setPropertyType(pdefn.getPropertyType().getDisplayName());
            result.setPropertyTypeClassName(pdefn.getPropertyType().getClassName());
            result.setRequired(pdefn.isRequired());
            result.setRequiresRestart(pdefn.getRequiresRestart());
            result.setValueDelimiter(pdefn.getValueDelimiter());
            String value = properties.getProperty(pdefn.getName());
            result.setValue(value);
            results.add(result);
        }
        return results;
    }

    protected Collection getAdminObjects(String identifier, String className) throws AdminException {
        int code = MMAdminObject.getObjectType((String)className);
        ArrayList<Object> list = null;
        switch (code) {
            case 0: {
                return this.parent.getCaches(identifier);
            }
            case 2: {
                return this.parent.getConnectorBindings(identifier);
            }
            case 3: {
                return this.parent.getConnectorTypes(identifier);
            }
            case 4: {
                return this.parent.getDQPs(identifier);
            }
            case 6: {
                return this.parent.getExtensionModules(identifier);
            }
            case 7: {
                return this.parent.getGroups(identifier);
            }
            case 8: {
                return this.parent.getHosts(identifier);
            }
            case 9: {
                list = new ArrayList<Object>();
                list.add(this.parent.getLogConfiguration());
                return list;
            }
            case 11: {
                return this.parent.getProcesses(identifier);
            }
            case 13: {
                return this.parent.getQueueWorkerPools(identifier);
            }
            case 14: {
                return this.parent.getRequests(identifier);
            }
            case 15: {
                return this.parent.getResources(identifier);
            }
            case 17: {
                return this.parent.getSessions(identifier);
            }
            case 18: {
                return this.parent.getSourceRequests(identifier);
            }
            case 19: {
                list = new ArrayList();
                list.add(this.parent.getSystem());
                return list;
            }
            case 21: {
                return this.parent.getVDBs(identifier);
            }
        }
        this.throwProcessingException("AbstractAdminImpl.Unsupported_Admin_Object", new Object[]{className});
        return Collections.EMPTY_LIST;
    }

    protected ConfigurationModelContainer getConfigurationModel() throws ConfigurationException {
        return this.getConfigurationServiceProxy().getConfigurationModel("Next Startup");
    }

    String importDataRoles(String vdbName, String vdbVersion, char[] xmlContents, AdminOptions options) throws AdminException {
        try {
            Collection roles = AuthorizationPolicyFactory.buildPolicies((String)vdbName, (String)vdbVersion, (char[])xmlContents);
            SessionToken session = this.validateSession();
            EntitlementMigrationReport rpt = new EntitlementMigrationReport("from file", vdbName + " " + vdbVersion);
            HashSet allPaths = new HashSet(RuntimeMetadataHelper.getAllDataNodeNames(vdbName, vdbVersion, new HashMap()));
            this.getAuthorizationServiceProxy().migratePolicies(session, rpt, vdbName, vdbVersion, allPaths, roles, options);
            return rpt.toString();
        }
        catch (InvalidSessionException e) {
            throw new AdminProcessingException((Throwable)e);
        }
        catch (AuthorizationException e) {
            throw new AdminProcessingException((Throwable)e);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (SAXException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (IOException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    char[] exportDataRoles(String vdbName, String vdbVersion) throws AdminException {
        Collection roles = null;
        try {
            roles = this.getAuthorizationServiceProxy().getPoliciesInRealm(this.validateSession(), new AuthorizationRealm(vdbName, vdbVersion));
            if (roles != null && !roles.isEmpty()) {
                return AuthorizationPolicyFactory.exportPolicies((Collection)roles);
            }
            return null;
        }
        catch (AuthorizationMgmtException e) {
            throw new AdminProcessingException((Throwable)e);
        }
        catch (AuthorizationException e) {
            throw new AdminProcessingException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
        catch (IOException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }
}

