/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.server;

import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.objects.AdminOptions;
import com.metamatrix.admin.api.objects.ConnectorBinding;
import com.metamatrix.admin.api.objects.LogConfiguration;
import com.metamatrix.admin.api.objects.ScriptsContainer;
import com.metamatrix.admin.api.objects.SystemObject;
import com.metamatrix.admin.api.objects.VDB;
import com.metamatrix.admin.api.server.ServerAdmin;
import com.metamatrix.admin.server.ServerConfigAdminImpl;
import com.metamatrix.admin.server.ServerMonitoringAdminImpl;
import com.metamatrix.admin.server.ServerRuntimeStateAdminImpl;
import com.metamatrix.admin.server.ServerSecurityAdminImpl;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.extensionmodule.ExtensionModuleManager;
import com.metamatrix.platform.admin.apiimpl.RuntimeStateAdminAPIHelper;
import com.metamatrix.platform.config.api.service.ConfigurationServiceInterface;
import com.metamatrix.platform.registry.ClusteredRegistryState;
import com.metamatrix.platform.registry.ServiceRegistryBinding;
import com.metamatrix.platform.security.api.service.AuthorizationServiceInterface;
import com.metamatrix.platform.security.api.service.MembershipServiceInterface;
import com.metamatrix.platform.security.api.service.SessionServiceInterface;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.util.PlatformProxyHelper;
import com.metamatrix.server.HostManagement;
import com.metamatrix.server.query.service.QueryServiceInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;

public class ServerAdminImpl
implements ServerAdmin {
    private ServerRuntimeStateAdminImpl runtime = null;
    private ServerConfigAdminImpl config = null;
    private ServerMonitoringAdminImpl monitoring = null;
    private ServerSecurityAdminImpl security = null;
    private SessionServiceInterface sessionServiceProxy = null;
    private ConfigurationServiceInterface configurationServiceProxy = null;
    private MembershipServiceInterface membershipServiceProxy = null;
    private AuthorizationServiceInterface authorizationServiceProxy = null;
    private QueryServiceInterface queryServiceProxy = null;
    private ExtensionModuleManager extensionModuleManager = null;
    private RuntimeStateAdminAPIHelper runtimeStateAdminAPIHelper = null;
    protected static final int SERVICE_WAIT_INTERVAL = 500;
    ClusteredRegistryState registry;
    HostManagement hostManagement;

    public ServerAdminImpl(ClusteredRegistryState registry, HostManagement hostManagement) {
        this.registry = registry;
        this.hostManagement = hostManagement;
    }

    public void addAuthorizationProvider(String domainprovidername, String providertypename, Properties properties) throws AdminException {
        this.getConfigurationAdmin().addAuthorizationProvider(domainprovidername, providertypename, properties);
    }

    public Collection getCaches(String identifier) throws AdminException {
        return this.getMonitoringAdmin().getCaches(identifier);
    }

    public Collection getConnectorBindings(String identifier) throws AdminException {
        return this.getMonitoringAdmin().getConnectorBindings(identifier);
    }

    public Collection getConnectorBindingsInVDB(String identifier) throws AdminException {
        return this.getMonitoringAdmin().getConnectorBindingsInVDB(identifier);
    }

    public Collection getConnectorTypes(String identifier) throws AdminException {
        return this.getMonitoringAdmin().getConnectorTypes(identifier);
    }

    public Collection getDQPs(String identifier) throws AdminException {
        return this.getMonitoringAdmin().getDQPs(identifier);
    }

    public Collection getExtensionModules(String identifier) throws AdminException {
        return this.getMonitoringAdmin().getExtensionModules(identifier);
    }

    public Collection getHosts(String identifier) throws AdminException {
        return this.getMonitoringAdmin().getHosts(identifier);
    }

    public Collection getProcesses(String identifier) throws AdminException {
        return this.getMonitoringAdmin().getProcesses(identifier);
    }

    public Collection getQueueWorkerPools(String identifier) throws AdminException {
        return this.getMonitoringAdmin().getQueueWorkerPools(identifier);
    }

    public Collection getRequests(String identifier) throws AdminException {
        return this.getMonitoringAdmin().getRequests(identifier);
    }

    public Collection getResources(String identifier) throws AdminException {
        return this.getMonitoringAdmin().getResources(identifier);
    }

    public Collection getSessions(String identifier) throws AdminException {
        return this.getMonitoringAdmin().getSessions(identifier);
    }

    public Collection getSourceRequests(String identifier) throws AdminException {
        return this.getMonitoringAdmin().getSourceRequests(identifier);
    }

    public SystemObject getSystem() throws AdminException {
        return this.getMonitoringAdmin().getSystem();
    }

    public Collection getVDBs(String identifier) throws AdminException {
        return this.getMonitoringAdmin().getVDBs(identifier);
    }

    public Collection getPropertyDefinitions(String identifier, String className) throws AdminException {
        return this.getMonitoringAdmin().getPropertyDefinitions(identifier, className);
    }

    public byte[] exportLogs() throws AdminException {
        return this.getMonitoringAdmin().exportLogs();
    }

    public ConnectorBinding addConnectorBinding(String connectorBindingIdentifier, String connectorTypeIdentifier, Properties props, AdminOptions options) throws AdminException {
        return this.getConfigurationAdmin().addConnectorBinding(connectorBindingIdentifier, connectorTypeIdentifier, props, options);
    }

    public ConnectorBinding addConnectorBinding(String name, char[] xmlFile, AdminOptions options) throws AdminException {
        return this.getConfigurationAdmin().addConnectorBinding(name, xmlFile, options);
    }

    public void addConnectorType(String name, char[] cdkFile) throws AdminException {
        this.getConfigurationAdmin().addConnectorType(name, cdkFile);
    }

    public void addConnectorArchive(byte[] archiveContents, AdminOptions options) throws AdminException {
        this.getConfigurationAdmin().addConnectorArchive(archiveContents, options);
    }

    public void addExtensionModule(String type, String sourceName, byte[] source, String description) throws AdminException {
        this.getConfigurationAdmin().addExtensionModule(type, sourceName, source, description);
    }

    public void addHost(String hostName, Properties properties) throws AdminException {
        this.getConfigurationAdmin().addHost(hostName, properties);
    }

    public void addProcess(String processIdentifier, Properties properties) throws AdminException {
        this.getConfigurationAdmin().addProcess(processIdentifier, properties);
    }

    public VDB addVDB(String name, byte[] vdbFile, AdminOptions options) throws AdminException {
        return this.getConfigurationAdmin().addVDB(name, vdbFile, options);
    }

    public void changeVDBStatus(String name, String version, int status) throws AdminException {
        this.getRuntimeAdmin().changeVDBStatus(name, version, status);
    }

    public void disableHost(String identifier) throws AdminException {
        this.getConfigurationAdmin().disableHost(identifier);
    }

    public void disableProcess(String identifier) throws AdminException {
        this.getConfigurationAdmin().disableProcess(identifier);
    }

    public void enableHost(String identifier) throws AdminException {
        this.getConfigurationAdmin().enableHost(identifier);
    }

    public void enableProcess(String identifier) throws AdminException {
        this.getConfigurationAdmin().enableProcess(identifier);
    }

    public LogConfiguration getLogConfiguration() throws AdminException {
        return this.getConfigurationAdmin().getLogConfiguration();
    }

    public void setLogConfiguration(LogConfiguration config) throws AdminException {
        this.getConfigurationAdmin().setLogConfiguration(config);
    }

    public void setSystemProperty(String property, String value) throws AdminException {
        this.getConfigurationAdmin().setSystemProperty(property, value);
    }

    public void updateSystemProperties(Properties properties) throws AdminException {
        this.getConfigurationAdmin().updateSystemProperties(properties);
    }

    public void cancelRequest(String identifier) throws AdminException {
        this.getRuntimeAdmin().cancelRequest(identifier);
    }

    public void cancelSourceRequest(String identifier) throws AdminException {
        this.getRuntimeAdmin().cancelSourceRequest(identifier);
    }

    public void startConnectorBinding(String connectorBindingIdentifier) throws AdminException {
        this.getRuntimeAdmin().startConnectorBinding(connectorBindingIdentifier);
    }

    public void startHost(String hostName, boolean waitUntilDone) throws AdminException {
        this.getRuntimeAdmin().startHost(hostName, waitUntilDone);
    }

    public void stopConnectorBinding(String connectorBindingIdentifier, boolean stopNow) throws AdminException {
        this.getRuntimeAdmin().stopConnectorBinding(connectorBindingIdentifier, stopNow);
    }

    public void stopHost(String hostName, boolean stopNow, boolean waitUntilDone) throws AdminException {
        this.getRuntimeAdmin().stopHost(hostName, stopNow, waitUntilDone);
    }

    public void stopProcess(String identifier, boolean stopNow, boolean waitUntilDone) throws AdminException {
        this.getRuntimeAdmin().stopProcess(identifier, stopNow, waitUntilDone);
    }

    public void startProcess(String identifier, boolean waitUntilDone) throws AdminException {
        this.getRuntimeAdmin().startProcess(identifier, waitUntilDone);
    }

    public void stopSystem() throws AdminException {
        this.getRuntimeAdmin().stopSystem();
    }

    public void bounceSystem(boolean waitUntilDone) throws AdminException {
        this.getRuntimeAdmin().bounceSystem(waitUntilDone);
    }

    public void synchronizeSystem(boolean waitUntilDone) throws AdminException {
        this.getRuntimeAdmin().synchronizeSystem(waitUntilDone);
    }

    public void terminateSession(String identifier) throws AdminException {
        this.getRuntimeAdmin().terminateSession(identifier);
    }

    public void clearCache(String cacheIdentifier) throws AdminException {
        this.getRuntimeAdmin().clearCache(cacheIdentifier);
    }

    public void setProperty(String identifier, String className, String propertyName, String propertyValue) throws AdminException {
        this.getConfigurationAdmin().setProperty(identifier, className, propertyName, propertyValue);
    }

    public void updateProperties(String identifier, String className, Properties properties) throws AdminException {
        this.getConfigurationAdmin().updateProperties(identifier, className, properties);
    }

    public void deleteConnectorBinding(String connectorBindingIdentifier) throws AdminException {
        this.getConfigurationAdmin().deleteConnectorBinding(connectorBindingIdentifier);
    }

    public void deleteConnectorType(String name) throws AdminException {
        this.getConfigurationAdmin().deleteConnectorType(name);
    }

    public void deleteExtensionModule(String sourceName) throws AdminException {
        this.getConfigurationAdmin().deleteExtensionModule(sourceName);
    }

    public void deleteHost(String identifier) throws AdminException {
        this.getConfigurationAdmin().deleteHost(identifier);
    }

    public void deleteProcess(String identifier) throws AdminException {
        this.getConfigurationAdmin().deleteProcess(identifier);
    }

    private synchronized ServerRuntimeStateAdminImpl getRuntimeAdmin() {
        if (this.runtime == null) {
            this.runtime = new ServerRuntimeStateAdminImpl(this, this.registry);
        }
        return this.runtime;
    }

    private synchronized ServerConfigAdminImpl getConfigurationAdmin() {
        if (this.config == null) {
            this.config = new ServerConfigAdminImpl(this, this.registry);
        }
        return this.config;
    }

    private synchronized ServerMonitoringAdminImpl getMonitoringAdmin() {
        if (this.monitoring == null) {
            this.monitoring = new ServerMonitoringAdminImpl(this, this.registry);
        }
        return this.monitoring;
    }

    private synchronized ServerSecurityAdminImpl getSecurityAdmin() {
        if (this.security == null) {
            this.security = new ServerSecurityAdminImpl(this, this.registry);
        }
        return this.security;
    }

    protected synchronized SessionServiceInterface getSessionServiceProxy() throws ServiceException {
        if (this.sessionServiceProxy == null) {
            this.sessionServiceProxy = PlatformProxyHelper.getSessionServiceProxy("ROUND_ROBIN_LOCAL");
        }
        return this.sessionServiceProxy;
    }

    protected synchronized ConfigurationServiceInterface getConfigurationServiceProxy() throws ServiceException {
        if (this.configurationServiceProxy == null) {
            this.configurationServiceProxy = PlatformProxyHelper.getConfigurationServiceProxy("ROUND_ROBIN_LOCAL");
        }
        return this.configurationServiceProxy;
    }

    protected synchronized MembershipServiceInterface getMembershipServiceProxy() throws ServiceException {
        if (this.membershipServiceProxy == null) {
            this.membershipServiceProxy = PlatformProxyHelper.getMembershipServiceProxy("ROUND_ROBIN_LOCAL");
        }
        return this.membershipServiceProxy;
    }

    protected synchronized AuthorizationServiceInterface getAuthorizationServiceProxy() throws ServiceException {
        if (this.authorizationServiceProxy == null) {
            this.authorizationServiceProxy = PlatformProxyHelper.getAuthorizationServiceProxy("ROUND_ROBIN_LOCAL");
        }
        return this.authorizationServiceProxy;
    }

    protected synchronized QueryServiceInterface getQueryServiceProxy() throws ServiceException {
        if (this.queryServiceProxy == null) {
            this.queryServiceProxy = PlatformProxyHelper.getQueryServiceProxy("ROUND_ROBIN_LOCAL");
        }
        return this.queryServiceProxy;
    }

    protected ExtensionModuleManager getExtensionSourceManager() {
        if (this.extensionModuleManager == null) {
            this.extensionModuleManager = ExtensionModuleManager.getInstance();
        }
        return this.extensionModuleManager;
    }

    protected RuntimeStateAdminAPIHelper getRuntimeStateAdminAPIHelper() {
        if (this.runtimeStateAdminAPIHelper == null) {
            this.runtimeStateAdminAPIHelper = RuntimeStateAdminAPIHelper.getInstance(this.registry, this.hostManagement);
        }
        return this.runtimeStateAdminAPIHelper;
    }

    public Collection getRolesForUser(String userIdentifier) throws AdminException {
        return this.getSecurityAdmin().getRolesForUser(userIdentifier);
    }

    public Collection getGroupsForUser(String userIdentifier) throws AdminException {
        return this.getSecurityAdmin().getGroupsForUser(userIdentifier);
    }

    public Collection getGroups(String groupIdentifier) throws AdminException {
        return this.getSecurityAdmin().getGroups(groupIdentifier);
    }

    public Collection getRolesForGroup(String groupIdentifier) throws AdminException {
        return this.getSecurityAdmin().getRolesForGroup(groupIdentifier);
    }

    public void assignBindingToModel(String connectorBindingName, String vdbName, String vdbVersion, String modelName) throws AdminException {
        this.getConfigurationAdmin().assignBindingToModel(connectorBindingName, vdbName, vdbVersion, modelName);
    }

    public void deassignBindingFromModel(String connectorBindingName, String vdbName, String vdbVersion, String modelName) throws AdminException {
        this.getConfigurationAdmin().deassignBindingFromModel(connectorBindingName, vdbName, vdbVersion, modelName);
    }

    public void assignBindingsToModel(String[] connectorBindingNames, String vdbName, String vdbVersion, String modelName) throws AdminException {
        this.getConfigurationAdmin().assignBindingsToModel(connectorBindingNames, vdbName, vdbVersion, modelName);
    }

    public void deassignBindingsFromModel(String[] connectorBindingNames, String vdbName, String vdbVersion, String modelName) throws AdminException {
        this.getConfigurationAdmin().deassignBindingsFromModel(connectorBindingNames, vdbName, vdbVersion, modelName);
    }

    public String importDataRoles(String vdbName, String vdbVersion, char[] data, AdminOptions options) throws AdminException {
        return this.getSecurityAdmin().importDataRoles(vdbName, vdbVersion, data, options);
    }

    public char[] exportDataRoles(String vdbName, String vdbVersion) throws AdminException {
        return this.getSecurityAdmin().exportDataRoles(vdbName, vdbVersion);
    }

    public char[] exportConfiguration() throws AdminException {
        return this.getConfigurationAdmin().exportConfiguration();
    }

    public void importConfiguration(char[] fileData) throws AdminException {
        this.getConfigurationAdmin().importConfiguration(fileData);
    }

    public char[] exportConnectorBinding(String connectorBindingIdentifier) throws AdminException {
        return this.getConfigurationAdmin().exportConnectorBinding(connectorBindingIdentifier);
    }

    public char[] exportConnectorType(String connectorTypeIdentifier) throws AdminException {
        return this.getConfigurationAdmin().exportConnectorType(connectorTypeIdentifier);
    }

    public byte[] exportConnectorArchive(String connectorTypeIdentifier) throws AdminException {
        return this.getConfigurationAdmin().exportConnectorArchive(connectorTypeIdentifier);
    }

    public byte[] exportExtensionModule(String sourceName) throws AdminException {
        return this.getConfigurationAdmin().exportExtensionModule(sourceName);
    }

    public byte[] exportVDB(String name, String version) throws AdminException {
        return this.getConfigurationAdmin().exportVDB(name, version);
    }

    public void assignRoleToGroup(String roleIdentifier, String groupIdentifier) throws AdminException {
        this.getSecurityAdmin().assignRoleToGroup(roleIdentifier, groupIdentifier);
    }

    public void removeRoleFromGroup(String roleIdentifier, String grouplIdentifier) throws AdminException {
        this.getSecurityAdmin().removeRoleFromGroup(roleIdentifier, grouplIdentifier);
    }

    public void close() {
    }

    protected void waitForServicesToStart(Collection expectedServiceNames) throws MetaMatrixComponentException {
        boolean done = false;
        while (!done) {
            done = this.areServicesAttempted(expectedServiceNames);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void waitForServicesToStop(Collection expectedServiceNames) throws MetaMatrixComponentException {
        boolean done = false;
        while (!done) {
            done = this.areServicesStopped(expectedServiceNames);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean areServicesStopped(Collection expectedServiceNames) throws MetaMatrixComponentException {
        List<ServiceRegistryBinding> services = this.getRuntimeStateAdminAPIHelper().getServices();
        for (ServiceRegistryBinding serviceBinding : services) {
            int state;
            boolean stopped;
            DeployedComponent deployedComponent = serviceBinding.getDeployedComponent();
            if (!expectedServiceNames.contains(deployedComponent.getID().getFullName()) || (stopped = this.isStateStopped(state = serviceBinding.getCurrentState()))) continue;
            return false;
        }
        return true;
    }

    private boolean areServicesAttempted(Collection expectedServiceNames) throws MetaMatrixComponentException {
        ArrayList<String> attemptedServiceNames = new ArrayList<String>();
        ArrayList<String> notAttemptedServiceNames = new ArrayList<String>();
        List<ServiceRegistryBinding> services = this.getRuntimeStateAdminAPIHelper().getServices();
        for (ServiceRegistryBinding serviceBinding : services) {
            DeployedComponent deployedComponent = serviceBinding.getDeployedComponent();
            int state = serviceBinding.getCurrentState();
            boolean attempted = this.isStateAttempted(state);
            if (attempted) {
                attemptedServiceNames.add(deployedComponent.getID().getFullName());
                continue;
            }
            notAttemptedServiceNames.add(deployedComponent.getID().getFullName());
        }
        if (notAttemptedServiceNames.size() > 0) {
            return false;
        }
        return attemptedServiceNames.containsAll(expectedServiceNames);
    }

    private boolean isStateStopped(int state) {
        return state != 1 && state != 6;
    }

    private boolean isStateAttempted(int state) {
        return state == 1 || state == 3 || state == 4 || state == 6;
    }

    public ScriptsContainer generateMaterializationScripts(String vdbName, String vdbVersion, String metamatrixUserName, String metamatrixUserPwd, String materializationUserName, String materializationUserPwd) throws AdminException {
        return this.getConfigurationAdmin().generateMaterializationScripts(vdbName, vdbVersion, metamatrixUserName, metamatrixUserPwd, materializationUserName, materializationUserPwd);
    }

    public void addUDF(byte[] modelFileContents, String classpath) throws AdminException {
        this.getConfigurationAdmin().addUDF(modelFileContents, classpath);
    }

    public void deleteUDF() throws AdminException {
        this.getConfigurationAdmin().deleteUDF();
    }

    public Properties getBootstrapProperties() throws AdminException {
        return this.getConfigurationAdmin().getBootstrapProperties();
    }

    public byte[] getClusterKey() throws AdminException {
        return this.getConfigurationAdmin().getClusterKey();
    }
}

