/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.server;

import com.metamatrix.admin.AdminPlugin;
import com.metamatrix.admin.api.exception.AdminComponentException;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.exception.AdminProcessingException;
import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.admin.api.objects.AdminObject;
import com.metamatrix.admin.api.objects.AdminOptions;
import com.metamatrix.admin.api.objects.AdminStatus;
import com.metamatrix.admin.api.objects.Host;
import com.metamatrix.admin.api.objects.LogConfiguration;
import com.metamatrix.admin.api.objects.ProcessObject;
import com.metamatrix.admin.api.objects.ScriptsContainer;
import com.metamatrix.admin.api.objects.VDB;
import com.metamatrix.admin.api.server.ServerConfigAdmin;
import com.metamatrix.admin.objects.MMAdminObject;
import com.metamatrix.admin.objects.MMAdminStatus;
import com.metamatrix.admin.objects.MMConnectorBinding;
import com.metamatrix.admin.objects.MMLogConfiguration;
import com.metamatrix.admin.objects.MMScriptsContainer;
import com.metamatrix.admin.server.AbstractAdminImpl;
import com.metamatrix.admin.server.AdminServerPlugin;
import com.metamatrix.admin.server.ServerAdminImpl;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.common.actions.ModificationActionQueue;
import com.metamatrix.common.actions.ModificationException;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.AuthenticationProvider;
import com.metamatrix.common.config.api.ComponentDefnID;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorArchive;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ConnectorBindingType;
import com.metamatrix.common.config.api.ExtensionModule;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.api.exceptions.ConfigurationLockException;
import com.metamatrix.common.config.api.exceptions.InvalidConfigurationException;
import com.metamatrix.common.config.model.BasicConfigurationObjectEditor;
import com.metamatrix.common.config.model.BasicConnectorArchive;
import com.metamatrix.common.config.model.BasicExtensionModule;
import com.metamatrix.common.config.model.ConfigurationModelContainerAdapter;
import com.metamatrix.common.config.util.ConfigObjectsNotResolvableException;
import com.metamatrix.common.config.util.InvalidConfigurationElementException;
import com.metamatrix.common.config.xml.XMLConfigurationImportExportUtility;
import com.metamatrix.common.extensionmodule.ExtensionModuleDescriptor;
import com.metamatrix.common.extensionmodule.exception.DuplicateExtensionModuleException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleNotFoundException;
import com.metamatrix.common.extensionmodule.exception.InvalidExtensionModuleTypeException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.net.ServerSocketConfiguration;
import com.metamatrix.common.util.LogContextsUtil;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.common.util.crypto.Cryptor;
import com.metamatrix.common.util.crypto.cipher.SymmetricCryptor;
import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.common.vdb.api.VDBArchive;
import com.metamatrix.core.util.ObjectConverterUtil;
import com.metamatrix.metadata.runtime.RuntimeMetadataCatalog;
import com.metamatrix.metadata.runtime.api.Model;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseException;
import com.metamatrix.metadata.runtime.vdb.defn.VDBDefnFactory;
import com.metamatrix.metadata.runtime.vdb.defn.VDBDefnImport;
import com.metamatrix.platform.registry.ClusteredRegistryState;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.server.admin.apiimpl.MaterializationLoadScriptsImpl;
import com.metamatrix.server.admin.apiimpl.RuntimeMetadataHelper;
import com.metamatrix.vdb.runtime.BasicVDBDefn;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class ServerConfigAdminImpl
extends AbstractAdminImpl
implements ServerConfigAdmin {
    private static final String CONNECTION_PROPERTY_DRIVER = "Driver";
    private static final String CONNECTION_PROPERTY_PASSWORD = "Password";
    private static final String CONNECTION_PROPERTY_USER = "User";
    private static final String CONNECTION_PROPERTY_URL = "URL";
    private static String METAMATRIXPROCESS_PSC = "MMProcessPSC";
    private static String PLATFORM_STANDARD_PSC = "PlatformStandard";
    private static String QUERY_ENGINE_PSC = "QueryEngine";
    private static String FUNCTION_DEFINITIONS_MODEL = "FunctionDefinitions.xmi";

    public ServerConfigAdminImpl(ServerAdminImpl parent, ClusteredRegistryState registry) {
        super(parent, registry);
    }

    public com.metamatrix.admin.api.objects.ConnectorBinding addConnectorBinding(String connectorBindingName, String connectorTypeIdentifier, Properties properties, AdminOptions options) throws AdminException {
        com.metamatrix.admin.api.objects.ConnectorBinding newBinding = null;
        if (connectorBindingName == null) {
            throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerConfigAdminImpl.Name_can_not_be_null"));
        }
        if (connectorTypeIdentifier == null) {
            throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerConfigAdminImpl.Connector_Type_can_not_be_null"));
        }
        if (properties == null) {
            throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerConfigAdminImpl.Properties_can_not_be_null"));
        }
        Collection existingBindings = this.parent.getConnectorBindings("*" + AdminObject.DELIMITER + connectorBindingName);
        ArrayList<String> newBindingNames = new ArrayList<String>(1);
        newBindingNames.add(connectorBindingName);
        Collection updateBindingNames = this.getBindingNamesToUpdate(existingBindings, newBindingNames, options);
        if (updateBindingNames.size() > 0 && updateBindingNames.iterator().next().equals(connectorBindingName)) {
            AdminStatus status = this.checkDecryption(properties, connectorBindingName, connectorTypeIdentifier);
            if (status.getCode() == -101 && !options.containsOption(8)) {
                throw new AdminProcessingException(status.getCode(), status.getMessage());
            }
            ConnectorBinding binding = null;
            try {
                binding = this.getConfigurationServiceProxy().createConnectorBinding(connectorBindingName, connectorTypeIdentifier, METAMATRIXPROCESS_PSC, this.getUserName(), properties);
                if (binding == null) {
                    this.throwProcessingException("ServerConfigAdminImpl.Connector_Binding_was_null", new Object[]{connectorBindingName});
                }
            }
            catch (ConfigurationException e) {
                throw new AdminComponentException((Throwable)e);
            }
            catch (ServiceException e) {
                throw new AdminComponentException((Throwable)((Object)e));
            }
            Collection newBindings = this.parent.getConnectorBindings("*" + AdminObject.DELIMITER + connectorBindingName);
            newBinding = (com.metamatrix.admin.api.objects.ConnectorBinding)newBindings.iterator().next();
        } else if (existingBindings != null && existingBindings.size() > 0) {
            newBinding = (com.metamatrix.admin.api.objects.ConnectorBinding)existingBindings.iterator().next();
        }
        return newBinding;
    }

    public com.metamatrix.admin.api.objects.ConnectorBinding addConnectorBinding(String connectorBindingName, char[] xmlFile, AdminOptions options) throws AdminException {
        com.metamatrix.admin.api.objects.ConnectorBinding newBinding = null;
        if (connectorBindingName == null) {
            throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerConfigAdminImpl.Connector_Binding_can_not_be_null"));
        }
        if (xmlFile == null) {
            throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerConfigAdminImpl.CDK_File_Name_can_not_be_null"));
        }
        Collection existingBindings = this.parent.getConnectorBindings("*" + AdminObject.DELIMITER + connectorBindingName);
        ArrayList<String> newBindingNames = new ArrayList<String>(1);
        newBindingNames.add(connectorBindingName);
        Collection updateBindingNames = this.getBindingNamesToUpdate(existingBindings, newBindingNames, options);
        if (updateBindingNames.size() > 0 && updateBindingNames.iterator().next().equals(connectorBindingName)) {
            InputStream is = ObjectConverterUtil.convertToInputStream((char[])xmlFile);
            XMLConfigurationImportExportUtility ciu = new XMLConfigurationImportExportUtility();
            ConnectorBinding binding = null;
            try {
                binding = ciu.importConnectorBinding(is, (ConfigurationObjectEditor)new BasicConfigurationObjectEditor(false), connectorBindingName);
                is.close();
            }
            catch (ConfigObjectsNotResolvableException e) {
                throw new AdminComponentException((Throwable)e);
            }
            catch (InvalidConfigurationElementException e) {
                throw new AdminComponentException((Throwable)e);
            }
            catch (IOException e) {
                throw new AdminComponentException((Throwable)e);
            }
            AdminStatus status = this.checkDecryption(binding);
            if (status.getCode() == -101 && !options.containsOption(8)) {
                throw new AdminProcessingException(status.getCode(), status.getMessage());
            }
            try {
                is = ObjectConverterUtil.convertToInputStream((char[])xmlFile);
                binding = this.getConfigurationServiceProxy().importConnectorBinding(is, connectorBindingName, METAMATRIXPROCESS_PSC, this.getUserName());
                if (binding == null) {
                    this.throwProcessingException("ServerConfigAdminImpl.Connector_Type_was_null", new Object[]{connectorBindingName});
                }
            }
            catch (ConfigurationException e) {
                throw new AdminComponentException((Throwable)e);
            }
            catch (ServiceException e) {
                throw new AdminComponentException((Throwable)((Object)e));
            }
            Collection newBindings = this.parent.getConnectorBindings("*" + AdminObject.DELIMITER + connectorBindingName);
            newBinding = (com.metamatrix.admin.api.objects.ConnectorBinding)newBindings.iterator().next();
        } else if (existingBindings != null && existingBindings.size() > 0) {
            newBinding = (com.metamatrix.admin.api.objects.ConnectorBinding)existingBindings.iterator().next();
        }
        return newBinding;
    }

    public void addConnectorType(String name, char[] cdkFile) throws AdminException {
        ComponentType connectorType = null;
        if (name == null) {
            throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerConfigAdminImpl.Connector_Type_can_not_be_null"));
        }
        if (cdkFile == null) {
            throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerConfigAdminImpl.CDK_File_Name_can_not_be_null"));
        }
        try {
            InputStream is = ObjectConverterUtil.convertToInputStream((char[])cdkFile);
            connectorType = this.getConfigurationServiceProxy().importConnectorType(is, name, this.getUserName());
            if (connectorType == null) {
                this.throwProcessingException("ServerConfigAdminImpl.Connector_Type_was_null", new Object[]{name});
            }
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
    }

    public void addConnectorArchive(byte[] contents, AdminOptions options) throws AdminException {
        if (options == null) {
            options = new AdminOptions(2);
        }
        if (contents == null || contents.length == 0) {
            throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerConfigAdminImpl.CDK_File_Name_can_not_be_null"));
        }
        XMLConfigurationImportExportUtility util = new XMLConfigurationImportExportUtility();
        InputStream in = ObjectConverterUtil.convertToInputStream((byte[])contents);
        try {
            HashSet previouslyAddedModules = new HashSet();
            HashSet<ConnectorBindingType> typesToAdd = new HashSet<ConnectorBindingType>();
            ConnectorArchive archive = util.importConnectorArchive(in, (ConfigurationObjectEditor)new BasicConfigurationObjectEditor());
            ConnectorBindingType[] connectorTypes = archive.getConnectorTypes();
            for (int typeIndex = 0; typeIndex < connectorTypes.length; ++typeIndex) {
                String connectorName = connectorTypes[typeIndex].getName();
                ConnectorBindingType type = (ConnectorBindingType)this.getComponentType(connectorName);
                if (type != null && options.containsOption(4)) {
                    this.throwProcessingException("ServerConfigAdminImpl.Connector_Type_already_exists", new Object[]{connectorName});
                } else {
                    if (type != null && options.containsOption(2)) continue;
                    if (type != null && options.containsOption(1)) {
                        this.deleteConnectorType(connectorName);
                    }
                }
                type = connectorTypes[typeIndex];
                ExtensionModule[] extModules = archive.getExtensionModules(type);
                this.checkAddingConnectorType(type, extModules, options, previouslyAddedModules);
                typesToAdd.add(type);
            }
            for (ConnectorBindingType type : typesToAdd) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(10240);
                util.exportComponentType((OutputStream)baos, (ComponentType)type, this.getPropertiesForExporting());
                this.addConnectorType(type.getName(), ObjectConverterUtil.bytesToChar((byte[])baos.toByteArray(), null));
                baos.close();
            }
            for (ExtensionModule extModule : previouslyAddedModules) {
                this.addExtensionModule(extModule.getModuleType(), extModule.getFullName(), extModule.getFileContents(), extModule.getDescription());
            }
        }
        catch (InvalidConfigurationElementException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (IOException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (MetaMatrixProcessingException e) {
            throw new AdminProcessingException((Throwable)e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
    }

    public void addAuthorizationProvider(String domainprovidername, String providertypename, Properties properties) throws AdminException {
        if (domainprovidername == null) {
            throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerConfigAdminImpl.Provider_name_can_not_be_null"));
        }
        if (providertypename == null) {
            throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerConfigAdminImpl.ProviderType_name_can_not_be_null"));
        }
        try {
            ConfigurationObjectEditor coe = this.getConfigurationServiceProxy().createEditor();
            ConfigurationModelContainer cmc = this.getConfigurationServiceProxy().getConfigurationModel("Next Startup");
            if (cmc.getConfiguration().getAuthenticationProvider(domainprovidername) != null) {
                throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerConfigAdminImpl.Provider_already_exist"));
            }
            ComponentType providertype = cmc.getComponentType(providertypename);
            if (providertype == null) {
                throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerConfigAdminImpl.ProviderType_does_not_exist"));
            }
            AuthenticationProvider provider = coe.createAuthenticationProviderComponent(Configuration.NEXT_STARTUP_ID, (ComponentTypeID)providertype.getID(), domainprovidername);
            Properties props = providertype.getDefaultPropertyValues();
            props.putAll((Map<?, ?>)properties);
            provider = (AuthenticationProvider)coe.modifyProperties((ComponentObject)provider, props, 0);
            this.getConfigurationServiceProxy().executeTransaction(coe.getDestination().popActions(), this.getUserName());
        }
        catch (InvalidConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ModificationException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    void checkAddingConnectorType(ConnectorBindingType type, ExtensionModule[] extModules, AdminOptions options, HashSet ignorableModules) throws MetaMatrixComponentException, MetaMatrixProcessingException, AdminException {
        for (int i = 0; i < extModules.length; ++i) {
            boolean add = true;
            String moduleName = extModules[i].getFullName();
            if (ignorableModules.contains(extModules[i])) continue;
            if (this.getExtensionSourceManager().isSourceInUse(moduleName)) {
                if (options.containsOption(4)) {
                    this.throwProcessingException("ServerConfigAdminImpl.Extension_module_already_exists", new Object[]{moduleName});
                } else if (options.containsOption(2)) {
                    add = false;
                } else if (options.containsOption(1)) {
                    this.deleteExtensionModule(moduleName);
                }
            }
            if (!add) continue;
            ignorableModules.add(extModules[i]);
        }
    }

    public void addExtensionModule(String type, String sourceName, byte[] source, String description) throws AdminException {
        Collection foundModules = this.parent.getExtensionModules(sourceName);
        if (foundModules.size() > 0) {
            this.throwProcessingException("ServerConfigAdminImpl.Extension_Module_duplicate", new Object[]{sourceName});
        }
        try {
            ExtensionModuleDescriptor desc = this.getExtensionSourceManager().addSource(this.getUserName(), type, sourceName, source, description, true);
            if (desc == null) {
                this.throwProcessingException("ServerConfigAdminImpl.Extension_Module_Descriptor_was_null", new Object[]{sourceName});
            }
        }
        catch (DuplicateExtensionModuleException e) {
            throw new AdminProcessingException((Throwable)e);
        }
        catch (InvalidExtensionModuleTypeException e) {
            throw new AdminProcessingException((Throwable)e);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public void deleteExtensionModule(String sourceName) throws AdminException {
        try {
            this.getExtensionSourceManager().removeSource(this.getUserName(), sourceName);
        }
        catch (ExtensionModuleNotFoundException e) {
            throw new AdminProcessingException((Throwable)e);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public void addHost(String hostIdentifer, Properties properties) throws AdminException {
        com.metamatrix.common.config.api.Host host = null;
        String hostName = this.getName(hostIdentifer);
        if (hostName == null) {
            throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerConfigAdminImpl.Host_name_can_not_be_null"));
        }
        if (properties == null) {
            throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerConfigAdminImpl.Properties_can_not_be_null"));
        }
        try {
            host = this.getConfigurationServiceProxy().addHost(hostName, this.getUserName(), properties);
            if (host == null) {
                this.throwProcessingException("ServerConfigAdminImpl.Host_was_null", new Object[]{hostName});
            }
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
    }

    public void addProcess(String processIdentifier, Properties properties) throws AdminException {
        String processName = this.getName(processIdentifier);
        if (processName == null) {
            throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerConfigAdminImpl.Name_can_not_be_null"));
        }
        String hostName = this.getParent(processIdentifier);
        if (hostName == null) {
            throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerConfigAdminImpl.Host_name_can_not_be_null"));
        }
        com.metamatrix.common.config.api.Host theHost = this.getHostByName(hostName);
        if (properties == null) {
            throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerConfigAdminImpl.Properties_can_not_be_null"));
        }
        try {
            VMComponentDefn processDefn = null;
            processDefn = this.getConfigurationServiceProxy().addProcess(processName, hostName, this.getUserName(), properties);
            if (processDefn != null) {
                Collection pscs = this.getConfigurationModel().getConfiguration().getPSCs();
                if (pscs != null && !pscs.isEmpty()) {
                    ProductServiceConfig psc2 = null;
                    for (ProductServiceConfig psc2 : pscs) {
                        if (!psc2.getName().equalsIgnoreCase(METAMATRIXPROCESS_PSC)) continue;
                        this.getConfigurationServiceProxy().deployPSC(theHost, processDefn, METAMATRIXPROCESS_PSC, this.getUserName());
                    }
                }
                this.getConfigurationServiceProxy().deployPSC(theHost, processDefn, PLATFORM_STANDARD_PSC, this.getUserName());
                this.getConfigurationServiceProxy().deployPSC(theHost, processDefn, QUERY_ENGINE_PSC, this.getUserName());
            } else {
                Object[] params = new Object[]{processIdentifier, hostName};
                this.throwProcessingException("ServerConfigAdminImpl.Process_was_null", params);
            }
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
        catch (ModificationException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public VDB addVDB(String name, byte[] vdbFile, AdminOptions options) throws AdminException {
        VDBArchive vdb = null;
        try {
            vdb = new VDBArchive((InputStream)new ByteArrayInputStream(vdbFile));
            vdb.setName(name);
        }
        catch (IOException e) {
            throw new AdminComponentException((Throwable)e);
        }
        return this.addVDB(vdb, options);
    }

    private VDB addVDB(VDBArchive vdb, AdminOptions options) throws AdminException {
        BasicVDBDefn def = vdb.getConfigurationDef();
        ArrayList newBindings = new ArrayList(def.getConnectorBindings().values());
        AdminStatus status = this.checkDecryption(newBindings);
        if (status.getCode() == -101 && !options.containsOption(8)) {
            throw new AdminProcessingException(status.getCode(), status.getMessage());
        }
        Collection newBindingNames = this.getBindingNames(newBindings);
        Collection existingBindings = this.parent.getConnectorBindingsInVDB(vdb.getName());
        this.getBindingNamesToUpdate(existingBindings, newBindingNames, options);
        boolean updateBindings = options.containsOption(1);
        VirtualDatabase newVDB = null;
        try {
            newVDB = VDBDefnImport.importVDBDefn(vdb, this.getUserName(), updateBindings);
        }
        catch (Exception e) {
            throw new AdminComponentException((Throwable)e);
        }
        if (newVDB == null) {
            this.throwProcessingException("ServerConfigAdminImpl.VDB_created_was_null", new Object[]{def.getName()});
        }
        if (vdb.getDataRoles() != null) {
            this.importDataRoles(vdb.getName(), vdb.getVersion(), vdb.getDataRoles(), options);
        }
        return this.convertToAdminVDB(newVDB);
    }

    public ScriptsContainer generateMaterializationScripts(String vdbName, String vdbVersion, String metamatrixUserName, String metamatrixUserPwd, String materializationUserName, String materializationUserPwd) throws AdminException {
        VDBArchive vdbArchive = null;
        ModelInfo materializationModel = null;
        try {
            vdbArchive = VDBDefnFactory.createVDBArchive(vdbName, vdbVersion);
            BasicVDBDefn def = vdbArchive.getConfigurationDef();
            Collection models = def.getModels();
            for (ModelInfo model : models) {
                if (!model.isMaterialization()) continue;
                materializationModel = model;
                break;
            }
        }
        catch (Exception e) {
            throw new AdminComponentException((Throwable)e);
        }
        finally {
            if (vdbArchive != null) {
                vdbArchive.close();
            }
        }
        List bindings = materializationModel.getConnectorBindingNames();
        ConnectorBinding materializationConnector = null;
        String materializationConnectorName = null;
        if (bindings == null || bindings.size() <= 0) {
            Object[] params = new Object[]{materializationModel.getName()};
            throw new AdminProcessingException(AdminServerPlugin.Util.getString(AdminServerPlugin.Util.getString("ServerConfigAdminImpl.Unable_to_get_binding_name", params)));
        }
        materializationConnectorName = (String)bindings.iterator().next();
        try {
            materializationConnector = this.getConnectorBindingByName(materializationConnectorName);
        }
        catch (ServiceException e) {
            throw new AdminComponentException(AdminServerPlugin.Util.getString("ServerConfigAdminImpl.Unable_to_get_binding_name", new Object[]{materializationModel.getName()}), (Throwable)((Object)e));
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException(AdminServerPlugin.Util.getString("ServerConfigAdminImpl.Unable_to_get_binding_name", new Object[]{materializationModel.getName()}), (Throwable)e);
        }
        Properties materializationConnectorProps = materializationConnector.getProperties();
        String materializationURL = materializationConnectorProps.getProperty(CONNECTION_PROPERTY_URL);
        if (materializationUserName == null || materializationUserName.length() == 0 || materializationUserPwd == null || materializationUserPwd.length() == 0) {
            materializationUserName = materializationConnectorProps.getProperty(CONNECTION_PROPERTY_USER);
            materializationUserPwd = materializationConnectorProps.getProperty(CONNECTION_PROPERTY_PASSWORD);
        } else {
            try {
                materializationUserPwd = PropertiesUtils.saveConvert((String)CryptoUtil.stringEncrypt((String)materializationUserPwd), (boolean)false);
            }
            catch (CryptoException e) {
                throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerConfigAdminImpl.Unable_to_encrypt_mat_db_user", new Object[]{materializationUserName}), (Throwable)e);
            }
        }
        try {
            metamatrixUserPwd = PropertiesUtils.saveConvert((String)CryptoUtil.stringEncrypt((String)metamatrixUserPwd), (boolean)false);
        }
        catch (CryptoException e) {
            throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerConfigAdminImpl.Unable_to_encrypt_MM_user", new Object[]{metamatrixUserName}), (Throwable)e);
        }
        String materializationDriver = materializationConnectorProps.getProperty(CONNECTION_PROPERTY_DRIVER);
        String mmHost = null;
        String mmPort = null;
        Collection hosts = this.parent.getHosts("*");
        Host aHost = (Host)hosts.iterator().next();
        mmHost = aHost.getName();
        Collection hostProcesses = this.parent.getProcesses(aHost.getIdentifier() + AdminObject.DELIMITER + "*");
        ProcessObject hostProcess = (ProcessObject)hostProcesses.iterator().next();
        mmPort = hostProcess.getPropertyValue("vm.socketPort");
        boolean useSSL = ServerSocketConfiguration.isSSLEnabled();
        String mmDriver = "com.metamatrix.jdbc.MMDriver";
        MaterializationLoadScriptsImpl binaryScripts = (MaterializationLoadScriptsImpl)RuntimeMetadataHelper.createMaterializedViewLoadPropertiesVersion(materializationModel, materializationURL, materializationDriver, materializationUserName, materializationUserPwd, mmHost, mmPort, mmDriver, useSSL, metamatrixUserName, metamatrixUserPwd, vdbName, vdbVersion);
        MMScriptsContainer scripts = new MMScriptsContainer();
        scripts.addFile(binaryScripts.getCreateScriptFileName(), binaryScripts.getCreateFileContents());
        scripts.addFile(binaryScripts.getConnectionPropsFileName(), binaryScripts.getConPropsFileContents());
        scripts.addFile(binaryScripts.getTruncateScriptFileName(), binaryScripts.getTruncateFileContents());
        scripts.addFile(binaryScripts.getLoadScriptFileName(), binaryScripts.getLoadFileContents());
        scripts.addFile(binaryScripts.getSwapScriptFileName(), binaryScripts.getSwapFileContents());
        return scripts;
    }

    public void disableHost(String identifier) throws AdminException {
        try {
            Collection hosts = this.getConfigurationServiceProxy().getHosts();
            for (com.metamatrix.common.config.api.Host hostObject : hosts) {
                com.metamatrix.common.config.api.Host updatedHost;
                String hostName = hostObject.getName();
                if (!ServerConfigAdminImpl.identifierMatches(identifier, new String[]{hostName}) || (updatedHost = this.updateHost(hostObject, false)) != null) continue;
                this.throwProcessingException("ServerConfigAdminImpl.Host_was_null", new Object[]{hostName});
            }
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
        catch (ModificationException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    private com.metamatrix.common.config.api.Host updateHost(com.metamatrix.common.config.api.Host hostObject, boolean enable) throws ConfigurationException, ModificationException {
        Properties theProperties = hostObject.getProperties();
        theProperties.setProperty("host.enabled", Boolean.toString(enable));
        return (com.metamatrix.common.config.api.Host)this.getConfigurationServiceProxy().modify((ComponentObject)hostObject, theProperties, this.getUserName());
    }

    public void disableProcess(String identifier) throws AdminException {
        Collection defns = new ArrayList();
        try {
            defns = this.getConfigurationServiceProxy().getCurrentConfiguration().getVMComponentDefns();
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
        try {
            for (VMComponentDefn defn : defns) {
                VMComponentDefn updatedProcess;
                String processName = defn.getName();
                String hostName = defn.getHostID().getName();
                String[] identifierParts = new String[]{hostName, processName};
                if (!ServerConfigAdminImpl.identifierMatches(identifier, identifierParts) || (updatedProcess = this.updateProcess(defn, false)) != null) continue;
                Object[] params = new Object[]{identifier, hostName};
                this.throwProcessingException("ServerConfigAdminImpl.Process_was_null", params);
            }
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ModificationException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    private VMComponentDefn updateProcess(VMComponentDefn defn, boolean enabled) throws ConfigurationException, ModificationException {
        Properties processProperties = defn.getProperties();
        processProperties.setProperty("vm.enabled", Boolean.toString(enabled));
        return (VMComponentDefn)this.getConfigurationServiceProxy().modify((ComponentObject)defn, processProperties, this.getUserName());
    }

    public void enableHost(String identifier) throws AdminException {
        try {
            Collection hosts = this.getConfigurationServiceProxy().getHosts();
            for (com.metamatrix.common.config.api.Host hostObject : hosts) {
                com.metamatrix.common.config.api.Host updatedHost;
                String hostName = hostObject.getName();
                if (!ServerConfigAdminImpl.identifierMatches(identifier, new String[]{hostName}) || (updatedHost = this.updateHost(hostObject, true)) != null) continue;
                this.throwProcessingException("ServerConfigAdminImpl.Host_was_null", new Object[]{hostName});
            }
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
        catch (ModificationException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public void enableProcess(String identifier) throws AdminException {
        try {
            Collection defns = this.getConfigurationServiceProxy().getCurrentConfiguration().getVMComponentDefns();
            for (VMComponentDefn defn : defns) {
                VMComponentDefn updatedProcess;
                String processName = defn.getName();
                String hostName = defn.getHostID().getName();
                String[] identifierParts = new String[]{hostName, processName};
                if (!ServerConfigAdminImpl.identifierMatches(identifier, identifierParts) || (updatedProcess = this.updateProcess(defn, true)) != null) continue;
                Object[] params = new Object[]{identifier, hostName};
                this.throwProcessingException("ServerConfigAdminImpl.Process_was_null", params);
            }
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
        catch (ModificationException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public char[] exportConfiguration() throws AdminException {
        char[] results = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream os = new BufferedOutputStream(baos);
        try {
            ConfigurationModelContainer container = this.getConfigurationServiceProxy().getConfigurationModel("Next Startup");
            ConfigurationModelContainerAdapter adapter = new ConfigurationModelContainerAdapter();
            adapter.writeConfigurationModel((OutputStream)os, container, this.getUserName());
            results = ObjectConverterUtil.bytesToChar((byte[])baos.toByteArray(), null);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (IOException e) {
            throw new AdminComponentException((Throwable)e);
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException err) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException err) {}
            }
        }
        return results;
    }

    public void importConfiguration(char[] fileData) throws AdminException {
        InputStream is = null;
        try {
            is = ObjectConverterUtil.convertToInputStream((char[])fileData);
            ConfigurationObjectEditor readEditor = this.getConfigurationServiceProxy().createEditor();
            XMLConfigurationImportExportUtility utility = new XMLConfigurationImportExportUtility();
            Collection objects = utility.importConfigurationObjects(is, readEditor, "Next Startup");
            ConfigurationObjectEditor writeEditor = this.getConfigurationServiceProxy().createEditor();
            writeEditor.delete(Configuration.NEXT_STARTUP_ID);
            writeEditor.createConfiguration(Configuration.NEXT_STARTUP_ID, objects);
            this.getConfigurationServiceProxy().executeTransaction(writeEditor.getDestination().getActions(), this.getUserName());
        }
        catch (ConfigObjectsNotResolvableException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (InvalidConfigurationElementException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ModificationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
        catch (IOException e) {
            throw new AdminComponentException((Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
    }

    public char[] exportConnectorBinding(String connectorBindingIdentifier) throws AdminException {
        char[] results = null;
        ArrayList<ConnectorBinding> selectedBindings = new ArrayList<ConnectorBinding>();
        ArrayList<ComponentType> selectedTypes = new ArrayList<ComponentType>();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream os = new BufferedOutputStream(baos);
        XMLConfigurationImportExportUtility util = new XMLConfigurationImportExportUtility();
        try {
            Configuration config = this.getConfigurationServiceProxy().getCurrentConfiguration();
            ConfigurationModelContainer container = this.getConfigurationServiceProxy().getConfigurationModel("Next Startup");
            Collection components = config.getDeployedComponents();
            for (Object component : components) {
                String bindingName = component.getName();
                String[] identifierParts = new String[]{component.getHostID().getName(), component.getVMComponentDefnID().getName(), bindingName};
                ConnectorBinding binding = config.getConnectorBinding(bindingName);
                if (binding == null || !ServerConfigAdminImpl.identifierMatches(connectorBindingIdentifier, identifierParts)) continue;
                selectedBindings.add(binding);
                ComponentType ct = container.getComponentType(binding.getComponentTypeID().getFullName());
                selectedTypes.add(ct);
            }
            int numSelected = selectedBindings.size();
            if (numSelected == 0) {
                Object component;
                component = new char[0];
                return component;
            }
            ConnectorBinding[] bindingArray = new ConnectorBinding[numSelected];
            bindingArray = selectedBindings.toArray(bindingArray);
            int numSelected2 = selectedTypes.size();
            ComponentType[] typeArray = new ComponentType[numSelected2];
            typeArray = selectedTypes.toArray(typeArray);
            Properties properties = this.getPropertiesForExporting();
            util.exportConnectorBindings((OutputStream)os, bindingArray, typeArray, properties);
            results = ObjectConverterUtil.bytesToChar((byte[])baos.toByteArray(), null);
        }
        catch (ConfigObjectsNotResolvableException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
        catch (IOException e) {
            throw new AdminComponentException((Throwable)e);
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException err) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException err) {}
            }
        }
        return results;
    }

    public char[] exportConnectorType(String connectorTypeIdentifier) throws AdminException {
        char[] results = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream os = new BufferedOutputStream(baos);
        XMLConfigurationImportExportUtility util = new XMLConfigurationImportExportUtility();
        try {
            List selectedTypes = this.getComponentTypes(connectorTypeIdentifier);
            int numSelected = selectedTypes.size();
            ComponentType[] typeArray = new ComponentType[numSelected];
            typeArray = selectedTypes.toArray(typeArray);
            Properties properties = this.getPropertiesForExporting();
            util.exportComponentTypes((OutputStream)os, typeArray, properties);
            results = ObjectConverterUtil.bytesToChar((byte[])baos.toByteArray(), null);
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (IOException e) {
            throw new AdminComponentException((Throwable)e);
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException err) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException err) {}
            }
        }
        return results;
    }

    private List getComponentTypes(String connectorTypeIdentifier) throws ConfigurationException {
        ArrayList<ComponentType> selectedTypes = new ArrayList<ComponentType>();
        Collection types = this.getConfigurationServiceProxy().getAllComponentTypes(false);
        for (ComponentType componentType : types) {
            if (componentType.getComponentTypeCode() != 2) continue;
            String name = componentType.getName();
            String[] identifierParts = new String[]{name};
            if (!ServerConfigAdminImpl.identifierMatches(connectorTypeIdentifier, identifierParts)) continue;
            selectedTypes.add(componentType);
        }
        return selectedTypes;
    }

    public byte[] exportConnectorArchive(String connectorTypeIdentifier) throws AdminException {
        BasicConnectorArchive archive = new BasicConnectorArchive();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            List selectedTypes = this.getComponentTypes(connectorTypeIdentifier);
            int numSelected = selectedTypes.size();
            if (numSelected == 0) {
                this.throwProcessingException("ServerConfigAdminImpl.Connector_Type_not_found_in_Configuration", new Object[]{connectorTypeIdentifier});
            }
            for (ConnectorBindingType type : selectedTypes) {
                archive.addConnectorType(type);
                String[] modules = type.getExtensionModules();
                for (int m = 0; m < modules.length; ++m) {
                    String extModuleName = modules[m];
                    if ("connector_patch.jar".equals(extModuleName)) continue;
                    ExtensionModuleDescriptor emd = this.getExtensionSourceManager().getSourceDescriptor(extModuleName);
                    byte[] source = this.getExtensionSourceManager().getSource(extModuleName);
                    BasicExtensionModule extModule = new BasicExtensionModule(extModuleName, emd.getType(), emd.getDescription(), source);
                    archive.addExtensionModule(type, (ExtensionModule)extModule);
                }
            }
            XMLConfigurationImportExportUtility util = new XMLConfigurationImportExportUtility();
            util.exportConnectorArchive((OutputStream)baos, (ConnectorArchive)archive, this.getPropertiesForExporting());
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (ConfigObjectsNotResolvableException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ExtensionModuleNotFoundException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (IOException e) {
            throw new AdminComponentException((Throwable)e);
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException e) {}
        }
    }

    public byte[] exportExtensionModule(String identifier) throws AdminException {
        byte[] data = null;
        try {
            List modules = this.getExtensionSourceManager().getSourceDescriptors();
            for (ExtensionModuleDescriptor descriptor : modules) {
                String sourceName = descriptor.getName();
                String[] identifierParts = new String[]{sourceName};
                if (!ServerConfigAdminImpl.identifierMatches(identifier, identifierParts)) continue;
                data = this.getExtensionSourceManager().getSource(sourceName);
                break;
            }
        }
        catch (ExtensionModuleNotFoundException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
        return data;
    }

    public byte[] exportVDB(String name, String version) throws AdminException {
        VDBArchive archive = null;
        try {
            archive = VDBDefnFactory.createVDBArchive(name, version);
            archive.updateRoles(this.exportDataRoles(name, version));
            byte[] byArray = VDBArchive.writeToByteArray((VDBArchive)archive);
            return byArray;
        }
        catch (Exception e) {
            throw new AdminComponentException((Throwable)e);
        }
        finally {
            if (archive != null) {
                archive.close();
            }
        }
    }

    private Properties getPropertiesForExporting() {
        Properties properties = new Properties();
        properties.put("ApplicationCreatedBy", "ServerAdmin");
        properties.put("ApplicationVersion", "4.3");
        properties.put("UserCreatedBy", this.getUserName());
        return properties;
    }

    public LogConfiguration getLogConfiguration() throws AdminException {
        com.metamatrix.common.log.LogConfiguration logConfig = null;
        try {
            logConfig = this.getConfigurationServiceProxy().getNextStartupConfiguration().getLogConfiguration();
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
        MMLogConfiguration result = new MMLogConfiguration();
        if (logConfig != null) {
            result.setLogLevel(logConfig.getMessageLevel());
            result.setDiscardedContexts(logConfig.getDiscardedContexts());
            HashSet contextsSet = new HashSet(LogContextsUtil.ALL_CONTEXTS);
            if (logConfig.getDiscardedContexts() != null) {
                contextsSet.removeAll(logConfig.getDiscardedContexts());
            }
            result.setIncludedContexts(contextsSet);
        }
        return result;
    }

    public void setLogConfiguration(LogConfiguration adminLogConfig) throws AdminException {
        Configuration config = null;
        try {
            config = this.getConfigurationServiceProxy().getNextStartupConfiguration();
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
        if (config != null) {
            Set discardedCtx = adminLogConfig.getDiscardedContexts();
            HashSet includedCtx = adminLogConfig.getIncludedContexts();
            if (discardedCtx.contains("CTX_ALL") && includedCtx.contains("CTX_ALL")) {
                return;
            }
            if (discardedCtx.contains("CTX_ALL")) {
                discardedCtx = new HashSet(LogContextsUtil.ALL_CONTEXTS);
                includedCtx = Collections.EMPTY_SET;
            } else if (includedCtx.contains("CTX_ALL")) {
                includedCtx = new HashSet(LogContextsUtil.ALL_CONTEXTS);
                discardedCtx = Collections.EMPTY_SET;
            }
            com.metamatrix.common.log.LogConfiguration logConfig = config.getLogConfiguration();
            logConfig.setMessageLevel(adminLogConfig.getLogLevel());
            logConfig.recordContexts(includedCtx);
            logConfig.discardContexts(discardedCtx);
            LogManager.setLogConfiguration((com.metamatrix.common.log.LogConfiguration)logConfig);
            ConfigurationObjectEditor coe = null;
            try {
                coe = this.getConfigurationServiceProxy().createEditor();
                coe.setLogConfiguration(config, logConfig);
                ModificationActionQueue maq = coe.getDestination();
                List actions = maq.popActions();
                this.getRuntimeStateAdminAPIHelper().setLogConfiguration(config, logConfig, actions, this.getUserName());
            }
            catch (ConfigurationLockException e) {
                throw new AdminComponentException((Throwable)e);
            }
            catch (ConfigurationException e) {
                throw new AdminComponentException((Throwable)e);
            }
            catch (ServiceException e) {
                throw new AdminComponentException((Throwable)((Object)e));
            }
            catch (MetaMatrixComponentException e) {
                throw new AdminComponentException((Throwable)e);
            }
        }
    }

    public void setSystemProperty(String propertyName, String propertyValue) throws AdminException {
        if (propertyName == null) {
            throw new IllegalArgumentException(AdminPlugin.Util.getString("ServerConfigAdminImpl.Property_name_can_not_be_null"));
        }
        try {
            this.getConfigurationServiceProxy().setSystemPropertyValue(propertyName, propertyValue, this.getUserName());
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
    }

    public void updateSystemProperties(Properties properties) throws AdminException {
        try {
            this.getConfigurationServiceProxy().updateSystemPropertyValues(properties, this.getUserName());
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
    }

    public void setProperty(String identifier, String className, String propertyName, String propertyValue) throws AdminException {
        Properties properties = new Properties();
        properties.setProperty(propertyName, propertyValue);
        this.updateProperties(identifier, className, properties);
    }

    public void updateProperties(String identifier, String className, Properties properties) throws AdminException {
        Collection adminObjects = this.getAdminObjects(identifier, className);
        if (adminObjects == null || adminObjects.size() == 0) {
            this.throwProcessingException("ServerConfigAdminImpl.No_Objects_Found", new Object[]{identifier, className});
        }
        if (adminObjects.size() > 1) {
            this.throwProcessingException("ServerConfigAdminImpl.Multiple_Objects_Found", new Object[]{identifier, className});
        }
        AdminObject adminObject = (AdminObject)adminObjects.iterator().next();
        int type = MMAdminObject.getObjectType((String)className);
        switch (type) {
            case 19: {
                this.updateSystemProperties(properties);
                break;
            }
            case 8: {
                String hostName = adminObject.getName();
                com.metamatrix.common.config.api.Host host = this.getHostByName(hostName);
                Properties hostProperties = host.getProperties();
                hostProperties.putAll((Map<?, ?>)properties);
                try {
                    com.metamatrix.common.config.api.Host updatedHost = (com.metamatrix.common.config.api.Host)this.getConfigurationServiceProxy().modify((ComponentObject)host, hostProperties, this.getUserName());
                    if (updatedHost != null) break;
                    this.throwProcessingException("ServerConfigAdminImpl.Host_was_null_when_updating_properties", new Object[]{hostName});
                    break;
                }
                catch (ConfigurationException e) {
                    throw new AdminComponentException((Throwable)e);
                }
                catch (ModificationException e) {
                    throw new AdminComponentException((Throwable)e);
                }
                catch (ServiceException e) {
                    throw new AdminComponentException((Throwable)((Object)e));
                }
            }
            case 11: {
                ProcessObject process = (ProcessObject)adminObject;
                String processName = adminObject.getName();
                String hostName = process.getHostIdentifier();
                try {
                    VMComponentDefn vmDefn = this.getVMByName(hostName, processName);
                    Properties processProperties = vmDefn.getProperties();
                    processProperties.putAll((Map<?, ?>)properties);
                    VMComponentDefn updatedProcess = (VMComponentDefn)this.getConfigurationServiceProxy().modify((ComponentObject)vmDefn, processProperties, this.getUserName());
                    if (updatedProcess != null) break;
                    this.throwProcessingException("ServerConfigAdminImpl.Process_was_null_when_updating_properties", new Object[]{processName});
                    break;
                }
                catch (ConfigurationException e) {
                    throw new AdminComponentException((Throwable)e);
                }
                catch (ServiceException e) {
                    throw new AdminComponentException((Throwable)((Object)e));
                }
                catch (MetaMatrixProcessingException e) {
                    throw new AdminProcessingException((Throwable)e);
                }
                catch (ModificationException e) {
                    throw new AdminComponentException((Throwable)e);
                }
            }
            case 2: {
                String connectorBindingName = adminObject.getName();
                try {
                    ConnectorBinding connectorBinding = this.getConnectorBindingByName(connectorBindingName);
                    Properties bindingProperties = connectorBinding.getProperties();
                    bindingProperties.putAll((Map<?, ?>)properties);
                    ConnectorBinding updatedConnectorBinding = (ConnectorBinding)this.getConfigurationServiceProxy().modify((ComponentObject)connectorBinding, bindingProperties, this.getUserName());
                    if (updatedConnectorBinding != null) break;
                    this.throwProcessingException("ServerConfigAdminImpl.Connector_Binding_was_null_when_updating_properties", new Object[]{connectorBindingName});
                    break;
                }
                catch (ConfigurationException e) {
                    throw new AdminComponentException((Throwable)e);
                }
                catch (ServiceException e) {
                    throw new AdminComponentException((Throwable)((Object)e));
                }
                catch (ModificationException e) {
                    throw new AdminComponentException((Throwable)e);
                }
            }
            default: {
                this.throwProcessingException("ServerConfigAdminImpl.Unsupported_Admin_Object", new Object[]{className});
            }
        }
    }

    private ConnectorBinding getConnectorBindingByName(String name) throws ConfigurationException, ServiceException, AdminProcessingException {
        Configuration nextStartupConfig = this.getConfigurationServiceProxy().getNextStartupConfiguration();
        ConnectorBinding cb = nextStartupConfig.getConnectorBinding(name);
        if (cb == null) {
            throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerConfigAdminImpl.Connector_Binding_not_found_in_Configuration", new Object[]{name}));
        }
        return cb;
    }

    protected List<ConnectorBinding> getConnectorBindingsByName(String[] bindingNames) throws ConfigurationException, ServiceException, AdminProcessingException {
        ArrayList<ConnectorBinding> bindingList = new ArrayList<ConnectorBinding>(bindingNames.length);
        for (int i = 0; i < bindingNames.length; ++i) {
            bindingList.add(this.getConnectorBindingByName(bindingNames[i]));
        }
        return bindingList;
    }

    public void assignBindingToModel(String connectorBindingName, String vdbName, String vdbVersion, String modelName) throws AdminException {
        String[] connectorBindingNames = new String[]{connectorBindingName};
        this.assignBindingsToModel(connectorBindingNames, vdbName, vdbVersion, modelName);
    }

    public void deassignBindingFromModel(String connectorBindingName, String vdbName, String vdbVersion, String modelName) throws AdminException {
        String[] connectorBindingNames = new String[]{connectorBindingName};
        this.deassignBindingsFromModel(connectorBindingNames, vdbName, vdbVersion, modelName);
    }

    public void assignBindingsToModel(String[] connectorBindingNames, String vdbName, String vdbVersion, String modelName) throws AdminException {
        block12: {
            try {
                List<ConnectorBinding> newBindingList = this.getConnectorBindingsByName(connectorBindingNames);
                if (!newBindingList.isEmpty()) {
                    Collection colVdbs = this.getVirtualDatabases();
                    if (colVdbs == null) break block12;
                    for (VirtualDatabase vdb : colVdbs) {
                        if (!vdb.getName().equals(vdbName) || !vdb.getVirtualDatabaseID().getVersion().equals(vdbVersion)) continue;
                        VirtualDatabaseID vdbId = (VirtualDatabaseID)vdb.getID();
                        Collection models = this.getModels(vdbId);
                        if (models != null) {
                            HashMap<String, List> map = new HashMap<String, List>(models.size());
                            for (Model model : models) {
                                if (model.getName().equals(modelName)) {
                                    ArrayList bindings = new ArrayList(newBindingList.size());
                                    if (model.isMultiSourceBindingEnabled()) {
                                        HashSet<String> multibindings = new HashSet<String>();
                                        if (!model.getConnectorBindingNames().isEmpty()) {
                                            multibindings.addAll(model.getConnectorBindingNames());
                                        }
                                        for (ConnectorBinding newBinding : newBindingList) {
                                            multibindings.add(newBinding.getRoutingUUID());
                                        }
                                        bindings.addAll(multibindings);
                                    } else {
                                        bindings.add(newBindingList.get(0).getRoutingUUID());
                                    }
                                    map.put(model.getName(), bindings);
                                    continue;
                                }
                                map.put(model.getName(), model.getConnectorBindingNames());
                            }
                            this.setConnectorBindingNames(vdbId, map);
                        }
                        this.setVDBState(vdbId, 3);
                        break block12;
                    }
                    break block12;
                }
                throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerConfigAdminImpl.Connector_Binding_not_found_in_Configuration"));
            }
            catch (VirtualDatabaseException e) {
                throw new AdminComponentException((Throwable)e);
            }
            catch (ConfigurationException e) {
                throw new AdminComponentException((Throwable)e);
            }
        }
    }

    public void deassignBindingsFromModel(String[] connectorBindingNames, String vdbName, String vdbVersion, String modelName) throws AdminException {
        try {
            List<ConnectorBinding> connectorList = this.getConnectorBindingsByName(connectorBindingNames);
            Collection colVdbs = this.getVirtualDatabases();
            if (colVdbs == null) {
                return;
            }
            for (VirtualDatabase vdb : colVdbs) {
                if (!vdb.getName().equals(vdbName) || !vdb.getVirtualDatabaseID().getVersion().equals(vdbVersion)) continue;
                VirtualDatabaseID vdbId = (VirtualDatabaseID)vdb.getID();
                Collection models = this.getModels(vdbId);
                if (models != null) {
                    HashMap<String, List> map = new HashMap<String, List>(models.size());
                    for (Model model : models) {
                        if (model.getName().equals(modelName)) {
                            if (model.getConnectorBindingNames().size() <= 0) continue;
                            HashSet bindingSet = new HashSet(model.getConnectorBindingNames().size());
                            bindingSet.addAll(model.getConnectorBindingNames());
                            for (ConnectorBinding binding : connectorList) {
                                bindingSet.remove(binding.getRoutingUUID());
                            }
                            ArrayList bindings = new ArrayList(model.getConnectorBindingNames().size());
                            bindings.addAll(bindingSet);
                            map.put(model.getName(), bindings);
                            continue;
                        }
                        map.put(model.getName(), model.getConnectorBindingNames());
                    }
                    this.setConnectorBindingNames(vdbId, map);
                }
                this.setVDBState(vdbId, 3);
                break;
            }
        }
        catch (VirtualDatabaseException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    protected Collection getVirtualDatabases() throws VirtualDatabaseException {
        return RuntimeMetadataCatalog.getInstance().getVirtualDatabases();
    }

    protected Collection getModels(VirtualDatabaseID vdbId) throws VirtualDatabaseException {
        return RuntimeMetadataCatalog.getInstance().getModels(vdbId);
    }

    protected void setConnectorBindingNames(VirtualDatabaseID vdbId, Map mapModelsToConnBinds) throws VirtualDatabaseException {
        RuntimeMetadataCatalog.getInstance().setConnectorBindingNames(vdbId, mapModelsToConnBinds, this.getUserName());
    }

    protected void setVDBState(VirtualDatabaseID vdbID, int siState) throws VirtualDatabaseException {
        RuntimeMetadataCatalog.getInstance().setVDBStatus(vdbID, (short)siState, this.getUserName());
    }

    public void deleteConnectorBinding(String connectorBindingIdentifier) throws AdminException {
        com.metamatrix.admin.api.objects.ConnectorBinding theBinding;
        Collection binding = this.parent.getConnectorBindings(connectorBindingIdentifier);
        if (binding != null && binding.size() > 0 && (theBinding = (com.metamatrix.admin.api.objects.ConnectorBinding)binding.iterator().next()) != null && theBinding.getState() == 1) {
            try {
                this.shutDownConnectorBinding((MMConnectorBinding)theBinding, true);
            }
            catch (Exception err) {
                // empty catch block
            }
        }
        String connectorBindingName = this.getName(connectorBindingIdentifier);
        Configuration nextStartupConfig = null;
        try {
            nextStartupConfig = this.getConfigurationServiceProxy().getNextStartupConfiguration();
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
        if (nextStartupConfig == null) {
            return;
        }
        ServiceComponentDefn service = null;
        try {
            service = this.getServiceByName(connectorBindingName);
        }
        catch (InvalidSessionException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (AuthorizationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
        if (service != null) {
            try {
                this.getConfigurationServiceProxy().delete((ComponentObject)service, false, this.getUserName());
            }
            catch (ConfigurationException e) {
                throw new AdminComponentException((Throwable)e);
            }
            catch (ModificationException e) {
                throw new AdminComponentException((Throwable)e);
            }
            catch (ServiceException e) {
                throw new AdminComponentException((Throwable)((Object)e));
            }
        }
        ConnectorBinding cb = nextStartupConfig.getConnectorBinding(connectorBindingName);
        if (cb == null) {
            this.throwProcessingException("ServerConfigAdminImpl.Connector_Binding_not_found_in_Configuration", new Object[]{connectorBindingName});
        } else {
            try {
                this.getConfigurationServiceProxy().delete((ComponentObject)cb, false, this.getUserName());
            }
            catch (ConfigurationException e) {
                throw new AdminComponentException((Throwable)e);
            }
            catch (ModificationException e) {
                throw new AdminComponentException((Throwable)e);
            }
            catch (ServiceException e) {
                throw new AdminComponentException((Throwable)((Object)e));
            }
        }
    }

    public void deleteConnectorType(String name) throws AdminException {
        ComponentType ct = this.getComponentType(name);
        if (ct == null) {
            this.throwProcessingException("ServerConfigAdminImpl.Connector_Type_not_found_in_Configuration", new Object[]{name});
        } else {
            try {
                this.getConfigurationServiceProxy().delete(ct, this.getUserName());
            }
            catch (ConfigurationException e) {
                throw new AdminComponentException((Throwable)e);
            }
            catch (ModificationException e) {
                throw new AdminComponentException((Throwable)e);
            }
            catch (ServiceException e) {
                throw new AdminComponentException((Throwable)((Object)e));
            }
        }
    }

    private ComponentType getComponentType(String name) throws AdminException {
        Collection types = null;
        try {
            types = this.getConfigurationServiceProxy().getAllComponentTypes(true);
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
        ComponentType result = null;
        for (ComponentType type : types) {
            if (!type.getName().equals(name)) continue;
            result = type;
            break;
        }
        return result;
    }

    public void deleteHost(String identifier) throws AdminException {
        String hostName = this.getName(identifier);
        try {
            com.metamatrix.common.config.api.Host host = this.getHostByName(hostName);
            if (host != null) {
                this.getConfigurationServiceProxy().delete((ComponentObject)host, false, this.getUserName());
            }
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ModificationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
    }

    private com.metamatrix.common.config.api.Host getHostByName(String hostName) throws AdminException {
        com.metamatrix.common.config.api.Host theHost = null;
        try {
            theHost = this.getConfigurationServiceProxy().getHost(new HostID(hostName));
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
        if (theHost == null) {
            this.throwProcessingException("ServerConfigAdminImpl.Host_not_found_in_Configuration", new Object[]{hostName});
        }
        return theHost;
    }

    private VMComponentDefn getVMByName(String hostName, String processName) throws ConfigurationException, ServiceException, MetaMatrixProcessingException, AdminException {
        VMComponentDefn result = null;
        Collection defns = this.getConfigurationServiceProxy().getCurrentConfiguration().getVMComponentDefns();
        for (VMComponentDefn defn : defns) {
            if (!defn.getName().equalsIgnoreCase(processName) || !defn.getHostID().getName().equalsIgnoreCase(hostName)) continue;
            result = defn;
            break;
        }
        if (result == null) {
            Object[] params = new Object[]{processName, hostName};
            this.throwProcessingException("ServerConfigAdminImpl.Process_not_found_in_Configuration", params);
        }
        return result;
    }

    public void deleteProcess(String processIdentifier) throws AdminException {
        String processName = this.getName(processIdentifier);
        if (processName == null) {
            throw new AdminProcessingException(AdminPlugin.Util.getString("ServerConfigAdminImpl.Name_can_not_be_null"));
        }
        String hostName = this.getParent(processIdentifier);
        if (hostName == null) {
            throw new AdminProcessingException(AdminPlugin.Util.getString("ServerConfigAdminImpl.Host_name_can_not_be_null"));
        }
        try {
            VMComponentDefn vmDefn = this.getVMByName(hostName, processName);
            if (vmDefn != null) {
                this.getConfigurationServiceProxy().delete((ComponentObject)vmDefn, false, this.getUserName());
            }
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
        catch (MetaMatrixProcessingException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ModificationException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    protected ServiceComponentDefn getServiceByName(String serviceName) throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        ServiceComponentDefnID serviceID = new ServiceComponentDefnID(Configuration.NEXT_STARTUP_ID, serviceName);
        return this.getServiceByID(serviceID);
    }

    protected ServiceComponentDefn getServiceByID(ServiceComponentDefnID serviceID) throws InvalidSessionException, AuthorizationException, ConfigurationException, MetaMatrixComponentException {
        return (ServiceComponentDefn)this.getConfigurationServiceProxy().getComponentDefn(Configuration.NEXT_STARTUP_ID, (ComponentDefnID)serviceID);
    }

    private AdminStatus checkDecryption(Properties properties, String connectorBindingName, String connectorTypeIdentifier) {
        boolean decryptable = true;
        if (decryptable) {
            return new MMAdminStatus(0, "AdminStatus.CODE_SUCCESS");
        }
        return new MMAdminStatus(-101, "AdminStatus.CODE_DECRYPTION_FAILED", (Object)connectorBindingName);
    }

    private AdminStatus checkDecryption(ConnectorBinding binding) throws AdminException {
        ArrayList<ConnectorBinding> bindings = new ArrayList<ConnectorBinding>();
        bindings.add(binding);
        List decryptables = new ArrayList();
        try {
            decryptables = this.getConfigurationServiceProxy().checkPropertiesDecryptable(bindings);
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
        boolean decryptable = (Boolean)decryptables.get(0);
        if (decryptable) {
            return new MMAdminStatus(0, "AdminStatus.CODE_SUCCESS");
        }
        return new MMAdminStatus(-101, "AdminStatus.CODE_DECRYPTION_FAILED", (Object)binding.getName());
    }

    private AdminStatus checkDecryption(List bindings) throws AdminException {
        List decryptables = new ArrayList();
        try {
            decryptables = this.getConfigurationServiceProxy().checkPropertiesDecryptable(bindings);
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
        ArrayList<ConnectorBinding> nonDecryptableBindings = new ArrayList<ConnectorBinding>();
        Iterator iter1 = bindings.iterator();
        Iterator iter2 = decryptables.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            ConnectorBinding binding = (ConnectorBinding)iter1.next();
            boolean decryptable = (Boolean)iter2.next();
            if (decryptable) continue;
            nonDecryptableBindings.add(binding);
        }
        if (nonDecryptableBindings.size() == 0) {
            return new MMAdminStatus(0, "AdminStatus.CODE_SUCCESS");
        }
        return new MMAdminStatus(-101, "AdminStatus.CODE_DECRYPTION_FAILED", (Object)this.prettyPrintBindingNames(nonDecryptableBindings));
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Collection getBindingNamesToUpdate(Collection existingBindings, Collection newBindingNames, AdminOptions options) throws AdminException {
        if (options == null) {
            options = new AdminOptions(2);
        }
        ArrayList addBindings = new ArrayList(newBindingNames.size());
        if (existingBindings == null || existingBindings.size() == 0) {
            addBindings.addAll(newBindingNames);
            return addBindings;
        }
        Collection existingBindingNames = this.getBindingNames(existingBindings);
        ArrayList<String> collidingBindingNames = new ArrayList<String>(existingBindingNames.size());
        ArrayList<String> nonCollidingBindingNames = new ArrayList<String>(existingBindingNames.size());
        for (String newBindingName : newBindingNames) {
            if (existingBindingNames.contains(newBindingName)) {
                collidingBindingNames.add(newBindingName);
                continue;
            }
            nonCollidingBindingNames.add(newBindingName);
        }
        if (collidingBindingNames.size() <= 0) {
            addBindings.addAll(nonCollidingBindingNames);
            return addBindings;
        }
        if (options.containsOption(1)) {
            addBindings.addAll(newBindingNames);
            return addBindings;
        }
        if (options.containsOption(2)) {
            addBindings.addAll(nonCollidingBindingNames);
            return addBindings;
        }
        if (!options.containsOption(4)) {
            throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerConfigAdminImpl.Unknown_admin_options", new Object[]{options.toString()}));
        }
        String msg = collidingBindingNames.size() == 1 ? AdminServerPlugin.Util.getString("ServerConfigAdminImpl.binding_exists", collidingBindingNames.toArray()) : AdminServerPlugin.Util.getString("ServerConfigAdminImpl.bindings_exist", collidingBindingNames.toArray());
        throw new AdminProcessingException(msg);
    }

    private Collection getBindingNames(Collection connectorBindings) {
        ArrayList<String> bindingNames = new ArrayList<String>(connectorBindings.size());
        for (Object aBindingObj : connectorBindings) {
            String aBindingName = null;
            aBindingName = aBindingObj instanceof ConnectorBinding ? ((ConnectorBinding)aBindingObj).getName() : ((com.metamatrix.admin.api.objects.ConnectorBinding)aBindingObj).getName();
            bindingNames.add(aBindingName);
        }
        return bindingNames;
    }

    private String prettyPrintBindingNames(List bindings) {
        StringBuffer buffer = new StringBuffer();
        Iterator iter = bindings.iterator();
        while (iter.hasNext()) {
            ConnectorBinding binding = (ConnectorBinding)iter.next();
            buffer.append(binding.getName());
            if (!iter.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    public void addUDF(byte[] modelFileContents, String classpath) throws AdminException {
        classpath = classpath.trim();
        try {
            this.deleteExtensionModule(FUNCTION_DEFINITIONS_MODEL);
        }
        catch (AdminException e) {
            // empty catch block
        }
        this.addExtensionModule("Function Definition", FUNCTION_DEFINITIONS_MODEL, modelFileContents, "User Defined Functions File");
        String commonpath = CurrentConfiguration.getInstance().getProperties().getProperty("metamatrix.extension.CommonClasspath", "");
        StringBuilder sb = new StringBuilder();
        if (classpath != null && classpath.length() > 0) {
            StringTokenizer st = new StringTokenizer(classpath, ";");
            while (st.hasMoreTokens()) {
                String partpath = st.nextToken();
                if (commonpath.indexOf(partpath) != -1) continue;
                sb.append(partpath).append(";");
            }
        }
        this.setSystemProperty("metamatrix.extension.CommonClasspath", sb.toString() + commonpath);
    }

    public void deleteUDF() throws AdminException {
        this.deleteExtensionModule(FUNCTION_DEFINITIONS_MODEL);
    }

    public Properties getBootstrapProperties() throws AdminException {
        Properties p = new Properties();
        try {
            p.putAll((Map<?, ?>)CurrentConfiguration.getInstance().getBootStrapProperties());
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        return p;
    }

    public byte[] getClusterKey() throws AdminException {
        Cryptor cryptor;
        try {
            cryptor = CryptoUtil.getCryptor();
        }
        catch (CryptoException e) {
            throw new AdminComponentException((Throwable)e);
        }
        if (cryptor instanceof SymmetricCryptor) {
            return ((SymmetricCryptor)cryptor).getEncodedKey();
        }
        return null;
    }
}

